//
//  ASCII+Hexadecimal.swift
//  ASCII
//
//  Created by Ihar Biaspalau on 8.02.25.
//

public extension ASCII {
    /// Returns hexadecimal representation (00-7F).
    /// Uses `StaticString` for zero runtime overhead.
    var hexadecimal: StaticString {
        switch self {
        case .null: "00"
        case .startOfHeading: "01"
        case .startOfText: "02"
        case .endOfText: "03"
        case .endOfTransmission: "04"
        case .enquiry: "05"
        case .acknowledge: "06"
        case .bell: "07"
        case .backspace: "08"
        case .horizontalTab: "09"
        case .lineFeed: "0A"
        case .verticalTab: "0B"
        case .formFeed: "0C"
        case .carriageReturn: "0D"
        case .shiftOut: "0E"
        case .shiftIn: "0F"
        case .dataLinkEscape: "10"
        case .deviceControl1: "11"
        case .deviceControl2: "12"
        case .deviceControl3: "13"
        case .deviceControl4: "14"
        case .negativeAcknowledge: "15"
        case .synchronousIdle: "16"
        case .endOfTransmissionBlock: "17"
        case .cancel: "18"
        case .endOfMedium: "19"
        case .substitute: "1A"
        case .escape: "1B"
        case .fileSeparator: "1C"
        case .groupSeparator: "1D"
        case .recordSeparator: "1E"
        case .unitSeparator: "1F"
        case .space: "20"
        case .exclamationMark: "21"
        case .doubleQuote: "22"
        case .numberSign: "23"
        case .dollarSign: "24"
        case .percentSign: "25"
        case .ampersand: "26"
        case .singleQuote: "27"
        case .leftParenthesis: "28"
        case .rightParenthesis: "29"
        case .asterisk: "2A"
        case .plus: "2B"
        case .comma: "2C"
        case .minus: "2D"
        case .period: "2E"
        case .forwardSlash: "2F"
        case .digit0: "30"
        case .digit1: "31"
        case .digit2: "32"
        case .digit3: "33"
        case .digit4: "34"
        case .digit5: "35"
        case .digit6: "36"
        case .digit7: "37"
        case .digit8: "38"
        case .digit9: "39"
        case .colon: "3A"
        case .semicolon: "3B"
        case .lessThan: "3C"
        case .equals: "3D"
        case .greaterThan: "3E"
        case .questionMark: "3F"
        case .atSign: "40"
        case .A: "41"
        case .B: "42"
        case .C: "43"
        case .D: "44"
        case .E: "45"
        case .F: "46"
        case .G: "47"
        case .H: "48"
        case .I: "49"
        case .J: "4A"
        case .K: "4B"
        case .L: "4C"
        case .M: "4D"
        case .N: "4E"
        case .O: "4F"
        case .P: "50"
        case .Q: "51"
        case .R: "52"
        case .S: "53"
        case .T: "54"
        case .U: "55"
        case .V: "56"
        case .W: "57"
        case .X: "58"
        case .Y: "59"
        case .Z: "5A"
        case .leftBracket: "5B"
        case .backslash: "5C"
        case .rightBracket: "5D"
        case .caret: "5E"
        case .underscore: "5F"
        case .backquote: "60"
        case .a: "61"
        case .b: "62"
        case .c: "63"
        case .d: "64"
        case .e: "65"
        case .f: "66"
        case .g: "67"
        case .h: "68"
        case .i: "69"
        case .j: "6A"
        case .k: "6B"
        case .l: "6C"
        case .m: "6D"
        case .n: "6E"
        case .o: "6F"
        case .p: "70"
        case .q: "71"
        case .r: "72"
        case .s: "73"
        case .t: "74"
        case .u: "75"
        case .v: "76"
        case .w: "77"
        case .x: "78"
        case .y: "79"
        case .z: "7A"
        case .leftBrace: "7B"
        case .verticalBar: "7C"
        case .rightBrace: "7D"
        case .tilde: "7E"
        case .delete: "7F"
        }
    }
}
