import Foundation

extension KeyedDecodingContainer {
    func decodeBytesFromURLEncodedBase64(forKey key: KeyedDecodingContainer.Key) throws -> [UInt8] {
        guard let bytes = try decode(
            URLEncodedBase64.self,
            forKey: key
        ).decodedBytes else {
            throw DecodingError.dataCorruptedError(
                forKey: key,
                in: self,
                debugDescription: "Failed to decode base64url encoded string at \(key) into bytes"
            )
        }
        return bytes
    }

    func decodeBytesFromURLEncodedBase64IfPresent(forKey key: KeyedDecodingContainer.Key) throws -> [UInt8]? {
        guard let bytes = try decodeIfPresent(
            URLEncodedBase64.self,
            forKey: key
        ) else { return nil }

        guard let decodedBytes = bytes.decodedBytes else {
            throw DecodingError.dataCorruptedError(
                forKey: key,
                in: self,
                debugDescription: "Failed to decode base64url encoded string at \(key) into bytes"
            )
        }
        return decodedBytes
    }
}
