# ``OpenAPIAsyncHTTPClient``

Send HTTP requests to the server using the AsyncHTTPClient library. 

## Overview

A client transport that uses the [HTTPClient](https://swiftpackageindex.com/swift-server/async-http-client/documentation/asynchttpclient/httpclient) type from the [AsyncHTTPClient](https://github.com/swift-server/async-http-client) library to perform HTTP operations.

Use the transport with client code generated by [Swift OpenAPI Generator](https://github.com/apple/swift-openapi-generator).

### Supported platforms and minimum versions
| macOS     | Linux | iOS    | tvOS   | watchOS | visionOS |
| :-:       | :-:   | :-:    | :-:    | :-:     | :-:      |
| ✅ 10.15+ | ✅    | ✅ 13+ | ✅ 13+ | ✅ 6+   | ✅ 1+    |

### Usage

Add the package dependency in your `Package.swift`:

```swift
.package(url: "https://github.com/swift-server/swift-openapi-async-http-client", from: "1.0.0"),
```

Next, in your target, add `OpenAPIAsyncHTTPClient` to your dependencies:

```swift
.target(name: "MyTarget", dependencies: [
    .product(name: "OpenAPIAsyncHTTPClient", package: "swift-openapi-async-http-client"),
]),
```

Then, to get started, check out ``AsyncHTTPClientTransport``.

## Topics

### Usage

- ``AsyncHTTPClientTransport``
