# AsyncHTTPClient Transport for Swift OpenAPI Generator

[![](https://img.shields.io/badge/docc-read_documentation-blue)](https://swiftpackageindex.com/swift-server/swift-openapi-async-http-client/documentation)
[![](https://img.shields.io/github/v/release/swift-server/swift-openapi-async-http-client)](https://github.com/swift-server/swift-openapi-async-http-client/releases)
[![](https://img.shields.io/endpoint?url=https%3A%2F%2Fswiftpackageindex.com%2Fapi%2Fpackages%2Fswift-server%2Fswift-openapi-async-http-client%2Fbadge%3Ftype%3Dswift-versions)](https://swiftpackageindex.com/swift-server/swift-openapi-async-http-client)
[![](https://img.shields.io/endpoint?url=https%3A%2F%2Fswiftpackageindex.com%2Fapi%2Fpackages%2Fswift-server%2Fswift-openapi-async-http-client%2Fbadge%3Ftype%3Dplatforms)](https://swiftpackageindex.com/swift-server/swift-openapi-async-http-client)

A client transport that uses the [HTTPClient](https://swiftpackageindex.com/swift-server/async-http-client/documentation/asynchttpclient/httpclient) type from the [AsyncHTTPClient](https://github.com/swift-server/async-http-client) library to perform HTTP operations.

Use the transport with client code generated by [Swift OpenAPI Generator](https://github.com/apple/swift-openapi-generator).

## Supported platforms and minimum versions
| macOS     | Linux | iOS    | tvOS   | watchOS | visionOS |
| :-:       | :-:   | :-:    | :-:    | :-:     | :-:      |
| ✅ 10.15+ | ✅    | ✅ 13+ | ✅ 13+ | ✅ 6+   | ✅ 1+    |

## Usage

Add the package dependency in your `Package.swift`:

```swift
.package(url: "https://github.com/swift-server/swift-openapi-async-http-client", from: "1.0.0"),
```

Next, in your target, add `OpenAPIAsyncHTTPClient` to your dependencies:

```swift
.target(name: "MyTarget", dependencies: [
    .product(name: "OpenAPIAsyncHTTPClient", package: "swift-openapi-async-http-client"),
]),
```

Then, to get started, check out `AsyncHTTPClientTransport`.

## Documentation

To learn more, check out the full [documentation](https://swiftpackageindex.com/swift-server/swift-openapi-async-http-client/documentation).
