(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define("stackframe",[],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.StackFrame=factory()}})(this,function(){"use strict";function _isNumber(n){return!isNaN(parseFloat(n))&&isFinite(n)}function StackFrame(functionName,args,fileName,lineNumber,columnNumber){if(functionName!==undefined){this.setFunctionName(functionName)}if(args!==undefined){this.setArgs(args)}if(fileName!==undefined){this.setFileName(fileName)}if(lineNumber!==undefined){this.setLineNumber(lineNumber)}if(columnNumber!==undefined){this.setColumnNumber(columnNumber)}}StackFrame.prototype={getFunctionName:function(){return this.functionName},setFunctionName:function(v){this.functionName=String(v)},getArgs:function(){return this.args},setArgs:function(v){if(Object.prototype.toString.call(v)!=="[object Array]"){throw new TypeError("Args must be an Array")}this.args=v},getFileName:function(){return this.fileName},setFileName:function(v){this.fileName=String(v)},getLineNumber:function(){return this.lineNumber},setLineNumber:function(v){if(!_isNumber(v)){throw new TypeError("Line Number must be a Number")}this.lineNumber=Number(v)},getColumnNumber:function(){return this.columnNumber},setColumnNumber:function(v){if(!_isNumber(v)){throw new TypeError("Column Number must be a Number")}this.columnNumber=Number(v)},toString:function(){var functionName=this.getFunctionName()||"{anonymous}";var args="("+(this.getArgs()||[]).join(",")+")";var fileName=this.getFileName()?"@"+this.getFileName():"";var lineNumber=_isNumber(this.getLineNumber())?":"+this.getLineNumber():"";var columnNumber=_isNumber(this.getColumnNumber())?":"+this.getColumnNumber():"";return functionName+args+fileName+lineNumber+columnNumber}};return StackFrame});
//@ sourceMappingURL=stackframe.js.map