#if canImport(UIKit) && (os(iOS) || os(tvOS))
import UIKit

public extension UISegmentedControl {
    
    var segmentTitles: [String] {
        get {
            let range = 0..<numberOfSegments
            return range.compactMap { titleForSegment(at: $0) }
        }
        set {
            removeAllSegments()
            for (index, title) in newValue.enumerated() {
                insertSegment(withTitle: title, at: index, animated: false)
            }
        }
    }
}
#endif
