SparkFun Weather Shield
========================

[![SparkFun Weather Shield](https://cdn.sparkfun.com/assets/learn_tutorials/6/2/6/Arduino_Weather_Shield3.jpg)](https://www.sparkfun.com/products/13956)  

[*SparkFun Weather Shield (DEV-13956)*](https://www.sparkfun.com/products/13956)

Weather Shield is an Arduino shield that gathers relative humidity, barometric pressure, temperature, light intensity, as well as optional rain, wind direction, and wind speed (using optional [external weather gauges](https://www.sparkfun.com/products/8942)).

Repository Contents
------------------

* **/Firmware** - Example Arduino sketch to demostrate how to read from the various sensors.
* **/Fritzing** - Fritzing Example wiring images
* **/Hardware** - All the Eagle PCB design files (.brd, .sch).
* **/Production** - Test bed files and production panel files

Documentation
--------------
* **[Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library)** - Basic information on how to install an Arduino library.
* **[MPL3115A2 Library](https://github.com/sparkfun/SparkFun_MPL3115A2_Breakout_Arduino_Library)** - MPL3115A2 library required for Weather Shield examples. 
* **[Si7021 Library](https://github.com/sparkfun/SparkFun_Si701_Breakout_Arduino_Library)** - Si7021 humidity sensor library required for Weather Shield examples. 
* **[Hookup Guide](https://learn.sparkfun.com/tutorials/arduino-weather-shield-hookup-guide-v12)** - Basic hookup guide for the Weather Shield v1.2.
* **[SparkFun Fritzing repo](https://github.com/sparkfun/Fritzing_Parts)** - Fritzing diagrams for SparkFun products.
* **[SparkFun 3D Model repo](https://github.com/sparkfun/3D_Models)** - 3D models of SparkFun products. 
* _**[HTU21D Library](https://github.com/sparkfun/SparkFun_HTU21D_Breakout_Arduino_Library)** - The HTU21D humidity sensor was used on DEV-12081 and prior versions of the Weather Shield so if you have an older version you may need this library to run the examples._

Product Versions
----------------
* [DEV-13956](https://www.sparkfun.com/products/13956)- V1.2 w/ Si7021
* _[DEV-12081 (Retired)](https://www.sparkfun.com/products/13956)- HTU21D_

Version History
---------------
* [v1.2](https://github.com/sparkfun/Weather_Shield/releases/tag/v1.2) - Latest Version
* [v1.1](https://github.com/sparkfun/Weather_Shield/releases/tag/v1.1) - Initial Release

License Information
-------------------

This product is _**open source**_! 

Please review the LICENSE.md file for license information. 

If you have any questions or concerns on licensing, please contact techsupport@sparkfun.com.

Distributed as-is; no warranty is given.

- Your friends at SparkFun.
