SparkFun Alphanumeric Display Library
========================================

[![Qwiic Alphanumeric Display - Pink](https://cdn.sparkfun.com/assets/parts/1/5/8/5/5/16919-SparkFun_Qwiic_Alphanumeric_Display_-_Pink-Demo.jpg)](https://cdn.sparkfun.com/assets/parts/1/5/8/5/5/16919-SparkFun_Qwiic_Alphanumeric_Display_-_Pink-Demo.jpg)

[*Qwiic Alphanumeric Display - Pink (COM-16919)*](https://www.sparkfun.com/products/16919)

[![Qwiic Alphanumeric Display - Green](https://cdn.sparkfun.com/assets/parts/1/8/0/2/2/18566-SparkFun_Qwiic_Alphanumeric_Display_-_Green-Demo.jpg)](https://cdn.sparkfun.com/assets/parts/1/8/0/2/2/18566-SparkFun_Qwiic_Alphanumeric_Display_-_Green-Demo.jpg)

[*Qwiic Alphanumeric Display - Green (COM-18566)*](https://www.sparkfun.com/products/18566)

[![Qwiic Alphanumeric Display - Red](https://cdn.sparkfun.com/assets/parts/1/5/8/5/2/16916-SparkFun_Qwiic_Alphanumeric_Display_-_Red-Demo.jpg)](https://cdn.sparkfun.com/assets/parts/1/5/8/5/2/16916-SparkFun_Qwiic_Alphanumeric_Display_-_Red-Demo.jpg)

[*Qwiic Alphanumeric Display - Red (COM-16916)*](https://www.sparkfun.com/products/16916)

[![Qwiic Alphanumeric Display - Blue](https://cdn.sparkfun.com/assets/parts/1/5/8/5/3/16917-SparkFun_Qwiic_Alphanumeric_Display_-_Blue-Demo.jpg)](https://cdn.sparkfun.com/assets/parts/1/5/8/5/3/16917-SparkFun_Qwiic_Alphanumeric_Display_-_Blue-Demo.jpg)

[*Qwiic Alphanumeric Display - Blue (COM-16917)*](https://www.sparkfun.com/products/16917)

[![Qwiic Alphanumeric Display - Purple](https://cdn.sparkfun.com/assets/parts/1/5/8/5/4/16918-SparkFun_Qwiic_Alphanumeric_Display_-_Purple-Demo.jpg)](https://cdn.sparkfun.com/assets/parts/1/5/8/5/4/16918-SparkFun_Qwiic_Alphanumeric_Display_-_Purple-Demo.jpg)

[*Qwiic Alphanumeric Display - Purple (COM-16918)*](https://www.sparkfun.com/products/16918)

[![Qwiic Alphanumeric Display - White](https://cdn.sparkfun.com/assets/parts/1/8/0/2/0/18565-SparkFun_Qwiic_Alphanumeric_Display_-_White-Demo.jpg)](https://cdn.sparkfun.com/assets/parts/1/8/0/2/0/18565-SparkFun_Qwiic_Alphanumeric_Display_-_White-Demo.jpg)

[*Qwiic Alphanumeric Display - White (COM-18565)*](https://www.sparkfun.com/products/18565)

We are quite familiar with seven-segment displays. We see them on our alarm clocks, ovens, and microwaves. By adding more segments to each digit you can display more than just numbers! Introducing the brand new SparkFun Qwiic Alphanumeric Display. These fourteen-segment digits allow you to display all sorts of numbers, characters, and symbols. With [Qwiic](https://www.sparkfun.com/qwiic), simply plug it in and go. No soldering, no figuring out which is SDA or SCL, and no voltage regulation or translation required! 

The SparkFun Alphanumeric Display Arduino library makes printing strings to the display as easy as calling the print() function. With this library, you'll be able to send I<sup>2</sup>C commands to the VK16K33 LED driver chip to light up segments (including the decimal point or colon) and even scroll your string across the display. You can download the library through the Arduino library manager by searching 'SparkFun Alphanumeric Display' or you can get the GitHub repo as a .zip file and install the library from there.

The VK16K33 also supports I<sup>2</sup>C address configuration. Simply close a combination of the address jumpers on the back and you can communicate with up to four displays on the same bus. Our slim board design also features detachable standoff holes, vertical Qwiic connectors, and internal mounting holes.

SparkFun labored with love to create this code. Feel like supporting open source hardware? 
Buy a [board]() from SparkFun!

Repository Contents
-------------------

* **/examples** - Example code to show how the functions work.
* **/src** - Source files for the library (.cpp, .h).
* **keywords.txt** - Keywords from this library that will be highlighted in the Arduino IDE.
* **libray.properties** - General library properties for the Arduino package manager

Documentation
--------------

* **[Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library)** - Basic information on how to install an Arduino library.
* **[Product Repository](https://github.com/sparkfun/Qwiic_Alphanumeric_Display_Breakout)** - Main repository (including hardware files)

License Information
-------------------

This product is _**open source**_! 

Please review the LICENSE.md file for license information. 

If you have any questions or concerns on licensing, please contact technical support on our [SparkFun forums](https://forum.sparkfun.com/viewforum.php?f=152).

Distributed as-is; no warranty is given.

- Your friends at SparkFun.

_<COLLABORATION CREDIT>_
