# Text-based savefile format
This small document describes a new, TOML-like text format for game saves. This format allows the user to use a simple text editor to change the data necessary for the game (for example, special saves for speedrun training).

All data is stored in pairs (*key = value*). Pairs can be placed arbitrarily within a single section. The format of values may differ for each section.

Each savefile (4 total) must be named `save_file_X.sav`, where X - save slot (0, 1, 2 or 3).

> **Note**: The game creates the savefile only when you are saved in the game after completing a course!
___
## Header
The header is automatically generated by the game when saving progress. It mainly contains information about the value of the 0 and 1 flags, the character that the comment starts with, and the time when the file content changed.

Example:
```
# Super Mario 64 save file
# Comment starts with #
# True = 1, False = 0
# 2020-05-18 17:37:07
```

___
## Commenting
All comment lines starts with `#` character. Comments can be located on a separate line or as part of another line. When the game reads the save, comments are ignored.

Example:
```
# This is a comment
coin_score_age = ??     # This is a comment too!
```

___
## Menu Section - [menu]
This section contains two flags for menu. 

| Flag | Value | Description |
|---|---|---|
| coin_score_age | 0, 1, 2, 3 | Each save file has a 2 bit "age"    for each course. The higher this value, the older the high score is. This is used for tie-breaking when displaying on the high score screen
| sound_mode | stereo, mono, headset | Sound mode for the game

Example:
```
[menu]
coin_score_age = 0
sound_mode = stereo
```
___
## Flags Section - [flags]
This section contains all main game flags (walkthought milestones).
> **Note**: The value can be only 0 (False) or 1 (True).

| Flag | Description |
|---|---|
| wing_cap | **Red Switch** is pressed 
| metal_cap | **Green Switch** is pressed
| vanish_cap | **Blue Switch** is pressed. 
| key_1 | Key is found in **Bowser in the Dark World**
| key_2 | Key is found in **Bowser in the Fire Sea**
| basement_door | Mario unlocked castle's basement door
| upstairs_door | Mario unlocked castle's upper floors
| ddd_moved_back | **Dire Dire Docks** painting is moved back 
| moat_drained | Water is drained in the moat of the castle
| pps_door | **Princess's Secret Slide** window is unlocked
| wf_door | **Whomp's Fortress door** is unlocked
| ccm_door | **Cool, Cool Mountain door** is unlocked
| jrb_door | **Jolly Roger Bay door** is unlocked
| bitdw_door | **Bowser in the Dark World door** door is unlocked
| bitfs_door | **Bowser in the Fire Sea** door is unlocked 
| 50star_door | **Endless Staircase** is not endless anymore

Example:
```
[flags]
wing_cap = 1
metal_cap = 1
vanish_cap = 0
key_1 = 1
key_2 = 1
```
___
## Main Courses Section - [courses]
This section contains all stars and coins that Mario collected in each main course.

The first value stores the number of coins collected.
> **Warning!**: Make sure that coins count will not exceed 255!

The second value stores the stars (or completed missions). Each mission (6 main + 1 bonus) is must be marked `0` (not completed) and `1` (completed). 
> **Warning!**: The sequence of stars' missions goes from **RIGHT** to **LEFT**!
> **Note**: Last star flag is **100 coins star**

| Flag | Short for |
|---|---|
| bob | Bob-omb Battlefield |
| wf | Whomp's Fortress
| jrb | Jolly Roger Bay
| ccm | Cool, Cool Mountain
| bbh | Big Boo's Haunt
| hmc | Hazy Maze Cave
| lll | Lethal Lava Land
| ssl | Shifting Sand Land
| ddd | Dire, Dire Docks
| sl | Snowman's Land
| wdw | Wet-Dry World
| ttm | Tall, Tall Mountain
| thi | Tiny-Huge Island
| ttc | Tick Tock Clock
| rr | Rainbow Ride

Example:
```
[courses]
bob = "3, 0000011"
wf = "3, 0000101"
jrb = "0, 1000000"
ccm = "1, 1111111"
```
___
## Bonus Section - [bonus]
This section contains all bonus stars that Mario collected in the castle and all bonus courses.
> **Note**: The game takes into account only the number of bonus stars collected, the order of stars flags can be arbitrary

| Flag | Stars | Description |
|---|---|---|
| hub | 5 | MIPS' stars and Toads' stars
| bitdw | 1 | Bowser in the Dark World 
| bitfs | 1 | Bowser in the Fire Sea 
| bits | 1 | Bowser in the Sky
| pss | 2 | The Princess's Secret Slide
| cotmc | 1 | Cavern of the Metal Cap
| totwc | 1 | Tower of the Wing Cap
| vcutm | 1 | Vanish Cap Under the Moat
| wmotr | 1 | Wing Mario Over the Rainbow
| sa | 1 | The Secret Aquarium

Example:
```
[bonus]
hub = 11101
bitdw = 1
bitfs = 0
bits = 1
pss = 10
```
___
## Cap Section - [cap]
This section contains information about where Mario lost his cap and who take it.
| Flag | Value | Description |
|---|---|---|
| type | ground, klepto, ukiki, mrblizzard | The one who or what took the cap from Mario. Default flag is **"ground"**
| level | ssl, sl, ttm, none | Specifies the course where the cap is located. Default flag is **"none"**.
| area | 1, 2 | Specifies the area in the course.

Example:
```
[cap]
type = ground
level = ssl
area = 1
```