﻿// -----------------------------------------------------------------------------------------
// QSVEnc/NVEnc by rigaya
// -----------------------------------------------------------------------------------------
// The MIT License
//
// Copyright (c) 2019 rigaya
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// -------------------------------------------------------------------------------------------

#ifndef __RGY_TIMECODE_H__
#define __RGY_TIMECODE_H__

#include <cstdint>
#include "rgy_err.h"
#include "rgy_tchar.h"
#include "rgy_util.h"

class RGYTimecode {
public:
    RGYTimecode() {};
    ~RGYTimecode() { fp.reset(); };
    RGY_ERR init(const tstring &filename);
    void write(int64_t timestamp, rgy_rational<int> timebase);

    std::unique_ptr<FILE, fp_deleter> fp;
};

class RGYTimecodeReader {
public:
    RGYTimecodeReader();
    ~RGYTimecodeReader();
    RGY_ERR init(const tstring &filename, rgy_rational<int> timeBaseTimecode);
    RGY_ERR read(int64_t& timestamp, int64_t& duration);
    rgy_rational<int> timebase() const { return m_timeBaseTimecode;}
    const tstring& filename() const { return m_filename; }
protected:
    std::tuple<RGY_ERR, double> getValue();

    std::unique_ptr<FILE, fp_deleter> m_fp;
    tstring m_filename;
    rgy_rational<int> m_timeBaseTimecode;
    int64_t m_prevPts;
    int64_t m_prevDuration;
};

#endif //__RGY_TIMECODE_H__
