/**
  {3 Example of use}
  In order to render a [PickerIOS] {{:https://facebook.github.io/react-native/docs/pickerios}} component you will need to pass one or many [PickerIOS.Item] component(s) as children.

  And [PickerIOS.Item] has a required label prop
  {[
    let component = ReasonReact.statelessComponent("MyComponent");

    let make = _children => {
      ...component,
      render: _self =>
        <View>
          <PickerIOS>
            <PickerIOS.Item label="ReasonML" value="reason" />
            <PickerIOS.Item label="Ocaml" value="ocaml" />
            <PickerIOS.Item label="JavaScript" value="js" />
          </PickerIOS>
        </View>,
    };
  ]}
  {4 selectedValue and onValueChange}
  {[
    let component = ReasonReact.statelessComponent("MyComponent");

    let make = _children => {
      ...component,
      render: _self =>
        <View>
          <PickerIOS selectedValue="ocaml" onValueChange=(value => Js.log(value))>
            <PickerIOS.Item label="ReasonML" value="reason" />
            <PickerIOS.Item label="Ocaml" value="ocaml" />
            <PickerIOS.Item label="JavaScript" value="js" />
          </PickerIOS>
        </View>,
    };
  ]}
  {3 Props}
  {4 itemStyle}
  {[
    itemStyle: Style.t=?
  ]}
  {4 onValueChange}
  {[
    onValueChange: 'value => unit=?
  ]}
  {4 selectedValue}
  {[
    selectedValue: 'value=?
  ]}
*/
[@react.component]
let make:
  (
    ~itemStyle: Style.t=?,
    ~onValueChange: 'value => unit=?,
    ~selectedValue: 'value=?,
    ~accessibilityLabel: string=?,
    ~accessible: bool=?,
    ~hitSlop: Types.insets=?,
    ~onAccessibilityTap: unit => unit=?,
    ~onLayout: RNEvent.NativeLayoutEvent.t => unit=?,
    ~onMagicTap: unit => unit=?,
    ~responderHandlers: Types.touchResponderHandlers=?,
    ~pointerEvents: Types.pointerEvents=?,
    ~removeClippedSubviews: bool=?,
    ~style: Style.t=?,
    ~testID: string=?,
    ~accessibilityComponentType: Types.accessibilityComponentType=?,
    ~accessibilityLiveRegion: Types.accessibilityLiveRegion=?,
    ~collapsable: bool=?,
    ~importantForAccessibility: Types.importantForAccessibility=?,
    ~needsOffscreenAlphaCompositing: bool=?,
    ~renderToHardwareTextureAndroid: bool=?,
    ~accessibilityTraits: list(Types.accessibilityTrait)=?,
    ~accessibilityRole: Types.accessibilityRole=?,
    ~accessibilityStates: list(Types.accessibilityState)=?,
    ~accessibilityHint: string=?,
    ~accessibilityIgnoresInvertColors: bool=?,
    ~accessibilityViewIsModal: bool=?,
    ~shouldRasterizeIOS: bool=?,
    ~children: React.element=?
  ) =>
  React.element;

/**
  [PickerIOS.Item] component is used {b only} inside [<PickerIOS></PickerIOS>] component

  {3 Props}
  {4 label}
  {[
    label: string
  ]}
  {4 color}
  {[
    color: ReactNative.Color.t=?
  ]}
  {4 value}
  {[
    value: 'value=?
  ]}
*/

module Item: {
  [@react.component]
  let make:
    (~label: string, ~value: 'value=?, ~color: ReactNative.Color.t=?) =>
    React.element;
};
