## Overview

<p class="intro" markdown>

Set up a **Django Project** with at least one app.

</p>

!!! note

      If you have reached this point, you should have already [installed ReactPy-Django](../get-started/installation.md) through the previous steps.

---

## Deciding which Django App to use

You will now need to pick at least one **Django app** to start using ReactPy-Django on.

For the following examples, we will assume the following:

1. You have a **Django app** named `my_app`, which was created by Django's [`startapp` command](https://docs.djangoproject.com/en/dev/intro/tutorial01/#creating-the-polls-app).
2. You have placed `my_app` directly into your **Django project** folder (`./example_project/my_app`). This is common for small projects.

??? question "How do I organize my Django project for ReactPy?"

      ReactPy-Django has no project structure requirements. Organize everything as you wish, just like any **Django project**.
