/*
 * Copyright 2014 Igor Maznitsa (http://www.igormaznitsa.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.igormaznitsa.jbbp.compiler.varlen;

import com.igormaznitsa.jbbp.utils.JBBPSystemProperty;
import static org.junit.Assert.*;
import org.junit.BeforeClass;
import org.junit.Test;

public class JBBPExpressionEvaluatorWithCustomStackSizeTest {

  private static final int CUSTOM_STACK_SIZE = 256;
  
  @BeforeClass
  public static void beforeClass() throws Exception {
    JBBPSystemProperty.PROPERTY_EXPRESSION_STACK_DEPTH.set(Integer.toString(CUSTOM_STACK_SIZE));
  }
  
  @Test
  public void testExpression_BigStackusageWithoutStackOverfow() throws Exception {
      JBBPExpressionEvaluator expr = new JBBPExpressionEvaluator("1+(2+(3+(4+(5+(6+(7+(8+(9+(10+(11+(12+(13+(14+(15+(16+(17+(18+(19+(20*2)))))))))))))))))))", null, null);
      assertEquals(1 + (2 + (3 + (4 + (5 + (6 + (7 + (8 + (9 + (10 + (11 + (12 + (13 + (14 + (15 + (16 + (17 + (18 + (19 + (20 * 2))))))))))))))))))), expr.eval(null, 0, null, null));
  }


}
