const DEFAULT_ICON_COLOR = "var(--clr-neutral-200)";
const DEFAULT_GRADIENT_COLORS = ["var(--clr-accent)", "var(--clr-neutral-700)"];

export const LogoIcon = () => (
  <svg
    width="44"
    height="30"
    viewBox="0 0 44 30"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M11.1623 3.96725C8.96775 3.96725 7.9365 4.62725 8.0685 5.94725L8.5635 11.021C8.58 11.1695 8.58825 11.384 8.58825 11.6645C8.58825 12.4565 8.3985 13.067 8.019 13.496C7.6395 13.9085 7.05375 14.189 6.26175 14.3375C7.07025 14.486 7.656 14.7665 8.019 15.179C8.3985 15.575 8.58825 16.1772 8.58825 16.9857C8.58825 17.2662 8.58 17.489 8.5635 17.654L8.0685 22.7277C8.0025 23.4537 8.25 23.9653 8.811 24.2623C9.372 24.5593 10.1558 24.7078 11.1623 24.7078V26.366C9.67725 26.366 8.4645 26.1103 7.524 25.5988C6.5835 25.0873 6.11325 24.221 6.11325 23C6.11325 22.7855 6.1215 22.6205 6.138 22.505L6.65775 17.8025C6.67425 17.687 6.6825 17.522 6.6825 17.3075C6.6825 16.5815 6.41025 16.0452 5.86575 15.6987C5.32125 15.3522 4.33125 15.179 2.89575 15.179V13.496C4.33125 13.496 5.32125 13.331 5.86575 13.001C6.41025 12.6545 6.6825 12.1182 6.6825 11.3922C6.6825 11.1942 6.67425 11.0375 6.65775 10.922L6.138 6.17C6.1215 6.0545 6.11325 5.8895 6.11325 5.675C6.11325 4.454 6.5835 3.58775 7.524 3.07625C8.4645 2.56475 9.67725 2.309 11.1623 2.309V3.96725Z"
      fill="url(#paint0_linear_11_2)"
    />
    <path
      d="M30.8281 13.3735L18.5599 25.9883C18.219 26.3378 17.6536 25.9329 17.8752 25.4982L22.2421 16.881C22.2751 16.8159 22.291 16.7435 22.288 16.6706C22.2851 16.5977 22.2635 16.5267 22.2253 16.4646C22.1871 16.4024 22.1335 16.3511 22.0698 16.3156C22.0061 16.28 21.9343 16.2614 21.8613 16.2616H12.6758C12.5919 16.2615 12.5099 16.2367 12.4401 16.1902C12.3702 16.1437 12.3157 16.0777 12.2832 16.0003C12.2507 15.9229 12.2418 15.8377 12.2576 15.7553C12.2734 15.6729 12.3131 15.597 12.3718 15.5371L23.7507 4.00902C24.0803 3.67518 24.6286 4.04169 24.4454 4.47497L21.1823 12.1674C21.1547 12.2327 21.1437 12.3037 21.1505 12.3742C21.1572 12.4447 21.1814 12.5125 21.2209 12.5713C21.2604 12.6301 21.3139 12.6781 21.3766 12.711C21.4393 12.7439 21.5092 12.7607 21.5801 12.7598L30.517 12.649C30.6013 12.6477 30.6842 12.6714 30.755 12.7171C30.8259 12.7629 30.8816 12.8286 30.915 12.9061C30.9485 12.9835 30.9582 13.0691 30.943 13.1521C30.9278 13.235 30.8883 13.3116 30.8295 13.3721L30.8281 13.3735Z"
      stroke="url(#paint1_linear_11_2)"
      strokeWidth="1.65"
    />
    <path
      d="M31.8878 2.309C33.3728 2.309 34.5855 2.56475 35.526 3.07625C36.4665 3.58775 36.9368 4.454 36.9368 5.675C36.9368 5.8895 36.9285 6.0545 36.912 6.17L36.3923 10.922C36.3758 11.0045 36.3675 11.1282 36.3675 11.2932C36.3675 12.0357 36.6563 12.5885 37.2338 12.9515C37.8278 13.3145 38.8013 13.496 40.1543 13.496V15.179C38.7848 15.179 37.8113 15.3605 37.2338 15.7235C36.6563 16.0865 36.3675 16.6475 36.3675 17.4065C36.3675 17.5715 36.3758 17.7035 36.3923 17.8025L36.912 22.505C36.9285 22.6205 36.9368 22.7855 36.9368 23C36.9368 24.221 36.4665 25.0873 35.526 25.5988C34.5855 26.1103 33.3728 26.366 31.8878 26.366V24.7078C32.8943 24.7078 33.678 24.5593 34.239 24.2623C34.8 23.9653 35.0475 23.4537 34.9815 22.7277L34.4865 17.654C34.4535 17.324 34.437 17.1012 34.437 16.9857C34.437 16.1607 34.6433 15.5502 35.0558 15.1542C35.4683 14.7582 36.1365 14.4942 37.0605 14.3622C36.1695 14.1972 35.5095 13.9085 35.0805 13.496C34.668 13.067 34.4618 12.4482 34.4618 11.6397C34.4618 11.3757 34.47 11.1695 34.4865 11.021L34.9815 5.94725C35.1135 4.62725 34.0823 3.96725 31.8878 3.96725V2.309Z"
      fill="url(#paint2_linear_11_2)"
    />
    <defs>
      <linearGradient
        id="paint0_linear_11_2"
        x1="2.0336e-07"
        y1="14.6512"
        x2="15"
        y2="14.6512"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#00B4D8" />
        <stop offset="1" stopColor="#2A2A2A" />
      </linearGradient>
      <linearGradient
        id="paint1_linear_11_2"
        x1="12.25"
        y1="14.7414"
        x2="30.95"
        y2="14.7414"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#00B4D8" />
        <stop offset="1" stopColor="#2A2A2A" />
      </linearGradient>
      <linearGradient
        id="paint2_linear_11_2"
        x1="28.2"
        y1="14.6512"
        x2="43.2"
        y2="14.6512"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#00B4D8" />
        <stop offset="1" stopColor="#2A2A2A" />
      </linearGradient>
    </defs>
  </svg>
);

export const SearchIcon = ({ fillColor = DEFAULT_ICON_COLOR }) => (
  <svg
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M19.6 21L13.3 14.7C12.8 15.1 12.225 15.4167 11.575 15.65C10.925 15.8833 10.2333 16 9.5 16C7.68333 16 6.146 15.3707 4.888 14.112C3.63 12.8533 3.00067 11.316 3 9.5C2.99933 7.684 3.62867 6.14667 4.888 4.888C6.14733 3.62933 7.68467 3 9.5 3C11.3153 3 12.853 3.62933 14.113 4.888C15.373 6.14667 16.002 7.684 16 9.5C16 10.2333 15.8833 10.925 15.65 11.575C15.4167 12.225 15.1 12.8 14.7 13.3L21 19.6L19.6 21ZM9.5 14C10.75 14 11.8127 13.5627 12.688 12.688C13.5633 11.8133 14.0007 10.7507 14 9.5C13.9993 8.24933 13.562 7.187 12.688 6.313C11.814 5.439 10.7513 5.00133 9.5 5C8.24867 4.99867 7.18633 5.43633 6.313 6.313C5.43967 7.18967 5.002 8.252 5 9.5C4.998 10.748 5.43567 11.8107 6.313 12.688C7.19033 13.5653 8.25267 14.0027 9.5 14Z"
      fill={fillColor}
    />
  </svg>
);

export const GitHubIcon = ({ fillColor = DEFAULT_ICON_COLOR }) => (
  <svg
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M12 2C10.6868 2 9.38642 2.25866 8.17317 2.7612C6.95991 3.26375 5.85752 4.00035 4.92893 4.92893C3.05357 6.8043 2 9.34784 2 12C2 16.42 4.87 20.17 8.84 21.5C9.34 21.58 9.5 21.27 9.5 21V19.31C6.73 19.91 6.14 17.97 6.14 17.97C5.68 16.81 5.03 16.5 5.03 16.5C4.12 15.88 5.1 15.9 5.1 15.9C6.1 15.97 6.63 16.93 6.63 16.93C7.5 18.45 8.97 18 9.54 17.76C9.63 17.11 9.89 16.67 10.17 16.42C7.95 16.17 5.62 15.31 5.62 11.5C5.62 10.39 6 9.5 6.65 8.79C6.55 8.54 6.2 7.5 6.75 6.15C6.75 6.15 7.59 5.88 9.5 7.17C10.29 6.95 11.15 6.84 12 6.84C12.85 6.84 13.71 6.95 14.5 7.17C16.41 5.88 17.25 6.15 17.25 6.15C17.8 7.5 17.45 8.54 17.35 8.79C18 9.5 18.38 10.39 18.38 11.5C18.38 15.32 16.04 16.16 13.81 16.41C14.17 16.72 14.5 17.33 14.5 18.26V21C14.5 21.27 14.66 21.59 15.17 21.5C19.14 20.16 22 16.42 22 12C22 10.6868 21.7413 9.38642 21.2388 8.17317C20.7362 6.95991 19.9997 5.85752 19.0711 4.92893C18.1425 4.00035 17.0401 3.26375 15.8268 2.7612C14.6136 2.25866 13.3132 2 12 2Z"
      fill={fillColor}
    />
  </svg>
);

export const SwitchIcon = ({ fillColor = DEFAULT_ICON_COLOR }) => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M2.75 8.70833H19.25L13.75 3.20833M19.6162 13.2917H3.11621L8.61621 18.7917"
      stroke={fillColor}
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const ExpandIcon = ({ fillColor = DEFAULT_ICON_COLOR }) => (
  <svg
    width="16"
    height="17"
    viewBox="0 0 16 17"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M14 14.5L10 10.5M14 14.5V11.3M14 14.5H10.8M2 11.3V14.5M2 14.5H5.2M2 14.5L6 10.5M14 5.7V2.5M14 2.5H10.8M14 2.5L10 6.5M2 5.7V2.5M2 2.5H5.2M2 2.5L6 6.5"
      stroke={fillColor}
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const CloseIcon = ({ fillColor = DEFAULT_ICON_COLOR }) => (
  <svg
    width="31"
    height="30"
    viewBox="0 0 31 30"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M8.5 23.75L6.75 22L13.75 15L6.75 8L8.5 6.25L15.5 13.25L22.5 6.25L24.25 8L17.25 15L24.25 22L22.5 23.75L15.5 16.75L8.5 23.75Z"
      fill={fillColor}
    />
  </svg>
);

export const CopyIcon = ({
  gradient_1 = DEFAULT_GRADIENT_COLORS[0],
  gradient_2 = DEFAULT_GRADIENT_COLORS[1],
}) => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M12.7 1.66667H9.455C7.985 1.66667 6.82 1.66667 5.90917 1.79C4.97083 1.91667 4.21167 2.18333 3.61333 2.78417C3.01417 3.385 2.74833 4.1475 2.6225 5.08917C2.5 6.00417 2.5 7.17333 2.5 8.64917V13.5142C2.5 14.7708 3.26667 15.8475 4.35583 16.2992C4.3 15.5408 4.3 14.4783 4.3 13.5933V9.41833C4.3 8.35083 4.3 7.43 4.39833 6.69333C4.50417 5.90333 4.7425 5.14667 5.35417 4.5325C5.96583 3.91833 6.72 3.67917 7.50667 3.5725C8.24 3.47417 9.15667 3.47417 10.2208 3.47417H12.7792C13.8425 3.47417 14.7575 3.47417 15.4917 3.5725C15.2718 3.01108 14.8878 2.52895 14.3898 2.18899C13.8918 1.84902 13.303 1.66701 12.7 1.66667Z"
      fill="url(#paint0_linear_34_108)"
    />
    <path
      d="M5.5 9.4975C5.5 7.22583 5.5 6.09 6.20333 5.38417C6.90583 4.67833 8.03667 4.67833 10.3 4.67833H12.7C14.9625 4.67833 16.0942 4.67833 16.7975 5.38417C17.5008 6.09 17.5 7.22583 17.5 9.4975V13.5142C17.5 15.7858 17.5 16.9217 16.7975 17.6275C16.0942 18.3333 14.9625 18.3333 12.7 18.3333H10.3C8.0375 18.3333 6.90583 18.3333 6.20333 17.6275C5.5 16.9217 5.5 15.7858 5.5 13.5142V9.4975Z"
      fill="url(#paint1_linear_34_108)"
    />
    <defs>
      <linearGradient
        id="paint0_linear_34_108"
        x1="2.5"
        y1="8.81277"
        x2="15.4917"
        y2="8.81277"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor={gradient_1} />
        <stop offset="1" stopColor={gradient_2} />
      </linearGradient>
      <linearGradient
        id="paint1_linear_34_108"
        x1="5.5"
        y1="11.3471"
        x2="17.5"
        y2="11.3471"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor={gradient_1} />
        <stop offset="1" stopColor={gradient_2} />
      </linearGradient>
    </defs>
  </svg>
);
