// For now, we are using a local copy of react-html-attributes.
// Eventually, the relative path here should be removed, and
// the version number of react-html-attributes should be bumped.
module.exports.htmlProps = require("./react-html-attributes");
module.exports.svgProps = require("svg-element-attributes");

module.exports.voids = ["area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param", "source", "track", "wbr"];
// The types for certain attributes differ according to their containing element.
// These appear in the typesByElement object, using "*" as a default element
// (required only if the default attribute type is other than `String`).
// For clarity, it is an error for any attribute to be in both `types` and `typesByElement`.
module.exports.typesByElement = {
  "cols": {
    "textarea": "Int",
  },
  "max": {
    "meter": "Number",
    "progress": "Number"
  },
  "min": {
    "meter": "Number"
  },
  "rows": {
    "textarea": "Int"
  },
  "size" : {
    "input": "Int",
    "select": "Int"
  }
};
module.exports.types = {
  "_data": "Object String",
  "allowFullScreen": "Boolean",
  "allowTransparency": "Boolean",
  "async": "Boolean",
  "autoComplete": "Boolean",
  "autoFocus": "Boolean",
  "autoPlay": "Boolean",
  "capture": "Boolean",
  "checked": "Boolean",
  "children": "Array JSX",
  "colSpan": "Int",
  "contentEditable": "Boolean",
  "controls": "Boolean",
  "dangerouslySetInnerHTML": "{ __html :: String }",
  "default": "Boolean",
  "defer": "Boolean",
  "disabled": "Boolean",
  "draggable": "Boolean",
  "formNoValidate": "Boolean",
  "hidden": "Boolean",
  "itemScope": "Boolean",
  "loop": "Boolean",
  "maxLength": "Int",
  "minLength": "Int",
  "multiple": "Boolean",
  "muted": "Boolean",
  "noValidate": "Boolean",
  "onAbort": "EventHandler",
  "onAnimationEnd": "EventHandler",
  "onAnimationIteration": "EventHandler",
  "onAnimationStart": "EventHandler",
  "onBlur": "EventHandler",
  "onCanPlay": "EventHandler",
  "onCanPlayThrough": "EventHandler",
  "onChange": "EventHandler",
  "onClick": "EventHandler",
  "onCompositionEnd": "EventHandler",
  "onCompositionStart": "EventHandler",
  "onCompositionUpdate": "EventHandler",
  "onContextMenu": "EventHandler",
  "onCopy": "EventHandler",
  "onCut": "EventHandler",
  "onDoubleClick": "EventHandler",
  "onDrag": "EventHandler",
  "onDragEnd": "EventHandler",
  "onDragEnter": "EventHandler",
  "onDragExit": "EventHandler",
  "onDragLeave": "EventHandler",
  "onDragOver": "EventHandler",
  "onDragStart": "EventHandler",
  "onDrop": "EventHandler",
  "onDurationChange": "EventHandler",
  "onEmptied": "EventHandler",
  "onEncrypted": "EventHandler",
  "onEnded": "EventHandler",
  "onError": "EventHandler",
  "onFocus": "EventHandler",
  "onGotPointerCapture": "EventHandler",
  "onInput": "EventHandler",
  "onInvalid": "EventHandler",
  "onKeyDown": "EventHandler",
  "onKeyPress": "EventHandler",
  "onKeyUp": "EventHandler",
  "onLoad": "EventHandler",
  "onLoadedData": "EventHandler",
  "onLoadedMetadata": "EventHandler",
  "onLoadStart": "EventHandler",
  "onLostPointerCapture": "EventHandler",
  "onMouseDown": "EventHandler",
  "onMouseEnter": "EventHandler",
  "onMouseLeave": "EventHandler",
  "onMouseMove": "EventHandler",
  "onMouseOut": "EventHandler",
  "onMouseOver": "EventHandler",
  "onMouseUp": "EventHandler",
  "onPaste": "EventHandler",
  "onPause": "EventHandler",
  "onPlay": "EventHandler",
  "onPlaying": "EventHandler",
  "onPointerCancel": "EventHandler",
  "onPointerDown": "EventHandler",
  "onPointerEnter": "EventHandler",
  "onPointerLeave": "EventHandler",
  "onPointerMove": "EventHandler",
  "onPointerOut": "EventHandler",
  "onPointerOver": "EventHandler",
  "onPointerUp": "EventHandler",
  "onProgress": "EventHandler",
  "onRateChange": "EventHandler",
  "onScroll": "EventHandler",
  "onSeeked": "EventHandler",
  "onSeeking": "EventHandler",
  "onSelect": "EventHandler",
  "onStalled": "EventHandler",
  "onSubmit": "EventHandler",
  "onSuspend": "EventHandler",
  "onTimeUpdate": "EventHandler",
  "onTouchCancel": "EventHandler",
  "onTouchEnd": "EventHandler",
  "onTouchMove": "EventHandler",
  "onTouchStart": "EventHandler",
  "onTransitionEnd": "EventHandler",
  "onVolumeChange": "EventHandler",
  "onWaiting": "EventHandler",
  "onWheel": "EventHandler",
  "open": "Boolean",
  "playsInline": "Boolean",
  "readOnly": "Boolean",
  "ref": "Ref (Nullable Node)",
  "required": "Boolean",
  "reversed": "Boolean",
  "rowSpan": "Int",
  "scoped": "Boolean",
  "seamless": "Boolean",
  "selected": "Boolean",
  "span": "Int",
  "spellCheck": "Boolean",
  "srcDoc": "JSX",
  "start": "Int",
  "style": "CSS",
  "suppressContentEditableWarning": "Boolean",
  "tabIndex": "Int",
  "unselectable": "Boolean"
};
module.exports.reserved = ["module", "data", "type", "newtype", "class", "instance", "where", "derive", "if", "then", "else", "case", "of"];
