/*
Copyright 2023.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	codeflarev1alpha1 "github.com/project-codeflare/codeflare-operator/api/codeflare/v1alpha1"
	versioned "github.com/project-codeflare/codeflare-operator/client/clientset/versioned"
	internalinterfaces "github.com/project-codeflare/codeflare-operator/client/informer/externalversions/internalinterfaces"
	v1alpha1 "github.com/project-codeflare/codeflare-operator/client/listers/codeflare/v1alpha1"
)

// InstaScaleInformer provides access to a shared informer and lister for
// InstaScales.
type InstaScaleInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.InstaScaleLister
}

type instaScaleInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewInstaScaleInformer constructs a new informer for InstaScale type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewInstaScaleInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredInstaScaleInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredInstaScaleInformer constructs a new informer for InstaScale type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredInstaScaleInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CodeflareV1alpha1().InstaScales(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CodeflareV1alpha1().InstaScales(namespace).Watch(context.TODO(), options)
			},
		},
		&codeflarev1alpha1.InstaScale{},
		resyncPeriod,
		indexers,
	)
}

func (f *instaScaleInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredInstaScaleInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *instaScaleInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&codeflarev1alpha1.InstaScale{}, f.defaultInformer)
}

func (f *instaScaleInformer) Lister() v1alpha1.InstaScaleLister {
	return v1alpha1.NewInstaScaleLister(f.Informer().GetIndexer())
}
