/*
Copyright 2023.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "github.com/project-codeflare/codeflare-operator/api/codeflare/v1alpha1"
	codeflarev1alpha1 "github.com/project-codeflare/codeflare-operator/client/applyconfiguration/codeflare/v1alpha1"
	scheme "github.com/project-codeflare/codeflare-operator/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// InstaScalesGetter has a method to return a InstaScaleInterface.
// A group's client should implement this interface.
type InstaScalesGetter interface {
	InstaScales(namespace string) InstaScaleInterface
}

// InstaScaleInterface has methods to work with InstaScale resources.
type InstaScaleInterface interface {
	Create(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.CreateOptions) (*v1alpha1.InstaScale, error)
	Update(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.UpdateOptions) (*v1alpha1.InstaScale, error)
	UpdateStatus(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.UpdateOptions) (*v1alpha1.InstaScale, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.InstaScale, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.InstaScaleList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.InstaScale, err error)
	Apply(ctx context.Context, instaScale *codeflarev1alpha1.InstaScaleApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InstaScale, err error)
	ApplyStatus(ctx context.Context, instaScale *codeflarev1alpha1.InstaScaleApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InstaScale, err error)
	InstaScaleExpansion
}

// instaScales implements InstaScaleInterface
type instaScales struct {
	client rest.Interface
	ns     string
}

// newInstaScales returns a InstaScales
func newInstaScales(c *CodeflareV1alpha1Client, namespace string) *instaScales {
	return &instaScales{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the instaScale, and returns the corresponding instaScale object, and an error if there is any.
func (c *instaScales) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.InstaScale, err error) {
	result = &v1alpha1.InstaScale{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("instascales").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of InstaScales that match those selectors.
func (c *instaScales) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.InstaScaleList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.InstaScaleList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("instascales").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested instaScales.
func (c *instaScales) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("instascales").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a instaScale and creates it.  Returns the server's representation of the instaScale, and an error, if there is any.
func (c *instaScales) Create(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.CreateOptions) (result *v1alpha1.InstaScale, err error) {
	result = &v1alpha1.InstaScale{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("instascales").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(instaScale).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a instaScale and updates it. Returns the server's representation of the instaScale, and an error, if there is any.
func (c *instaScales) Update(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.UpdateOptions) (result *v1alpha1.InstaScale, err error) {
	result = &v1alpha1.InstaScale{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("instascales").
		Name(instaScale.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(instaScale).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *instaScales) UpdateStatus(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.UpdateOptions) (result *v1alpha1.InstaScale, err error) {
	result = &v1alpha1.InstaScale{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("instascales").
		Name(instaScale.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(instaScale).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the instaScale and deletes it. Returns an error if one occurs.
func (c *instaScales) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("instascales").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *instaScales) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("instascales").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched instaScale.
func (c *instaScales) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.InstaScale, err error) {
	result = &v1alpha1.InstaScale{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("instascales").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied instaScale.
func (c *instaScales) Apply(ctx context.Context, instaScale *codeflarev1alpha1.InstaScaleApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InstaScale, err error) {
	if instaScale == nil {
		return nil, fmt.Errorf("instaScale provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(instaScale)
	if err != nil {
		return nil, err
	}
	name := instaScale.Name
	if name == nil {
		return nil, fmt.Errorf("instaScale.Name must be provided to Apply")
	}
	result = &v1alpha1.InstaScale{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("instascales").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *instaScales) ApplyStatus(ctx context.Context, instaScale *codeflarev1alpha1.InstaScaleApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InstaScale, err error) {
	if instaScale == nil {
		return nil, fmt.Errorf("instaScale provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(instaScale)
	if err != nil {
		return nil, err
	}

	name := instaScale.Name
	if name == nil {
		return nil, fmt.Errorf("instaScale.Name must be provided to Apply")
	}

	result = &v1alpha1.InstaScale{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("instascales").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
