/*
Copyright 2023.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/project-codeflare/codeflare-operator/api/codeflare/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// MCADLister helps list MCADs.
// All objects returned here must be treated as read-only.
type MCADLister interface {
	// List lists all MCADs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.MCAD, err error)
	// MCADs returns an object that can list and get MCADs.
	MCADs(namespace string) MCADNamespaceLister
	MCADListerExpansion
}

// mCADLister implements the MCADLister interface.
type mCADLister struct {
	indexer cache.Indexer
}

// NewMCADLister returns a new MCADLister.
func NewMCADLister(indexer cache.Indexer) MCADLister {
	return &mCADLister{indexer: indexer}
}

// List lists all MCADs in the indexer.
func (s *mCADLister) List(selector labels.Selector) (ret []*v1alpha1.MCAD, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.MCAD))
	})
	return ret, err
}

// MCADs returns an object that can list and get MCADs.
func (s *mCADLister) MCADs(namespace string) MCADNamespaceLister {
	return mCADNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// MCADNamespaceLister helps list and get MCADs.
// All objects returned here must be treated as read-only.
type MCADNamespaceLister interface {
	// List lists all MCADs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.MCAD, err error)
	// Get retrieves the MCAD from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.MCAD, error)
	MCADNamespaceListerExpansion
}

// mCADNamespaceLister implements the MCADNamespaceLister
// interface.
type mCADNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all MCADs in the indexer for a given namespace.
func (s mCADNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.MCAD, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.MCAD))
	})
	return ret, err
}

// Get retrieves the MCAD from the indexer for a given namespace and name.
func (s mCADNamespaceLister) Get(name string) (*v1alpha1.MCAD, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("mcad"), name)
	}
	return obj.(*v1alpha1.MCAD), nil
}
