/*
Copyright 2023.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/project-codeflare/codeflare-operator/api/codeflare/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// InstaScaleLister helps list InstaScales.
// All objects returned here must be treated as read-only.
type InstaScaleLister interface {
	// List lists all InstaScales in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.InstaScale, err error)
	// InstaScales returns an object that can list and get InstaScales.
	InstaScales(namespace string) InstaScaleNamespaceLister
	InstaScaleListerExpansion
}

// instaScaleLister implements the InstaScaleLister interface.
type instaScaleLister struct {
	indexer cache.Indexer
}

// NewInstaScaleLister returns a new InstaScaleLister.
func NewInstaScaleLister(indexer cache.Indexer) InstaScaleLister {
	return &instaScaleLister{indexer: indexer}
}

// List lists all InstaScales in the indexer.
func (s *instaScaleLister) List(selector labels.Selector) (ret []*v1alpha1.InstaScale, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.InstaScale))
	})
	return ret, err
}

// InstaScales returns an object that can list and get InstaScales.
func (s *instaScaleLister) InstaScales(namespace string) InstaScaleNamespaceLister {
	return instaScaleNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// InstaScaleNamespaceLister helps list and get InstaScales.
// All objects returned here must be treated as read-only.
type InstaScaleNamespaceLister interface {
	// List lists all InstaScales in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.InstaScale, err error)
	// Get retrieves the InstaScale from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.InstaScale, error)
	InstaScaleNamespaceListerExpansion
}

// instaScaleNamespaceLister implements the InstaScaleNamespaceLister
// interface.
type instaScaleNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all InstaScales in the indexer for a given namespace.
func (s instaScaleNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.InstaScale, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.InstaScale))
	})
	return ret, err
}

// Get retrieves the InstaScale from the indexer for a given namespace and name.
func (s instaScaleNamespaceLister) Get(name string) (*v1alpha1.InstaScale, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("instascale"), name)
	}
	return obj.(*v1alpha1.InstaScale), nil
}
