/*
Copyright 2023.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "github.com/project-codeflare/codeflare-operator/api/codeflare/v1alpha1"
	codeflarev1alpha1 "github.com/project-codeflare/codeflare-operator/client/applyconfiguration/codeflare/v1alpha1"
	scheme "github.com/project-codeflare/codeflare-operator/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MCADsGetter has a method to return a MCADInterface.
// A group's client should implement this interface.
type MCADsGetter interface {
	MCADs(namespace string) MCADInterface
}

// MCADInterface has methods to work with MCAD resources.
type MCADInterface interface {
	Create(ctx context.Context, mCAD *v1alpha1.MCAD, opts v1.CreateOptions) (*v1alpha1.MCAD, error)
	Update(ctx context.Context, mCAD *v1alpha1.MCAD, opts v1.UpdateOptions) (*v1alpha1.MCAD, error)
	UpdateStatus(ctx context.Context, mCAD *v1alpha1.MCAD, opts v1.UpdateOptions) (*v1alpha1.MCAD, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.MCAD, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.MCADList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.MCAD, err error)
	Apply(ctx context.Context, mCAD *codeflarev1alpha1.MCADApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MCAD, err error)
	ApplyStatus(ctx context.Context, mCAD *codeflarev1alpha1.MCADApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MCAD, err error)
	MCADExpansion
}

// mCADs implements MCADInterface
type mCADs struct {
	client rest.Interface
	ns     string
}

// newMCADs returns a MCADs
func newMCADs(c *CodeflareV1alpha1Client, namespace string) *mCADs {
	return &mCADs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the mCAD, and returns the corresponding mCAD object, and an error if there is any.
func (c *mCADs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.MCAD, err error) {
	result = &v1alpha1.MCAD{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("mcads").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MCADs that match those selectors.
func (c *mCADs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.MCADList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.MCADList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("mcads").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested mCADs.
func (c *mCADs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("mcads").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a mCAD and creates it.  Returns the server's representation of the mCAD, and an error, if there is any.
func (c *mCADs) Create(ctx context.Context, mCAD *v1alpha1.MCAD, opts v1.CreateOptions) (result *v1alpha1.MCAD, err error) {
	result = &v1alpha1.MCAD{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("mcads").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(mCAD).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a mCAD and updates it. Returns the server's representation of the mCAD, and an error, if there is any.
func (c *mCADs) Update(ctx context.Context, mCAD *v1alpha1.MCAD, opts v1.UpdateOptions) (result *v1alpha1.MCAD, err error) {
	result = &v1alpha1.MCAD{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("mcads").
		Name(mCAD.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(mCAD).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *mCADs) UpdateStatus(ctx context.Context, mCAD *v1alpha1.MCAD, opts v1.UpdateOptions) (result *v1alpha1.MCAD, err error) {
	result = &v1alpha1.MCAD{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("mcads").
		Name(mCAD.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(mCAD).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the mCAD and deletes it. Returns an error if one occurs.
func (c *mCADs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("mcads").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *mCADs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("mcads").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched mCAD.
func (c *mCADs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.MCAD, err error) {
	result = &v1alpha1.MCAD{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("mcads").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied mCAD.
func (c *mCADs) Apply(ctx context.Context, mCAD *codeflarev1alpha1.MCADApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MCAD, err error) {
	if mCAD == nil {
		return nil, fmt.Errorf("mCAD provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(mCAD)
	if err != nil {
		return nil, err
	}
	name := mCAD.Name
	if name == nil {
		return nil, fmt.Errorf("mCAD.Name must be provided to Apply")
	}
	result = &v1alpha1.MCAD{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("mcads").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *mCADs) ApplyStatus(ctx context.Context, mCAD *codeflarev1alpha1.MCADApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MCAD, err error) {
	if mCAD == nil {
		return nil, fmt.Errorf("mCAD provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(mCAD)
	if err != nil {
		return nil, err
	}

	name := mCAD.Name
	if name == nil {
		return nil, fmt.Errorf("mCAD.Name must be provided to Apply")
	}

	result = &v1alpha1.MCAD{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("mcads").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
