/*
Copyright 2023.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha1 "github.com/project-codeflare/codeflare-operator/api/codeflare/v1alpha1"
	codeflarev1alpha1 "github.com/project-codeflare/codeflare-operator/client/applyconfiguration/codeflare/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeInstaScales implements InstaScaleInterface
type FakeInstaScales struct {
	Fake *FakeCodeflareV1alpha1
	ns   string
}

var instascalesResource = v1alpha1.SchemeGroupVersion.WithResource("instascales")

var instascalesKind = v1alpha1.SchemeGroupVersion.WithKind("InstaScale")

// Get takes name of the instaScale, and returns the corresponding instaScale object, and an error if there is any.
func (c *FakeInstaScales) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.InstaScale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(instascalesResource, c.ns, name), &v1alpha1.InstaScale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.InstaScale), err
}

// List takes label and field selectors, and returns the list of InstaScales that match those selectors.
func (c *FakeInstaScales) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.InstaScaleList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(instascalesResource, instascalesKind, c.ns, opts), &v1alpha1.InstaScaleList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.InstaScaleList{ListMeta: obj.(*v1alpha1.InstaScaleList).ListMeta}
	for _, item := range obj.(*v1alpha1.InstaScaleList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested instaScales.
func (c *FakeInstaScales) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(instascalesResource, c.ns, opts))

}

// Create takes the representation of a instaScale and creates it.  Returns the server's representation of the instaScale, and an error, if there is any.
func (c *FakeInstaScales) Create(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.CreateOptions) (result *v1alpha1.InstaScale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(instascalesResource, c.ns, instaScale), &v1alpha1.InstaScale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.InstaScale), err
}

// Update takes the representation of a instaScale and updates it. Returns the server's representation of the instaScale, and an error, if there is any.
func (c *FakeInstaScales) Update(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.UpdateOptions) (result *v1alpha1.InstaScale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(instascalesResource, c.ns, instaScale), &v1alpha1.InstaScale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.InstaScale), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeInstaScales) UpdateStatus(ctx context.Context, instaScale *v1alpha1.InstaScale, opts v1.UpdateOptions) (*v1alpha1.InstaScale, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(instascalesResource, "status", c.ns, instaScale), &v1alpha1.InstaScale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.InstaScale), err
}

// Delete takes name of the instaScale and deletes it. Returns an error if one occurs.
func (c *FakeInstaScales) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(instascalesResource, c.ns, name, opts), &v1alpha1.InstaScale{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeInstaScales) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(instascalesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.InstaScaleList{})
	return err
}

// Patch applies the patch and returns the patched instaScale.
func (c *FakeInstaScales) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.InstaScale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(instascalesResource, c.ns, name, pt, data, subresources...), &v1alpha1.InstaScale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.InstaScale), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied instaScale.
func (c *FakeInstaScales) Apply(ctx context.Context, instaScale *codeflarev1alpha1.InstaScaleApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InstaScale, err error) {
	if instaScale == nil {
		return nil, fmt.Errorf("instaScale provided to Apply must not be nil")
	}
	data, err := json.Marshal(instaScale)
	if err != nil {
		return nil, err
	}
	name := instaScale.Name
	if name == nil {
		return nil, fmt.Errorf("instaScale.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(instascalesResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha1.InstaScale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.InstaScale), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeInstaScales) ApplyStatus(ctx context.Context, instaScale *codeflarev1alpha1.InstaScaleApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InstaScale, err error) {
	if instaScale == nil {
		return nil, fmt.Errorf("instaScale provided to Apply must not be nil")
	}
	data, err := json.Marshal(instaScale)
	if err != nil {
		return nil, err
	}
	name := instaScale.Name
	if name == nil {
		return nil, fmt.Errorf("instaScale.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(instascalesResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha1.InstaScale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.InstaScale), err
}
