import sys
import re


out_file_beg = """/*-------------------------------------------------------------------------
 *
 * {0}
 *    Generated node infrastructure code
 *
 * PgPro (C)
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by pg_uporbe/gen_node_names_array.py
 *
 *-------------------------------------------------------------------------
 */
 "Invalid",\n"""


def parse_nodetags(in_file_name: str, out_file_name: str) -> None:
    nodes_file = open(in_file_name, "r")
    out_file = open(out_file_name, "w")
    out_file.write(out_file_beg.format(out_file_name))

    file_lines = nodes_file.readlines()
    for i in range(len(file_lines)):
        line = file_lines[i]
        if line.startswith(("/*", " *")): #skip comments at the start
            continue

        # line format is: "  T_NodeName = 1,/n"
        line_splited = line[line.find("_") + 1 :].split(" = ")
        node_name = line_splited[0]
        if (i != len(file_lines) - 1):
            out_file.write('"' + node_name + '",\n')
        else:
            out_file.write('"' + node_name + '"\n')
    nodes_file.close()
    out_file.close()


def parse_nodes_enum(in_file_name: str, out_file_name: str) -> None:
    nodes_file = open(in_file_name, "r")
    out_file = open(out_file_name, "w")
    out_file.write(out_file_beg.format(out_file_name))
    index_line_of_enum_start: int = -1
    index_line_of_enum_end: int = -1

    file_lines:list[str] = nodes_file.readlines()

    # finding start and end of enum NodeTag
    for i in range(len(file_lines)):
        if (file_lines[i] == "typedef enum NodeTag\n"):
            index_line_of_enum_start = i + 3 #skipping enum entry till end of "T_Invalid = 0," line

        if (index_line_of_enum_start != -1 and file_lines[i] == "} NodeTag;\n"):
            index_line_of_enum_end = i

    # working with enum entries
    for i in range(index_line_of_enum_start, index_line_of_enum_end):
        current_line = file_lines[i].strip().strip("	") #removing spaces and tab symbols
        if (not current_line.startswith("T_")):
            continue
        current_line = current_line[2:] # we skip "T_"
        if (i != index_line_of_enum_end - 1):
            current_line = current_line.split(",")[0]
        else:
            current_line = re.match(r'^[a-zA-Z]+', current_line).group(0) # we take only letters before anything else

        if (i != index_line_of_enum_end - 1):
            out_file.write('"' + current_line + '",\n')
        else:
            out_file.write('"' + current_line + '"\n')

    nodes_file.close()
    out_file.close()


def main():
    args = sys.argv

    if len(args) != 4 :
        print("invalid number of args given\n need two arg: pg_major_version, path to nodes include dir, out file name")
        exit(1)

    if (int(args[1]) >= 16):
        parse_nodetags(args[2] + "/nodetags.h", args[3])
    else:
        parse_nodes_enum(args[2] + "/nodes.h", args[3])










if __name__ == "__main__" :
    main()
