# Пример трассирования сеанса

Подразумевается, что расширение уже установлено и настроено. Как установить и настроить расширение можно посмотреть в основном файле [README](./../README.md#установка).

Установим следующие настройки для большей наглядности:
- pg_uprobe.trace_write_mode='json'
- pg_uprobe.write_only_sleep_lwlocks_stat='false'

Создадим таблицу к которой будем посылать запросы и трассировать их.
```sql
create table t(id int primary key);

insert into t values (1);
```
## Трассирование текущего сеанса

Начнём трассирование сеанса:
```sql
select start_session_trace();
```
Выполним запрос:

```sql
select * from t where id = 1;
```
Остановим трассирование сеанса:
```sql
select stop_session_trace();
```

Результат трассирования будет находиться в каталоге, указанном в настройке `pg_uprobe.data_dir`(по умолчанию `$PGDATA/pg_uprobe`).

В нашем случае получается следующий файл: [Пример результата](./example_trace_session.json)

## Трассирование сеанса по PID
Прежде чем трассировать другой сеанс по PID, необходимо подготовить сам сеанс, для этого заходим в `psql` и узнаём номер PID, который мы будем трассировать:
```sql
--Terminal-1

select pg_backend_pid();
 pg_backend_pid 
----------------
         411064
```
411064 - Пид, который мы будем трассировать из другой сессии.

Для того, чтобы начать трассировать, необходимо открыть ещё один терминал `psql`:

```sql
--Terminal-2

-- Убедимся, что мы действительно в другом терминале
select pg_backend_pid();
 pg_backend_pid 
----------------
         997809

```

Начнём трассирование сеанса:
```sql
--Terminal-2

select start_session_trace_pid(411064);
```
В первом терминале выполним запрос, обратите внимание, что первый запрос не запишется, а трассирование начнётся только с второго запроса:
```sql
--Terminal-1

select 1; -- Запрос не запишется в результирующий файл

select * from t where id = 1;
```

Остановим трассирование сеанса:
```sql
select stop_session_trace_pid(411064);
```

В этом случае получается аналогичный файл: [Пример результата](./example_trace_session.json)
