/*--------------------------------------------------------------------------
 * Copyright (c) 2019-2021, Postgres.ai, Nikolay Samokhvalov nik@postgres.ai
 * All Rights Reserved. Proprietary and confidential.
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *--------------------------------------------------------------------------
 */

export const icons = {
  exitIcon: (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M7.97344 14.6443H1.99334C1.62656 14.6443 1.32891 14.3466 1.32891 13.9799V2.01974C1.32891 1.65296 1.62659 1.3553 1.99334 1.3553H7.97344C8.34087 1.3553 8.63787 1.0583 8.63787 0.690867C8.63787 0.32343 8.34087 0.0263672 7.97344 0.0263672H1.99334C0.894344 0.0263672 0 0.920742 0 2.01974V13.9799C0 15.0789 0.894344 15.9732 1.99334 15.9732H7.97344C8.34087 15.9732 8.63787 15.6762 8.63787 15.3088C8.63787 14.9413 8.34087 14.6443 7.97344 14.6443Z"
        fill="white"
      />
      <path
        d="M15.802 7.52713L11.7622 3.54041C11.5017 3.2826 11.0805 3.28594 10.8226 3.54707C10.5648 3.80819 10.5675 4.22879 10.8293 4.4866L13.7163 7.33576H5.98011C5.61267 7.33576 5.31567 7.63276 5.31567 8.00019C5.31567 8.36763 5.61267 8.66466 5.98011 8.66466H13.7163L10.8293 11.5138C10.5675 11.7716 10.5655 12.1922 10.8226 12.4534C10.9529 12.5849 11.1243 12.6514 11.2957 12.6514C11.4645 12.6514 11.6333 12.5876 11.7622 12.46L15.802 8.47326C15.9283 8.34835 16 8.17823 16 8.00016C16 7.82216 15.929 7.65272 15.802 7.52713Z"
        fill="white"
      />
    </svg>
  ),
  userIcon: (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M13.6569 2.34314C12.1459 0.832153 10.1368 0 8 0C5.86304 0 3.85413 0.832153 2.34314 2.34314C0.832153 3.85413 0 5.86304 0 8C0 10.1368 0.832153 12.1459 2.34314 13.6569C3.85413 15.1678 5.86304 16 8 16C10.1368 16 12.1459 15.1678 13.6569 13.6569C15.1678 12.1459 16 10.1368 16 8C16 5.86304 15.1678 3.85413 13.6569 2.34314ZM4.01062 13.8246C4.34521 11.8981 6.01465 10.4771 8 10.4771C9.98547 10.4771 11.6548 11.8981 11.9894 13.8246C10.8535 14.605 9.47925 15.0625 8 15.0625C6.52075 15.0625 5.14648 14.605 4.01062 13.8246ZM5.4563 6.99585C5.4563 5.59314 6.59741 4.45215 8 4.45215C9.40259 4.45215 10.5437 5.59326 10.5437 6.99585C10.5437 8.39844 9.40259 9.53955 8 9.53955C6.59741 9.53955 5.4563 8.39844 5.4563 6.99585ZM12.8014 13.1743C12.5491 12.2775 12.048 11.4637 11.3456 10.8281C10.9147 10.4381 10.4242 10.1304 9.89685 9.91345C10.85 9.29175 11.4813 8.21619 11.4813 6.99585C11.4813 5.07629 9.91956 3.51465 8 3.51465C6.08044 3.51465 4.5188 5.07629 4.5188 6.99585C4.5188 8.21619 5.15015 9.29175 6.10315 9.91345C5.57593 10.1304 5.08533 10.438 4.65442 10.828C3.95215 11.4636 3.45093 12.2773 3.19861 13.1742C1.80884 11.8835 0.9375 10.0417 0.9375 8C0.9375 4.10571 4.10571 0.9375 8 0.9375C11.8943 0.9375 15.0625 4.10571 15.0625 8C15.0625 10.0419 14.1912 11.8837 12.8014 13.1743Z"
        fill="white"
      />
    </svg>
  ),
  dashboardIcon: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M4.62497 4.00003H0.874969C0.392487 4.00003 0 3.60754 0 3.12497V0.874969C0 0.392487 0.392487 0 0.874969 0H4.62497C5.10754 0 5.50003 0.392487 5.50003 0.874969V3.12497C5.50003 3.60754 5.10754 4.00003 4.62497 4.00003ZM0.874969 0.75C0.80603 0.75 0.75 0.80603 0.75 0.874969V3.12497C0.75 3.194 0.80603 3.25003 0.874969 3.25003H4.62497C4.694 3.25003 4.75003 3.194 4.75003 3.12497V0.874969C4.75003 0.80603 4.694 0.75 4.62497 0.75H0.874969Z"
        fill="black"
      />
      <path
        d="M4.62497 12H0.874969C0.392487 12 0 11.6075 0 11.1251V5.87506C0 5.39249 0.392487 5 0.874969 5H4.62497C5.10754 5 5.50003 5.39249 5.50003 5.87506V11.1251C5.50003 11.6075 5.10754 12 4.62497 12ZM0.874969 5.75C0.80603 5.75 0.75 5.80603 0.75 5.87506V11.1251C0.75 11.194 0.80603 11.25 0.874969 11.25H4.62497C4.694 11.25 4.75003 11.194 4.75003 11.1251V5.87506C4.75003 5.80603 4.694 5.75 4.62497 5.75H0.874969Z"
        fill="black"
      />
      <path
        d="M11.1251 12H7.37506C6.89249 12 6.5 11.6075 6.5 11.1251V8.87506C6.5 8.39249 6.89249 8 7.37506 8H11.1251C11.6075 8 12 8.39249 12 8.87506V11.1251C12 11.6075 11.6075 12 11.1251 12ZM7.37506 8.75C7.30603 8.75 7.25 8.80603 7.25 8.87506V11.1251C7.25 11.194 7.30603 11.25 7.37506 11.25H11.1251C11.194 11.25 11.25 11.194 11.25 11.1251V8.87506C11.25 8.80603 11.194 8.75 11.1251 8.75H7.37506Z"
        fill="black"
      />
      <path
        d="M11.1251 7.00003H7.37506C6.89249 7.00003 6.5 6.60754 6.5 6.12497V0.874969C6.5 0.392487 6.89249 0 7.37506 0H11.1251C11.6075 0 12 0.392487 12 0.874969V6.12497C12 6.60754 11.6075 7.00003 11.1251 7.00003ZM7.37506 0.75C7.30603 0.75 7.25 0.80603 7.25 0.874969V6.12497C7.25 6.194 7.30603 6.25003 7.37506 6.25003H11.1251C11.194 6.25003 11.25 6.194 11.25 6.12497V0.874969C11.25 0.80603 11.194 0.75 11.1251 0.75H7.37506Z"
        fill="black"
      />
    </svg>
  ),
  databaseLabIcon: (
    <svg
      width="14"
      height="9"
      viewBox="0 0 14 9"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.402978 2.35249C0.168411 2.14894 0 1.87683 0 1.53955H0.666669C0.666669 1.63267 0.707794 1.73432 0.839914 1.84897C0.977174 1.96808 1.19339 2.08196 1.48578 2.17876C2.06832 2.37163 2.86729 2.46895 3.68365 2.46344C4.49966 2.45792 5.30014 2.34989 5.88475 2.1537C6.17839 2.05516 6.39644 1.9413 6.53499 1.82402C6.66998 1.70974 6.70514 1.61534 6.70514 1.53955H7.37181C7.37181 1.87151 7.19743 2.13671 6.96573 2.33285C6.73759 2.52597 6.43181 2.67333 6.09685 2.78573C5.42424 3.01145 4.54844 3.12428 3.68816 3.13009C2.82823 3.1359 1.95091 3.03502 1.27624 2.81165C0.940031 2.70033 0.632405 2.55158 0.402978 2.35249ZM0.402978 4.07408C0.168411 3.87053 0 3.59841 0 3.26114H0.666669C0.666669 3.35426 0.707794 3.45591 0.839914 3.57056C0.977174 3.68967 1.19339 3.80354 1.48578 3.90035C2.06832 4.09322 2.86729 4.19054 3.68365 4.18503C4.49966 4.17951 5.30014 4.07148 5.88475 3.87529C6.17839 3.77675 6.39644 3.66289 6.53499 3.54561C6.66998 3.43133 6.70514 3.33693 6.70514 3.26114H7.37181C7.37181 3.5931 7.19743 3.8583 6.96573 4.05444C6.73759 4.24756 6.43181 4.39492 6.09685 4.50732C5.42424 4.73304 4.54844 4.84587 3.68816 4.85168C2.82823 4.85749 1.95091 4.75661 1.27624 4.53323C0.940031 4.42192 0.632405 4.27317 0.402978 4.07408ZM0.402978 5.70506C0.168411 5.50151 0 5.22939 0 4.89212H0.666669C0.666669 4.98524 0.707794 5.08689 0.839914 5.20154C0.977174 5.32065 1.19339 5.43452 1.48578 5.53133C2.06832 5.7242 2.86729 5.82152 3.68365 5.81601C4.49966 5.81049 5.30014 5.70246 5.88475 5.50627C6.17839 5.40773 6.39644 5.29387 6.53499 5.17659C6.66998 5.06231 6.70514 4.96791 6.70514 4.89212H7.37181C7.37181 5.22408 7.19743 5.48928 6.96573 5.68542C6.73759 5.87854 6.43181 6.0259 6.09685 6.1383C5.42424 6.36402 4.54844 6.47685 3.68816 6.48266C2.82823 6.48847 1.95091 6.38759 1.27624 6.16421C0.940031 6.0529 0.632405 5.90415 0.402978 5.70506Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.66667 1.4986L0.666673 6.58424C0.78839 6.8042 1.11038 7.0266 1.6624 7.1938C2.23403 7.36695 2.96199 7.45257 3.70041 7.44708C4.43865 7.4416 5.16498 7.34521 5.73271 7.16899C6.01665 7.08086 6.24972 6.97618 6.42249 6.86111C6.5677 6.76438 6.65647 6.66973 6.70514 6.58397L6.70514 1.55181C6.6651 1.45725 6.58184 1.35452 6.43377 1.2499C6.26468 1.13043 6.03022 1.0226 5.73926 0.933004C5.15766 0.753914 4.40414 0.66398 3.64133 0.66673C2.87858 0.669481 2.13174 0.764802 1.56409 0.940015C1.27972 1.02779 1.05501 1.13117 0.897771 1.24209C0.760161 1.33916 0.694116 1.42735 0.66667 1.4986ZM6.81847 0.705432C7.06382 0.878784 7.26829 1.10576 7.35726 1.39693L7.37181 1.44455L7.37181 6.72424L7.3473 6.78457C7.24 7.0487 7.03283 7.25559 6.79207 7.41595C6.54983 7.57731 6.25305 7.70553 5.93033 7.8057C5.28473 8.00608 4.49051 8.1079 3.70537 8.11373C2.92042 8.11957 2.12216 8.02964 1.46914 7.83185C0.840111 7.64132 0.244846 7.31967 0.0251106 6.78602L4.74355e-06 6.72505L0 1.408L0.00995294 1.36818C0.0815807 1.08167 0.280377 0.861751 0.513495 0.697313C0.747891 0.531973 1.0441 0.402815 1.36747 0.303001C2.01531 0.103033 2.83125 0.00297767 3.63892 6.5497e-05C4.44653 -0.00284645 5.27105 0.0912716 5.93546 0.295858C6.2675 0.398103 6.57303 0.532012 6.81847 0.705432Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.16407 4.15887C8.91615 4.37119 8.58331 4.55637 8.28749 4.58924L8.21387 3.92664C8.32579 3.91421 8.53661 3.8185 8.73042 3.65252C8.82216 3.57395 8.89573 3.49144 8.9441 3.41531C8.994 3.33679 9.00466 3.28511 9.00466 3.26123H9.67133C9.67133 3.45482 9.59705 3.6308 9.50678 3.77285C9.415 3.9173 9.29319 4.04829 9.16407 4.15887Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.15301 5.79443C8.9001 5.99286 8.57121 6.15249 8.28749 6.18402L8.21387 5.52143C8.33789 5.50764 8.55266 5.41809 8.74148 5.26994C8.94323 5.11164 9.00466 4.97596 9.00466 4.91943H9.67133C9.67133 5.29783 9.39297 5.60615 9.15301 5.79443Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M7.91797 0.124023L8.32626 0.218244C8.98486 0.370229 9.5689 0.811954 9.66754 1.41206C9.7189 1.7245 9.62717 2.03851 9.39646 2.30798C9.17213 2.57 8.82378 2.78353 8.3592 2.94246L7.91797 3.09341V0.124023ZM8.58464 1.02227V2.11627C8.72519 2.03478 8.82379 1.95179 8.89003 1.87441C9.00477 1.74039 9.0263 1.62117 9.0097 1.5202C8.98383 1.36278 8.84248 1.16723 8.58464 1.02227Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.67147 1.69434V6.39619L9.67101 6.40494C9.64614 6.87741 9.38688 7.19717 9.11178 7.40454C8.85809 7.59577 8.56805 7.70883 8.39718 7.77544C8.38857 7.7788 8.38027 7.78203 8.37228 7.78516L7.91748 7.96312V2.62711H8.58415V6.95643C8.62758 6.93066 8.66998 6.90271 8.71049 6.87217C8.88105 6.7436 8.99117 6.58987 9.0048 6.37779V1.69434H9.67147Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.3237 4.15887C11.0758 4.37119 10.743 4.55637 10.4472 4.58924L10.3735 3.92664C10.4855 3.91421 10.6963 3.8185 10.8901 3.65252C10.9818 3.57395 11.0554 3.49144 11.1038 3.41531C11.1537 3.33679 11.1643 3.28511 11.1643 3.26123H11.831C11.831 3.45482 11.7567 3.6308 11.6665 3.77285C11.5747 3.9173 11.4529 4.04829 11.3237 4.15887Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.3127 5.79443C11.0598 5.99286 10.7309 6.15249 10.4472 6.18402L10.3735 5.52143C10.4976 5.50764 10.7123 5.41809 10.9011 5.26994C11.1029 5.11164 11.1643 4.97596 11.1643 4.91943H11.831C11.831 5.29783 11.5526 5.60615 11.3127 5.79443Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.0771 0.124023L10.4854 0.218244C11.144 0.370229 11.7281 0.811954 11.8267 1.41206C11.8781 1.7245 11.7863 2.03851 11.5556 2.30798C11.3313 2.57 10.983 2.78353 10.5184 2.94246L10.0771 3.09341V0.124023ZM10.7438 1.02227V2.11627C10.8844 2.03478 10.983 1.95179 11.0492 1.87441C11.164 1.74039 11.1855 1.62117 11.1689 1.5202C11.143 1.36278 11.0017 1.16723 10.7438 1.02227Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.8311 1.69434V6.39619L11.8307 6.40494C11.8058 6.87741 11.5465 7.19717 11.2714 7.40454C11.0178 7.59577 10.7277 7.70883 10.5569 7.77544C10.5482 7.7788 10.5399 7.78203 10.5319 7.78516L10.0771 7.96312V2.62711H10.7438V6.95643C10.7872 6.93066 10.8296 6.90271 10.8702 6.87217C11.0407 6.7436 11.1508 6.58987 11.1645 6.37779V1.69434H11.8311Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.4839 4.15887C13.236 4.37119 12.9031 4.55637 12.6073 4.58924L12.5337 3.92664C12.6456 3.91421 12.8564 3.8185 13.0502 3.65252C13.142 3.57395 13.2155 3.49144 13.2639 3.41531C13.3138 3.33679 13.3245 3.28511 13.3245 3.26123H13.9912C13.9912 3.45482 13.9169 3.6308 13.8266 3.77285C13.7348 3.9173 13.613 4.04829 13.4839 4.15887Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.4728 5.79443C13.2199 5.99286 12.891 6.15249 12.6073 6.18402L12.5337 5.52143C12.6577 5.50764 12.8725 5.41809 13.0613 5.26994C13.2631 5.11164 13.3245 4.97596 13.3245 4.91943H13.9912C13.9912 5.29783 13.7128 5.60615 13.4728 5.79443Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.2368 0.124023L12.6451 0.218244C13.3037 0.370229 13.8877 0.811954 13.9864 1.41206C14.0378 1.7245 13.946 2.03851 13.7153 2.30798C13.491 2.57 13.1426 2.78353 12.678 2.94246L12.2368 3.09341V0.124023ZM12.9035 1.02227V2.11627C13.044 2.03478 13.1426 1.95179 13.2089 1.87441C13.3236 1.74039 13.3451 1.62117 13.3286 1.5202C13.3027 1.36278 13.1613 1.16723 12.9035 1.02227Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.9908 1.69434V6.39619L13.9903 6.40494C13.9655 6.87741 13.7062 7.19717 13.4311 7.40454C13.1774 7.59577 12.8874 7.70883 12.7165 7.77544C12.7079 7.7788 12.6996 7.78203 12.6916 7.78516L12.2368 7.96312V2.62711H12.9035V6.95643C12.9469 6.93066 12.9893 6.90271 13.0298 6.87217C13.2004 6.7436 13.3105 6.58987 13.3241 6.37779V1.69434H13.9908Z"
        fill="black"
      />
    </svg>
  ),
  checkupIcon: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M11.9492 6.58984C10.9589 6.58984 10.1303 7.29553 9.9397 8.23047H9.43359C8.30279 8.23047 7.38281 9.15045 7.38281 10.2812V11.9492C7.38281 12.6277 6.83082 13.1797 6.15234 13.1797C5.47386 13.1797 4.92188 12.6277 4.92188 11.9492V10.6209C5.39927 10.4515 5.74219 9.99564 5.74219 9.46094V8.74562C6.46849 8.38335 7.15974 7.70593 7.7592 6.75235C8.5272 5.53066 9.02344 4.01792 9.02344 2.89844C9.02344 1.9854 8.9731 1.41646 8.17441 0.966984C8.05345 0.414723 7.56068 0 6.97266 0C6.29418 0 5.74219 0.551988 5.74219 1.23047C5.74219 1.90895 6.29418 2.46094 6.97266 2.46094C7.41861 2.46094 7.80987 2.22245 8.02569 1.86635C8.17649 2.03875 8.20312 2.29644 8.20312 2.89844C8.20312 3.85927 7.74564 5.23258 7.06472 6.31575C6.29978 7.53257 5.36925 8.23047 4.51172 8.23047C3.65419 8.23047 2.72366 7.53257 1.95871 6.31575C1.2778 5.23258 0.820312 3.85927 0.820312 2.89844C0.820312 2.29644 0.846945 2.03875 0.997746 1.86635C1.21357 2.22245 1.60483 2.46094 2.05078 2.46094C2.72926 2.46094 3.28125 1.90895 3.28125 1.23047C3.28125 0.551988 2.72926 0 2.05078 0C1.46275 0 0.969992 0.414723 0.849023 0.966984C0.0502305 1.41652 0 1.98562 0 2.89844C0 4.01792 0.496234 5.53066 1.26424 6.75235C1.8637 7.70593 2.55495 8.38335 3.28125 8.74562V9.46094C3.28125 9.99564 3.62417 10.4515 4.10156 10.6209V11.9492C4.10156 13.08 5.02154 14 6.15234 14C7.28314 14 8.20312 13.08 8.20312 11.9492V10.2812C8.20312 9.60277 8.75511 9.05078 9.43359 9.05078H9.9397C10.1302 9.98572 10.9588 10.6914 11.9492 10.6914C13.08 10.6914 14 9.77143 14 8.64062C14 7.50982 13.08 6.58984 11.9492 6.58984ZM6.97266 1.64062C6.7465 1.64062 6.5625 1.45663 6.5625 1.23047C6.5625 1.00431 6.7465 0.820312 6.97266 0.820312C7.19882 0.820312 7.38281 1.00431 7.38281 1.23047C7.38281 1.45663 7.19882 1.64062 6.97266 1.64062ZM2.05078 0.820312C2.27694 0.820312 2.46094 1.00431 2.46094 1.23047C2.46094 1.45663 2.27694 1.64062 2.05078 1.64062C1.82462 1.64062 1.64062 1.45663 1.64062 1.23047C1.64062 1.00431 1.82462 0.820312 2.05078 0.820312ZM4.51172 9.87109C4.28556 9.87109 4.10156 9.6871 4.10156 9.46094V9.0166C4.23793 9.03902 4.37475 9.05078 4.51172 9.05078C4.64868 9.05078 4.78551 9.03902 4.92188 9.0166V9.46094C4.92188 9.6871 4.73788 9.87109 4.51172 9.87109ZM11.9492 9.87109C11.2707 9.87109 10.7188 9.31911 10.7188 8.64062C10.7188 7.96214 11.2707 7.41016 11.9492 7.41016C12.6277 7.41016 13.1797 7.96214 13.1797 8.64062C13.1797 9.31911 12.6277 9.87109 11.9492 9.87109Z"
        fill="black"
      />
    </svg>
  ),
  sqlOptimizationIcon: (
    <svg
      width="14"
      height="11"
      viewBox="0 0 14 11"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M14 2.05078H12.2551L12.0934 2.19829C10.7722 0.796494 8.93777 0 7 0C5.13026 0 3.37236 0.728134 2.05025 2.05025C0.728134 3.37236 0 5.13026 0 7V7.41016H1.64062V7C1.64062 4.9646 3.29663 3.30859 5.33203 3.30859C6.08067 3.30859 6.80144 3.5314 7.41635 3.95288C7.93898 4.31113 8.35651 4.79135 8.63635 5.35243C8.63635 5.35243 5.84419 7.9001 5.83981 7.90448C5.20012 8.54417 5.20012 9.58505 5.83981 10.2247C6.14967 10.5346 6.56165 10.7053 6.99989 10.7053C7.43814 10.7053 7.85011 10.5346 8.15997 10.2247C8.16467 10.22 10.7168 7.41016 10.7168 7.41016H14V7C14 6.0858 13.827 5.19916 13.4855 4.36165L14 3.79523V2.05078ZM13.1797 2.87109V3.47821L8.56137 8.5634C8.48436 8.32222 8.35085 8.09546 8.15997 7.90448C7.97156 7.71606 7.74522 7.57945 7.49838 7.50105L12.5731 2.87109H13.1797ZM0.838791 6.58984H0.833664C0.922211 5.22939 1.4505 3.95438 2.34975 2.92984L2.73373 3.31372C1.68217 4.05713 0.96109 5.23825 0.838791 6.58984ZM3.47052 2.89043L2.93005 2.34996C3.95448 1.45071 5.22949 0.922531 6.58984 0.834091V2.6658C6.1846 2.54852 5.76205 2.48828 5.33203 2.48828C4.66862 2.48828 4.03833 2.63226 3.47052 2.89043ZM7.88013 3.27623C7.72845 3.1723 7.57155 3.07841 7.41016 2.99446V0.834412C8.9633 0.936951 10.4153 1.61905 11.4872 2.75136L9.26131 4.78217C8.92378 4.18402 8.45403 3.66962 7.88013 3.27623ZM6.4198 9.64465C6.1015 9.32625 6.10011 8.80928 6.41553 8.48906L6.48239 8.42807C6.62819 8.30898 6.80902 8.24425 6.99989 8.24425C7.21896 8.24425 7.425 8.32959 7.57988 8.48457C7.87895 8.78365 7.89828 9.258 7.63809 9.57982L7.57518 9.64914C7.42073 9.80113 7.21672 9.88487 6.99989 9.88487C6.78072 9.88498 6.57468 9.79964 6.4198 9.64465ZM13.1664 6.58984H11.4618L12.8644 5.04556C13.0308 5.54437 13.1322 6.06091 13.1664 6.58984Z"
        fill="black"
      />
    </svg>
  ),
  postgresSQLIcon: (
    <svg
      version="1.1"
      id="Layer_1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      x="0px"
      y="0px"
      width="14"
      height="14"
      viewBox="0 0 14 14"
      xmlSpace="preserve"
    >
      <g>
        <path
          d="M14,8.7c-0.2,0.4-0.6,0.6-1,0.8c-0.3,0.1-0.7,0.2-1,0.2c-0.3,0-0.6,0-0.8,0c-0.1,0-0.1,0-0.1,0.1c-0.1,0.5-0.1,1-0.2,1.5
		c-0.1,0.4-0.1,0.8-0.2,1.3c-0.2,0.6-0.5,1-1.2,1.2C9.1,13.9,8.8,14,8.5,14c-0.5,0-0.9-0.2-1.2-0.6c-0.2-0.3-0.3-0.7-0.4-1
		c-0.1-0.5-0.1-1.1-0.1-1.6c0-0.3,0-0.6,0-0.8c0,0,0,0,0,0c-0.5,0.4-1.1,0.5-1.7,0.4c-0.2,0-0.3-0.1-0.5-0.1c-0.1,0-0.3-0.1-0.4-0.2
		C4,9.8,4,9.6,4.2,9.5c0.1-0.1,0.3-0.1,0.4-0.2c0.2,0,0.3-0.1,0.5-0.1c0.2,0,0.3-0.1,0.4-0.3c0.1-0.1,0.2-0.2,0.3-0.3
		c-0.1,0-0.2,0-0.3,0C5.4,8.6,5.2,8.5,5,8.5c-0.1,0-0.1,0-0.1,0C4.5,8.9,4.2,9.3,3.8,9.7C3.7,9.8,3.6,9.9,3.5,10
		c-0.3,0.2-0.7,0.2-1.1,0C2.1,9.8,1.9,9.6,1.8,9.3C1.4,8.7,1.2,8.1,0.9,7.5C0.6,6.4,0.3,5.3,0.1,4.2C0.1,4,0,3.7,0,3.5c0,0,0,0,0,0
		c0-0.1,0-0.1,0-0.2c0,0,0-0.1,0-0.1c0-0.4,0.1-0.9,0.2-1.3c0.2-0.7,0.7-1.2,1.4-1.5C2.1,0.3,2.5,0.2,3,0.2c0.8,0,1.6,0.2,2.3,0.4
		c0.1,0,0.2,0,0.3,0C6,0.3,6.4,0.2,6.9,0.2c0.4,0,0.9,0,1.3,0.1c0.2,0,0.3,0,0.5,0C9,0.1,9.4,0,9.7,0c0.5,0,1,0,1.6,0.1
		c0.9,0.2,1.7,0.6,2.3,1.4c0.1,0.1,0.2,0.3,0.2,0.5c0.1,0.4,0.1,0.9,0,1.3c-0.1,0.8-0.3,1.6-0.7,2.4c-0.4,0.9-0.8,1.7-1.3,2.6
		c-0.1,0.1-0.1,0.2,0.1,0.2c0.3,0.1,0.5,0.1,0.8,0c0.3,0,0.5-0.1,0.8-0.1c0.2,0,0.4,0,0.4,0.2C14,8.6,14,8.7,14,8.7z M4.4,3.9
		C4.4,3.9,4.4,3.9,4.4,3.9c0.1,0,0.1,0,0.1,0c0.4-0.2,0.9-0.3,1.3-0.3c0.5,0,0.9,0.3,1,0.7C6.9,4.6,7,4.9,7,5.2c0,0.5,0,0.9-0.1,1.3
		C6.9,6.9,6.7,7.2,6.6,7.5C6.5,7.7,6.4,8,6.3,8.3c0,0,0,0.1,0,0.1c0.3,0,0.6,0.1,0.7,0.4C7.2,8.9,7.2,9,7.2,9.2c0,0.3,0,0.7,0,1
		c0,0.7,0,1.4,0.1,2.1c0,0.3,0.1,0.6,0.3,0.8c0.2,0.3,0.5,0.4,0.9,0.4c0.3,0,0.5-0.1,0.8-0.2c0.5-0.2,0.8-0.5,0.9-0.9
		c0-0.2,0.1-0.3,0.1-0.5c0.1-0.6,0.2-1.2,0.2-1.8c0-0.4,0.1-0.8,0.1-1.2c0-0.3,0.2-0.5,0.5-0.6c0,0,0.1,0,0.1-0.1
		c-0.1-0.1-0.2-0.2-0.3-0.4c-0.2-0.3-0.3-0.6-0.5-0.8C10.2,6.6,10,6.2,9.8,5.7C9.7,5.3,9.5,4.9,9.6,4.5c0-0.6,0.4-0.9,0.9-1
		c0.3,0,0.5,0,0.8,0c0.1,0,0.1,0,0.1-0.1C11.2,3,11,2.7,10.8,2.4c-0.9-1.2-2-1.9-3.5-1.9C6.8,0.6,6.4,0.6,6,0.8
		C5.5,1.1,5.1,1.5,4.9,2C4.6,2.5,4.5,2.9,4.4,3.4C4.4,3.6,4.4,3.7,4.4,3.9z M5.1,0.9C5.1,0.9,5.1,0.9,5.1,0.9
		C4.5,0.8,3.9,0.7,3.3,0.6c-0.3,0-0.5,0-0.8,0c-0.4,0-0.7,0.1-1,0.3C1,1.2,0.7,1.7,0.6,2.2c-0.2,0.7-0.2,1.3-0.1,2
		C0.7,5.4,1,6.5,1.5,7.7c0.2,0.5,0.4,1,0.7,1.5c0.1,0.2,0.3,0.3,0.4,0.5c0.2,0.2,0.4,0.1,0.6,0c0,0,0.1-0.1,0.1-0.1
		c0.4-0.4,0.8-0.9,1.2-1.3c0,0,0,0,0-0.1c0,0,0,0,0,0C4,7.6,3.8,7,3.9,6.3c0.1-0.5,0.1-1.1,0.1-1.6c0-0.5,0-1.1,0.1-1.6
		c0.2-0.7,0.4-1.4,0.9-1.9C5,1.1,5,1,5.1,0.9z M9.2,0.5C9.2,0.6,9.2,0.6,9.2,0.5c0.2,0.1,0.4,0.2,0.5,0.3c0.9,0.5,1.5,1.3,2,2.2
		c0.1,0.3,0.2,0.6,0.2,0.9c0,0.3,0,0.5-0.1,0.8c-0.1,0.4-0.1,0.8,0,1.2c0.1,0.3,0.1,0.6,0,1c0,0.4-0.1,0.7-0.3,1c0,0.1,0,0.1,0,0.1
		c0,0,0,0,0,0c0.4-0.7,0.8-1.4,1.1-2.2c0.4-0.9,0.7-1.9,0.8-2.8c0-0.2,0-0.5,0-0.7c-0.1-0.3-0.2-0.5-0.5-0.8c-0.6-0.6-1.3-0.9-2.1-1
		c-0.4,0-0.7,0-1.1,0C9.6,0.4,9.4,0.5,9.2,0.5z M6.6,5.7c0-0.4-0.1-0.8-0.2-1.2C6.4,4.2,6.2,4,5.9,3.9c-0.1,0-0.2,0-0.4,0
		C5.1,4,4.8,4.1,4.4,4.3c-0.1,0-0.1,0.1-0.1,0.2c0,0.3,0,0.5,0,0.8c0,0.3,0,0.7-0.1,1c-0.1,0.4,0,0.8,0.2,1.2
		c0.3,0.5,0.7,0.7,1.2,0.8c0.1,0,0.1,0,0.1-0.1C6,7.8,6.2,7.4,6.3,7C6.5,6.6,6.6,6.1,6.6,5.7z M10,4.6C10,4.6,10,4.7,10,4.6
		c0,0.4,0.1,0.7,0.3,1c0.3,0.6,0.6,1.2,0.9,1.8c0,0,0,0,0,0c0,0,0,0,0,0c0.1-0.3,0.2-0.5,0.2-0.8c0-0.3-0.1-0.6-0.1-0.8
		c0-0.3-0.1-0.7,0-1c0-0.3,0.1-0.5,0.1-0.8c0-0.1,0-0.1-0.1-0.1c-0.2,0-0.3,0-0.5,0c-0.2,0-0.3,0-0.5,0.1C10.2,4,10.1,4.2,10,4.4
		C10,4.5,10,4.5,10,4.6z M4.5,9.8C4.6,9.8,4.6,9.8,4.5,9.8C4.6,9.8,4.6,9.8,4.5,9.8C4.9,9.9,5.1,10,5.3,10c0.6,0,1.1-0.2,1.4-0.6
		c0-0.1,0.1-0.1,0.1-0.2c0-0.2-0.1-0.3-0.3-0.4c-0.1-0.1-0.2,0-0.3,0C6.2,8.9,6.1,9,6.1,9c-0.2,0.3-0.6,0.5-1,0.6
		C4.9,9.7,4.7,9.7,4.5,9.8z M13.4,8.8C13.4,8.8,13.3,8.8,13.4,8.8c-0.4,0.1-0.8,0.1-1.2,0.1c-0.2,0-0.4,0-0.6-0.1
		c-0.1-0.1-0.2-0.1-0.4,0c-0.1,0-0.2,0.1-0.2,0.2c0,0.1,0,0.2,0,0.3c0,0,0,0.1,0.1,0.1c0.1,0,0.3,0.1,0.4,0.1c0.2,0,0.4,0,0.6,0
		C12.6,9.3,13,9.1,13.4,8.8C13.4,8.8,13.4,8.8,13.4,8.8z"
        />
        <path
          d="M5.9,4.6c-0.2,0-0.4-0.1-0.4-0.3c0-0.1,0-0.1,0.1-0.1c0.2-0.1,0.4-0.1,0.6,0c0.2,0.1,0.2,0.2,0,0.3C6.1,4.6,6,4.6,5.9,4.6z
		"
        />
        <path
          d="M10.6,4.5c-0.1,0-0.2-0.1-0.3-0.1c-0.1-0.1-0.1-0.2,0-0.2c0.2-0.1,0.3-0.1,0.5-0.1C11,4.1,11,4.2,11,4.2
		C11,4.4,10.8,4.5,10.6,4.5z"
        />
      </g>
    </svg>
  ),
  settingsIcon: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M14 8.40167V5.59833L12.6724 5.2124C12.5681 4.88198 12.4348 4.5611 12.2745 4.25403L12.9409 3.04134L10.9586 1.05911L9.746 1.72553C9.43895 1.56516 9.11805 1.43194 8.7876 1.32759L8.40167 0H5.59833L5.2124 1.32762C4.88198 1.43194 4.56107 1.56518 4.254 1.72555L3.04136 1.05913L1.05911 3.04136L1.72553 4.25406C1.56516 4.5611 1.43194 4.88201 1.32762 5.21243L0 5.59833V8.40164L1.32762 8.78757C1.43194 9.11799 1.56518 9.43887 1.72553 9.74594L1.05911 10.9586L3.04136 12.9409L4.254 12.2744C4.56105 12.4348 4.88195 12.568 5.2124 12.6724L5.59833 14H8.40164L8.78757 12.6724C9.11799 12.5681 9.4389 12.4348 9.74597 12.2744L10.9586 12.9409L12.9409 10.9586L12.2744 9.74594C12.4348 9.4389 12.568 9.11799 12.6724 8.78757L14 8.40167ZM12.0072 8.1267L11.9467 8.3484C11.8328 8.76564 11.666 9.16729 11.4509 9.54228L11.3363 9.74209L11.9254 10.814L10.814 11.9254L9.74209 11.3363L9.54231 11.4509C9.16732 11.666 8.76561 11.8328 8.34838 11.9467L8.12667 12.0072L7.78586 13.1797H6.21414L5.8733 12.0072L5.6516 11.9467C5.23436 11.8328 4.83268 11.666 4.45766 11.4509L4.25789 11.3363L3.18596 11.9254L2.0746 10.814L2.66366 9.74209L2.54907 9.54228C2.33395 9.16729 2.16716 8.76564 2.0533 8.3484L1.99279 8.1267L0.820312 7.78583V6.21414L1.99281 5.87327L2.05332 5.65157C2.16718 5.23433 2.33398 4.83268 2.54909 4.45769L2.66369 4.25789L2.07463 3.18596L3.18598 2.0746L4.25791 2.66366L4.45769 2.54909C4.83268 2.33398 5.23439 2.16718 5.65163 2.0533L5.87333 1.99279L6.21414 0.820312H7.78583L8.12667 1.99281L8.34838 2.05332C8.76561 2.16721 9.16729 2.33401 9.54231 2.54912L9.74209 2.66369L10.814 2.07463L11.9254 3.18598L11.3363 4.25791L11.4509 4.45771C11.666 4.83271 11.8328 5.23436 11.9467 5.6516L12.0072 5.8733L13.1797 6.21417V7.78586L12.0072 8.1267Z"
        fill="black"
      />
      <path
        d="M7 2.84375C4.70824 2.84375 2.84375 4.70824 2.84375 7C2.84375 9.29176 4.70824 11.1562 7 11.1562C9.29176 11.1562 11.1562 9.29176 11.1562 7C11.1562 4.70824 9.29176 2.84375 7 2.84375ZM7 10.3359C5.16056 10.3359 3.66406 8.83944 3.66406 7C3.66406 5.16056 5.16056 3.66406 7 3.66406C8.83944 3.66406 10.3359 5.16056 10.3359 7C10.3359 8.83944 8.83944 10.3359 7 10.3359Z"
        fill="black"
      />
      <path
        d="M7 4.48438C5.61288 4.48438 4.48438 5.61288 4.48438 7C4.48438 8.38712 5.61288 9.51562 7 9.51562C8.38712 9.51562 9.51562 8.38712 9.51562 7C9.51562 5.61288 8.38712 4.48438 7 4.48438ZM7 8.69531C6.0652 8.69531 5.30469 7.9348 5.30469 7C5.30469 6.0652 6.0652 5.30469 7 5.30469C7.9348 5.30469 8.69531 6.0652 8.69531 7C8.69531 7.9348 7.9348 8.69531 7 8.69531Z"
        fill="black"
      />
    </svg>
  ),
  infoIcon: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M6 0C2.6916 0 0 2.69164 0 6.00004C0 9.30844 2.6916 12 6 12C9.3084 12 12 9.30844 12 6.00004C12 2.69164 9.3084 0 6 0ZM6 10.9091C3.29309 10.9091 1.09091 8.70691 1.09091 6.00004C1.09091 3.29316 3.29309 1.09091 6 1.09091C8.70691 1.09091 10.9091 3.29316 10.9091 6.00004C10.9091 8.70691 8.70687 10.9091 6 10.9091Z"
        fill="#808080"
      />
      <path
        d="M6.00008 2.54541C5.59913 2.54541 5.27295 2.87181 5.27295 3.27301C5.27295 3.67385 5.59913 3.99996 6.00008 3.99996C6.40102 3.99996 6.7272 3.67385 6.7272 3.27301C6.7272 2.87181 6.40102 2.54541 6.00008 2.54541Z"
        fill="#808080"
      />
      <path
        d="M6.00004 5.09082C5.69881 5.09082 5.45459 5.33504 5.45459 5.63627V8.909C5.45459 9.21024 5.69881 9.45446 6.00004 9.45446C6.30128 9.45446 6.5455 9.21024 6.5455 8.909V5.63627C6.5455 5.33504 6.30128 5.09082 6.00004 5.09082Z"
        fill="#808080"
      />
    </svg>
  ),
  infoIconBlue: (
    <svg
      width="10"
      height="10"
      viewBox="0 0 10 10"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M5 0C2.243 0 0 2.24303 0 5.00003C0 7.75703 2.243 10 5 10C7.757 10 10 7.75703 10 5.00003C10 2.24303 7.757 0 5 0ZM5 9.09091C2.74424 9.09091 0.909091 7.25576 0.909091 5.00003C0.909091 2.7443 2.74424 0.909091 5 0.909091C7.25576 0.909091 9.09091 2.7443 9.09091 5.00003C9.09091 7.25576 7.25573 9.09091 5 9.09091Z"
        fill="#013A44"
      />
      <path
        d="M5.00047 2.12109C4.66635 2.12109 4.39453 2.39309 4.39453 2.72743C4.39453 3.06146 4.66635 3.33322 5.00047 3.33322C5.33459 3.33322 5.60641 3.06146 5.60641 2.72743C5.60641 2.39309 5.33459 2.12109 5.00047 2.12109Z"
        fill="#013A44"
      />
      <path
        d="M5.00044 4.24268C4.74941 4.24268 4.5459 4.44619 4.5459 4.69722V7.42449C4.5459 7.67552 4.74941 7.87904 5.00044 7.87904C5.25147 7.87904 5.45499 7.67552 5.45499 7.42449V4.69722C5.45499 4.44619 5.25147 4.24268 5.00044 4.24268Z"
        fill="#013A44"
      />
    </svg>
  ),
  okIcon: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <circle cx="6" cy="6" r="6" fill="#0DB94D" />
      <path
        d="M9.04039 3.57129L5.10187 7.50981L2.95961 5.36756L2 6.32716L5.10187 9.42904L10 4.53091L9.04039 3.57129Z"
        fill="white"
      />
    </svg>
  ),
  failedIcon: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M7.97999 6.00037L11.6923 2.28802C12.1025 1.87784 12.1025 1.21284 11.6923 0.803306L11.1974 0.308402C10.7871 -0.101903 10.1221 -0.101903 9.7126 0.308402L6.00037 4.02063L2.28802 0.307633C1.87784 -0.102544 1.21284 -0.102544 0.803306 0.307633L0.307633 0.802536C-0.102544 1.21284 -0.102544 1.87784 0.307633 2.28738L4.02063 6.00037L0.308402 9.7126C-0.101903 10.1229 -0.101903 10.7879 0.308402 11.1974L0.803306 11.6923C1.21348 12.1025 1.87848 12.1025 2.28802 11.6923L6.00037 7.97999L9.7126 11.6923C10.1229 12.1025 10.7879 12.1025 11.1974 11.6923L11.6923 11.1974C12.1025 10.7871 12.1025 10.1221 11.6923 9.7126L7.97999 6.00037Z"
        fill="#FF4F12"
      />
    </svg>
  ),
  okIconWhite: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <circle cx="6" cy="6" r="6" fill="#FFFFFF" />
      <path
        d="M9.04039 3.57129L5.10187 7.50981L2.95961 5.36756L2 6.32716L5.10187 9.42904L10 4.53091L9.04039 3.57129Z"
        fill="#0DB94D"
      />
    </svg>
  ),
  failedIconWhite: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M7.97999 6.00037L11.6923 2.28802C12.1025 1.87784 12.1025 1.21284 11.6923 0.803306L11.1974 0.308402C10.7871 -0.101903 10.1221 -0.101903 9.7126 0.308402L6.00037 4.02063L2.28802 0.307633C1.87784 -0.102544 1.21284 -0.102544 0.803306 0.307633L0.307633 0.802536C-0.102544 1.21284 -0.102544 1.87784 0.307633 2.28738L4.02063 6.00037L0.308402 9.7126C-0.101903 10.1229 -0.101903 10.7879 0.308402 11.1974L0.803306 11.6923C1.21348 12.1025 1.87848 12.1025 2.28802 11.6923L6.00037 7.97999L9.7126 11.6923C10.1229 12.1025 10.7879 12.1025 11.1974 11.6923L11.6923 11.1974C12.1025 10.7871 12.1025 10.1221 11.6923 9.7126L7.97999 6.00037Z"
        fill="#FFFFFF"
      />
    </svg>
  ),

  okLargeIcon: (
    <svg
      width="16"
      height="16"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <circle cx="6" cy="6" r="6" fill="#0DB94D" />
      <path
        d="M9.04039 3.57129L5.10187 7.50981L2.95961 5.36756L2 6.32716L5.10187 9.42904L10 4.53091L9.04039 3.57129Z"
        fill="white"
      />
    </svg>
  ),
  failedLargeIcon: (
    <svg
      width="16"
      height="16"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M7.97999 6.00037L11.6923 2.28802C12.1025 1.87784 12.1025 1.21284 11.6923 0.803306L11.1974 0.308402C10.7871 -0.101903 10.1221 -0.101903 9.7126 0.308402L6.00037 4.02063L2.28802 0.307633C1.87784 -0.102544 1.21284 -0.102544 0.803306 0.307633L0.307633 0.802536C-0.102544 1.21284 -0.102544 1.87784 0.307633 2.28738L4.02063 6.00037L0.308402 9.7126C-0.101903 10.1229 -0.101903 10.7879 0.308402 11.1974L0.803306 11.6923C1.21348 12.1025 1.87848 12.1025 2.28802 11.6923L6.00037 7.97999L9.7126 11.6923C10.1229 12.1025 10.7879 12.1025 11.1974 11.6923L11.6923 11.1974C12.1025 10.7871 12.1025 10.1221 11.6923 9.7126L7.97999 6.00037Z"
        fill="#FF4F12"
      />
    </svg>
  ),

  processingIcon: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <circle cx="6" cy="6" r="6" fill="#FFAD5F" />
      <path
        d="M10.296 5.93132L6.65097 5.91569L6.6343 2.88612L5.27722 2.89359L5.30135 7.28024L10.2961 7.29932L10.296 5.93132Z"
        fill="white"
      />
    </svg>
  ),
  processingIconWhite: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <circle cx="6" cy="6" r="6" fill="#FFFFFF" />
      <path
        d="M10.296 5.93132L6.65097 5.91569L6.6343 2.88612L5.27722 2.89359L5.30135 7.28024L10.2961 7.29932L10.296 5.93132Z"
        fill="#FFAD5F"
      />
    </svg>
  ),
  processingLargeIcon: (
    <svg
      width="16"
      height="16"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <circle cx="6" cy="6" r="6" fill="#FFAD5F" />
      <path
        d="M10.296 5.93132L6.65097 5.91569L6.6343 2.88612L5.27722 2.89359L5.30135 7.28024L10.2961 7.29932L10.296 5.93132Z"
        fill="white"
      />
    </svg>
  ),

  warningIcon: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0)">
        <path
          d="M13.7091 10.4984L8.76358 1.40725C7.969 0.069566 6.03205 0.0677887 5.23641 1.40725L0.291126 10.4984C-0.521148 11.8653 0.46227 13.5962 2.0543 13.5962H11.9455C13.5362 13.5962 14.5214 11.8667 13.7091 10.4984ZM7 11.9556C6.54778 11.9556 6.17968 11.5875 6.17968 11.1353C6.17968 10.683 6.54778 10.3149 7 10.3149C7.45221 10.3149 7.82031 10.683 7.82031 11.1353C7.82031 11.5875 7.45221 11.9556 7 11.9556ZM7.82031 8.67432C7.82031 9.12653 7.45221 9.49463 7 9.49463C6.54778 9.49463 6.17968 9.12653 6.17968 8.67432V4.57275C6.17968 4.12054 6.54778 3.75244 7 3.75244C7.45221 3.75244 7.82031 4.12054 7.82031 4.57275V8.67432Z"
          fill="#FF8612"
        />
      </g>
      <defs>
        <clipPath id="clip0">
          <rect width="14" height="14" fill="white" />
        </clipPath>
      </defs>
    </svg>
  ),
  docIcon: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M10.3813 4.65783C10.2304 4.65783 10.1079 4.53539 10.1079 4.38439V2.51465C10.1079 2.36366 10.2304 2.24121 10.3813 2.24121C10.5323 2.24121 10.6548 2.36366 10.6548 2.51465V4.38439C10.6548 4.53539 10.5324 4.65783 10.3813 4.65783Z"
        fill="black"
      />
      <path
        d="M10.3799 1.9082C10.5309 1.9082 10.6533 1.78578 10.6533 1.63477C10.6533 1.48375 10.5309 1.36133 10.3799 1.36133C10.2289 1.36133 10.1064 1.48375 10.1064 1.63477C10.1064 1.78578 10.2289 1.9082 10.3799 1.9082Z"
        fill="black"
      />
      <path
        d="M13.2522 2.87265C13.2522 1.28866 11.9638 0 10.3801 0C9.72462 0 9.11972 0.220773 8.63579 0.591883H1.74317C1.19446 0.591883 0.748047 1.03827 0.748047 1.587V11.5339C0.748047 12.0826 1.19446 12.5291 1.74317 12.5291H2.61081V13.0049C2.61081 13.5536 3.05723 14 3.60593 14H10.7553C11.304 14 11.7504 13.5536 11.7504 13.0049V9.21222C11.7504 9.06123 11.6279 8.93878 11.4769 8.93878C11.3259 8.93878 11.2035 9.06123 11.2035 9.21222V13.0049C11.2035 13.252 11.0024 13.4531 10.7553 13.4531H3.60593C3.35877 13.4531 3.15769 13.252 3.15769 13.0049V12.5291H8.89252C9.44123 12.5291 9.88767 12.0827 9.88767 11.5339V5.70303C10.0477 5.73081 10.2123 5.7453 10.3802 5.7453C10.6662 5.7453 10.9426 5.70325 11.2035 5.62502V6.74004C11.2035 6.89104 11.326 7.01348 11.477 7.01348C11.628 7.01348 11.7504 6.89104 11.7504 6.74004V5.39678C12.6443 4.90935 13.2522 3.96069 13.2522 2.87265ZM9.34079 11.5339C9.34079 11.7811 9.13971 11.9822 8.89252 11.9822H1.74317C1.49601 11.9822 1.29492 11.7811 1.29492 11.5339V1.587C1.29492 1.33984 1.49601 1.13876 1.74317 1.13876H8.09159C7.74838 1.59083 7.53581 2.14728 7.51059 2.75133H2.8542C2.70321 2.75133 2.58076 2.87377 2.58076 3.02477V4.1796C2.58076 4.33059 2.70321 4.45304 2.8542 4.45304H7.78149C7.84364 4.45304 7.90095 4.43229 7.94689 4.39734C8.27354 4.91698 8.7619 5.32514 9.34079 5.55067V11.5339ZM7.50805 3.2982V3.90616H3.12764V3.2982H7.50805ZM10.3801 5.1984C9.09801 5.1984 8.05493 4.15507 8.05493 2.87262C8.05493 1.5902 9.09801 0.546848 10.3801 0.546848C11.6623 0.546848 12.7054 1.59018 12.7054 2.87262C12.7054 4.15507 11.6623 5.1984 10.3801 5.1984Z"
        fill="black"
      />
      <path
        d="M11.4765 8.24455C11.3638 8.24455 11.2605 8.17245 11.2208 8.06731C11.18 7.95941 11.2134 7.83253 11.3031 7.75955C11.3929 7.68646 11.5222 7.67768 11.6208 7.73882C11.7191 7.79986 11.7694 7.92025 11.7428 8.03316C11.714 8.15527 11.6021 8.24455 11.4765 8.24455Z"
        fill="black"
      />
      <path
        d="M7.7818 5.95117H2.85449C2.7035 5.95117 2.58105 5.82875 2.58105 5.67773C2.58105 5.52674 2.7035 5.4043 2.85449 5.4043H7.7818C7.93279 5.4043 8.05523 5.52674 8.05523 5.67773C8.05523 5.82873 7.93282 5.95117 7.7818 5.95117Z"
        fill="black"
      />
      <path
        d="M7.7818 7.24803H2.85449C2.7035 7.24803 2.58105 7.12559 2.58105 6.9746C2.58105 6.82359 2.7035 6.70117 2.85449 6.70117H7.7818C7.93279 6.70117 8.05523 6.82359 8.05523 6.9746C8.05523 7.12559 7.93282 7.24803 7.7818 7.24803Z"
        fill="black"
      />
      <path
        d="M7.7818 8.54492H2.85449C2.7035 8.54492 2.58105 8.42248 2.58105 8.27148C2.58105 8.12049 2.7035 7.99805 2.85449 7.99805H7.7818C7.93279 7.99805 8.05523 8.12049 8.05523 8.27148C8.05523 8.4225 7.93282 8.54492 7.7818 8.54492Z"
        fill="black"
      />
      <path
        d="M7.7818 9.8418H2.85449C2.7035 9.8418 2.58105 9.71935 2.58105 9.56836C2.58105 9.41734 2.7035 9.29492 2.85449 9.29492H7.7818C7.93279 9.29492 8.05523 9.41734 8.05523 9.56836C8.05523 9.71935 7.93282 9.8418 7.7818 9.8418Z"
        fill="black"
      />
    </svg>
  ),
  supportIcon: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M14 9.47461C14 7.43398 12.625 5.65108 10.6861 5.11382C10.5642 2.27338 8.21562 0 5.3457 0C2.39803 0 0 2.39803 0 5.3457C0 6.30637 0.255707 7.24171 0.741272 8.06288L0.0196533 10.6716L2.62852 9.95013C3.38336 10.3965 4.23486 10.6479 5.11371 10.6859C5.65086 12.6249 7.43387 14 9.47461 14C10.2892 14 11.0813 13.7831 11.7773 13.3709L13.9802 13.9802L13.3709 11.7773C13.7831 11.0813 14 10.2892 14 9.47461ZM2.75798 9.06317L1.19618 9.49522L1.62823 7.93343L1.52975 7.7794C1.06566 7.0533 0.820312 6.21173 0.820312 5.3457C0.820312 2.85037 2.85037 0.820312 5.3457 0.820312C7.84103 0.820312 9.87109 2.85037 9.87109 5.3457C9.87109 7.84103 7.84103 9.87109 5.3457 9.87109C4.47968 9.87109 3.63821 9.62575 2.912 9.16165L2.75798 9.06317ZM12.8038 12.8038L11.6449 12.4832L11.4901 12.5839C10.8902 12.9736 10.1931 13.1797 9.47461 13.1797C7.87073 13.1797 6.46135 12.1427 5.96201 10.6556C8.41803 10.3725 10.3725 8.41803 10.6557 5.9619C12.1427 6.46135 13.1797 7.87073 13.1797 9.47461C13.1797 10.1931 12.9736 10.8902 12.5839 11.4901L12.4832 11.6449L12.8038 12.8038Z"
        fill="black"
      />
      <path
        d="M4.93555 7.41016H5.75586V8.23047H4.93555V7.41016Z"
        fill="black"
      />
      <path
        d="M6.16602 4.10156C6.16602 4.33452 6.07117 4.54953 5.89899 4.70708L4.93555 5.58891V6.58984H5.75586V5.95015L6.4528 5.31227C6.79182 5.00198 6.98633 4.56075 6.98633 4.10156C6.98633 3.19687 6.2504 2.46094 5.3457 2.46094C4.44101 2.46094 3.70508 3.19687 3.70508 4.10156H4.52539C4.52539 3.64922 4.89336 3.28125 5.3457 3.28125C5.79805 3.28125 6.16602 3.64922 6.16602 4.10156Z"
        fill="black"
      />
    </svg>
  ),
  copyIcon: (
    <svg
      width="12"
      height="14"
      viewBox="0 0 12 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M7.50391 14H2.28125C1.07503 14 0.09375 13.0187 0.09375 11.8125V4.40234C0.09375 3.19612 1.07503 2.21484 2.28125 2.21484H7.50391C8.71013 2.21484 9.69141 3.19612 9.69141 4.40234V11.8125C9.69141 13.0187 8.71013 14 7.50391 14ZM2.28125 3.30859C1.67819 3.30859 1.1875 3.79929 1.1875 4.40234V11.8125C1.1875 12.4156 1.67819 12.9062 2.28125 12.9062H7.50391C8.10696 12.9062 8.59766 12.4156 8.59766 11.8125V4.40234C8.59766 3.79929 8.10696 3.30859 7.50391 3.30859H2.28125ZM11.8789 10.4453V2.1875C11.8789 0.981277 10.8976 0 9.69141 0H3.62109C3.31903 0 3.07422 0.244812 3.07422 0.546875C3.07422 0.848938 3.31903 1.09375 3.62109 1.09375H9.69141C10.2945 1.09375 10.7852 1.58444 10.7852 2.1875V10.4453C10.7852 10.7474 11.03 10.9922 11.332 10.9922C11.6341 10.9922 11.8789 10.7474 11.8789 10.4453Z"
        fill="#808080"
      />
    </svg>
  ),

  joeChatIcon: (
    <svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.8984 16.7116H16.1253L14.9676 14.2124L13.8984 16.7116Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.7804 12.1688C19.9667 12.1688 20.1182 12.0173 20.1182 11.831C20.1182 11.6447 19.9667 11.4932 19.7804 11.4932C19.5941 11.4932 19.4424 11.6447 19.4424 11.831C19.4424 12.0173 19.5941 12.1688 19.7804 12.1688Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.4478 10.5238C11.1686 10.5238 11.755 11.1103 11.755 11.831C11.755 12.5518 11.1686 13.1382 10.4478 13.1382C9.72716 13.1382 9.14062 12.5518 9.14062 11.831C9.14062 11.1103 9.72716 10.5238 10.4478 10.5238ZM19.7811 10.5238C20.5019 10.5238 21.0883 11.1103 21.0883 11.831C21.0883 12.5518 20.5019 13.1382 19.7811 13.1382C19.0603 13.1382 18.4737 12.5518 18.4737 11.831C18.4737 11.1103 19.0603 10.5238 19.7811 10.5238ZM7.36507 13.8576H22.5494C23.2483 13.8576 23.815 13.291 23.815 12.5919V11.0322C23.815 10.3333 23.2483 9.7666 22.5494 9.7666H7.36507C6.66633 9.7666 6.09961 10.3333 6.09961 11.0322V12.5919C6.09961 13.291 6.66633 13.8576 7.36507 13.8576Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.12851 17.2148V17.0357V16.8437V11.5596V11.3678V11.1885C2.12851 11.187 2.12903 11.1858 2.12903 11.1844C2.13144 10.8144 2.43272 10.5141 2.80295 10.5141H3.12785C3.49963 10.5141 3.80229 10.8168 3.80229 11.1885V17.2148C3.80229 17.5867 3.49963 17.8894 3.12785 17.8894H2.80295C2.43272 17.8894 2.13144 17.589 2.12903 17.2191C2.12903 17.2177 2.12851 17.2163 2.12851 17.2148ZM1.6924 13.1716V15.2311V16.9454C1.69154 16.9454 1.69068 16.9457 1.68999 16.9457H1.04174C0.697371 16.9457 0.417114 16.6653 0.417114 16.3209V16.2003V16.031V15.8619V12.5409V12.3716V12.2024V12.0817C0.417114 11.7372 0.697371 11.4571 1.04174 11.4571H1.68999C1.69068 11.4571 1.69154 11.4573 1.6924 11.4573V13.1716ZM4.30014 10.3668C4.30014 8.68994 5.27449 7.23988 6.68473 6.54234C6.74092 6.51459 6.79642 6.48615 6.85399 6.46064C6.90949 6.43634 6.96637 6.41462 7.02307 6.39238C7.39227 6.24829 7.78507 6.15298 8.19546 6.1173C8.26147 6.11161 8.32852 6.10989 8.39505 6.1073C8.45297 6.10489 8.50984 6.09851 8.56845 6.09851H8.60688H10.6997H10.9184H11.1213H13.4226H13.6251H13.8444H15.9368H16.1557H16.3584H18.9891H19.1918H19.4109H21.2124C21.3068 6.09851 21.399 6.10661 21.4918 6.11264C21.5607 6.11713 21.63 6.1204 21.6979 6.12816C21.7632 6.13557 21.827 6.14746 21.8911 6.1578C22.35 6.2314 22.785 6.37601 23.1828 6.58422C23.2402 6.61421 23.2962 6.64679 23.3521 6.67919C23.4093 6.71246 23.466 6.74641 23.5213 6.78226C24.6982 7.54306 25.4809 8.86402 25.4809 10.3668V16.0247C25.4809 18.007 24.1206 19.6732 22.2855 20.151C21.942 20.2405 21.5836 20.2929 21.2124 20.2929H8.56845C8.42504 20.2929 8.28371 20.2853 8.14393 20.2713C5.98892 20.0576 4.30014 18.2349 4.30014 16.0247V10.3668ZM7.0231 5.01378C7.0231 4.5098 7.43297 4.1001 7.93695 4.1001H7.97487H8.14395H8.31338H10.9932H11.1623H11.3317H13.2122H13.3813H13.5507H16.2304H16.3998H16.5687H18.7789H18.948H19.117H21.7971H21.9665H22.1356H22.2691C22.773 4.1001 23.1828 4.5098 23.1828 5.01378V6.11085C22.8269 5.94142 22.4474 5.81525 22.0485 5.74165C21.993 5.73148 21.9365 5.72424 21.8805 5.71597C21.8238 5.7077 21.7678 5.69632 21.7104 5.69012C21.5466 5.67236 21.3808 5.66202 21.2126 5.66202H19.1939H19.0171H18.8411H16.5065H16.3303H16.1538H13.6272H13.4504H13.2744H11.2693H11.0932H10.9165H8.56848C8.50918 5.66202 8.45144 5.66874 8.39267 5.67081C8.33458 5.67323 8.27633 5.67547 8.21876 5.6796C8.16136 5.68426 8.1038 5.68719 8.04692 5.69356C7.69151 5.73407 7.34955 5.81749 7.0231 5.93435V5.01378ZM8.31349 3.16327C8.31349 2.57811 8.78955 2.10205 9.37454 2.10205H9.93195C10.5173 2.10205 10.9933 2.57811 10.9933 3.16327V3.66398H8.31349V3.16327ZM13.5507 3.16327C13.5507 2.57811 14.0266 2.10205 14.6117 2.10205H15.1693C15.7545 2.10205 16.2303 2.57811 16.2303 3.16327V3.66398H13.5507V3.16327ZM19.1171 3.16327C19.1171 2.57811 19.5931 2.10205 20.1785 2.10205H20.7361C21.3212 2.10205 21.7971 2.57811 21.7971 3.16327V3.66398H19.1171V3.16327ZM8.47256 22.1477H21.4802V20.6675H8.47256V22.1477ZM26.0238 11.1885C26.0238 10.8168 26.3265 10.5141 26.6983 10.5141H27.0232C27.3934 10.5141 27.6947 10.8144 27.6971 11.1844C27.6971 11.1858 27.6976 11.187 27.6976 11.1885V11.3678V11.5596V16.8437V17.0357V17.2148C27.6976 17.2163 27.6971 17.2177 27.6971 17.2191C27.6947 17.589 27.3934 17.8894 27.0232 17.8894H26.6983C26.3265 17.8894 26.0238 17.5867 26.0238 17.2148V11.1885ZM28.1338 15.2311V13.1716V11.4573C28.1347 11.4573 28.1353 11.4571 28.1362 11.4571H28.7843C29.1286 11.4571 29.4089 11.7372 29.4089 12.0817V12.2024V12.3716V12.5409V15.8619V16.031V16.2003V16.3209C29.4089 16.6653 29.1286 16.9457 28.7843 16.9457H28.1362C28.1353 16.9457 28.1347 16.9454 28.1338 16.9454V15.2311ZM4.51737 22.5688H8.14398H22.2855H25.6852C26.3903 22.5688 27.0404 22.7996 27.5697 23.1867C29.1063 20.8324 30 18.0209 30 15C30 6.71583 23.2844 0 15.0001 0C6.71564 0 0 6.71583 0 15C0 18.065 0.920054 20.9147 2.49783 23.2894C3.04938 22.8399 3.75157 22.5688 4.51737 22.5688Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.8862 17.4849H13.1781C12.955 17.4849 12.7744 17.6657 12.7744 17.8889C12.7744 18.1119 12.955 18.2927 13.1781 18.2927H16.8862C17.1093 18.2927 17.2901 18.1119 17.2901 17.8889C17.2901 17.6657 17.1093 17.4849 16.8862 17.4849Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.4472 12.1688C10.6335 12.1688 10.785 12.0173 10.785 11.831C10.785 11.6447 10.6335 11.4932 10.4472 11.4932C10.2609 11.4932 10.1094 11.6447 10.1094 11.831C10.1094 12.0173 10.2609 12.1688 10.4472 12.1688Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.44235 26.116C5.68727 25.964 5.97322 25.8721 6.28209 25.8721H23.7831C24.0918 25.8721 24.3779 25.964 24.6227 26.116C24.709 26.1696 24.7878 26.2332 24.8624 26.3013C24.9664 26.2103 25.0691 26.1177 25.1708 26.024C25.0132 25.8628 24.8281 25.7289 24.6227 25.6298C24.3683 25.5069 24.084 25.436 23.7831 25.436H6.28209C5.98097 25.436 5.69693 25.5069 5.44235 25.6298C5.22345 25.7354 5.02834 25.8814 4.86426 26.0567C4.96509 26.1493 5.06695 26.241 5.17054 26.3306C5.25362 26.2504 5.34376 26.1772 5.44235 26.116Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.9933 3.1631C10.9933 2.57794 10.5173 2.10205 9.9321 2.10205H9.37452C8.78953 2.10205 8.31348 2.57794 8.31348 3.1631V3.6638H10.9933V3.1631Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.2306 3.1631C16.2306 2.57794 15.7546 2.10205 15.1696 2.10205H14.6118C14.0268 2.10205 13.5508 2.57794 13.5508 3.1631V3.6638H16.2306V3.1631Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M21.7972 3.1631C21.7972 2.57794 21.3211 2.10205 20.7362 2.10205H20.1784C19.5932 2.10205 19.1172 2.57794 19.1172 3.1631V3.6638H21.7972V3.1631Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M28.7843 16.9458C29.1286 16.9458 29.4089 16.6654 29.4089 16.321V16.2004V16.0309V15.862V12.5408V12.3717V12.2023V12.0817C29.4089 11.7371 29.1286 11.457 28.7843 11.457H28.136C28.1352 11.457 28.1345 11.4572 28.1338 11.4572V13.1717V15.2312V16.9455C28.1345 16.9455 28.1352 16.9458 28.136 16.9458H28.7843Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M26.6979 17.8894H27.0228C27.393 17.8894 27.6943 17.589 27.6967 17.2191C27.6967 17.2178 27.6972 17.2164 27.6972 17.2148V17.0357V16.8437V11.5597V11.3679V11.1886C27.6972 11.1871 27.6967 11.1858 27.6967 11.1845C27.6943 10.8144 27.393 10.5142 27.0228 10.5142H26.6979C26.3261 10.5142 26.0234 10.8168 26.0234 11.1886V17.2148C26.0234 17.5868 26.3261 17.8894 26.6979 17.8894Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M1.04162 11.457C0.697248 11.457 0.416992 11.7371 0.416992 12.0817V12.2023V12.3717V12.5408V15.862V16.0309V16.2004V16.321C0.416992 16.6654 0.697248 16.9458 1.04162 16.9458H1.68987C1.69056 16.9458 1.69142 16.9455 1.69211 16.9455V15.231V13.1715V11.4572C1.69142 11.4572 1.69056 11.457 1.68987 11.457H1.04162Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M22.2859 22.5693H8.14437H4.51775C3.75196 22.5693 3.04977 22.8403 2.49805 23.29C3.17318 24.3062 3.96879 25.2356 4.86489 26.0572C5.0288 25.8819 5.22408 25.7359 5.44281 25.6303C5.69738 25.5074 5.98143 25.4365 6.28254 25.4365H23.7836C24.0847 25.4365 24.3687 25.5074 24.6233 25.6303C24.8286 25.7294 25.0137 25.8633 25.1712 26.0245C26.0827 25.183 26.8895 24.2302 27.5701 23.1872C27.0408 22.8001 26.3905 22.5693 25.6855 22.5693H22.2859Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M23.7835 25.8726H6.28244C5.97358 25.8726 5.68763 25.9644 5.44271 26.1164C5.34412 26.1778 5.25398 26.2509 5.1709 26.331C7.80334 28.6169 11.2402 30.0004 15.0002 30.0004C18.7763 30.0004 22.2259 28.6048 24.8628 26.3017C24.7881 26.2337 24.7094 26.1701 24.623 26.1164C24.3783 25.9644 24.0922 25.8726 23.7835 25.8726Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.21909 5.6796C8.27666 5.67547 8.33492 5.67323 8.393 5.67081C8.45178 5.66874 8.50952 5.66185 8.56881 5.66185H10.9169H11.0935H11.2697H13.2747H13.4509H13.6276H16.1542H16.3308H16.5068H18.8414H19.0174H19.1942H21.2129C21.3811 5.66185 21.547 5.67236 21.7107 5.69012C21.7681 5.69632 21.8241 5.7077 21.8808 5.71597C21.9368 5.72424 21.9934 5.73148 22.0489 5.74165C22.4477 5.81525 22.8272 5.94142 23.1832 6.11085V5.01378C23.1832 4.5098 22.7733 4.1001 22.2695 4.1001H22.1359H21.9668H21.7974H19.1174H18.9483H18.7792H16.569H16.4001H16.2307H13.551H13.3816H13.2125H11.3321H11.1626H10.9936H8.31372H8.14429H7.97521H7.93729C7.43331 4.1001 7.02344 4.5098 7.02344 5.01378V5.93435C7.34989 5.81749 7.69185 5.7339 8.04725 5.69356C8.10413 5.68719 8.1617 5.68408 8.21909 5.6796Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.80335 17.8894H3.12825C3.50002 17.8894 3.80269 17.5868 3.80269 17.2148V11.1886C3.80269 10.8168 3.50002 10.5142 3.12825 10.5142H2.80335C2.43312 10.5142 2.13184 10.8144 2.12942 11.1845C2.12942 11.1858 2.12891 11.1871 2.12891 11.1886V11.3679V11.5597V16.8437V17.0357V17.2148C2.12891 17.2164 2.12942 17.2178 2.12942 17.2191C2.13184 17.589 2.43312 17.8894 2.80335 17.8894Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.4479 11.4932C10.6343 11.4932 10.7858 11.6447 10.7858 11.831C10.7858 12.0173 10.6343 12.1688 10.4479 12.1688C10.2616 12.1688 10.1101 12.0173 10.1101 11.831C10.1101 11.6447 10.2616 11.4932 10.4479 11.4932ZM10.4478 13.1383C11.1686 13.1383 11.755 12.5519 11.755 11.8311C11.755 11.1105 11.1686 10.5239 10.4478 10.5239C9.72716 10.5239 9.14062 11.1105 9.14062 11.8311C9.14062 12.5519 9.72716 13.1383 10.4478 13.1383Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.7811 11.4932C19.9674 11.4932 20.1189 11.6447 20.1189 11.831C20.1189 12.0173 19.9674 12.1688 19.7811 12.1688C19.5948 12.1688 19.4431 12.0173 19.4431 11.831C19.4431 11.6447 19.5948 11.4932 19.7811 11.4932ZM19.781 13.1383C20.5018 13.1383 21.0882 12.5519 21.0882 11.8311C21.0882 11.1105 20.5018 10.5239 19.781 10.5239C19.06 10.5239 18.4736 11.1105 18.4736 11.8311C18.4736 12.5519 19.06 13.1383 19.781 13.1383Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6.09901 11.0327C6.09901 10.3336 6.66556 9.76703 7.36448 9.76703H22.5486C23.2476 9.76703 23.8143 10.3336 23.8143 11.0327V12.5924C23.8143 13.2913 23.2476 13.858 22.5486 13.858H7.36448C6.66556 13.858 6.09901 13.2913 6.09901 12.5924V11.0327ZM13.8978 16.7117L14.967 14.2125L16.1247 16.7117H13.8978ZM16.8854 18.2928H13.1772C12.9542 18.2928 12.7736 18.112 12.7736 17.8889C12.7736 17.6657 12.9542 17.4849 13.1772 17.4849H16.8854C17.1084 17.4849 17.2892 17.6657 17.2892 17.8889C17.2892 18.112 17.1084 18.2928 16.8854 18.2928ZM8.14359 20.2716C8.28337 20.2856 8.42471 20.2932 8.56811 20.2932H21.212C21.5833 20.2932 21.9416 20.2406 22.2852 20.1511C24.1203 19.6734 25.4805 18.0071 25.4805 16.0248V10.367C25.4805 8.86415 24.6978 7.54318 23.521 6.78238C23.4656 6.74653 23.4089 6.71275 23.3517 6.67931C23.2957 6.64691 23.2399 6.61433 23.1825 6.58434C22.7847 6.37613 22.3496 6.23169 21.8908 6.15792C21.8267 6.14758 21.7629 6.13569 21.6976 6.12828C21.6295 6.12052 21.5604 6.11725 21.4914 6.11277C21.3987 6.10673 21.3063 6.09863 21.212 6.09863H19.4104H19.1915H18.9888H16.3579H16.1554H15.9365H13.844H13.6248H13.4223H11.1209H10.9181H10.6992H8.60655H8.56811C8.50951 6.09863 8.45263 6.10501 8.39472 6.10742C8.32819 6.11001 8.26114 6.11173 8.19513 6.11742C7.78474 6.1531 7.39193 6.24841 7.02274 6.39251C6.96603 6.41474 6.90915 6.43646 6.85365 6.46093C6.79608 6.48627 6.74058 6.51471 6.68422 6.54246C5.27415 7.24 4.2998 8.69006 4.2998 10.367V16.0248C4.2998 18.235 5.98858 20.0577 8.14359 20.2716Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.47266 22.1477H21.4803V20.6675H8.47266V22.1477Z"
        fill="white"
      />
    </svg>
  ),
  userChatIcon: (
    <svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <mask
        id="mask0"
        mask-type="alpha"
        maskUnits="userSpaceOnUse"
        x="0"
        y="0"
        width="30"
        height="30"
      >
        <circle cx="15" cy="15" r="15" fill="#8D8D8D" />
      </mask>
      <g mask="url(#mask0)">
        <circle cx="15" cy="15" r="15" fill="#0F879D" />
        <ellipse
          cx="15"
          cy="30.0001"
          rx="11.1111"
          ry="14.4444"
          fill="#AFD6DE"
        />
        <circle cx="14.9999" cy="9.99989" r="5.55556" fill="white" />
      </g>
    </svg>
  ),

  databaseLabLogo: (
    <svg
      width="206"
      height="130"
      viewBox="0 0 206 130"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M121.727 20.091C92.182 -11.8181 11.8184 5.90916 8.27295 20.091V109.909C27.182 135.909 111.091 130 121.727 109.909V20.091Z"
        fill="#FF6212"
      />
      <path
        d="M123.746 20.1145C121.009 9.97455 100.637 0 65.0001 0C29.3635 0 8.989 9.97455 6.25427 20.1145C6.05572 20.462 5.90918 20.8425 5.90918 21.2727V22.4545V49.6364V50.8182V52V78V79.1818V80.3636V108.727C5.90918 109.11 6.01082 109.472 6.18573 109.793C8.97718 121.363 33.9514 130 65.0001 130C95.9779 130 120.912 121.399 123.796 109.871C123.985 109.533 124.091 109.143 124.091 108.727V80.3636V79.1818V78V52V50.8182V49.6364V22.4545V21.2727C124.091 20.8425 123.944 20.462 123.746 20.1145ZM119.177 80.3282C119.111 80.6142 119.019 80.8978 118.903 81.1862C118.808 81.4202 118.692 81.6542 118.565 81.8882C118.406 82.1789 118.229 82.4696 118.019 82.7604C117.863 82.9802 117.686 83.1976 117.501 83.4151C117.239 83.7247 116.96 84.0344 116.643 84.3416C116.452 84.5284 116.241 84.7127 116.029 84.8995C115.641 85.2375 115.237 85.5731 114.785 85.9064C114.592 86.0506 114.384 86.19 114.178 86.3318C113.644 86.7005 113.086 87.0669 112.474 87.4262C112.313 87.5231 112.14 87.6153 111.973 87.7098C111.268 88.1069 110.533 88.5016 109.739 88.8845C109.637 88.9342 109.531 88.9815 109.427 89.0287C108.541 89.4471 107.614 89.8584 106.624 90.2555C106.595 90.2673 106.567 90.2767 106.539 90.2886C101.171 92.4324 94.3044 94.2358 86.3035 95.4176C86.2634 95.4224 86.2232 95.4271 86.183 95.4342C84.6277 95.6635 83.0323 95.8667 81.3943 96.0464C81.1272 96.0747 80.8459 96.0936 80.5764 96.122C79.1464 96.2709 77.6999 96.408 76.2108 96.5167C75.5301 96.5664 74.8163 96.59 74.1237 96.6325C73.0034 96.6987 71.8948 96.772 70.7461 96.8122C68.8694 96.8713 66.9548 96.9091 65.0001 96.9091C63.0454 96.9091 61.1308 96.8713 59.2517 96.8051C58.103 96.7649 56.9944 96.6893 55.8741 96.6255C55.1815 96.5853 54.4677 96.5593 53.787 96.5096C52.2979 96.4009 50.8514 96.2638 49.4214 96.1149C49.1519 96.0865 48.8706 96.0676 48.6035 96.0393C46.9655 95.8596 45.3701 95.654 43.8148 95.4271C43.7746 95.4224 43.7345 95.4176 43.6943 95.4105C35.6934 94.2287 28.827 92.4253 23.4592 90.2815C23.4308 90.272 23.4025 90.2602 23.3741 90.2484C22.3837 89.8513 21.4548 89.44 20.5708 89.0216C20.4692 88.972 20.3605 88.9247 20.2588 88.8775C19.4646 88.4945 18.7295 88.1022 18.0252 87.7027C17.8597 87.6082 17.6848 87.516 17.5241 87.4191C16.9119 87.0598 16.3541 86.6935 15.8199 86.3247C15.6166 86.1829 15.4063 86.0435 15.2125 85.8993C14.761 85.566 14.3568 85.2304 13.9692 84.8924C13.7588 84.708 13.5461 84.5236 13.3546 84.3345C13.0379 84.0273 12.759 83.72 12.4966 83.408C12.3123 83.1905 12.135 82.9731 11.979 82.7533C11.771 82.4625 11.5937 82.1718 11.433 81.8811C11.3054 81.6471 11.1919 81.4131 11.095 81.1791C10.9792 80.8931 10.887 80.6071 10.8208 80.3211C10.7334 79.9453 10.6365 79.5624 10.6365 79.1818C10.6365 78.9147 10.6672 78.6476 10.7097 78.3829C10.7688 78.026 10.7357 77.6691 10.6365 77.3311V59.7835C10.7026 59.8449 10.7854 59.904 10.8539 59.9655C11.3692 60.4193 11.8939 60.8707 12.4848 61.3056C21.3886 68.0396 39.1939 73.2727 65.0001 73.2727C90.6975 73.2727 108.458 68.0822 117.4 61.3884C118.113 60.8684 118.756 60.3318 119.361 59.7858L119.364 77.3311C119.264 77.6691 119.231 78.026 119.29 78.3829C119.335 78.6476 119.364 78.9147 119.364 79.1818C119.364 79.5624 119.267 79.9453 119.177 80.3282ZM119.364 31.4198V48.9674C119.264 49.3055 119.231 49.6624 119.29 50.0193C119.335 50.284 119.364 50.5511 119.364 50.8182C119.364 51.1987 119.267 51.5816 119.177 51.9645C119.111 52.2505 119.019 52.5342 118.903 52.8225C118.808 53.0565 118.692 53.2905 118.565 53.5245C118.406 53.8153 118.229 54.106 118.019 54.3967C117.863 54.6166 117.686 54.834 117.501 55.0515C117.239 55.3611 116.96 55.6707 116.643 55.978C116.452 56.1647 116.241 56.3491 116.029 56.5358C115.641 56.8738 115.237 57.2094 114.785 57.5427C114.592 57.6869 114.384 57.8264 114.178 57.9682C113.644 58.3369 113.086 58.7033 112.474 59.0625C112.313 59.1595 112.14 59.2516 111.973 59.3462C111.268 59.7433 110.533 60.138 109.739 60.5209C109.637 60.5705 109.531 60.6178 109.427 60.6651C108.541 61.0835 107.614 61.4947 106.624 61.8918C106.595 61.9036 106.567 61.9131 106.539 61.9249C101.171 64.0687 94.3044 65.8722 86.3035 67.054C86.2634 67.0587 86.2232 67.0635 86.183 67.0705C84.6277 67.2998 83.0323 67.5031 81.3943 67.6827C81.1272 67.7111 80.8459 67.73 80.5764 67.7584C79.1464 67.9073 77.6999 68.0444 76.2108 68.1531C75.5301 68.2027 74.8163 68.2264 74.1237 68.2689C73.0034 68.3351 71.8948 68.4084 70.7461 68.4485C68.8694 68.5076 66.9548 68.5455 65.0001 68.5455C63.0454 68.5455 61.1308 68.5076 59.2517 68.4414C58.103 68.4013 56.9944 68.3256 55.8741 68.2618C55.1815 68.2216 54.4677 68.1956 53.787 68.146C52.2979 68.0373 50.8514 67.9002 49.4214 67.7513C49.1519 67.7229 48.8706 67.704 48.6035 67.6756C46.9655 67.496 45.3701 67.2904 43.8148 67.0635C43.7746 67.0587 43.7345 67.054 43.6943 67.0469C35.6934 65.8651 28.827 64.0616 23.4592 61.9178C23.4308 61.9084 23.4025 61.8965 23.3741 61.8847C22.3837 61.4876 21.4548 61.0764 20.5708 60.658C20.4692 60.6084 20.3605 60.5611 20.2588 60.5138C19.4646 60.1309 18.7295 59.7385 18.0252 59.3391C17.8597 59.2445 17.6848 59.1524 17.5241 59.0555C16.9119 58.6962 16.3541 58.3298 15.8199 57.9611C15.6166 57.8193 15.4063 57.6798 15.2125 57.5356C14.761 57.2024 14.3568 56.8667 13.9692 56.5287C13.7588 56.3444 13.5461 56.16 13.3546 55.9709C13.0379 55.6636 12.759 55.3564 12.4966 55.0444C12.3123 54.8269 12.135 54.6095 11.979 54.3896C11.771 54.0989 11.5937 53.8082 11.433 53.5175C11.3054 53.2835 11.1919 53.0495 11.095 52.8155C10.9792 52.5295 10.887 52.2435 10.8208 51.9575C10.7334 51.5816 10.6365 51.1987 10.6365 50.8182C10.6365 50.5511 10.6672 50.284 10.7097 50.0193C10.7688 49.6624 10.7357 49.3055 10.6365 48.9674V31.4198C10.9201 31.6775 11.2439 31.9304 11.5512 32.1856C11.7214 32.3275 11.8797 32.4693 12.0594 32.6111C12.7685 33.1689 13.5343 33.7196 14.3639 34.2562C14.5365 34.3673 14.7303 34.476 14.9099 34.5871C15.6048 35.0196 16.3399 35.4427 17.1128 35.8587C17.3988 36.0124 17.6848 36.1636 17.9803 36.3149C18.843 36.7545 19.7483 37.1824 20.7008 37.596C20.8568 37.6645 20.9986 37.7355 21.157 37.8016C22.2655 38.272 23.4426 38.7211 24.667 39.156C25.005 39.2765 25.3595 39.39 25.707 39.5082C26.6808 39.8367 27.6877 40.1511 28.7301 40.456C29.1059 40.5647 29.4746 40.6782 29.8599 40.7822C31.2426 41.1651 32.6703 41.5291 34.1688 41.8647C34.3745 41.912 34.5966 41.9498 34.8046 41.9947C36.1259 42.2831 37.4968 42.5502 38.9055 42.8007C39.383 42.8858 39.8675 42.9662 40.3545 43.0465C41.6946 43.2664 43.075 43.4673 44.4908 43.6516C44.8548 43.6989 45.2023 43.7533 45.571 43.7982C47.3295 44.0109 49.1495 44.1929 51.0192 44.3489C51.4801 44.3867 51.9599 44.4151 52.4279 44.4482C53.9241 44.5569 55.4534 44.6467 57.0181 44.7176C57.5877 44.7436 58.155 44.7696 58.7365 44.7909C60.7739 44.8595 62.8492 44.9091 65.0001 44.9091C67.151 44.9091 69.2263 44.8595 71.2637 44.7909C71.8428 44.7696 72.4101 44.7436 72.9821 44.7176C74.5468 44.6467 76.0761 44.5569 77.5723 44.4482C78.0403 44.4127 78.5177 44.3867 78.981 44.3489C80.8506 44.1953 82.6706 44.0109 84.4292 43.7982C84.7979 43.7533 85.1453 43.6989 85.5093 43.6516C86.9252 43.4673 88.3032 43.2664 89.6457 43.0465C90.1326 42.9662 90.6172 42.8858 91.0946 42.8007C92.5034 42.5502 93.8743 42.2831 95.1955 41.9947C95.4035 41.9498 95.6257 41.9096 95.8314 41.8647C97.3299 41.5291 98.7575 41.1627 100.14 40.7822C100.526 40.6758 100.894 40.5647 101.27 40.456C102.312 40.1511 103.319 39.8367 104.293 39.5082C104.641 39.39 104.995 39.2765 105.333 39.156C106.558 38.7211 107.737 38.272 108.843 37.8016C109.002 37.7355 109.143 37.6645 109.299 37.596C110.252 37.18 111.157 36.7545 112.02 36.3149C112.315 36.1636 112.604 36.0124 112.887 35.8587C113.66 35.4451 114.395 35.022 115.09 34.5871C115.27 34.476 115.464 34.3673 115.636 34.2562C116.466 33.7196 117.232 33.1713 117.941 32.6111C118.118 32.4693 118.276 32.3275 118.449 32.1856C118.756 31.9304 119.08 31.6775 119.364 31.4198ZM65.0001 4.72727C97.0392 4.72727 119.364 14.0684 119.364 22.4545C119.364 30.8407 97.0392 40.1818 65.0001 40.1818C32.961 40.1818 10.6365 30.8407 10.6365 22.4545C10.6365 14.0684 32.961 4.72727 65.0001 4.72727ZM119.364 108.025C119.331 108.129 119.307 108.236 119.288 108.344C117.948 116.52 95.8124 125.273 65.0001 125.273C34.1877 125.273 12.0523 116.52 10.7121 108.344C10.6932 108.238 10.6672 108.134 10.6365 108.035V88.1471C10.7026 88.2085 10.7854 88.2676 10.8539 88.3291C11.3692 88.7829 11.8939 89.2344 12.4848 89.6693C21.3886 96.4033 39.1939 101.636 65.0001 101.636C90.6975 101.636 108.458 96.4458 117.4 89.752C118.113 89.232 118.756 88.6954 119.361 88.1495L119.364 108.025Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M130.62 120.083C140.028 117.52 147.632 112.619 149.851 106.095V23.3362C145.134 15.4064 138.23 10.8035 130.62 8.56616V120.083Z"
        fill="#FF6212"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M130.62 122.86C141.847 119.961 149.845 113.71 151.074 106.061C151.186 105.749 151.249 105.39 151.249 105.007V78.8723V77.7834V76.6945V52.7379V51.649V50.56V25.5146V24.4256C151.249 24.0293 151.162 23.6786 151.045 23.3585C149.838 16.3969 142.836 9.51987 130.62 6.46643V10.9783C141.573 13.9063 148.451 19.9395 148.451 25.5146C148.451 31.0897 141.573 37.1228 130.62 40.0508V44.5493C130.701 44.5291 130.782 44.5087 130.862 44.4881C131.15 44.4141 131.437 44.34 131.72 44.2616C132.554 44.0308 133.365 43.7847 134.147 43.519C134.207 43.4989 134.268 43.4799 134.33 43.4609C134.395 43.4407 134.461 43.4205 134.523 43.3992C135.41 43.09 136.255 42.7524 137.074 42.4017C137.229 42.3348 137.381 42.2658 137.532 42.1969C137.602 42.1649 137.672 42.133 137.742 42.1012C138.359 41.8203 138.955 41.5306 139.532 41.2279C139.606 41.1887 139.68 41.1501 139.755 41.1115C139.887 41.0429 140.019 40.9745 140.147 40.9034C140.872 40.5027 141.57 40.0889 142.225 39.6555C142.279 39.62 142.33 39.5831 142.382 39.546C142.419 39.5193 142.456 39.4924 142.495 39.466C143.058 39.0827 143.594 38.6907 144.105 38.2856C144.28 38.1462 144.45 38.0068 144.618 37.8653C145.076 37.4841 145.511 37.0943 145.922 36.6936C145.966 36.6507 146.012 36.6083 146.058 36.5659C146.122 36.507 146.186 36.4482 146.245 36.3887C146.736 35.8943 147.189 35.389 147.609 34.8729C147.669 34.7982 147.725 34.7235 147.782 34.6488C147.824 34.5928 147.866 34.5368 147.91 34.4808C147.964 34.4109 148.019 34.3412 148.074 34.2715C148.204 34.1067 148.333 33.9421 148.451 33.7752V49.9437C148.393 50.2551 148.373 50.584 148.408 50.9129C148.434 51.1568 148.451 51.4029 148.451 51.649C148.451 51.9756 148.401 52.3041 148.352 52.6328C148.348 52.6569 148.344 52.6811 148.341 52.7052C148.302 52.9688 148.247 53.2301 148.178 53.4958C148.123 53.7114 148.054 53.927 147.978 54.1426C147.885 54.4105 147.78 54.6784 147.655 54.9463C147.563 55.1488 147.458 55.3492 147.349 55.5495C147.194 55.8348 147.029 56.1201 146.841 56.4033C146.729 56.5729 146.607 56.7404 146.483 56.91L146.477 56.9172C146.248 57.2287 146.009 57.5379 145.742 57.845C145.652 57.9491 145.557 58.0506 145.461 58.1525C145.435 58.1806 145.408 58.2088 145.382 58.237C145.066 58.5768 144.736 58.9143 144.373 59.2454C144.307 59.3073 144.238 59.3671 144.169 59.4271C144.138 59.4535 144.107 59.48 144.077 59.5067C143.66 59.8726 143.225 60.2363 142.755 60.5891C142.706 60.6261 142.656 60.6616 142.606 60.6968C142.594 60.7052 142.582 60.7136 142.57 60.722C142.045 61.1075 141.497 61.4864 140.911 61.8523C140.903 61.8577 140.894 61.8626 140.886 61.8675C140.877 61.8724 140.869 61.8773 140.861 61.8828C138.079 63.6124 134.617 65.1016 130.62 66.1763V70.6962C138.264 68.7847 143.867 65.376 147.289 61.3884C147.711 60.9093 148.092 60.4149 148.45 59.9118L148.451 76.0781C148.393 76.3895 148.373 76.7184 148.408 77.0473C148.434 77.2912 148.451 77.5373 148.451 77.7834C148.451 78.11 148.401 78.4385 148.352 78.7671C148.348 78.7913 148.344 78.8155 148.341 78.8396C148.302 79.1032 148.247 79.3645 148.178 79.6302C148.123 79.8458 148.054 80.0614 147.978 80.277C147.885 80.5449 147.78 80.8128 147.655 81.0807C147.563 81.2832 147.458 81.4836 147.349 81.684C147.194 81.9693 147.029 82.2545 146.841 82.5377C146.729 82.7072 146.607 82.8746 146.483 83.0441L146.477 83.0517C146.248 83.3631 146.009 83.6723 145.742 83.9794C145.652 84.0836 145.556 84.185 145.461 84.287C145.435 84.3151 145.408 84.3432 145.382 84.3714C145.066 84.7112 144.736 85.0488 144.373 85.3798C144.307 85.4417 144.238 85.5015 144.169 85.5614C144.138 85.5879 144.107 85.6144 144.077 85.6411C143.66 86.007 143.225 86.3707 142.755 86.7235C142.706 86.7605 142.656 86.796 142.606 86.8313C142.594 86.8397 142.582 86.848 142.57 86.8564C142.045 87.2419 141.497 87.6208 140.911 87.9867C140.903 87.9921 140.894 87.997 140.886 88.0019C140.877 88.0068 140.869 88.0117 140.861 88.0172C138.079 89.7468 134.617 91.236 130.62 92.3107V96.8306C138.264 94.9191 143.867 91.5105 147.289 87.5228C147.711 87.0437 148.092 86.5493 148.45 86.0462L148.451 104.36C148.432 104.456 148.418 104.554 148.406 104.654C147.842 110.011 141.054 115.637 130.62 118.441V122.86Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M157.778 120.083C167.187 117.52 174.791 112.619 177.009 106.095V23.3362C172.293 15.4064 165.389 10.8035 157.778 8.56616V120.083Z"
        fill="#FF6212"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M157.778 122.86C169.006 119.961 177.004 113.71 178.233 106.061C178.345 105.749 178.408 105.39 178.408 105.007V78.8723V77.7834V76.6945V52.7379V51.649V50.56V25.5146V24.4256C178.408 24.0293 178.321 23.6786 178.204 23.3585C176.997 16.3969 169.995 9.51987 157.778 6.46643V10.9783C168.732 13.9063 175.61 19.9395 175.61 25.5146C175.61 31.0897 168.732 37.1228 157.778 40.0508V44.5493C157.859 44.5291 157.94 44.5087 158.021 44.4881C158.309 44.4141 158.596 44.34 158.879 44.2616C159.712 44.0308 160.524 43.7847 161.306 43.519C161.365 43.4989 161.427 43.4799 161.489 43.4609C161.554 43.4407 161.619 43.4205 161.682 43.3992C162.569 43.09 163.414 42.7524 164.232 42.4017C164.388 42.3348 164.539 42.2658 164.69 42.1969C164.76 42.1649 164.831 42.133 164.901 42.1012C165.518 41.8203 166.114 41.5306 166.69 41.2279C166.764 41.1887 166.839 41.1501 166.913 41.1115C167.046 41.0429 167.178 40.9745 167.306 40.9034C168.03 40.5027 168.729 40.0889 169.383 39.6555C169.438 39.62 169.489 39.5831 169.54 39.546C169.577 39.5193 169.615 39.4924 169.653 39.466C170.217 39.0827 170.753 38.6907 171.263 38.2856C171.438 38.1462 171.609 38.0068 171.777 37.8653C172.234 37.4841 172.669 37.0943 173.081 36.6936C173.125 36.6507 173.171 36.6083 173.217 36.5659C173.281 36.507 173.344 36.4482 173.404 36.3887C173.895 35.8943 174.348 35.389 174.768 34.8729C174.828 34.7982 174.884 34.7235 174.94 34.6488C174.983 34.5928 175.025 34.5368 175.069 34.4808C175.123 34.4109 175.178 34.3412 175.232 34.2715C175.362 34.1067 175.492 33.9421 175.61 33.7752V49.9437C175.551 50.2551 175.532 50.584 175.567 50.9129C175.593 51.1568 175.61 51.4029 175.61 51.649C175.61 51.9756 175.56 52.3041 175.51 52.6328C175.507 52.6569 175.503 52.6811 175.499 52.7052C175.46 52.9688 175.406 53.2301 175.337 53.4958C175.281 53.7114 175.213 53.927 175.137 54.1426C175.043 54.4105 174.938 54.6784 174.814 54.9463C174.722 55.1488 174.617 55.3492 174.508 55.5495C174.352 55.8348 174.187 56.1201 174 56.4033C173.888 56.5729 173.765 56.7404 173.641 56.91L173.636 56.9172C173.407 57.2287 173.167 57.5379 172.9 57.845C172.81 57.9491 172.715 58.0506 172.62 58.1525C172.593 58.1806 172.567 58.2088 172.541 58.237C172.225 58.5768 171.894 58.9143 171.532 59.2454C171.466 59.3073 171.397 59.3671 171.327 59.4271C171.297 59.4535 171.266 59.48 171.235 59.5067C170.819 59.8726 170.383 60.2363 169.913 60.5891C169.865 60.6261 169.814 60.6616 169.764 60.6968C169.753 60.7052 169.741 60.7136 169.729 60.722C169.204 61.1075 168.656 61.4864 168.07 61.8523C168.061 61.8577 168.053 61.8626 168.044 61.8675C168.036 61.8724 168.028 61.8773 168.019 61.8828C165.237 63.6124 161.776 65.1016 157.778 66.1763V70.6962C165.422 68.7847 171.026 65.376 174.447 61.3884C174.87 60.9093 175.25 60.4149 175.609 59.9118L175.61 76.0781C175.551 76.3895 175.532 76.7184 175.567 77.0473C175.593 77.2912 175.61 77.5373 175.61 77.7834C175.61 78.11 175.56 78.4385 175.51 78.7671C175.507 78.7913 175.503 78.8155 175.499 78.8396C175.46 79.1032 175.406 79.3645 175.337 79.6302C175.281 79.8458 175.213 80.0614 175.137 80.277C175.043 80.5449 174.938 80.8128 174.814 81.0807C174.722 81.2832 174.617 81.4836 174.508 81.684C174.352 81.9693 174.187 82.2545 174 82.5377C173.888 82.7072 173.766 82.8746 173.642 83.0441L173.636 83.0517C173.407 83.3631 173.167 83.6723 172.9 83.9794C172.81 84.0836 172.715 84.185 172.62 84.287C172.593 84.3151 172.567 84.3432 172.541 84.3714C172.225 84.7112 171.894 85.0488 171.532 85.3798C171.466 85.4417 171.397 85.5015 171.327 85.5614C171.297 85.5879 171.266 85.6144 171.235 85.6411C170.819 86.007 170.383 86.3707 169.913 86.7235C169.865 86.7605 169.814 86.796 169.764 86.8313C169.752 86.8397 169.741 86.848 169.729 86.8564C169.204 87.2419 168.656 87.6208 168.07 87.9867C168.061 87.9921 168.053 87.997 168.044 88.0019C168.036 88.0068 168.028 88.0117 168.019 88.0172C165.237 89.7468 161.776 91.236 157.778 92.3107V96.8306C165.422 94.9191 171.026 91.5105 174.447 87.5228C174.87 87.0437 175.25 86.5493 175.609 86.0462L175.61 104.36C175.59 104.456 175.576 104.554 175.565 104.654C175.001 110.011 168.212 115.637 157.778 118.441V122.86Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M184.937 120.083C194.345 117.52 201.95 112.619 204.168 106.095V23.3362C199.452 15.4064 192.547 10.8035 184.937 8.56616V120.083Z"
        fill="#FF6212"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M184.937 122.86C196.165 119.961 204.163 113.71 205.392 106.061C205.504 105.749 205.567 105.39 205.567 105.007V78.8723V77.7834V76.6945V52.7379V51.649V50.56V25.5146V24.4256C205.567 24.0293 205.48 23.6786 205.362 23.3585C204.155 16.3969 197.153 9.51987 184.937 6.46643V10.9783C195.89 13.9063 202.769 19.9395 202.769 25.5146C202.769 31.0897 195.89 37.1228 184.937 40.0508V44.5493C185.018 44.5291 185.099 44.5087 185.18 44.4881C185.468 44.4141 185.755 44.34 186.037 44.2616C186.871 44.0308 187.682 43.7847 188.464 43.519C188.524 43.4989 188.586 43.4799 188.647 43.4609C188.713 43.4407 188.778 43.4205 188.841 43.3992C189.728 43.09 190.573 42.7524 191.391 42.4017C191.547 42.3348 191.698 42.2658 191.849 42.1969C191.919 42.1649 191.989 42.133 192.06 42.1012C192.677 41.8203 193.273 41.5306 193.849 41.2279C193.923 41.1887 193.998 41.15 194.072 41.1114C194.204 41.0428 194.336 40.9744 194.464 40.9034C195.189 40.5026 195.887 40.0889 196.542 39.6555C196.596 39.62 196.648 39.5831 196.699 39.546C196.736 39.5193 196.773 39.4924 196.812 39.466C197.376 39.0827 197.912 38.6907 198.422 38.2856C198.597 38.1462 198.768 38.0068 198.936 37.8652C199.393 37.4841 199.828 37.0943 200.239 36.6936C200.284 36.6507 200.33 36.6083 200.376 36.5659C200.439 36.507 200.503 36.4482 200.563 36.3887C201.054 35.8943 201.507 35.389 201.926 34.8729C201.986 34.7982 202.043 34.7235 202.099 34.6488C202.141 34.5928 202.183 34.5368 202.227 34.4808C202.281 34.4109 202.336 34.3412 202.391 34.2716C202.521 34.1068 202.651 33.9421 202.769 33.7752V49.9437C202.71 50.2551 202.69 50.584 202.725 50.9129C202.752 51.1568 202.769 51.4029 202.769 51.649C202.769 51.9756 202.719 52.3041 202.669 52.6328C202.665 52.6569 202.662 52.6811 202.658 52.7052C202.619 52.9688 202.564 53.2301 202.496 53.4958C202.44 53.7114 202.371 53.927 202.296 54.1426C202.202 54.4105 202.097 54.6784 201.973 54.9463C201.88 55.1488 201.775 55.3492 201.666 55.5495C201.511 55.8348 201.346 56.1201 201.158 56.4033C201.047 56.5729 200.924 56.7404 200.8 56.91L200.795 56.9172C200.565 57.2287 200.326 57.5379 200.059 57.845C199.969 57.9491 199.874 58.0506 199.778 58.1526C199.752 58.1807 199.726 58.2088 199.699 58.237C199.383 58.5768 199.053 58.9143 198.691 59.2454C198.625 59.3073 198.555 59.3671 198.486 59.4271C198.455 59.4535 198.425 59.48 198.394 59.5067C197.977 59.8726 197.542 60.2363 197.072 60.5891C197.024 60.6261 196.973 60.6616 196.923 60.6969C196.911 60.7053 196.899 60.7136 196.887 60.722C196.363 61.1075 195.814 61.4864 195.228 61.8523C195.22 61.8577 195.212 61.8626 195.203 61.8675C195.195 61.8724 195.186 61.8773 195.178 61.8828C192.396 63.6124 188.934 65.1016 184.937 66.1763V70.6962C192.581 68.7847 198.185 65.376 201.606 61.3884C202.029 60.9093 202.409 60.4149 202.767 59.9118L202.769 76.0781C202.71 76.3895 202.69 76.7184 202.725 77.0473C202.752 77.2912 202.769 77.5373 202.769 77.7834C202.769 78.11 202.719 78.4385 202.669 78.7671C202.665 78.7913 202.662 78.8155 202.658 78.8396C202.619 79.1032 202.564 79.3645 202.496 79.6302C202.44 79.8458 202.371 80.0614 202.296 80.277C202.202 80.5449 202.097 80.8128 201.973 81.0807C201.88 81.2832 201.775 81.4836 201.666 81.684C201.511 81.9693 201.346 82.2545 201.158 82.5377C201.047 82.7073 200.924 82.8748 200.8 83.0443L200.795 83.0516C200.565 83.3631 200.326 83.6723 200.059 83.9794C199.969 84.0836 199.874 84.185 199.778 84.287C199.752 84.3151 199.726 84.3432 199.699 84.3714C199.383 84.7112 199.053 85.0488 198.691 85.3798C198.625 85.4417 198.555 85.5016 198.486 85.5615C198.455 85.588 198.425 85.6145 198.394 85.6411C197.977 86.007 197.542 86.3707 197.072 86.7235C197.024 86.7605 196.973 86.796 196.923 86.8313C196.911 86.8397 196.899 86.848 196.887 86.8564C196.363 87.2419 195.814 87.6208 195.228 87.9867C195.217 87.9942 195.205 88.0006 195.194 88.0075C195.188 88.0106 195.183 88.0138 195.178 88.0172C192.396 89.7468 188.934 91.236 184.937 92.3107V96.8306C192.581 94.9191 198.185 91.5105 201.606 87.5228C202.029 87.0437 202.409 86.5493 202.767 86.0462L202.769 104.36C202.749 104.456 202.735 104.554 202.724 104.654C202.16 110.011 195.371 115.637 184.937 118.441V122.86Z"
        fill="white"
      />
    </svg>
  ),
  checkupLogo: (
    <svg
      width="82"
      height="152"
      viewBox="0 0 82 152"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M1.46509 159.386H43.2423V107.745H1.46509V159.386Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.07896 158.773H42.6292V108.359H2.07896V158.773ZM0.851807 160H43.856V107.132H0.851807V160Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M34.7439 142.389L4.43616 117.861C0.0128719 114.282 -0.671378 107.794 2.90856 103.37L27.9329 72.4479L53.4379 73.3109L74.2594 109.938L49.2355 140.861C45.6555 145.284 39.1672 145.968 34.7439 142.389Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M28.218 73.0728L3.3859 103.757C1.75768 105.77 1.01045 108.295 1.28202 110.869C1.55319 113.444 2.81085 115.758 4.8227 117.386L35.1301 141.913C37.1423 143.542 39.667 144.29 42.2421 144.017C44.8163 143.746 47.1304 142.488 48.759 140.476L73.52 109.879L53.0743 73.9141L28.218 73.0728ZM41.2154 145.293C38.8028 145.293 36.3754 144.499 34.3586 142.867L4.05086 118.34C1.7838 116.505 0.367035 113.898 0.0615158 110.998C-0.244413 108.098 0.597709 105.253 2.43205 102.986L27.6483 71.8259L53.8023 72.711L53.9716 73.0096L75.0001 110.001L49.7127 141.248C47.5581 143.911 44.3995 145.293 41.2154 145.293Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M66.1661 158.409C66.0565 148.381 65.9076 134.653 53.4185 117.671C39.1438 98.2579 43.3356 81.9807 43.5209 81.2969L51.4157 83.4392L47.4681 82.368L51.4231 83.4093C51.286 83.9472 48.2002 96.7663 60.0087 112.825C74.0585 131.93 74.2311 147.809 74.3452 158.316L66.1661 158.409Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M81.0534 33.3637C81.1749 51.9113 66.2376 67.0457 47.6904 67.1668C29.1429 67.2883 14.0084 52.3513 13.887 33.8038C13.7655 15.2567 28.7028 0.122207 47.2504 0.00073566C65.7975 -0.120736 80.9319 14.8162 81.0534 33.3637Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M72.2467 33.4221C72.1572 19.7375 60.9908 8.71676 47.3066 8.80633C33.622 8.8959 22.6012 20.0623 22.6912 33.7469C22.7808 47.431 33.9468 58.4518 47.6309 58.3622C61.3155 58.2727 72.3367 47.1063 72.2467 33.4221Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M56.6547 33.5241C56.6215 28.4514 52.4821 24.3655 47.4089 24.3986C42.3357 24.4322 38.2503 28.5716 38.2834 33.6448C38.3165 38.7176 42.456 42.803 47.5292 42.7699C52.6023 42.7368 56.6878 38.5973 56.6547 33.5241Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M47.4693 24.8072C47.4497 24.8072 47.4301 24.8076 47.4108 24.8076C42.5716 24.8391 38.6604 28.8023 38.6919 33.6419C38.7234 38.4619 42.655 42.3613 47.4677 42.3613C47.4873 42.3613 47.507 42.3609 47.5262 42.3609C52.3654 42.3294 56.2766 38.3662 56.2451 33.5266C56.2136 28.7066 52.2824 24.8072 47.4693 24.8072ZM47.4688 43.1773C42.207 43.1773 37.9093 38.9151 37.875 33.6456C37.8402 28.3553 42.1162 24.0228 47.4066 23.988H47.4704C52.7321 23.988 57.0299 28.2502 57.0642 33.5197C57.099 38.81 52.8229 43.1425 47.5326 43.1773H47.4688Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M50.3177 33.5647C50.3079 31.9913 49.0237 30.7242 47.4499 30.7344C45.8764 30.7443 44.6094 32.0285 44.6192 33.6023C44.6298 35.1757 45.9137 36.4428 47.4875 36.433C49.0609 36.4223 50.328 35.1385 50.3177 33.5647Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M53.2395 82.3312L42.3394 82.4023L42.2678 71.5018L53.168 71.431L53.2395 82.3312Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M53.1551 69.6287L42.2549 69.7003L42.2435 67.9895C42.2336 66.4173 43.4995 65.1351 45.0708 65.1245L50.2794 65.0905C51.8512 65.0803 53.1334 66.3461 53.144 67.9179L53.1551 69.6287Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M50.2976 65.499H50.2812L45.0731 65.533C43.7291 65.5415 42.6432 66.6426 42.6518 67.9861L42.66 69.2879L52.7426 69.2221L52.734 67.9203C52.7295 67.2691 52.4722 66.6585 52.0092 66.2017C51.5499 65.7481 50.9422 65.499 50.2976 65.499ZM41.8487 70.1125L41.8348 67.9931C41.8229 66.198 43.2736 64.7281 45.0683 64.7162L50.2765 64.6823H50.2989C51.1599 64.6823 51.9709 65.0148 52.5844 65.6205C53.2032 66.2311 53.5472 67.0462 53.5529 67.9158L53.5668 70.0356L41.8487 70.1125Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M44.582 88.2425L36.6843 91.359C35.6201 91.779 34.4168 91.2568 33.9963 90.1925L31.5031 83.8752C31.0831 82.811 31.6054 81.6073 32.67 81.1877L40.5681 78.0707C41.6323 77.6507 42.8356 78.173 43.2556 79.2372L45.7488 85.5545C46.1689 86.6187 45.6466 87.8224 44.582 88.2425Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M41.3288 78.5392C41.148 78.5392 40.9664 78.5731 40.793 78.6418L32.8953 81.7588C32.5325 81.9019 32.2478 82.1772 32.0928 82.5347C31.9374 82.8917 31.9309 83.288 32.074 83.6504L34.5673 89.9673C34.71 90.3297 34.9857 90.6148 35.3431 90.7698C35.6994 90.9252 36.0965 90.9317 36.4593 90.7886L44.3566 87.672C44.7189 87.5289 45.004 87.2536 45.159 86.8962C45.3144 86.5391 45.321 86.1424 45.1778 85.78L42.6846 79.4631C42.5418 79.1003 42.2666 78.8157 41.9091 78.6607C41.723 78.5797 41.5259 78.5392 41.3288 78.5392ZM35.9233 92.1187C35.5605 92.1187 35.1977 92.0443 34.855 91.895C34.1969 91.6095 33.6893 91.0852 33.4259 90.4177L30.9327 84.1007C30.6697 83.4333 30.6816 82.7036 30.9675 82.0455C31.253 81.3875 31.7777 80.8803 32.4448 80.6169L40.3429 77.5C41.0104 77.237 41.74 77.2489 42.3977 77.5347C43.0562 77.8202 43.5633 78.345 43.8263 79.012L46.3195 85.3294C46.8631 86.7065 46.185 88.2692 44.8075 88.8132L36.9098 91.9297C36.5903 92.0557 36.257 92.1187 35.9233 92.1187Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M42.2473 71.069L32.4535 76.9455C30.4662 78.1381 27.6973 77.1156 26.3308 74.685L25.1071 72.5083C23.793 70.1709 24.2683 67.3971 26.1787 66.2511L35.9725 60.3742C37.9598 59.182 40.7287 60.2045 42.0956 62.6351L43.3193 64.8118C44.633 67.1488 44.1581 69.9226 42.2473 71.069Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M37.811 60.4901C37.2634 60.4901 36.7423 60.6288 36.2896 60.8999L26.4958 66.7768C24.8856 67.7428 24.5031 70.1788 25.6434 72.207L26.8671 74.3841C27.5256 75.5555 28.5677 76.4033 29.7272 76.7105C30.5898 76.9395 31.4458 76.8356 32.1395 76.4193L41.9333 70.5428C43.5439 69.5768 43.9263 67.1408 42.7861 65.1126L41.5623 62.9355C40.9039 61.7641 39.8613 60.9163 38.7018 60.6091C38.4016 60.5298 38.1027 60.4901 37.811 60.4901ZM30.6199 78.0565C30.2228 78.0565 29.8174 78.0038 29.4134 77.8966C27.9357 77.5052 26.6179 76.4439 25.7978 74.9854L24.5741 72.8087C23.0866 70.1629 23.6539 67.0517 25.8649 65.7249L35.6587 59.8481C36.6387 59.2595 37.8305 59.109 39.0162 59.4231C40.4943 59.8149 41.812 60.8759 42.6321 62.3344L43.8558 64.511C45.3429 67.1568 44.7756 70.2685 42.5646 71.5948L32.7708 77.4717C32.1254 77.859 31.3872 78.0565 30.6199 78.0565Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M27.8553 79.9788L22.9143 92.5795C21.9527 95.0311 19.0182 96.1435 16.4313 95.0372L14.1282 94.0527C11.6501 92.993 10.4125 90.2834 11.3332 87.935L16.2742 75.3347C17.2354 72.8827 20.1703 71.7703 22.7568 72.8766L25.0599 73.861C27.5384 74.9208 28.776 77.6304 27.8553 79.9788Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M20.6838 73.0642C20.1006 73.0642 19.5239 73.1754 18.9898 73.3991C17.9894 73.818 17.2278 74.5852 16.8458 75.5595L11.9047 88.1598C11.0998 90.2134 12.1829 92.554 14.3702 93.4894L16.6732 94.4743C17.8135 94.9618 19.0986 94.9773 20.1996 94.516C21.2004 94.0976 21.9619 93.3303 22.3439 92.3561L27.285 79.7553C28.0895 77.7022 27.0069 75.3611 24.8192 74.4257L22.5161 73.4413C21.9292 73.1901 21.3031 73.0642 20.6838 73.0642ZM18.5061 96.0777C17.7221 96.0777 16.9315 95.919 16.1912 95.602L13.8882 94.6175C11.0869 93.4204 9.71436 90.3869 10.7626 87.7117L15.7037 75.1113C16.208 73.8255 17.2067 72.8156 18.5163 72.2676C19.9208 71.679 21.5552 71.6958 22.9989 72.3134L25.302 73.2978C28.1032 74.4954 29.4758 77.5289 28.4275 80.2037L23.4865 92.8045C22.9822 94.0899 21.9834 95.1002 20.6738 95.6482C19.9895 95.9345 19.2505 96.0777 18.5061 96.0777Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M68.0044 93.5986L50.2442 100.608C49.0487 101.08 47.6974 100.493 47.225 99.2976L44.9195 93.4547C44.4475 92.2596 45.0344 90.9078 46.2299 90.4363L63.9906 83.4269C65.1856 82.9553 66.5374 83.5418 67.0089 84.7373L69.3149 90.5798C69.7864 91.7753 69.1999 93.127 68.0044 93.5986Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M64.8443 83.8774C64.6316 83.8774 64.419 83.9174 64.2153 83.998L46.4547 91.0074C45.5757 91.3538 45.1426 92.3513 45.4898 93.2299L47.7953 99.0724C48.1426 99.9513 49.1405 100.384 50.0186 100.038L67.7789 93.0282C68.6578 92.6814 69.0909 91.6843 68.7437 90.8053L66.4378 84.9628C66.2701 84.5371 65.9461 84.2025 65.5265 84.0201C65.3077 83.9248 65.0758 83.8774 64.8443 83.8774ZM49.3946 101.384C48.2216 101.384 47.1112 100.678 46.6547 99.5228L44.3492 93.6803C44.0609 92.9499 44.0744 92.1507 44.3869 91.43C44.6997 90.7094 45.2744 90.154 46.0053 89.8656L63.7655 82.8563C65.2726 82.262 66.9851 83.0035 67.5802 84.5123L69.8861 90.3548C70.4812 91.8628 69.7384 93.5744 68.2301 94.1695L50.4703 101.179C50.1169 101.318 49.7529 101.384 49.3946 101.384Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M42.5751 103.634L39.8156 104.723C38.6123 105.198 37.2512 104.608 36.7763 103.404L34.4823 97.5908C34.0074 96.3871 34.5976 95.0268 35.8013 94.5515L38.5612 93.4628C39.7645 92.9879 41.1248 93.5781 41.5996 94.7814L43.8945 100.595C44.3693 101.799 43.7783 103.159 42.5751 103.634Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M39.4213 93.9116C39.207 93.9116 38.9919 93.9525 38.7862 94.0334L36.0263 95.1222C35.1396 95.4719 34.7032 96.4784 35.0529 97.3651L37.3473 103.179C37.5166 103.609 37.8434 103.946 38.2671 104.13C38.6905 104.314 39.16 104.322 39.5902 104.152L42.3497 103.063C43.2369 102.714 43.6733 101.707 43.3236 100.821L41.0291 95.0068C40.8598 94.577 40.533 94.2396 40.1093 94.0555C39.8888 93.9594 39.6549 93.9116 39.4213 93.9116ZM38.9546 105.502C38.555 105.502 38.1558 105.42 37.7783 105.256C37.054 104.942 36.4957 104.364 36.2057 103.63L33.9112 97.816C33.3129 96.2998 34.0601 94.5796 35.5759 93.9808L38.3358 92.8921C39.8527 92.2941 41.5725 93.0405 42.1705 94.5563L44.465 100.37C44.7545 101.105 44.741 101.908 44.4265 102.632C44.1124 103.357 43.5349 103.915 42.8003 104.205L40.0409 105.294C39.6891 105.433 39.3218 105.502 38.9546 105.502Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M72.263 91.9169C71.1616 92.3516 69.9162 91.8113 69.4815 90.7099L67.0414 84.5267C66.6066 83.4253 67.1473 82.1799 68.2487 81.7455C69.3502 81.3104 70.5956 81.8515 71.0299 82.9525L73.47 89.1357C73.9052 90.2371 73.3641 91.4825 72.263 91.9169Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M69.0357 82.2084C68.8455 82.2084 68.6553 82.2444 68.4733 82.3164C68.093 82.4661 67.794 82.7553 67.6312 83.1303C67.4684 83.5054 67.4615 83.9209 67.612 84.3013L70.0516 90.4844C70.2017 90.8648 70.4909 91.1638 70.866 91.327C71.2406 91.4893 71.6569 91.4959 72.0373 91.3462C72.4177 91.1965 72.7167 90.9073 72.879 90.5323C73.0422 90.1573 73.0492 89.7413 72.8987 89.3609L70.4586 83.1777C70.3089 82.7974 70.0197 82.4984 69.6447 82.336C69.4492 82.251 69.2426 82.2084 69.0357 82.2084ZM71.4752 92.6816C71.1026 92.6816 70.7304 92.6051 70.3779 92.4526C69.7022 92.1593 69.1812 91.6203 68.9108 90.9352L66.4712 84.752C66.2004 84.067 66.2131 83.3177 66.5063 82.642C66.7996 81.9659 67.3386 81.4453 68.0233 81.175C68.7075 80.9046 69.4572 80.9165 70.1341 81.2105C70.8094 81.5034 71.3304 82.0424 71.6012 82.7275L74.0408 88.9107C74.3112 89.5958 74.2989 90.345 74.0053 91.0207C73.7124 91.6959 73.1734 92.2174 72.4883 92.4878C72.1607 92.617 71.8175 92.6816 71.4752 92.6816Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M72.0407 107.201L55.9374 113.556C54.6719 114.056 53.2413 113.434 52.7419 112.169L50.5362 106.579C50.0368 105.314 50.6576 103.884 51.9231 103.385L68.0264 97.0292C69.2915 96.5298 70.7221 97.1507 71.2215 98.4161L73.4276 104.006C73.9266 105.271 73.3058 106.702 72.0407 107.201Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M68.931 97.4699C68.7011 97.4699 68.4717 97.5128 68.2516 97.5999L52.1483 103.955C51.6885 104.137 51.3274 104.486 51.1307 104.939C50.9339 105.392 50.9258 105.895 51.107 106.354L53.3127 111.944C53.4943 112.404 53.8435 112.765 54.2967 112.962C54.7495 113.158 55.2521 113.167 55.7122 112.986L71.8156 106.63C72.7641 106.256 73.2311 105.18 72.8569 104.231L70.6508 98.6412C70.4696 98.1815 70.1199 97.8204 69.6672 97.6236C69.4308 97.5214 69.1809 97.4699 68.931 97.4699ZM55.0322 114.343C54.6163 114.343 54.2007 114.258 53.8077 114.087C53.0543 113.76 52.4727 113.159 52.1709 112.395L49.9652 106.805C49.3423 105.227 50.1198 103.437 51.6973 102.814L67.8006 96.4585C68.5651 96.1574 69.4014 96.1713 70.1552 96.4981C70.909 96.8253 71.4906 97.4265 71.792 98.191L73.9981 103.781C74.6206 105.359 73.8435 107.149 72.2656 107.772L56.1623 114.127C55.7966 114.271 55.4138 114.343 55.0322 114.343Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M48.1633 116.621L45.36 117.728C44.1686 118.197 42.8214 117.613 42.3514 116.422L40.0398 110.564C39.5694 109.373 40.1543 108.026 41.3457 107.556L44.1494 106.449C45.3408 105.979 46.6876 106.564 47.1575 107.755L49.4692 113.613C49.9395 114.804 49.3547 116.151 48.1633 116.621Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M45.0009 106.9C44.789 106.9 44.5775 106.94 44.3747 107.02L41.571 108.127C40.6966 108.472 40.2655 109.465 40.6107 110.339L42.9223 116.197C43.0892 116.621 43.4115 116.954 43.8299 117.135C44.2475 117.317 44.7105 117.325 45.1346 117.157L47.9383 116.051C48.362 115.884 48.6953 115.561 48.8769 115.143C49.0581 114.725 49.0659 114.262 48.8986 113.838L46.5869 107.981C46.4201 107.557 46.0978 107.224 45.6798 107.042C45.4618 106.948 45.2311 106.9 45.0009 106.9ZM44.5079 118.504C44.1112 118.504 43.7157 118.423 43.341 118.261C42.6224 117.949 42.0683 117.375 41.7807 116.647L39.4691 110.789C38.8752 109.286 39.6163 107.579 41.1206 106.985L43.9239 105.879C45.4286 105.284 47.1349 106.026 47.7283 107.53L50.04 113.387C50.3275 114.117 50.314 114.913 50.0024 115.632C49.6903 116.35 49.1169 116.904 48.3885 117.192L45.5852 118.298C45.2363 118.436 44.8719 118.504 44.5079 118.504Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M76.2682 105.53C75.1668 105.964 73.9214 105.424 73.4866 104.323L71.0466 98.1395C70.6118 97.0377 71.1521 95.7927 72.2539 95.3579C73.3554 94.9232 74.6007 95.4639 75.0351 96.5653L77.4752 102.748C77.9103 103.85 77.3692 105.095 76.2682 105.53Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M73.0389 95.8214C72.8524 95.8214 72.6626 95.8558 72.479 95.9286C72.0986 96.0787 71.7997 96.3678 71.6365 96.7429C71.4741 97.1175 71.4672 97.5339 71.6173 97.9138L74.0573 104.097C74.3673 104.882 75.2573 105.269 76.043 104.959C76.423 104.809 76.7223 104.52 76.8847 104.145C77.0479 103.77 77.0544 103.353 76.9043 102.973L74.4643 96.7903C74.2271 96.1891 73.6491 95.8214 73.0389 95.8214ZM75.4843 106.293C74.3845 106.293 73.3432 105.63 72.9158 104.548L70.4757 98.3645C70.2054 97.6795 70.2181 96.9298 70.5109 96.2545C70.8042 95.5785 71.3432 95.0578 72.0283 94.7871C73.4438 94.2276 75.0479 94.9261 75.6058 96.34L78.0458 102.523C78.3162 103.208 78.3039 103.958 78.0102 104.633C77.717 105.308 77.1783 105.83 76.4933 106.1C76.1624 106.231 75.8205 106.293 75.4843 106.293Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M74.9979 120.729L62.492 125.664C61.5771 126.026 60.5419 125.577 60.1808 124.661L57.4745 117.804C57.1133 116.889 57.5624 115.854 58.4773 115.493L70.984 110.557C71.8989 110.196 72.9332 110.645 73.2948 111.56L76.0011 118.418C76.3623 119.333 75.9128 120.368 74.9979 120.729Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M71.636 111.046C71.4937 111.046 71.3493 111.072 71.2091 111.128L58.7028 116.064C58.1036 116.3 57.8087 116.979 58.0455 117.579L60.7519 124.436C60.866 124.726 61.0868 124.954 61.3727 125.079C61.6598 125.204 61.9764 125.208 62.2668 125.094L74.7726 120.158C75.3718 119.921 75.6667 119.242 75.4303 118.643L72.724 111.786C72.5432 111.327 72.1019 111.046 71.636 111.046ZM61.8373 126.404C61.5138 126.404 61.1903 126.337 60.8844 126.204C60.2975 125.95 59.8451 125.482 59.6104 124.887L56.9036 118.029C56.4194 116.8 57.0239 115.407 58.2521 114.922L70.7583 109.986C71.9886 109.502 73.3804 110.107 73.8655 111.335L76.5718 118.193C77.0565 119.421 76.4512 120.815 75.2233 121.3L62.7171 126.235C62.4324 126.347 62.1351 126.404 61.8373 126.404Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M55.1636 128.554L52.735 129.513C51.4401 130.024 49.9759 129.388 49.465 128.093L47.301 122.611C46.7902 121.316 47.4258 119.853 48.7207 119.341L51.1493 118.383C52.4442 117.872 53.908 118.507 54.4192 119.802L56.5828 125.285C57.0936 126.579 56.458 128.044 55.1636 128.554Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M52.0738 118.821C51.8415 118.821 51.6051 118.863 51.3764 118.954L48.9478 119.912C47.9699 120.299 47.4881 121.408 47.8738 122.386L50.0378 127.869C50.2247 128.343 50.585 128.715 51.0525 128.918C51.52 129.121 52.0378 129.13 52.5114 128.943L54.9404 127.984C55.9183 127.598 56.4001 126.489 56.014 125.51L53.8504 120.028C53.5547 119.279 52.8341 118.821 52.0738 118.821ZM51.8106 130.305C51.3869 130.305 50.964 130.218 50.5636 130.043C49.7959 129.71 49.2033 129.098 48.8961 128.319L46.7321 122.837C46.0986 121.23 46.89 119.406 48.4974 118.771L50.9256 117.812C52.5333 117.179 54.357 117.97 54.9918 119.578L57.1554 125.06C57.7897 126.668 56.9979 128.492 55.3906 129.126L52.962 130.084C52.5894 130.231 52.2 130.305 51.8106 130.305Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M78.5639 118.942C77.4625 119.377 76.2175 118.837 75.7823 117.735L73.3422 111.552C72.9079 110.451 73.4482 109.206 74.55 108.771C75.651 108.336 76.8964 108.877 77.3308 109.978L79.7712 116.161C80.206 117.263 79.6653 118.508 78.5639 118.942Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M75.3369 109.234C75.1467 109.234 74.9565 109.27 74.7749 109.342C73.9901 109.651 73.6036 110.542 73.9132 111.327L76.3528 117.51C76.6628 118.294 77.5536 118.683 78.3385 118.372C78.7189 118.222 79.0178 117.933 79.1806 117.558C79.3434 117.183 79.3504 116.767 79.2003 116.386L76.7598 110.203C76.6101 109.823 76.3209 109.524 75.9459 109.361C75.7504 109.276 75.5438 109.234 75.3369 109.234ZM77.7805 119.706C76.6807 119.706 75.639 119.044 75.2112 117.961L72.7715 111.778C72.2132 110.364 72.9098 108.759 74.3241 108.2C75.0091 107.93 75.7588 107.943 76.4345 108.236C77.1101 108.529 77.6308 109.068 77.9016 109.753L80.3416 115.936C80.8999 117.351 80.203 118.956 78.7887 119.514C78.4578 119.644 78.1163 119.706 77.7805 119.706Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M67.6487 79.1396L50.7159 85.8221C49.4967 86.3035 48.1184 85.7052 47.637 84.4855L45.3654 78.7289C44.884 77.5101 45.4824 76.1318 46.7016 75.6504L63.6344 68.9678C64.8536 68.4865 66.232 69.0848 66.7133 70.304L68.9853 76.061C69.4659 77.2799 68.8675 78.6582 67.6487 79.1396Z"
        fill="#808080"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M64.5037 69.4153C64.2893 69.4153 64.0709 69.455 63.8599 69.5384L46.9271 76.221C46.4899 76.3936 46.1459 76.7257 45.9586 77.1572C45.7717 77.5879 45.7639 78.0664 45.9365 78.5036L48.2081 84.2602C48.3807 84.6974 48.7132 85.0414 49.1443 85.2287C49.5753 85.4152 50.0535 85.4238 50.4907 85.2512L67.4239 78.5687C68.3261 78.2124 68.7707 77.1883 68.4149 76.286L66.1429 70.5294C65.8701 69.8378 65.2055 69.4153 64.5037 69.4153ZM49.844 86.6025C49.4403 86.6025 49.0374 86.5195 48.6559 86.3542C47.9242 86.0364 47.3597 85.4528 47.0665 84.7105L44.7949 78.9539C44.5021 78.2119 44.5156 77.4001 44.833 76.6684C45.1512 75.9367 45.7344 75.3723 46.4767 75.0794L63.4091 68.3969C64.9412 67.7932 66.6795 68.5466 67.2844 70.0787L69.5563 75.8353C70.1604 77.367 69.4058 79.1052 67.8741 79.7101L50.9413 86.3927C50.5863 86.533 50.2145 86.6025 49.844 86.6025Z"
        fill="white"
      />
    </svg>
  ),
  joeLogo: (
    <svg
      width="130"
      height="130"
      viewBox="0 0 130 130"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M60.2256 72.4191H69.8754L64.8585 61.5891L60.2256 72.4191Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M85.7166 52.7328C86.524 52.7328 87.1805 52.0762 87.1805 51.2688C87.1805 50.4615 86.524 49.8049 85.7166 49.8049C84.9092 49.8049 84.252 50.4615 84.252 51.2688C84.252 52.0762 84.9092 52.7328 85.7166 52.7328Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M45.2726 45.6039C48.3961 45.6039 50.9371 48.1455 50.9371 51.2683C50.9371 54.3918 48.3961 56.9327 45.2726 56.9327C42.1499 56.9327 39.6082 54.3918 39.6082 51.2683C39.6082 48.1455 42.1499 45.6039 45.2726 45.6039ZM85.7166 45.6039C88.8401 45.6039 91.381 48.1455 91.381 51.2683C91.381 54.3918 88.8401 56.9327 85.7166 56.9327C82.5931 56.9327 80.0514 54.3918 80.0514 51.2683C80.0514 48.1455 82.5931 45.6039 85.7166 45.6039ZM31.9136 60.049H97.7124C100.741 60.049 103.197 57.594 103.197 54.5646V47.806C103.197 44.7773 100.741 42.3215 97.7124 42.3215H31.9136C28.8857 42.3215 26.4299 44.7773 26.4299 47.806V54.5646C26.4299 57.594 28.8857 60.049 31.9136 60.049Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.22314 74.5962V73.8202V72.9882V50.0907V49.2594V48.4826C9.22314 48.4759 9.22539 48.4707 9.22539 48.4647C9.23584 46.8611 10.5414 45.56 12.1457 45.56H13.5536C15.1647 45.56 16.4762 46.8716 16.4762 48.4826V74.5962C16.4762 76.208 15.1647 77.5196 13.5536 77.5196H12.1457C10.5414 77.5196 9.23584 76.2177 9.22539 74.6149C9.22539 74.6089 9.22314 74.6029 9.22314 74.5962ZM7.33359 57.0767V66.0013V73.4299C7.32986 73.4299 7.32612 73.4314 7.32314 73.4314H4.51408C3.02179 73.4314 1.80735 72.2162 1.80735 70.7239V70.2011V69.4676V68.7349V54.3438V53.6103V52.8769V52.3541C1.80735 50.861 3.02179 49.6473 4.51408 49.6473H7.32314C7.32612 49.6473 7.32986 49.6481 7.33359 49.6481V57.0767ZM18.6338 44.9219C18.6338 37.6554 22.856 31.3718 28.9671 28.3491C29.2105 28.2289 29.451 28.1056 29.7005 27.9951C29.941 27.8898 30.1875 27.7957 30.4332 27.6993C32.033 27.0749 33.7352 26.6619 35.5136 26.5073C35.7996 26.4826 36.0902 26.4752 36.3785 26.464C36.6294 26.4535 36.8759 26.4259 37.1298 26.4259H37.2964H46.3651H47.3129H48.192H58.1645H59.0421H59.9921H69.0594H70.0079H70.8863H82.2861H83.1644H84.1137H91.9202C92.3295 26.4259 92.7291 26.461 93.1309 26.4871C93.4297 26.5065 93.7299 26.5207 94.0242 26.5543C94.3073 26.5865 94.5836 26.638 94.8615 26.6828C96.8497 27.0017 98.7348 27.6284 100.459 28.5306C100.707 28.6606 100.95 28.8017 101.192 28.9422C101.44 29.0863 101.686 29.2334 101.926 29.3888C107.025 32.6856 110.417 38.4098 110.417 44.9219V69.4394C110.417 78.0294 104.522 85.2496 96.5703 87.32C95.0818 87.7077 93.529 87.9347 91.9202 87.9347H37.1298C36.5084 87.9347 35.896 87.9019 35.2902 87.8414C25.9519 86.9152 18.6338 79.0168 18.6338 69.4394V44.9219ZM30.4341 21.7264C30.4341 19.5425 32.2102 17.7671 34.3941 17.7671H34.5585H35.2912H36.0253H47.638H48.3707H49.1049H57.2535H57.9862H58.7204H70.3323H71.0665H71.7984H81.3758H82.1085H82.8412H94.4546H95.1888H95.9215H96.5003C98.6835 17.7671 100.46 19.5425 100.46 21.7264V26.4803C98.9172 25.7461 97.2726 25.1994 95.5443 24.8805C95.3038 24.8364 95.0588 24.8051 94.8161 24.7692C94.5703 24.7334 94.3276 24.6841 94.0789 24.6572C93.3693 24.5802 92.6508 24.5354 91.9219 24.5354H83.1743H82.408H81.6454H71.5288H70.7655H70.0006H59.052H58.2857H57.5231H48.8345H48.0712H47.3056H37.1307C36.8738 24.5354 36.6236 24.5646 36.3689 24.5735C36.1172 24.584 35.8648 24.5937 35.6153 24.6116C35.3666 24.6318 35.1171 24.6445 34.8707 24.6721C33.3306 24.8476 31.8487 25.2091 30.4341 25.7155V21.7264ZM36.0247 13.7069C36.0247 11.1712 38.0876 9.10831 40.6225 9.10831H43.038C45.5744 9.10831 47.6373 11.1712 47.6373 13.7069V15.8767H36.0247V13.7069ZM58.7199 13.7069C58.7199 11.1712 60.782 9.10831 63.3177 9.10831H65.7339C68.2696 9.10831 70.3318 11.1712 70.3318 13.7069V15.8767H58.7199V13.7069ZM82.8404 13.7069C82.8404 11.1712 84.9033 9.10831 87.4397 9.10831H89.8559C92.3916 9.10831 94.4538 11.1712 94.4538 13.7069V15.8767H82.8404V13.7069ZM36.7143 95.9728H93.0806V89.5585H36.7143V95.9728ZM112.77 48.4826C112.77 46.8716 114.082 45.56 115.693 45.56H117.101C118.705 45.56 120.011 46.8611 120.021 48.4647C120.021 48.4707 120.023 48.4759 120.023 48.4826V49.2594V50.0907V72.9882V73.8202V74.5962C120.023 74.6029 120.021 74.6089 120.021 74.6149C120.011 76.2177 118.705 77.5196 117.101 77.5196H115.693C114.082 77.5196 112.77 76.208 112.77 74.5962V48.4826ZM121.913 66.0013V57.0767V49.6481C121.917 49.6481 121.92 49.6473 121.924 49.6473H124.732C126.224 49.6473 127.439 50.861 127.439 52.3541V52.8769V53.6103V54.3438V68.7349V69.4676V70.2011V70.7239C127.439 72.2162 126.224 73.4314 124.732 73.4314H121.924C121.92 73.4314 121.917 73.4299 121.913 73.4299V66.0013ZM19.5752 97.7981H35.2906H96.5707H111.302C114.358 97.7981 117.175 98.7982 119.469 100.476C126.127 90.2739 130 78.0906 130 64.9998C130 29.1019 100.899 0 65.0004 0C29.1011 0 0 29.1019 0 64.9998C0 78.2818 3.9869 90.6302 10.8239 100.921C13.214 98.973 16.2568 97.7981 19.5752 97.7981Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M73.1718 75.7686H57.1032C56.1367 75.7686 55.354 76.552 55.354 77.5193C55.354 78.4858 56.1367 79.2692 57.1032 79.2692H73.1718C74.1383 79.2692 74.9218 78.4858 74.9218 77.5193C74.9218 76.552 74.1383 75.7686 73.1718 75.7686Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M45.272 52.7328C46.0794 52.7328 46.7359 52.0762 46.7359 51.2688C46.7359 50.4615 46.0794 49.8049 45.272 49.8049C44.4646 49.8049 43.8081 50.4615 43.8081 51.2688C43.8081 52.0762 44.4646 52.7328 45.272 52.7328Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M23.5839 113.169C24.6453 112.511 25.8843 112.113 27.2228 112.113H103.061C104.398 112.113 105.638 112.511 106.699 113.169C107.073 113.402 107.414 113.677 107.738 113.972C108.188 113.578 108.633 113.177 109.074 112.771C108.391 112.072 107.589 111.492 106.699 111.062C105.596 110.53 104.365 110.223 103.061 110.223H27.2228C25.918 110.223 24.6871 110.53 23.5839 111.062C22.6354 111.52 21.7899 112.153 21.0789 112.912C21.5158 113.314 21.9572 113.711 22.4061 114.099C22.7661 113.752 23.1567 113.435 23.5839 113.169Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M47.6373 13.7068C47.6373 11.1711 45.5744 9.10889 43.0387 9.10889H40.6225C38.0876 9.10889 36.0247 11.1711 36.0247 13.7068V15.8765H47.6373V13.7068Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M70.3319 13.7068C70.3319 11.1711 68.269 9.10889 65.734 9.10889H63.3171C60.7821 9.10889 58.7192 11.1711 58.7192 13.7068V15.8765H70.3319V13.7068Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M94.4542 13.7068C94.4542 11.1711 92.3913 9.10889 89.8564 9.10889H87.4394C84.9037 9.10889 82.8408 11.1711 82.8408 13.7068V15.8765H94.4542V13.7068Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M124.732 73.4315C126.224 73.4315 127.439 72.2163 127.439 70.724V70.2012V69.467V68.7351V54.3432V53.6105V52.8763V52.3535C127.439 50.8604 126.224 49.6467 124.732 49.6467H121.923C121.919 49.6467 121.916 49.6475 121.913 49.6475V57.0768V66.0014V73.43C121.916 73.43 121.919 73.4315 121.923 73.4315H124.732Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M115.693 77.5196H117.1C118.705 77.5196 120.01 76.2178 120.021 74.6149C120.021 74.609 120.023 74.603 120.023 74.5963V73.8202V72.9882V50.0907V49.2594V48.4826C120.023 48.4759 120.021 48.4707 120.021 48.4647C120.01 46.8611 118.705 45.5601 117.1 45.5601H115.693C114.082 45.5601 112.77 46.8716 112.77 48.4826V74.5963C112.77 76.2081 114.082 77.5196 115.693 77.5196Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M4.51459 49.6472C3.02231 49.6472 1.80786 50.8609 1.80786 52.354V52.8768V53.611V54.3437V68.7356V69.4675V70.2017V70.7245C1.80786 72.2168 3.02231 73.432 4.51459 73.432H7.32365C7.32663 73.432 7.33037 73.4305 7.33336 73.4305V66.0012V57.0766V49.648C7.33037 49.648 7.32663 49.6472 7.32365 49.6472H4.51459Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M96.5707 97.7983H35.2906H19.5753C16.2569 97.7983 13.214 98.9725 10.8232 100.921C13.7488 105.325 17.1965 109.352 21.0795 112.912C21.7898 112.153 22.6361 111.52 23.5839 111.062C24.687 110.53 25.9179 110.223 27.2227 110.223H103.06C104.365 110.223 105.596 110.53 106.699 111.062C107.589 111.492 108.391 112.072 109.074 112.771C113.023 109.124 116.519 104.995 119.469 100.476C117.175 98.7984 114.357 97.7983 111.302 97.7983H96.5707Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M103.06 112.113H27.2227C25.8843 112.113 24.6452 112.511 23.5839 113.17C23.1566 113.436 22.766 113.752 22.406 114.1C33.8133 124.005 48.7063 130 64.9997 130C81.3625 130 96.3108 123.953 107.737 113.973C107.414 113.678 107.073 113.402 106.699 113.17C105.638 112.511 104.398 112.113 103.06 112.113Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M35.6148 24.6116C35.8642 24.5937 36.1167 24.584 36.3684 24.5735C36.6231 24.5646 36.8733 24.5347 37.1302 24.5347H47.3051H48.0707H48.834H57.5226H58.2859H59.0514H70.0001H70.7657H71.5282H81.6449H82.4074H83.1738H91.9213C92.6503 24.5347 93.3688 24.5802 94.0784 24.6572C94.3271 24.6841 94.5698 24.7334 94.8155 24.7692C95.0583 24.8051 95.3033 24.8364 95.5438 24.8805C97.2721 25.1994 98.9167 25.7461 100.459 26.4803V21.7264C100.459 19.5425 98.6829 17.7671 96.4998 17.7671H95.9209H95.1882H94.454H82.8406H82.1079H81.3752H71.7979H71.0659H70.3317H58.7198H57.9856H57.2529H49.1044H48.3702H47.6375H36.0248H35.2906H34.5579H34.3936C32.2097 17.7671 30.4336 19.5425 30.4336 21.7264V25.7155C31.8482 25.2091 33.33 24.8469 34.8701 24.6721C35.1166 24.6445 35.3661 24.631 35.6148 24.6116Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.1462 77.5196H13.5541C15.1651 77.5196 16.4767 76.2081 16.4767 74.5963V48.4826C16.4767 46.8716 15.1651 45.5601 13.5541 45.5601H12.1462C10.5419 45.5601 9.23633 46.8611 9.22587 48.4647C9.22587 48.4707 9.22363 48.4759 9.22363 48.4826V49.2594V50.0907V72.9882V73.8202V74.5963C9.22363 74.603 9.22587 74.609 9.22587 74.6149C9.23633 76.2178 10.5419 77.5196 12.1462 77.5196Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M45.2731 49.8043C46.0805 49.8043 46.737 50.4608 46.737 51.2682C46.737 52.0756 46.0805 52.7321 45.2731 52.7321C44.4657 52.7321 43.8092 52.0756 43.8092 51.2682C43.8092 50.4608 44.4657 49.8043 45.2731 49.8043ZM45.2726 56.9326C48.3961 56.9326 50.937 54.3917 50.937 51.2682C50.937 48.1454 48.3961 45.6038 45.2726 45.6038C42.1498 45.6038 39.6082 48.1454 39.6082 51.2682C39.6082 54.3917 42.1498 56.9326 45.2726 56.9326Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M85.7179 49.8043C86.5253 49.8043 87.1818 50.4608 87.1818 51.2682C87.1818 52.0756 86.5253 52.7321 85.7179 52.7321C84.9105 52.7321 84.2533 52.0756 84.2533 51.2682C84.2533 50.4608 84.9105 49.8043 85.7179 49.8043ZM85.7174 56.9326C88.8409 56.9326 91.3818 54.3917 91.3818 51.2682C91.3818 48.1454 88.8409 45.6038 85.7174 45.6038C82.5932 45.6038 80.0522 48.1454 80.0522 51.2682C80.0522 54.3917 82.5932 56.9326 85.7174 56.9326Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M26.4305 47.8066C26.4305 44.7772 28.8855 42.3221 31.9142 42.3221H97.7122C100.741 42.3221 103.197 44.7772 103.197 47.8066V54.5652C103.197 57.5938 100.741 60.0496 97.7122 60.0496H31.9142C28.8855 60.0496 26.4305 57.5938 26.4305 54.5652V47.8066ZM60.226 72.4189L64.8589 61.589L69.8758 72.4189H60.226ZM73.1717 79.2692H57.1031C56.1366 79.2692 55.3539 78.4857 55.3539 77.5192C55.3539 76.552 56.1366 75.7685 57.1031 75.7685H73.1717C74.1382 75.7685 74.9216 76.552 74.9216 77.5192C74.9216 78.4857 74.1382 79.2692 73.1717 79.2692ZM35.2909 87.842C35.8967 87.9025 36.5091 87.9354 37.1305 87.9354H91.9209C93.5297 87.9354 95.0825 87.7076 96.571 87.3199C104.523 85.2496 110.418 78.0294 110.418 69.4393V44.9218C110.418 38.4097 107.026 32.6855 101.926 29.3887C101.686 29.2334 101.441 29.087 101.193 28.9421C100.95 28.8016 100.708 28.6605 100.459 28.5305C98.7355 27.6283 96.8504 27.0024 94.8621 26.6827C94.5843 26.6379 94.308 26.5864 94.0249 26.5542C93.7299 26.5206 93.4304 26.5064 93.1316 26.487C92.7298 26.4609 92.3294 26.4258 91.9209 26.4258H84.1136H83.1651H82.2868H70.8862H70.0086H69.0601H59.9928H59.0428H58.1652H48.1927H47.3136H46.3651H37.2971H37.1305C36.8766 26.4258 36.6301 26.4534 36.3791 26.4639C36.0908 26.4751 35.8003 26.4825 35.5142 26.5072C33.7359 26.6618 32.0337 27.0748 30.4339 27.6992C30.1882 27.7956 29.9417 27.8897 29.7012 27.9957C29.4517 28.1055 29.2112 28.2288 28.967 28.349C22.8567 31.3717 18.6345 37.6553 18.6345 44.9218V69.4393C18.6345 79.0167 25.9526 86.9151 35.2909 87.842Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M36.7136 95.9729H93.0799V89.5586H36.7136V95.9729Z"
        fill="white"
      />
    </svg>
  ),
  joeHistoryLogo: (
    <svg
      width="130"
      height="130"
      viewBox="0 0 130 130"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M60.2256 72.4193H69.8754L64.8585 61.5894L60.2256 72.4193Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M85.7171 52.7325C86.5245 52.7325 87.181 52.076 87.181 51.2686C87.181 50.4612 86.5245 49.8047 85.7171 49.8047C84.9097 49.8047 84.2524 50.4612 84.2524 51.2686C84.2524 52.076 84.9097 52.7325 85.7171 52.7325"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M45.2727 45.6037C48.3962 45.6037 50.9371 48.1454 50.9371 51.2681C50.9371 54.3916 48.3962 56.9325 45.2727 56.9325C42.15 56.9325 39.6083 54.3916 39.6083 51.2681C39.6083 48.1454 42.15 45.6037 45.2727 45.6037M85.7155 45.6037C88.839 45.6037 91.3799 48.1454 91.3799 51.2681C91.3799 54.3916 88.839 56.9325 85.7155 56.9325C82.592 56.9325 80.0503 54.3916 80.0503 51.2681C80.0503 48.1454 82.592 45.6037 85.7155 45.6037M31.9131 60.0493H97.7119C100.741 60.0493 103.196 57.5942 103.196 54.5648V47.8062C103.196 44.7776 100.741 42.3218 97.7119 42.3218H31.9131C28.8852 42.3218 26.4294 44.7776 26.4294 47.8062V54.5648C26.4294 57.5942 28.8852 60.0493 31.9131 60.0493"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.22262 74.5965V73.8205V72.9884V50.091V49.2597V48.4829C9.22262 48.4762 9.22486 48.4709 9.22486 48.465C9.23531 46.8614 10.5409 45.5603 12.1452 45.5603H13.5531C15.1641 45.5603 16.4757 46.8718 16.4757 48.4829V74.5965C16.4757 76.2083 15.1641 77.5198 13.5531 77.5198H12.1452C10.5409 77.5198 9.23531 76.218 9.22486 74.6152C9.22486 74.6092 9.22262 74.6032 9.22262 74.5965V74.5965ZM7.33374 57.0765V66.0011V73.4297C7.33 73.4297 7.32627 73.4312 7.32328 73.4312H4.51423C3.02194 73.4312 1.8075 72.216 1.8075 70.7237V70.2009V69.4674V68.7347V54.3436V53.6101V52.8767V52.3539C1.8075 50.8608 3.02194 49.6471 4.51423 49.6471H7.32328C7.32627 49.6471 7.33 49.6479 7.33374 49.6479V57.0765ZM18.6335 44.9213C18.6335 37.6548 22.8557 31.3712 28.9668 28.3485C29.2103 28.2283 29.4508 28.1051 29.7002 27.9945C29.9407 27.8892 30.1872 27.7951 30.4329 27.6987C32.0328 27.0743 33.7349 26.6613 35.5133 26.5067C35.7993 26.4821 36.0899 26.4746 36.3782 26.4634C36.6291 26.4529 36.8756 26.4253 37.1295 26.4253H37.2961H46.3648H47.3126H48.1917H58.1642H59.0418H59.9918H69.0591H70.0076H70.886H82.2858H83.1641H84.1134H91.9199C92.3292 26.4253 92.7288 26.4604 93.1306 26.4865C93.4294 26.506 93.7296 26.5201 94.0239 26.5538C94.307 26.5859 94.5833 26.6374 94.8612 26.6822C96.8494 27.0011 98.7345 27.6278 100.458 28.53C100.707 28.66 100.95 28.8012 101.192 28.9416C101.44 29.0857 101.686 29.2329 101.925 29.3882C107.025 32.685 110.417 38.4092 110.417 44.9213V69.4388C110.417 78.0289 104.522 85.2491 96.5701 87.3194C95.0815 87.7071 93.5287 87.9341 91.9199 87.9341H37.1295C36.5081 87.9341 35.8957 87.9013 35.2899 87.8408C25.9516 86.9146 18.6335 79.0162 18.6335 69.4388V44.9213ZM30.4344 21.7264C30.4344 19.5425 32.2105 17.7671 34.3944 17.7671H34.5587H35.2914H36.0256H47.6382H48.3709H49.1051H57.2537H57.9864H58.7206H70.3325H71.0667H71.7986H81.376H82.1087H82.8414H94.4548H95.189H95.9217H96.5005C98.6837 17.7671 100.46 19.5425 100.46 21.7264V26.4803C98.9175 25.7461 97.2728 25.1994 95.5445 24.8805C95.304 24.8364 95.059 24.8051 94.8163 24.7692C94.5706 24.7334 94.3278 24.6841 94.0791 24.6572C93.3696 24.5802 92.6511 24.5354 91.9221 24.5354H83.1745H82.4082H81.6456H71.529H70.7657H70.0009H59.0522H58.2859H57.5233H48.8348H48.0714H47.3059H37.131C36.8741 24.5354 36.6238 24.5646 36.3692 24.5735C36.1175 24.584 35.865 24.5937 35.6155 24.6116C35.3668 24.6318 35.1174 24.6445 34.8709 24.6721C33.3308 24.8476 31.849 25.2091 30.4344 25.7155V21.7264ZM36.0245 13.7075C36.0245 11.1718 38.0874 9.10889 40.6224 9.10889H43.0378C45.5743 9.10889 47.6372 11.1718 47.6372 13.7075V15.8772H36.0245V13.7075ZM58.7195 13.7075C58.7195 11.1718 60.7817 9.10889 63.3174 9.10889H65.7336C68.2693 9.10889 70.3314 11.1718 70.3314 13.7075V15.8772H58.7195V13.7075ZM82.8411 13.7075C82.8411 11.1718 84.9041 9.10889 87.4405 9.10889H89.8567C92.3924 9.10889 94.4545 11.1718 94.4545 13.7075V15.8772H82.8411V13.7075ZM36.7138 95.9734H93.0801V89.5591H36.7138V95.9734ZM112.77 48.4829C112.77 46.8718 114.082 45.5603 115.693 45.5603H117.101C118.705 45.5603 120.011 46.8614 120.021 48.465C120.021 48.4709 120.023 48.4762 120.023 48.4829V49.2597V50.091V72.9884V73.8205V74.5965C120.023 74.6032 120.021 74.6092 120.021 74.6152C120.011 76.218 118.705 77.5198 117.101 77.5198H115.693C114.082 77.5198 112.77 76.2083 112.77 74.5965V48.4829ZM121.913 66.0011V57.0765V49.6479C121.917 49.6479 121.92 49.6471 121.924 49.6471H124.732C126.224 49.6471 127.439 50.8608 127.439 52.3539V52.8767V53.6101V54.3436V68.7347V69.4674V70.2009V70.7237C127.439 72.216 126.224 73.4312 124.732 73.4312H121.924C121.92 73.4312 121.917 73.4297 121.913 73.4297V66.0011ZM19.5752 97.7981H35.2906H96.5707H111.302C114.358 97.7981 117.175 98.7982 119.469 100.476C126.127 90.2739 130 78.0906 130 64.9998C130 29.1019 100.899 0 65.0004 0C29.1011 0 0 29.1019 0 64.9998C0 78.2818 3.9869 90.6302 10.8239 100.921C13.214 98.973 16.2568 97.7981 19.5752 97.7981V97.7981Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M73.1716 75.7686H57.103C56.1365 75.7686 55.3538 76.552 55.3538 77.5193C55.3538 78.4858 56.1365 79.2692 57.103 79.2692H73.1716C74.1381 79.2692 74.9215 78.4858 74.9215 77.5193C74.9215 76.552 74.1381 75.7686 73.1716 75.7686"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M45.2718 52.7325C46.0792 52.7325 46.7357 52.076 46.7357 51.2686C46.7357 50.4612 46.0792 49.8047 45.2718 49.8047C44.4644 49.8047 43.8079 50.4612 43.8079 51.2686C43.8079 52.076 44.4644 52.7325 45.2718 52.7325Z"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M23.5842 113.169C24.6455 112.51 25.8846 112.112 27.223 112.112H103.061C104.398 112.112 105.638 112.51 106.699 113.169C107.073 113.401 107.414 113.677 107.738 113.972C108.188 113.578 108.633 113.177 109.074 112.77C108.391 112.072 107.589 111.492 106.699 111.062C105.596 110.53 104.365 110.223 103.061 110.223H27.223C25.9182 110.223 24.6873 110.53 23.5842 111.062C22.6356 111.52 21.7901 112.153 21.0791 112.912C21.516 113.313 21.9574 113.711 22.4063 114.099C22.7663 113.752 23.157 113.434 23.5842 113.169"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M47.6371 13.7068C47.6371 11.1711 45.5742 9.10889 43.0385 9.10889H40.6223C38.0873 9.10889 36.0244 11.1711 36.0244 13.7068V15.8765H47.6371V13.7068Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M70.3324 13.7068C70.3324 11.1711 68.2695 9.10889 65.7345 9.10889H63.3176C60.7826 9.10889 58.7197 11.1711 58.7197 13.7068V15.8765H70.3324V13.7068Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M94.4547 13.7068C94.4547 11.1711 92.3918 9.10889 89.8568 9.10889H87.4399C84.9042 9.10889 82.8413 11.1711 82.8413 13.7068V15.8765H94.4547V13.7068Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M124.732 73.4318C126.224 73.4318 127.439 72.2166 127.439 70.7243V70.2015V69.4673V68.7353V54.3434V53.6107V52.8765V52.3537C127.439 50.8607 126.224 49.647 124.732 49.647H121.923C121.919 49.647 121.916 49.6477 121.913 49.6477V57.0771V66.0017V73.4303C121.916 73.4303 121.919 73.4318 121.923 73.4318H124.732Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M115.693 77.5201H117.101C118.705 77.5201 120.011 76.2183 120.021 74.6154C120.021 74.6094 120.024 74.6035 120.024 74.5967V73.8207V72.9887V50.0912V49.2599V48.4831C120.024 48.4764 120.021 48.4712 120.021 48.4652C120.011 46.8616 118.705 45.5605 117.101 45.5605H115.693C114.082 45.5605 112.771 46.8721 112.771 48.4831V74.5967C112.771 76.2085 114.082 77.5201 115.693 77.5201"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M4.51435 49.647C3.02206 49.647 1.80762 50.8607 1.80762 52.3537V52.8765V53.6107V54.3434V68.7353V69.4673V70.2015V70.7243C1.80762 72.2166 3.02206 73.4318 4.51435 73.4318H7.3234C7.32639 73.4318 7.33013 73.4303 7.33311 73.4303V66.0009V57.0763V49.6477C7.33013 49.6477 7.32639 49.647 7.3234 49.647H4.51435Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M96.5707 97.7983H35.2906H19.5753C16.2569 97.7983 13.214 98.9725 10.8232 100.921C13.7488 105.325 17.1965 109.352 21.0795 112.912C21.7898 112.153 22.6361 111.52 23.5839 111.062C24.687 110.53 25.9179 110.223 27.2227 110.223H103.06C104.365 110.223 105.596 110.53 106.699 111.062C107.589 111.492 108.391 112.072 109.074 112.771C113.023 109.124 116.519 104.995 119.469 100.476C117.175 98.7984 114.357 97.7983 111.302 97.7983H96.5707Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M103.061 112.112H27.2229C25.8845 112.112 24.6454 112.51 23.5841 113.169C23.1569 113.435 22.7663 113.752 22.4062 114.099C33.8135 124.004 48.7065 130 64.9999 130C81.3628 130 96.3111 123.952 107.738 113.972C107.414 113.677 107.073 113.401 106.699 113.169C105.638 112.51 104.398 112.112 103.061 112.112"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M35.615 24.6116C35.8645 24.5937 36.1169 24.584 36.3686 24.5735C36.6233 24.5646 36.8735 24.5347 37.1305 24.5347H47.3053H48.0709H48.8342H57.5228H58.2861H59.0517H70.0004H70.7659H71.5285H81.6451H82.4077H83.174H91.9216C92.6505 24.5347 93.3691 24.5802 94.0786 24.6572C94.3273 24.6841 94.5701 24.7334 94.8158 24.7692C95.0585 24.8051 95.3035 24.8364 95.544 24.8805C97.2723 25.1994 98.917 25.7461 100.459 26.4803V21.7264C100.459 19.5425 98.6832 17.7671 96.5 17.7671H95.9212H95.1885H94.4543H82.8409H82.1082H81.3755H71.7981H71.0662H70.332H58.7201H57.9859H57.2532H49.1046H48.3704H47.6377H36.0251H35.2909H34.5582H34.3939C32.2099 17.7671 30.4338 19.5425 30.4338 21.7264V25.7155C31.8484 25.2091 33.3303 24.8469 34.8704 24.6721C35.1168 24.6445 35.3663 24.631 35.615 24.6116"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.1462 77.5201H13.5541C15.1651 77.5201 16.4767 76.2085 16.4767 74.5967V48.4831C16.4767 46.8721 15.1651 45.5605 13.5541 45.5605H12.1462C10.5419 45.5605 9.23633 46.8616 9.22587 48.4652C9.22587 48.4712 9.22363 48.4764 9.22363 48.4831V49.2599V50.0912V72.9887V73.8207V74.5967C9.22363 74.6035 9.22587 74.6094 9.22587 74.6154C9.23633 76.2183 10.5419 77.5201 12.1462 77.5201"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M45.2723 49.8048C46.0796 49.8048 46.7362 50.4613 46.7362 51.2687C46.7362 52.0761 46.0796 52.7326 45.2723 52.7326C44.4649 52.7326 43.8083 52.0761 43.8083 51.2687C43.8083 50.4613 44.4649 49.8048 45.2723 49.8048M45.2728 56.9324C48.3963 56.9324 50.9372 54.3915 50.9372 51.2679C50.9372 48.1452 48.3963 45.6035 45.2728 45.6035C42.1501 45.6035 39.6084 48.1452 39.6084 51.2679C39.6084 54.3915 42.1501 56.9324 45.2728 56.9324"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M85.716 49.8048C86.5234 49.8048 87.1799 50.4613 87.1799 51.2687C87.1799 52.0761 86.5234 52.7326 85.716 52.7326C84.9086 52.7326 84.2514 52.0761 84.2514 51.2687C84.2514 50.4613 84.9086 49.8048 85.716 49.8048M85.7164 56.9324C88.8399 56.9324 91.3809 54.3915 91.3809 51.2679C91.3809 48.1452 88.8399 45.6035 85.7164 45.6035C82.5922 45.6035 80.0513 48.1452 80.0513 51.2679C80.0513 54.3915 82.5922 56.9324 85.7164 56.9324"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M26.4306 47.8064C26.4306 44.777 28.8856 42.3219 31.9143 42.3219H97.7123C100.741 42.3219 103.197 44.777 103.197 47.8064V54.565C103.197 57.5937 100.741 60.0494 97.7123 60.0494H31.9143C28.8856 60.0494 26.4306 57.5937 26.4306 54.565V47.8064ZM60.2266 72.4191L64.8595 61.5892L69.8764 72.4191H60.2266ZM73.1726 79.2695H57.104C56.1375 79.2695 55.3547 78.486 55.3547 77.5195C55.3547 76.5523 56.1375 75.7688 57.104 75.7688H73.1726C74.139 75.7688 74.9225 76.5523 74.9225 77.5195C74.9225 78.486 74.139 79.2695 73.1726 79.2695V79.2695ZM35.2909 87.8415C35.8967 87.902 36.5091 87.9349 37.1305 87.9349H91.9209C93.5297 87.9349 95.0825 87.7071 96.571 87.3195C104.523 85.2491 110.418 78.0289 110.418 69.4388V44.9213C110.418 38.4092 107.026 32.685 101.926 29.3882C101.686 29.2329 101.441 29.0865 101.193 28.9416C100.95 28.8012 100.708 28.66 100.459 28.53C98.7355 27.6278 96.8504 27.0019 94.8621 26.6822C94.5843 26.6374 94.308 26.5859 94.0249 26.5538C93.7299 26.5201 93.4304 26.506 93.1316 26.4865C92.7298 26.4604 92.3294 26.4253 91.9209 26.4253H84.1136H83.1651H82.2868H70.8862H70.0086H69.0601H59.9928H59.0428H58.1652H48.1927H47.3136H46.3651H37.2971H37.1305C36.8766 26.4253 36.6301 26.4529 36.3791 26.4634C36.0908 26.4746 35.8003 26.4821 35.5142 26.5067C33.7359 26.6613 32.0337 27.0743 30.4339 27.6987C30.1882 27.7951 29.9417 27.8892 29.7012 27.9953C29.4517 28.1051 29.2112 28.2283 28.967 28.3485C22.8567 31.3712 18.6345 37.6548 18.6345 44.9213V69.4388C18.6345 79.0163 25.9526 86.9146 35.2909 87.8415V87.8415Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M36.7139 95.9734H93.0802V89.5591H36.7139V95.9734Z"
        fill="white"
      />
      <circle cx="104" cy="104" r="26" fill="#FF6112" />
      <circle cx="104" cy="104" r="24" fill="white" />
      <path
        d="M104.48 87.1997C96.0336 87.1997 89.0429 93.4728 87.8721 101.6H82.8804L90.0804 108.8L97.2804 101.6H92.723C93.8381 96.1294 98.6858 91.9997 104.48 91.9997C111.097 91.9997 116.48 97.3833 116.48 104C116.48 110.616 111.097 116 104.48 116C100.631 116 96.9874 114.132 94.735 111.005L90.8397 113.808C93.9921 118.186 99.0909 120.8 104.48 120.8C113.744 120.8 121.28 113.262 121.28 104C121.28 94.7372 113.744 87.1997 104.48 87.1997V87.1997Z"
        fill="#FF6112"
      />
      <path
        d="M102.079 96.7998V106.559L109.243 110.858L111.714 106.742L106.879 103.841V96.7999L102.079 96.7998Z"
        fill="#FF6112"
      />
    </svg>
  ),
  emoji: {
    white_check_mark: (
      <svg
        width="14"
        height="14"
        viewBox="0 0 14 14"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <circle cx="7" cy="7" r="7" fill="#0DB94D" />
        <g clipPath="url(#clip0)">
          <path
            d="M10.547 4.16699L5.95211 8.76193L3.4528 6.26264L2.33325 7.38218L5.95211 11.001L11.6666 5.28656L10.547 4.16699Z"
            fill="white"
          />
        </g>
        <defs>
          <clipPath id="clip0">
            <rect
              x="2.33325"
              y="2.91699"
              width="9.33333"
              height="9.33333"
              fill="white"
            />
          </clipPath>
        </defs>
      </svg>
    ),
  },
  logo: (
    <svg
      width="230"
      height="47"
      viewBox="0 0 230 47"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M12.7106 19.9681H2.62978V34.673H0V0H12.7106C18.7007 0 23.1823 3.60499 23.1823 9.98222C23.1823 16.3594 18.7007 19.9681 12.7106 19.9681ZM12.4184 2.33758H2.62978V17.6305H12.4184C17.2397 17.6305 20.5525 15.1943 20.5525 9.98587C20.5525 4.77744 17.2397 2.33758 12.4184 2.33758Z"
        fill="#202020"
      />
      <path
        d="M44.2169 32.3828C42.5112 34.0885 40.3708 34.9651 37.6899 34.9651C35.009 34.9651 32.8723 34.0885 31.1666 32.3828C28.6829 29.8991 28.2446 26.2941 28.2446 22.9338C28.2446 19.5736 28.6829 15.9686 31.1666 13.4849C32.0219 12.6335 33.0419 11.9654 34.1641 11.5214C35.2863 11.0774 36.4873 10.8668 37.6936 10.9026C40.3708 10.9026 42.5148 11.7792 44.2206 13.4849C46.7042 15.9686 47.1425 19.5736 47.1425 22.9338C47.1425 26.2941 46.7006 29.9028 44.2169 32.3828ZM42.5623 15.0956C41.264 13.8164 39.5144 13.0993 37.6918 13.0993C35.8691 13.0993 34.1195 13.8164 32.8212 15.0956C30.8744 17.0424 30.7283 20.2091 30.7283 22.9375C30.7283 25.6659 30.8744 28.8289 32.8212 30.7793C34.1195 32.0586 35.8691 32.7757 37.6918 32.7757C39.5144 32.7757 41.264 32.0586 42.5623 30.7793C44.5091 28.8326 44.6552 25.6659 44.6552 22.9375C44.6552 20.2091 44.5091 17.046 42.5623 15.0956Z"
        fill="#202020"
      />
      <path
        d="M62.432 34.9655C58.3412 34.9655 55.3206 33.8953 52.9355 31.6052L54.6413 29.8995C56.4419 31.7988 59.0242 32.774 62.337 32.774C66.9647 32.774 69.3973 31.1669 69.3973 28.0002C69.3973 25.5165 68.0349 24.3952 64.9157 24.0555L61.0185 23.7158C56.2958 23.325 53.9582 21.2796 53.9582 17.5797C53.9582 13.4889 57.271 10.9066 62.3845 10.9066C65.6462 10.9066 68.5207 11.8307 70.6135 13.3903L68.959 15.0449C67.0414 13.685 64.7344 12.984 62.3845 13.047C58.4873 13.047 56.3944 14.6541 56.3944 17.576C56.3944 20.0597 57.8554 21.181 61.1682 21.5207L64.9668 21.8604C68.864 22.2512 71.8335 23.42 71.8335 27.9966C71.8298 32.2882 68.2248 34.9655 62.432 34.9655Z"
        fill="#202020"
      />
      <path
        d="M79.3758 28.5368V13.0503H76.1616V11.2021H79.3758V3.69995H81.8595V11.2021H87.1665V13.0539H81.8595V28.5879C81.8595 31.0716 82.9808 32.4851 85.4645 32.4851H87.1702V34.6766H85.0262C81.3262 34.6729 79.3758 32.0943 79.3758 28.5368Z"
        fill="#202020"
      />
      <path
        d="M101.875 46.1673C98.3684 46.1673 96.5677 45.2432 94.1315 43.0517L95.786 41.3971C97.6379 43.1028 98.9016 43.9794 101.875 43.9794C106.795 43.9794 108.986 40.5242 108.986 35.8454V31.6523C106.893 34.3807 104.702 34.9651 102.021 34.9651C99.5371 34.9651 97.4918 34.136 96.2755 32.9197C93.8904 30.5347 93.2549 26.6375 93.2549 22.9375C93.2549 19.2376 93.8868 15.3404 96.2755 12.9553C97.4918 11.739 99.5371 10.9099 102.021 10.9099C104.698 10.9099 106.89 11.4943 108.986 14.2227V11.2021H111.47V35.9878C111.47 41.8792 107.963 46.1673 101.875 46.1673ZM102.361 13.1014C96.6152 13.1014 95.7386 18.0688 95.7386 22.9375C95.7386 27.8063 96.6152 32.7736 102.361 32.7736C108.106 32.7736 108.982 27.8063 108.982 22.9375C108.982 18.0688 108.113 13.1014 102.364 13.1014H102.361Z"
        fill="#202020"
      />
      <path
        d="M129.681 13.1014C125.638 13.1014 123.399 16.4617 123.399 20.2128V34.6766H120.915V11.2021H123.399V14.3177C124.761 12.1262 127.489 10.9099 130.265 10.9099C132.555 10.9099 134.21 11.4468 135.916 13.1489L134.115 14.9496C132.702 13.5397 131.631 13.1014 129.681 13.1014Z"
        fill="#202020"
      />
      <path
        d="M148.09 32.7264C150.866 32.7264 152.571 31.8973 154.566 29.903L156.417 31.364C154.032 33.7491 151.841 34.969 147.944 34.969C141.468 34.969 137.961 30.7833 137.961 22.9414C137.961 15.3443 141.468 10.9138 147.359 10.9138C153.251 10.9138 156.757 15.1507 156.757 22.357V23.4783H140.445C140.445 29.4611 143.075 32.7264 148.09 32.7264ZM153.448 17.0463C152.425 14.5626 150.088 13.1017 147.359 13.1017C144.631 13.1017 142.293 14.5626 141.271 17.0463C140.734 18.5548 140.588 19.1903 140.441 21.4768H154.273C154.135 19.2378 154.08 18.4562 153.448 17.0463V17.0463Z"
        fill="#202020"
      />
      <path
        d="M172.002 34.9655C167.912 34.9655 164.891 33.8953 162.506 31.6052L164.212 29.8995C166.012 31.7988 168.595 32.774 171.907 32.774C176.535 32.774 178.968 31.1669 178.968 28.0002C178.968 25.5165 177.605 24.3952 174.486 24.0555L170.571 23.7158C165.848 23.325 163.51 21.2796 163.51 17.5797C163.51 13.4889 166.823 10.9066 171.937 10.9066C175.198 10.9066 178.073 11.8307 180.166 13.3903L178.511 15.0449C176.593 13.685 174.286 12.984 171.937 13.047C168.039 13.047 165.946 14.6541 165.946 17.576C165.946 20.0597 167.407 21.181 170.72 21.5207L174.519 21.8604C178.416 22.2512 181.385 23.42 181.385 27.9966C181.4 32.2882 177.795 34.9655 172.002 34.9655Z"
        fill="#202020"
      />
      <path d="M188.753 31.068H192.358V34.673H188.753V31.068Z" fill="#202020" />
      <path
        d="M215.496 32.3357C213.498 34.3336 211.65 34.9655 208.337 34.9655C204.831 34.9655 202.931 34.3811 201.423 32.8215C200.302 31.7002 199.717 29.9981 199.717 28.2449C199.717 23.9606 202.785 21.4769 207.899 21.4769H215.496V18.8471C215.496 15.096 213.695 13.1018 208.874 13.1018C205.561 13.1018 203.907 13.9309 202.398 16.0712L200.598 14.5116C202.595 11.7357 205.028 10.9066 208.878 10.9066C215.112 10.9066 217.983 13.6825 217.983 18.6024V34.6733H215.496V32.3357ZM208.191 23.4748C204.199 23.4748 202.201 25.0344 202.201 28.1974C202.201 31.3605 204.053 32.774 208.337 32.774C210.481 32.774 212.475 32.5804 214.181 30.9733C215.058 30.1442 215.496 28.6357 215.496 26.4917V23.4748H208.191Z"
        fill="#202020"
      />
      <path
        d="M226.932 0H230V3.06808H226.932V0ZM227.224 11.2021H229.708V34.673H227.224V11.2021Z"
        fill="#202020"
      />
    </svg>
  ),

  favoriteOnIcon: (
    <svg
      width="12"
      height="16"
      viewBox="0 0 12 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M0.5 15.81V0.5H10.9V15.8119L5.7 12.2L0.5 15.81Z"
        fill="#FFDAC7"
      />
      <path
        d="M10.9658 0H0.395509C0.177207 0 4.3115e-07 0.177052 4.3115e-07 0.395509V15.2084C-0.00030854 15.5052 0.165465 15.7771 0.429344 15.9127C0.693377 16.0482 1.01102 16.0246 1.25188 15.8514L5.68065 12.6767L10.1096 15.8512C10.3506 16.0241 10.6679 16.0476 10.9318 15.9121C11.1955 15.7766 11.3615 15.5049 11.3615 15.2084V0.395509C11.3615 0.177052 11.1842 0 10.9658 0ZM10.5703 15.2082L5.91131 11.8685C5.7735 11.7698 5.58811 11.7698 5.45045 11.8685L0.791327 15.2084V0.791017H10.5703V15.2082Z"
        fill="#FF6212"
      />
    </svg>
  ),
  favoriteOffIcon: (
    <svg
      width="12"
      height="16"
      viewBox="0 0 12 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M0.5 15.81V0.5H10.9V15.8119L5.7 12.2L0.5 15.81Z" fill="white" />
      <path
        d="M10.9658 0H0.395509C0.177207 0 4.3115e-07 0.177052 4.3115e-07 0.395509V15.2084C-0.00030854 15.5052 0.165465 15.7771 0.429344 15.9127C0.693377 16.0482 1.01102 16.0246 1.25188 15.8514L5.68065 12.6767L10.1096 15.8512C10.3506 16.0241 10.6679 16.0476 10.9318 15.9121C11.1955 15.7766 11.3615 15.5049 11.3615 15.2084V0.395509C11.3615 0.177052 11.1842 0 10.9658 0ZM10.5703 15.2082L5.91131 11.8685C5.7735 11.7698 5.58811 11.7698 5.45045 11.8685L0.791327 15.2084V0.791017H10.5703V15.2082Z"
        fill="#CCD7DA"
      />
    </svg>
  ),
  closeIcon: (
    <svg
      width="10"
      height="10"
      viewBox="0 0 10 10"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M6.65 5.00032L9.74364 1.90668C10.0855 1.56487 10.0855 1.0107 9.74364 0.669423L9.33122 0.257002C8.9893 -0.0849196 8.43513 -0.0849196 8.09385 0.257002L5.00032 3.35053L1.90668 0.256361C1.56487 -0.0854537 1.0107 -0.0854537 0.669423 0.256361L0.256361 0.668782C-0.0854537 1.0107 -0.0854537 1.56487 0.256361 1.90615L3.35053 5.00032L0.257002 8.09385C-0.0849196 8.43577 -0.0849196 8.98994 0.257002 9.33122L0.669423 9.74364C1.01124 10.0855 1.5654 10.0855 1.90668 9.74364L5.00032 6.65L8.09385 9.74364C8.43577 10.0855 8.98994 10.0855 9.33122 9.74364L9.74364 9.33122C10.0855 8.9893 10.0855 8.43513 9.74364 8.09385L6.65 5.00032Z"
        fill="#808080"
      />
    </svg>
  ),
  searchIcon: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 12 12"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M11.9268 11.2197L8.44085 7.73383C9.10202 6.91757 9.50001 5.87985 9.50001 4.75002C9.50001 2.13087 7.36914 0 4.74999 0C2.13085 0 0 2.13087 0 4.75002C0 7.36916 2.13087 9.50004 4.75002 9.50004C5.87985 9.50004 6.91757 9.10202 7.73383 8.44087L11.2197 11.9268C11.3174 12.0244 11.4757 12.0244 11.5733 11.9268L11.9268 11.5733C12.0244 11.4757 12.0244 11.3174 11.9268 11.2197ZM4.75002 8.50002C2.68215 8.50002 1.00001 6.81789 1.00001 4.75002C1.00001 2.68215 2.68215 1.00001 4.75002 1.00001C6.81789 1.00001 8.50002 2.68215 8.50002 4.75002C8.50002 6.81789 6.81789 8.50002 4.75002 8.50002Z"
        fill="#CCD7DA"
      />
    </svg>
  ),
  menuIcon: (
    <svg width="16" height="16" viewBox="0 0 20 20" aria-hidden="true">
      <path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z" fill="white" />
    </svg>
  ),
  bannerCloseIcon: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M9.31 7.00045L13.6411 2.99018C14.1196 2.54709 14.1196 1.82873 13.6411 1.38632L13.0637 0.851705C12.585 0.408474 11.8092 0.408474 11.3314 0.851705L7.00045 4.86184L2.66936 0.850874C2.19082 0.407781 1.41498 0.407781 0.937192 0.850874L0.358905 1.38549C-0.119635 1.82873 -0.119635 2.54709 0.358905 2.98949L4.69074 7.00045L0.359803 11.0106C-0.118887 11.4538 -0.118887 12.1722 0.359803 12.6146L0.937192 13.1492C1.41573 13.5923 2.19157 13.5923 2.66936 13.1492L7.00045 9.13893L11.3314 13.1492C11.8101 13.5923 12.5859 13.5923 13.0637 13.1492L13.6411 12.6146C14.1196 12.1713 14.1196 11.453 13.6411 11.0106L9.31 7.00045Z"
        fill="white"
      />
    </svg>
  ),
  hourGlassIcon: (
    <svg
      width="12"
      height="12"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
      fill="#FFAD5F"
    >
      <path d="M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm-4-5l-4-4V4h8v3.5l-4 4z" />
    </svg>
  ),
  sortArrowUp: (
    <svg width="24" height="24" viewBox="0 0 24 24">
      <path d="M7 10l5 5 5-5z" />
    </svg>
  ),
  sortArrowDown: (
    <svg width="24" height="24" viewBox="0 0 24 24">
      <path d="M7 14l5-5 5 5z" />
    </svg>
  ),
  poweredByStripe: (
    <svg width="119px" height="26px">
      <path
        fillRule="evenodd"
        opacity="0.349"
        fill="rgb(66, 71, 112)"
        d="M113.000,26.000 L6.000,26.000 C2.686,26.000 -0.000,23.314 -0.000,20.000 L-0.000,6.000 C-0.000,2.686 2.686,-0.000 6.000,-0.000 L113.000,-0.000 C116.314,-0.000 119.000,2.686 119.000,6.000 L119.000,20.000 C119.000,23.314 116.314,26.000 113.000,26.000 ZM118.000,6.000 C118.000,3.239 115.761,1.000 113.000,1.000 L6.000,1.000 C3.239,1.000 1.000,3.239 1.000,6.000 L1.000,20.000 C1.000,22.761 3.239,25.000 6.000,25.000 L113.000,25.000 C115.761,25.000 118.000,22.761 118.000,20.000 L118.000,6.000 Z"
      />
      <path
        fillRule="evenodd"
        opacity="0.502"
        fill="rgb(66, 71, 112)"
        d="M60.700,18.437 L59.395,18.437 L60.405,15.943 L58.395,10.871 L59.774,10.871 L61.037,14.323 L62.310,10.871 L63.689,10.871 L60.700,18.437 ZM55.690,16.259 C55.238,16.259 54.774,16.091 54.354,15.764 L54.354,16.133 L53.007,16.133 L53.007,8.566 L54.354,8.566 L54.354,11.229 C54.774,10.913 55.238,10.745 55.690,10.745 C57.100,10.745 58.068,11.881 58.068,13.502 C58.068,15.122 57.100,16.259 55.690,16.259 ZM55.406,11.902 C55.038,11.902 54.669,12.060 54.354,12.376 L54.354,14.628 C54.669,14.943 55.038,15.101 55.406,15.101 C56.164,15.101 56.690,14.449 56.690,13.502 C56.690,12.555 56.164,11.902 55.406,11.902 ZM47.554,15.764 C47.144,16.091 46.681,16.259 46.218,16.259 C44.818,16.259 43.840,15.122 43.840,13.502 C43.840,11.881 44.818,10.745 46.218,10.745 C46.681,10.745 47.144,10.913 47.554,11.229 L47.554,8.566 L48.912,8.566 L48.912,16.133 L47.554,16.133 L47.554,15.764 ZM47.554,12.376 C47.249,12.060 46.881,11.902 46.513,11.902 C45.744,11.902 45.218,12.555 45.218,13.502 C45.218,14.449 45.744,15.101 46.513,15.101 C46.881,15.101 47.249,14.943 47.554,14.628 L47.554,12.376 ZM39.535,13.870 C39.619,14.670 40.251,15.217 41.134,15.217 C41.619,15.217 42.155,15.038 42.702,14.722 L42.702,15.849 C42.103,16.122 41.503,16.259 40.913,16.259 C39.324,16.259 38.209,15.101 38.209,13.460 C38.209,11.871 39.303,10.745 40.808,10.745 C42.187,10.745 43.123,11.829 43.123,13.375 C43.123,13.523 43.123,13.691 43.102,13.870 L39.535,13.870 ZM40.756,11.786 C40.103,11.786 39.598,12.271 39.535,12.997 L41.829,12.997 C41.787,12.281 41.356,11.786 40.756,11.786 ZM35.988,12.618 L35.988,16.133 L34.641,16.133 L34.641,10.871 L35.988,10.871 L35.988,11.397 C36.367,10.976 36.830,10.745 37.282,10.745 C37.430,10.745 37.577,10.755 37.724,10.797 L37.724,11.997 C37.577,11.955 37.409,11.934 37.251,11.934 C36.809,11.934 36.335,12.176 35.988,12.618 ZM29.979,13.870 C30.063,14.670 30.694,15.217 31.578,15.217 C32.062,15.217 32.599,15.038 33.146,14.722 L33.146,15.849 C32.546,16.122 31.946,16.259 31.357,16.259 C29.768,16.259 28.653,15.101 28.653,13.460 C28.653,11.871 29.747,10.745 31.252,10.745 C32.630,10.745 33.567,11.829 33.567,13.375 C33.567,13.523 33.567,13.691 33.546,13.870 L29.979,13.870 ZM31.199,11.786 C30.547,11.786 30.042,12.271 29.979,12.997 L32.273,12.997 C32.231,12.281 31.799,11.786 31.199,11.786 ZM25.274,16.133 L24.200,12.555 L23.137,16.133 L21.927,16.133 L20.117,10.871 L21.464,10.871 L22.527,14.449 L23.590,10.871 L24.810,10.871 L25.873,14.449 L26.936,10.871 L28.283,10.871 L26.484,16.133 L25.274,16.133 ZM17.043,16.259 C15.454,16.259 14.328,15.112 14.328,13.502 C14.328,11.881 15.454,10.745 17.043,10.745 C18.632,10.745 19.748,11.881 19.748,13.502 C19.748,15.112 18.632,16.259 17.043,16.259 ZM17.043,11.871 C16.254,11.871 15.707,12.534 15.707,13.502 C15.707,14.470 16.254,15.133 17.043,15.133 C17.822,15.133 18.369,14.470 18.369,13.502 C18.369,12.534 17.822,11.871 17.043,11.871 ZM11.128,13.533 L9.918,13.533 L9.918,16.133 L8.571,16.133 L8.571,8.892 L11.128,8.892 C12.602,8.892 13.654,9.850 13.654,11.218 C13.654,12.586 12.602,13.533 11.128,13.533 ZM10.939,9.987 L9.918,9.987 L9.918,12.439 L10.939,12.439 C11.718,12.439 12.265,11.944 12.265,11.218 C12.265,10.482 11.718,9.987 10.939,9.987 Z"
      />
      <path
        fillRule="evenodd"
        opacity="0.502"
        fill="rgb(66, 71, 112)"
        d="M111.116,14.051 L105.557,14.051 C105.684,15.382 106.659,15.774 107.766,15.774 C108.893,15.774 109.781,15.536 110.555,15.146 L110.555,17.433 C109.784,17.861 108.765,18.169 107.408,18.169 C104.642,18.169 102.704,16.437 102.704,13.013 C102.704,10.121 104.348,7.825 107.049,7.825 C109.746,7.825 111.154,10.120 111.154,13.028 C111.154,13.303 111.129,13.898 111.116,14.051 ZM107.031,10.140 C106.321,10.140 105.532,10.676 105.532,11.955 L108.468,11.955 C108.468,10.677 107.728,10.140 107.031,10.140 ZM98.108,18.169 C97.114,18.169 96.507,17.750 96.099,17.451 L96.093,20.664 L93.254,21.268 L93.253,8.014 L95.753,8.014 L95.901,8.715 C96.293,8.349 97.012,7.825 98.125,7.825 C100.119,7.825 101.997,9.621 101.997,12.927 C101.997,16.535 100.139,18.169 98.108,18.169 ZM97.446,10.340 C96.795,10.340 96.386,10.578 96.090,10.903 L96.107,15.122 C96.383,15.421 96.780,15.661 97.446,15.661 C98.496,15.661 99.200,14.518 99.200,12.989 C99.200,11.504 98.485,10.340 97.446,10.340 ZM89.149,8.014 L91.999,8.014 L91.999,17.966 L89.149,17.966 L89.149,8.014 ZM89.149,4.836 L91.999,4.230 L91.999,6.543 L89.149,7.149 L89.149,4.836 ZM86.110,11.219 L86.110,17.966 L83.272,17.966 L83.272,8.014 L85.727,8.014 L85.905,8.853 C86.570,7.631 87.897,7.879 88.275,8.015 L88.275,10.625 C87.914,10.508 86.781,10.338 86.110,11.219 ZM80.024,14.475 C80.024,16.148 81.816,15.627 82.179,15.482 L82.179,17.793 C81.801,18.001 81.115,18.169 80.187,18.169 C78.502,18.169 77.237,16.928 77.237,15.247 L77.250,6.138 L80.022,5.548 L80.024,8.014 L82.180,8.014 L82.180,10.435 L80.024,10.435 L80.024,14.475 ZM76.485,14.959 C76.485,17.003 74.858,18.169 72.497,18.169 C71.518,18.169 70.448,17.979 69.392,17.525 L69.392,14.814 C70.345,15.332 71.559,15.721 72.500,15.721 C73.133,15.721 73.589,15.551 73.589,15.026 C73.589,13.671 69.273,14.181 69.273,11.038 C69.273,9.028 70.808,7.825 73.111,7.825 C74.052,7.825 74.992,7.969 75.933,8.344 L75.933,11.019 C75.069,10.552 73.972,10.288 73.109,10.288 C72.514,10.288 72.144,10.460 72.144,10.903 C72.144,12.181 76.485,11.573 76.485,14.959 Z"
      />
    </svg>
  ),
  branch: (
    <svg
      width="9"
      height="14"
      viewBox="0 0 9 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0)">
        <path
          d="M7 2.625C6.03442 2.625 5.25 3.409 5.25 4.375C5.25 5.02057 5.60376 5.57897 6.125 5.88275V6.125C6.125 6.125 6.125 7.875 4.375 7.875C3.64954 7.875 3.08087 8.03052 2.625 8.26891V4.13275C3.14666 3.82897 3.5 3.27057 3.5 2.625C3.5 1.659 2.716 0.875 1.75 0.875C0.784 0.875 0 1.659 0 2.625C0 3.27057 0.353336 3.82897 0.875 4.13275V9.86768C0.353336 10.171 0 10.729 0 11.375C0 12.3406 0.784 13.125 1.75 13.125C2.716 13.125 3.5 12.3406 3.5 11.375C3.5 10.917 3.3197 10.5034 3.03174 10.1907C3.28638 9.87793 3.70038 9.625 4.375 9.625C7.84766 9.625 7.875 6.125 7.875 6.125V5.88275C8.39624 5.57897 8.75 5.02057 8.75 4.375C8.75 3.409 7.96558 2.625 7 2.625ZM1.75 1.75C2.23407 1.75 2.625 2.14093 2.625 2.625C2.625 3.10907 2.23407 3.5 1.75 3.5C1.26593 3.5 0.875 3.10907 0.875 2.625C0.875 2.14093 1.26593 1.75 1.75 1.75ZM1.75 12.25C1.26593 12.25 0.875 11.8586 0.875 11.375C0.875 10.8922 1.26593 10.5 1.75 10.5C2.23407 10.5 2.625 10.8922 2.625 11.375C2.625 11.8586 2.23407 12.25 1.75 12.25ZM7 5.25C6.51636 5.25 6.125 4.85907 6.125 4.375C6.125 3.89093 6.51636 3.5 7 3.5C7.48364 3.5 7.875 3.89093 7.875 4.375C7.875 4.85907 7.48364 5.25 7 5.25Z"
          fill="black"
        />
      </g>
      <defs>
        <clipPath id="clip0">
          <rect width="8.75" height="14" fill="white" />
        </clipPath>
      </defs>
    </svg>
  ),
  timer: (
    <svg
      width="10"
      height="10"
      viewBox="0 0 10 10"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M3.82812 0.78125H6.17188C6.38762 0.78125 6.5625 0.606367 6.5625 0.390625C6.5625 0.174883 6.38762 0 6.17188 0H3.82812C3.61238 0 3.4375 0.174883 3.4375 0.390625C3.4375 0.606367 3.61238 0.78125 3.82812 0.78125Z"
        fill="black"
      />
      <path
        d="M6.10486 4.04604L4.7238 5.42709C4.57124 5.57963 4.57123 5.82696 4.72378 5.97951C4.87638 6.13209 5.12369 6.13203 5.27623 5.97951L6.65729 4.59846C6.80985 4.44592 6.80987 4.1986 6.65731 4.04604C6.50475 3.8935 6.25744 3.89352 6.10486 4.04604Z"
        fill="black"
      />
      <path
        d="M5 1.40625C2.62525 1.40625 0.703125 3.32805 0.703125 5.70312C0.703125 8.07787 2.6249 10 5 10C7.3748 10 9.29688 8.07816 9.29688 5.70312C9.29688 3.32838 7.37508 1.40625 5 1.40625ZM5 9.21875C3.06148 9.21875 1.48438 7.64164 1.48438 5.70312C1.48438 3.76461 3.06148 2.1875 5 2.1875C6.93852 2.1875 8.51562 3.76461 8.51562 5.70312C8.51562 7.64164 6.93852 9.21875 5 9.21875Z"
        fill="black"
      />
    </svg>
  ),
  calendar: (
    <svg
      width="10"
      height="10"
      viewBox="0 0 10 10"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M0.292993 8.22264H1.75783V9.10155C1.75783 9.26334 1.88901 9.39451 2.0508 9.39451H9.70704C9.86883 9.39451 10 9.26334 10 9.10155V1.48437C10 1.32258 9.86883 1.19141 9.70704 1.19141H8.2422V0.898437C8.2422 0.73664 8.11102 0.605469 7.94923 0.605469C7.78743 0.605469 7.65626 0.73664 7.65626 0.898437V1.19141H6.17189V0.898437C6.17189 0.73664 6.04072 0.605469 5.87892 0.605469C5.71712 0.605469 5.58595 0.73664 5.58595 0.898437V1.19141H4.12111V0.898437C4.12111 0.73664 3.98994 0.605469 3.82814 0.605469C3.66635 0.605469 3.53517 0.73664 3.53517 0.898437V1.19141H2.0508C1.88901 1.19141 1.75783 1.32258 1.75783 1.48437V3.24218C1.75783 5.40136 0.860472 7.06241 0.105434 7.70462C0.0106689 7.78358 -0.0244677 7.91342 0.0175049 8.02942C0.0595165 8.1454 0.169633 8.22264 0.292993 8.22264ZM9.41407 8.80858H2.34377V8.22264H7.94923C8.01776 8.22264 8.08413 8.19862 8.13679 8.15473C8.48897 7.86139 9.0345 7.163 9.41407 6.2685V8.80858ZM2.34377 1.77734H3.53517V2.07031C3.53517 2.23211 3.66635 2.36328 3.82814 2.36328C3.98994 2.36328 4.12111 2.23211 4.12111 2.07031V1.77734H5.58595V2.07031C5.58595 2.23211 5.71712 2.36328 5.87892 2.36328C6.04072 2.36328 6.17189 2.23211 6.17189 2.07031V1.77734H7.65626V2.07031C7.65626 2.23211 7.78743 2.36328 7.94923 2.36328C8.11102 2.36328 8.2422 2.23211 8.2422 2.07031V1.77734H9.41407V2.94921H2.34377V1.77734ZM2.33875 3.53496H9.40887C9.34286 5.39345 8.62956 6.85571 7.83434 7.63671H0.959378C1.86041 6.48864 2.29041 4.99378 2.33875 3.53496Z"
        fill="black"
      />
    </svg>
  ),
  passedCheck: (
    <svg
      width="20"
      height="20"
      viewBox="0 0 20 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect
        x="1"
        y="1"
        width="18"
        height="18"
        rx="2"
        fill="#F3F3F3"
        stroke="#CCD7DA"
        strokeWidth="2"
      />
      <path
        d="M14.6896 5L8.15026 11.7236L4.59331 8.06648L3 9.70466L8.15026 15L16.2829 6.63821L14.6896 5Z"
        fill="#CCD7DA"
      />
    </svg>
  ),
  failedCheck: (
    <svg
      width="20"
      height="20"
      viewBox="0 0 20 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect
        x="1"
        y="1"
        width="18"
        height="18"
        rx="2"
        fill="#F3F3F3"
        stroke="#CCD7DA"
        strokeWidth="2"
      />
    </svg>
  ),
  intervalOk: (
    <svg
      width="14"
      height="11"
      viewBox="0 0 14 11"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M12.3207 0L5.42828 6.89241L1.67932 3.14347L0 4.82278L5.42828 10.2511L14 1.67934L12.3207 0Z"
        fill="#0DB94D"
      />
    </svg>
  ),
  intervalWarning: (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M13.7091 10.0951L8.76358 1.00393C7.969 -0.333754 6.03205 -0.335532 5.23641 1.00393L0.291126 10.0951C-0.521148 11.462 0.46227 13.1929 2.0543 13.1929H11.9455C13.5362 13.1929 14.5214 11.4634 13.7091 10.0951ZM7 11.5522C6.54778 11.5522 6.17968 11.1841 6.17968 10.7319C6.17968 10.2797 6.54778 9.91162 7 9.91162C7.45221 9.91162 7.82031 10.2797 7.82031 10.7319C7.82031 11.1841 7.45221 11.5522 7 11.5522ZM7.82031 8.271C7.82031 8.72321 7.45221 9.09131 7 9.09131C6.54778 9.09131 6.17968 8.72321 6.17968 8.271V4.16943C6.17968 3.71722 6.54778 3.34912 7 3.34912C7.45221 3.34912 7.82031 3.71722 7.82031 4.16943V8.271Z"
        fill="#FF2012"
      />
    </svg>
  ),
  downloadIcon: (
    <svg
      width="12"
      height="14"
      viewBox="0 0 12 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M9.1345 0H1.25272C0.768361 0 0.37207 0.39375 0.37207 0.875V13.125C0.37207 13.6062 0.768361 14 1.25272 14H10.9398C11.4242 14 11.8205 13.6062 11.8205 13.125V2.42813L9.1345 0ZM9.39869 1.42188L10.2353 2.1875H9.39869V1.42188ZM1.25272 13.125V0.875H8.51805V3.0625H10.9398V13.125H1.25272Z"
        fill="#0F879D"
      />
      <path
        d="M8.36443 7.54687L7.79201 6.89062L6.53709 7.98437V3.9375H5.65644V7.98437L4.40152 6.89062L3.8291 7.54687L6.09676 9.55937L8.36443 7.54687Z"
        fill="#0F879D"
      />
      <path d="M9.61939 10.5H2.57422V11.375H9.61939V10.5Z" fill="#0F879D" />
    </svg>
  ),
  disabledDownloadIcon: (
    <svg
      width="12"
      height="14"
      viewBox="0 0 12 14"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M9.1345 0H1.25272C0.768361 0 0.37207 0.39375 0.37207 0.875V13.125C0.37207 13.6062 0.768361 14 1.25272 14H10.9398C11.4242 14 11.8205 13.6062 11.8205 13.125V2.42813L9.1345 0ZM9.39869 1.42188L10.2353 2.1875H9.39869V1.42188ZM1.25272 13.125V0.875H8.51805V3.0625H10.9398V13.125H1.25272Z"
        fill="#e4e1e4"
      />
      <path
        d="M8.36443 7.54687L7.79201 6.89062L6.53709 7.98437V3.9375H5.65644V7.98437L4.40152 6.89062L3.8291 7.54687L6.09676 9.55937L8.36443 7.54687Z"
        fill="#e4e1e4"
      />
      <path d="M9.61939 10.5H2.57422V11.375H9.61939V10.5Z" fill="#e4e1e4" />
    </svg>
  ),
  updateIcon: (
    <svg
      width="14"
      height="16"
      viewBox="0 0 14 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M12.7422 2.75199H9.56873C9.98479 2.11702 9.92726 1.23489 9.39526 0.668849C8.79823 0.0335608 7.82679 0.0335608 7.22977 0.668849C7.16275 0.740161 7.08272 0.843419 7.00003 1.01808C6.91731 0.843419 6.8373 0.740161 6.77029 0.668849C6.17326 0.0335608 5.20182 0.0335608 4.6048 0.668849C4.07282 1.23489 4.01529 2.11699 4.43133 2.75199H1.25781C0.564266 2.75199 0 3.35239 0 4.09036V5.13777C0 5.73376 0.368074 6.2398 0.875 6.41254V13.7499C0.875 14.4878 1.43927 15.0882 2.13281 15.0882H6.125H7.875H11.8672C12.5607 15.0882 13.125 14.4878 13.125 13.7499V6.41254C13.6319 6.23978 14 5.73373 14 5.13777V4.09036C14 3.35239 13.4357 2.75199 12.7422 2.75199ZM7.4375 5.5451H6.5625V3.68303H7.4375V5.5451ZM7.54042 2.35793C7.67555 1.5309 7.83117 1.3456 7.84848 1.32718C7.97642 1.19105 8.14447 1.12299 8.31253 1.12299C8.48058 1.12299 8.64864 1.19105 8.77658 1.32718C9.03243 1.59945 9.03243 2.04242 8.77658 2.31469C8.75938 2.33299 8.58627 2.49764 7.8149 2.64117C7.70263 2.66206 7.59306 2.67954 7.49197 2.694C7.50526 2.58891 7.52128 2.47501 7.54042 2.35793ZM5.22345 1.32718C5.35139 1.19105 5.51945 1.12299 5.6875 1.12299C5.85555 1.12299 6.02361 1.19105 6.15155 1.32718C6.16875 1.34548 6.32349 1.52968 6.45837 2.35042C6.47801 2.46988 6.49444 2.5865 6.50803 2.69406C6.40927 2.67989 6.30219 2.66284 6.19218 2.64248C5.41494 2.49869 5.24079 2.33311 5.22348 2.31469C4.96759 2.04245 4.96759 1.59945 5.22345 1.32718ZM0.875 4.09036C0.875 3.86574 1.04672 3.68303 1.25781 3.68303H5.6875V5.5451H1.3125H1.25781C1.04672 5.5451 0.875 5.36239 0.875 5.13777V4.09036ZM1.75 13.7499V6.47614H5.6875V14.1572H2.13281C1.92172 14.1572 1.75 13.9745 1.75 13.7499ZM6.5625 14.1572V6.47614H7.4375V14.1572H6.5625ZM12.25 13.7499C12.25 13.9745 12.0783 14.1572 11.8672 14.1572H8.3125V6.47614H12.25V13.7499ZM13.125 5.13777C13.125 5.36239 12.9533 5.5451 12.7422 5.5451H12.6875H8.3125V3.68303H12.7422C12.9533 3.68303 13.125 3.86574 13.125 4.09036V5.13777Z"
        fill="#013A44"
      />
    </svg>
  ),
  openArrow: (
    <svg
      width="11"
      height="7"
      viewBox="0 0 11 7"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M10.8242 0.505721L10.4639 0.167824C10.3505 0.0622991 10.1996 0.00416447 10.0383 0.00416447C9.87719 0.00416447 9.72614 0.0622991 9.61274 0.167824L5.50246 3.99588L1.38744 0.163577C1.27422 0.0580514 1.12317 0 0.962016 0C0.80086 0 0.649721 0.0580514 0.536411 0.163577L0.176001 0.499392C-0.0586671 0.717771 -0.0586671 1.07349 0.176001 1.29187L5.07542 5.8711C5.18864 5.97654 5.33951 6.05083 5.5021 6.05083H5.50398C5.66522 6.05083 5.8161 5.97646 5.92932 5.8711L10.8242 1.30428C10.9376 1.19884 10.9998 1.05409 11 0.904002C11 0.753835 10.9376 0.61108 10.8242 0.505721Z"
        fill="#0F879D"
      />
    </svg>
  ),
  detailsArrow: (
    <svg viewBox="0 0 24 24" aria-hidden="true" width="14" height="14">
      <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z" />
    </svg>
  ),
  createDLEIcon: (
    <svg
      width="124"
      height="72"
      viewBox="0 0 124 72"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <ellipse
        cx="37.9868"
        cy="43.1941"
        rx="37.9868"
        ry="19.0728"
        fill="#FF6112"
      />
      <ellipse
        cx="37.9868"
        cy="43.1941"
        rx="37.9868"
        ry="19.0728"
        fill="#FF6112"
      />
      <ellipse
        cx="89.9278"
        cy="36.747"
        rx="22.2236"
        ry="24.9827"
        fill="#FF6112"
      />
      <ellipse
        cx="89.9278"
        cy="36.747"
        rx="22.2236"
        ry="24.9827"
        fill="#FF6112"
      />
      <ellipse
        cx="67.7042"
        cy="21.9722"
        rx="22.7404"
        ry="21.4905"
        fill="#FF6112"
      />
      <ellipse
        cx="67.7042"
        cy="21.9722"
        rx="22.7404"
        ry="21.4905"
        fill="#FF6112"
      />
      <ellipse
        cx="85.018"
        cy="50.1785"
        rx="37.9868"
        ry="19.0728"
        fill="#FF6112"
      />
      <ellipse
        cx="85.018"
        cy="50.1785"
        rx="37.9868"
        ry="19.0728"
        fill="#FF6112"
      />
      <ellipse
        cx="56.1999"
        cy="52.9882"
        rx="36.4363"
        ry="18.5355"
        fill="#FF6112"
      />
      <ellipse
        cx="56.1999"
        cy="52.9882"
        rx="36.4363"
        ry="18.5355"
        fill="#FF6112"
      />
      <ellipse
        cx="41.3461"
        cy="30.8371"
        rx="22.2236"
        ry="19.0728"
        fill="#FF6112"
      />
      <ellipse
        cx="41.3461"
        cy="30.8371"
        rx="22.2236"
        ry="19.0728"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M89.2644 57.4696C92.8089 56.5544 95.3337 54.5811 95.7217 52.1664C95.7571 52.0681 95.7769 51.9546 95.7769 51.8336V43.5836V43.2398V42.8961V35.3336V34.9898V34.6461V26.7398V26.396C95.7769 26.2709 95.7496 26.1602 95.7125 26.0592C95.3314 23.8615 93.121 21.6905 89.2644 20.7267V22.151C92.7223 23.0752 94.8937 24.9798 94.8937 26.7398C94.8937 28.4998 92.7223 30.4043 89.2644 31.3286V32.7487C89.2901 32.7423 89.3157 32.7358 89.3413 32.7293C89.4322 32.7059 89.5228 32.6826 89.612 32.6578C89.8752 32.5849 90.1313 32.5072 90.3782 32.4234C90.397 32.417 90.4165 32.411 90.4359 32.405C90.4566 32.3986 90.4772 32.3923 90.497 32.3856C90.777 32.2879 91.0437 32.1814 91.302 32.0707C91.3512 32.0495 91.3989 32.0278 91.4466 32.006C91.4688 31.9959 91.4909 31.9858 91.5131 31.9758C91.7079 31.8871 91.896 31.7957 92.078 31.7001C92.1013 31.6877 92.1249 31.6755 92.1484 31.6634C92.1902 31.6417 92.2319 31.6201 92.2723 31.5977C92.501 31.4712 92.7214 31.3405 92.9281 31.2037C92.9453 31.1926 92.9614 31.1809 92.9776 31.1692C92.9893 31.1607 93.0011 31.1523 93.0133 31.1439C93.1913 31.0229 93.3604 30.8992 93.5216 30.7713C93.5768 30.7273 93.6307 30.6833 93.6837 30.6386C93.8281 30.5183 93.9654 30.3952 94.0953 30.2687C94.1093 30.2552 94.1238 30.2418 94.1383 30.2284C94.1584 30.2098 94.1785 30.1913 94.1973 30.1725C94.3523 30.0164 94.4954 29.8569 94.6278 29.694C94.6468 29.6704 94.6646 29.6468 94.6823 29.6233C94.6957 29.6056 94.709 29.5879 94.7228 29.5702C94.7399 29.5482 94.7572 29.5262 94.7745 29.5042C94.8155 29.4521 94.8565 29.4001 94.8937 29.3475V34.4515C94.8752 34.5498 94.869 34.6536 94.88 34.7574C94.8884 34.8344 94.8937 34.9121 94.8937 34.9898C94.8937 35.0929 94.878 35.1966 94.8623 35.3004C94.8611 35.308 94.86 35.3156 94.8588 35.3233C94.8465 35.4064 94.8292 35.4889 94.8076 35.5728C94.7899 35.6409 94.7683 35.7089 94.7444 35.777C94.7148 35.8616 94.6817 35.9461 94.6424 36.0307C94.6133 36.0946 94.5802 36.1579 94.5457 36.2211C94.4967 36.3112 94.4446 36.4013 94.3854 36.4906C94.3501 36.5442 94.3114 36.597 94.2723 36.6506L94.2706 36.6529C94.1982 36.7512 94.1226 36.8488 94.0383 36.9458C94.0099 36.9786 93.9799 37.0107 93.9497 37.0428C93.9414 37.0517 93.9331 37.0606 93.9248 37.0695C93.825 37.1768 93.7208 37.2833 93.6064 37.3878C93.5856 37.4074 93.5637 37.4263 93.5418 37.4452C93.5321 37.4535 93.5224 37.4619 93.5128 37.4703C93.3812 37.5858 93.2438 37.7006 93.0954 37.812C93.0801 37.8237 93.0642 37.8349 93.0484 37.846C93.0446 37.8487 93.0409 37.8513 93.0372 37.8539C92.8715 37.9756 92.6984 38.0953 92.5134 38.2108C92.5107 38.2125 92.5081 38.214 92.5054 38.2156C92.5028 38.2171 92.5001 38.2187 92.4975 38.2204C91.6193 38.7664 90.5264 39.2366 89.2644 39.5758V41.0026C91.6776 40.3992 93.4466 39.3232 94.5267 38.0643C94.6601 37.9131 94.7802 37.757 94.8933 37.5982L94.8937 42.7015C94.8752 42.7998 94.869 42.9037 94.88 43.0075C94.8884 43.0845 94.8937 43.1622 94.8937 43.2398C94.8937 43.343 94.878 43.4467 94.8623 43.5504C94.8611 43.558 94.86 43.5657 94.8588 43.5733C94.8465 43.6565 94.8292 43.739 94.8076 43.8228C94.7899 43.8909 94.7683 43.959 94.7444 44.027C94.7148 44.1116 94.6817 44.1962 94.6424 44.2807C94.6133 44.3447 94.5802 44.4079 94.5457 44.4712C94.4967 44.5612 94.4446 44.6513 94.3854 44.7407C94.3502 44.7942 94.3115 44.847 94.2723 44.9005L94.2706 44.9029C94.1982 45.0012 94.1226 45.0989 94.0383 45.1958C94.0099 45.2287 93.9799 45.2607 93.9498 45.2929C93.9414 45.3017 93.9331 45.3106 93.9248 45.3195C93.825 45.4268 93.7208 45.5334 93.6064 45.6379C93.5856 45.6574 93.5637 45.6763 93.5417 45.6952C93.5321 45.7036 93.5224 45.7119 93.5128 45.7204C93.3812 45.8359 93.2438 45.9507 93.0954 46.062C93.0801 46.0737 93.0642 46.0849 93.0484 46.096C93.0446 46.0987 93.0409 46.1013 93.0372 46.104C92.8715 46.2257 92.6984 46.3453 92.5134 46.4608C92.5081 46.4642 92.5028 46.467 92.4975 46.4704C91.6193 47.0165 90.5264 47.4866 89.2644 47.8259V49.2527C91.6776 48.6493 93.4466 47.5732 94.5267 46.3144C94.6601 46.1631 94.7802 46.007 94.8933 45.8482L94.8937 51.6294C94.8875 51.6597 94.8831 51.6906 94.8796 51.7223C94.7015 53.4135 92.5583 55.1896 89.2644 56.0744V57.4696Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M80.6916 57.4693C84.236 56.5541 86.7606 54.5808 87.1486 52.1662C87.184 52.0678 87.2038 51.9544 87.2038 51.8334V43.5834V43.2396V42.8959V35.3333V34.9896V34.6458V26.7396V26.3958C87.2038 26.2707 87.1765 26.16 87.1394 26.0589C86.7583 23.8613 84.548 21.6904 80.6916 20.7265V22.1508C84.1493 23.0751 86.3206 24.9796 86.3206 26.7396C86.3206 28.4995 84.1493 30.404 80.6916 31.3283V32.7484C80.7172 32.742 80.7427 32.7356 80.7682 32.7291C80.8592 32.7057 80.9497 32.6823 81.0389 32.6576C81.3021 32.5847 81.5582 32.507 81.8051 32.4231C81.8239 32.4168 81.8434 32.4108 81.8628 32.4048C81.8835 32.3984 81.9041 32.3921 81.9239 32.3853C82.2039 32.2877 82.4706 32.1811 82.729 32.0704C82.7781 32.0493 82.8259 32.0275 82.8736 32.0058C82.8957 31.9957 82.9178 31.9856 82.9401 31.9756C83.1348 31.8869 83.3229 31.7954 83.5049 31.6999C83.5282 31.6875 83.5518 31.6753 83.5753 31.6631C83.6171 31.6415 83.6588 31.6199 83.6992 31.5974C83.9279 31.4709 84.1483 31.3403 84.355 31.2035C84.3722 31.1923 84.3883 31.1807 84.4046 31.169C84.4163 31.1605 84.428 31.152 84.4402 31.1437C84.6182 31.0227 84.7873 30.8989 84.9485 30.7711C85.0037 30.7271 85.0576 30.6831 85.1106 30.6384C85.255 30.5181 85.3923 30.395 85.5222 30.2685C85.5362 30.255 85.5507 30.2416 85.5652 30.2282C85.5853 30.2096 85.6054 30.191 85.6242 30.1723C85.7792 30.0162 85.9223 29.8567 86.0548 29.6937C86.0737 29.6702 86.0915 29.6466 86.1092 29.623C86.1226 29.6054 86.1359 29.5877 86.1497 29.57C86.1668 29.5479 86.1841 29.5259 86.2014 29.5039C86.2424 29.4519 86.2834 29.3999 86.3206 29.3472V34.4513C86.3021 34.5496 86.2959 34.6534 86.3069 34.7572C86.3153 34.8342 86.3206 34.9119 86.3206 34.9896C86.3206 35.0927 86.3049 35.1964 86.2892 35.3001C86.288 35.3078 86.2869 35.3154 86.2857 35.323C86.2734 35.4062 86.2561 35.4887 86.2345 35.5726C86.2168 35.6406 86.1952 35.7087 86.1713 35.7768C86.1418 35.8613 86.1086 35.9459 86.0693 36.0305C86.0402 36.0944 86.0071 36.1577 85.9726 36.2209C85.9236 36.311 85.8715 36.401 85.8123 36.4904C85.7771 36.5439 85.7384 36.5968 85.6992 36.6503L85.6975 36.6527C85.6251 36.751 85.5496 36.8486 85.4652 36.9455C85.4368 36.9784 85.4068 37.0104 85.3767 37.0426C85.3683 37.0515 85.36 37.0604 85.3517 37.0693C85.2519 37.1765 85.1477 37.2831 85.0333 37.3876C85.0125 37.4071 84.9906 37.426 84.9687 37.445C84.959 37.4533 84.9493 37.4617 84.9397 37.4701C84.8081 37.5856 84.6707 37.7004 84.5224 37.8118C84.507 37.8235 84.4911 37.8347 84.4753 37.8458C84.4715 37.8484 84.4678 37.8511 84.4641 37.8537C84.2985 37.9754 84.1253 38.095 83.9403 38.2105C83.9377 38.2123 83.935 38.2138 83.9324 38.2154C83.9297 38.2169 83.9271 38.2184 83.9244 38.2202C83.0463 38.7662 81.9534 39.2363 80.6916 39.5755V41.0023C83.1047 40.3989 84.8735 39.3229 85.9536 38.0641C86.087 37.9128 86.2071 37.7568 86.3202 37.598L86.3206 42.7013C86.3021 42.7996 86.2959 42.9034 86.3069 43.0072C86.3153 43.0842 86.3206 43.1619 86.3206 43.2396C86.3206 43.3427 86.3049 43.4464 86.2892 43.5502C86.288 43.5578 86.2869 43.5654 86.2857 43.5731C86.2734 43.6562 86.2561 43.7387 86.2345 43.8226C86.2168 43.8907 86.1952 43.9587 86.1713 44.0268C86.1418 44.1114 86.1086 44.1959 86.0693 44.2805C86.0402 44.3444 86.0071 44.4077 85.9726 44.4709C85.9236 44.561 85.8715 44.6511 85.8123 44.7404C85.777 44.794 85.7383 44.8469 85.6991 44.9004L85.6975 44.9027C85.6251 45.001 85.5496 45.0986 85.4652 45.1956C85.4368 45.2284 85.4068 45.2604 85.3767 45.2926C85.3684 45.3015 85.36 45.3104 85.3517 45.3193C85.2519 45.4266 85.1477 45.5331 85.0333 45.6376C85.0125 45.6572 84.9906 45.6761 84.9686 45.695C84.959 45.7034 84.9493 45.7117 84.9397 45.7201C84.8081 45.8356 84.6707 45.9504 84.5224 46.0618C84.5034 46.0762 84.4835 46.09 84.4641 46.1038C84.2985 46.2254 84.1253 46.3451 83.9403 46.4606C83.9369 46.4628 83.9334 46.4647 83.93 46.4667C83.9282 46.4679 83.9263 46.469 83.9244 46.4702C83.0463 47.0162 81.9534 47.4863 80.6916 47.8256V49.2524C83.1047 48.649 84.8735 47.5729 85.9536 46.3141C86.087 46.1629 86.2071 46.0068 86.3202 45.848L86.3206 51.6292C86.3144 51.6595 86.31 51.6904 86.3065 51.722C86.1284 53.4132 83.9853 55.1892 80.6916 56.0741V57.4693Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M72.1182 57.4693C75.6625 56.554 78.1872 54.5808 78.5752 52.1661C78.6105 52.0678 78.6304 51.9544 78.6304 51.8334V43.5834V43.2396V42.8959V35.3333V34.9896V34.6458V26.7395V26.3958C78.6304 26.2707 78.603 26.16 78.5659 26.0589C78.1849 23.8613 75.9745 21.6904 72.1182 20.7265V22.1508C75.5759 23.0751 77.7471 24.9796 77.7471 26.7395C77.7471 28.4995 75.5759 30.404 72.1182 31.3283V32.7484C72.1437 32.742 72.1693 32.7356 72.1947 32.7291C72.2857 32.7057 72.3762 32.6823 72.4654 32.6576C72.7286 32.5847 72.9848 32.507 73.2316 32.4231C73.2505 32.4168 73.2699 32.4108 73.2894 32.4048C73.31 32.3984 73.3306 32.392 73.3504 32.3853C73.6304 32.2877 73.8971 32.1811 74.1555 32.0704C74.2047 32.0493 74.2524 32.0275 74.3001 32.0058C74.3222 31.9957 74.3443 31.9856 74.3666 31.9756C74.5613 31.8869 74.7495 31.7954 74.9314 31.6999C74.9548 31.6875 74.9783 31.6753 75.0018 31.6631C75.0436 31.6415 75.0853 31.6199 75.1257 31.5974C75.3545 31.4709 75.5748 31.3403 75.7815 31.2035C75.7987 31.1923 75.8149 31.1807 75.8311 31.169C75.8428 31.1605 75.8545 31.152 75.8668 31.1437C76.0447 31.0227 76.2139 30.8989 76.3751 30.7711C76.4303 30.7271 76.4841 30.6831 76.5371 30.6384C76.6815 30.5181 76.8189 30.395 76.9487 30.2685C76.9628 30.255 76.9773 30.2416 76.9917 30.2282C77.0119 30.2096 77.032 30.191 77.0507 30.1723C77.2057 30.0162 77.3488 29.8567 77.4813 29.6937C77.5002 29.6702 77.518 29.6466 77.5358 29.623C77.5491 29.6054 77.5624 29.5877 77.5762 29.57C77.5933 29.5479 77.6106 29.5259 77.628 29.5039C77.669 29.4519 77.7099 29.3999 77.7471 29.3472V34.4513C77.7286 34.5496 77.7224 34.6534 77.7335 34.7572C77.7418 34.8342 77.7471 34.9119 77.7471 34.9896C77.7471 35.0927 77.7314 35.1964 77.7157 35.3001C77.7146 35.3078 77.7134 35.3154 77.7123 35.323C77.6999 35.4062 77.6827 35.4887 77.661 35.5726C77.6434 35.6406 77.6217 35.7087 77.5979 35.7768C77.5683 35.8613 77.5352 35.9459 77.4959 36.0305C77.4667 36.0944 77.4336 36.1576 77.3992 36.2209C77.3501 36.311 77.298 36.401 77.2388 36.4904C77.2036 36.5439 77.1649 36.5968 77.1257 36.6503L77.124 36.6527C77.0516 36.751 76.9761 36.8486 76.8917 36.9455C76.8634 36.9784 76.8333 37.0104 76.8032 37.0426C76.7949 37.0515 76.7866 37.0604 76.7782 37.0693C76.6784 37.1765 76.5742 37.2831 76.4598 37.3876C76.439 37.4071 76.4171 37.426 76.3952 37.445C76.3855 37.4533 76.3758 37.4617 76.3662 37.4701C76.2346 37.5856 76.0973 37.7004 75.9489 37.8118C75.9299 37.8262 75.91 37.84 75.8906 37.8537C75.725 37.9754 75.5519 38.095 75.3668 38.2105C75.3642 38.2123 75.3615 38.2138 75.3589 38.2153C75.3562 38.2169 75.3536 38.2184 75.3509 38.2202C74.4728 38.7662 73.38 39.2362 72.1182 39.5755V41.0023C74.5312 40.3989 76.3001 39.3229 77.3802 38.0641C77.5135 37.9128 77.6337 37.7568 77.7467 37.598L77.7471 42.7013C77.7286 42.7996 77.7224 42.9034 77.7335 43.0072C77.7418 43.0842 77.7471 43.1619 77.7471 43.2396C77.7471 43.3427 77.7314 43.4464 77.7157 43.5502C77.7146 43.5578 77.7134 43.5654 77.7123 43.5731C77.6999 43.6562 77.6827 43.7387 77.661 43.8226C77.6434 43.8907 77.6217 43.9587 77.5979 44.0268C77.5683 44.1114 77.5352 44.1959 77.4959 44.2805C77.4667 44.3444 77.4336 44.4077 77.3992 44.4709C77.3501 44.561 77.298 44.6511 77.2388 44.7404C77.2036 44.794 77.1649 44.8469 77.1257 44.9004L77.124 44.9027C77.0516 45.001 76.9761 45.0986 76.8917 45.1956C76.8634 45.2284 76.8334 45.2604 76.8032 45.2926C76.7949 45.3015 76.7866 45.3104 76.7782 45.3193C76.6784 45.4266 76.5742 45.5331 76.4598 45.6376C76.439 45.6572 76.4171 45.6761 76.3952 45.695C76.3855 45.7034 76.3758 45.7117 76.3662 45.7201C76.2346 45.8356 76.0973 45.9504 75.9489 46.0618C75.9335 46.0735 75.9176 46.0847 75.9018 46.0958C75.8981 46.0985 75.8943 46.1011 75.8906 46.1037C75.725 46.2254 75.5519 46.3451 75.3668 46.4606C75.3636 46.4627 75.3603 46.4646 75.357 46.4665C75.355 46.4677 75.353 46.4689 75.3509 46.4702C74.4728 47.0162 73.38 47.4863 72.1182 47.8256V49.2524C74.5312 48.649 76.3001 47.5729 77.3802 46.3141C77.5135 46.1629 77.6337 46.0068 77.7467 45.848L77.7471 51.6292C77.741 51.6595 77.7366 51.6904 77.733 51.722C77.5549 53.4132 75.4119 55.1892 72.1182 56.0741V57.4693Z"
        fill="white"
      />
      <g clipPath="url(#clip0_1_2)">
        <path
          d="M69.9481 25.0349C69.0841 21.8339 62.6531 18.6852 51.4034 18.6852C40.1538 18.6852 33.722 21.8339 32.8587 25.0349C32.796 25.1446 32.7498 25.2647 32.7498 25.4005V25.7736V34.3543V34.7273V35.1004V43.308V43.6811V44.0542V53.0079C32.7498 53.1288 32.7819 53.2429 32.8371 53.3444C33.7183 56.9968 41.6021 59.7232 51.4034 59.7232C61.1824 59.7232 69.0535 57.008 69.9638 53.369C70.0235 53.2623 70.0571 53.1392 70.0571 53.0079V44.0542V43.6811V43.308V35.1004V34.7273V34.3543V25.7736V25.4005C70.0571 25.2647 70.0108 25.1446 69.9481 25.0349ZM68.5058 44.043C68.4849 44.1332 68.4558 44.2228 68.4193 44.3138C68.3894 44.3877 68.3529 44.4616 68.3126 44.5354C68.2626 44.6272 68.2066 44.719 68.1402 44.8107C68.091 44.8801 68.035 44.9488 67.9768 45.0174C67.894 45.1152 67.8059 45.2129 67.706 45.3099C67.6455 45.3689 67.5791 45.4271 67.512 45.486C67.3896 45.5927 67.262 45.6987 67.1195 45.8039C67.0583 45.8494 66.9926 45.8934 66.9277 45.9382C66.7591 46.0546 66.583 46.1702 66.3898 46.2836C66.339 46.3142 66.2846 46.3433 66.2316 46.3732C66.0092 46.4985 65.7772 46.6231 65.5265 46.744C65.4944 46.7597 65.4608 46.7746 65.428 46.7895C65.1482 46.9216 64.8557 47.0514 64.543 47.1768C64.5341 47.1805 64.5251 47.1835 64.5162 47.1872C62.8217 47.864 60.6541 48.4333 58.1284 48.8064C58.1158 48.8079 58.1031 48.8093 58.0904 48.8116C57.5994 48.884 57.0958 48.9481 56.5787 49.0048C56.4944 49.0138 56.4056 49.0198 56.3205 49.0287C55.8691 49.0757 55.4125 49.119 54.9424 49.1533C54.7275 49.169 54.5022 49.1764 54.2835 49.1899C53.9299 49.2108 53.5799 49.2339 53.2173 49.2466C52.6249 49.2652 52.0205 49.2772 51.4034 49.2772C50.7864 49.2772 50.182 49.2652 49.5888 49.2443C49.2262 49.2317 48.8762 49.2078 48.5226 49.1876C48.3039 49.175 48.0786 49.1667 47.8637 49.1511C47.3936 49.1168 46.937 49.0735 46.4856 49.0265C46.4005 49.0175 46.3117 49.0115 46.2274 49.0026C45.7103 48.9459 45.2067 48.881 44.7157 48.8093C44.703 48.8079 44.6904 48.8064 44.6777 48.8041C42.152 48.431 39.9844 47.8617 38.2899 47.185C38.281 47.182 38.272 47.1783 38.2631 47.1745C37.9504 47.0492 37.6572 46.9194 37.3781 46.7873C37.346 46.7716 37.3117 46.7567 37.2796 46.7418C37.0289 46.6209 36.7969 46.497 36.5745 46.3709C36.5223 46.3411 36.4671 46.312 36.4163 46.2814C36.2231 46.168 36.047 46.0523 35.8784 45.9359C35.8142 45.8912 35.7478 45.8471 35.6866 45.8016C35.5441 45.6964 35.4165 45.5905 35.2941 45.4838C35.2277 45.4256 35.1606 45.3674 35.1001 45.3077C35.0002 45.2107 34.9121 45.1137 34.8293 45.0152C34.7711 44.9465 34.7151 44.8779 34.6659 44.8085C34.6002 44.7167 34.5443 44.625 34.4935 44.5332C34.4532 44.4593 34.4174 44.3854 34.3868 44.3116C34.3503 44.2213 34.3212 44.131 34.3003 44.0407C34.2727 43.9221 34.2421 43.8012 34.2421 43.6811C34.2421 43.5968 34.2518 43.5125 34.2652 43.4289C34.2839 43.3162 34.2734 43.2036 34.2421 43.0969V37.5575C34.263 37.5769 34.2891 37.5955 34.3107 37.6149C34.4734 37.7582 34.639 37.9007 34.8256 38.038C37.6363 40.1638 43.257 41.8157 51.4034 41.8157C59.5155 41.8157 65.1221 40.1772 67.9447 38.0641C68.1701 37.9 68.373 37.7306 68.564 37.5582L68.5648 43.0969C68.5334 43.2036 68.523 43.3162 68.5416 43.4289C68.5558 43.5125 68.5648 43.5968 68.5648 43.6811C68.5648 43.8012 68.5342 43.9221 68.5058 44.043ZM68.5648 28.6037V34.1431C68.5334 34.2498 68.523 34.3625 68.5416 34.4751C68.5558 34.5587 68.5648 34.643 68.5648 34.7273C68.5648 34.8475 68.5342 34.9683 68.5058 35.0892C68.4849 35.1795 68.4558 35.269 68.4193 35.3601C68.3894 35.4339 68.3529 35.5078 68.3126 35.5817C68.2626 35.6735 68.2066 35.7652 68.1402 35.857C68.091 35.9264 68.035 35.995 67.9768 36.0637C67.894 36.1614 67.8059 36.2592 67.706 36.3562C67.6455 36.4151 67.5791 36.4733 67.512 36.5323C67.3896 36.639 67.262 36.7449 67.1195 36.8501C67.0583 36.8956 66.9926 36.9397 66.9277 36.9844C66.7591 37.1008 66.583 37.2165 66.3898 37.3299C66.339 37.3605 66.2846 37.3896 66.2316 37.4194C66.0092 37.5448 65.7772 37.6694 65.5265 37.7903C65.4944 37.8059 65.4608 37.8209 65.428 37.8358C65.1482 37.9678 64.8557 38.0977 64.543 38.223C64.5341 38.2268 64.5251 38.2297 64.5162 38.2335C62.8217 38.9102 60.6541 39.4795 58.1284 39.8526C58.1158 39.8541 58.1031 39.8556 58.0904 39.8578C57.5994 39.9302 57.0958 39.9944 56.5787 40.0511C56.4944 40.06 56.4056 40.066 56.3205 40.075C55.8691 40.122 55.4125 40.1652 54.9424 40.1996C54.7275 40.2152 54.5022 40.2227 54.2835 40.2361C53.9299 40.257 53.5799 40.2802 53.2173 40.2928C52.6249 40.3115 52.0205 40.3234 51.4034 40.3234C50.7864 40.3234 50.182 40.3115 49.5888 40.2906C49.2262 40.2779 48.8762 40.254 48.5226 40.2339C48.3039 40.2212 48.0786 40.213 47.8637 40.1973C47.3936 40.163 46.937 40.1197 46.4856 40.0727C46.4005 40.0638 46.3117 40.0578 46.2274 40.0488C45.7103 39.9921 45.2067 39.9272 44.7157 39.8556C44.703 39.8541 44.6904 39.8526 44.6777 39.8504C42.152 39.4773 39.9844 38.908 38.2899 38.2312C38.281 38.2283 38.272 38.2245 38.2631 38.2208C37.9504 38.0954 37.6572 37.9656 37.3781 37.8335C37.346 37.8179 37.3117 37.803 37.2796 37.788C37.0289 37.6672 36.7969 37.5433 36.5745 37.4172C36.5223 37.3873 36.4671 37.3582 36.4163 37.3277C36.2231 37.2142 36.047 37.0986 35.8784 36.9822C35.8142 36.9374 35.7478 36.8934 35.6866 36.8479C35.5441 36.7427 35.4165 36.6367 35.2941 36.53C35.2277 36.4718 35.1606 36.4136 35.1001 36.3539C35.0002 36.2569 34.9121 36.1599 34.8293 36.0614C34.7711 35.9928 34.7151 35.9242 34.6659 35.8548C34.6002 35.763 34.5443 35.6712 34.4935 35.5794C34.4532 35.5056 34.4174 35.4317 34.3868 35.3578C34.3503 35.2675 34.3212 35.1773 34.3003 35.087C34.2727 34.9683 34.2421 34.8475 34.2421 34.7273C34.2421 34.643 34.2518 34.5587 34.2652 34.4751C34.2839 34.3625 34.2734 34.2498 34.2421 34.1431V28.6037C34.3316 28.6851 34.4338 28.7649 34.5308 28.8455C34.5846 28.8902 34.6346 28.935 34.6913 28.9798C34.9151 29.1559 35.1569 29.3297 35.4188 29.4991C35.4732 29.5342 35.5344 29.5685 35.5911 29.6036C35.8105 29.7401 36.0425 29.8737 36.2865 30.005C36.3768 30.0535 36.4671 30.1012 36.5604 30.149C36.8327 30.2878 37.1185 30.4228 37.4192 30.5534C37.4684 30.575 37.5132 30.5974 37.5632 30.6183C37.9131 30.7668 38.2847 30.9086 38.6712 31.0459C38.7779 31.0839 38.8898 31.1197 38.9995 31.157C39.3069 31.2607 39.6248 31.36 39.9538 31.4562C40.0725 31.4906 40.1889 31.5264 40.3105 31.5592C40.747 31.6801 41.1976 31.795 41.6707 31.9009C41.7356 31.9159 41.8058 31.9278 41.8714 31.942C42.2885 32.033 42.7213 32.1173 43.166 32.1964C43.3167 32.2233 43.4697 32.2486 43.6234 32.274C44.0464 32.3434 44.4822 32.4068 44.9291 32.465C45.044 32.48 45.1537 32.4971 45.2701 32.5113C45.8252 32.5784 46.3998 32.6359 46.99 32.6851C47.1355 32.6971 47.2869 32.706 47.4347 32.7165C47.907 32.7508 48.3897 32.7792 48.8837 32.8015C49.0635 32.8097 49.2426 32.818 49.4261 32.8247C50.0693 32.8463 50.7244 32.862 51.4034 32.862C52.0824 32.862 52.7375 32.8463 53.3807 32.8247C53.5635 32.818 53.7426 32.8097 53.9232 32.8015C54.4171 32.7792 54.8999 32.7508 55.3722 32.7165C55.5199 32.7053 55.6706 32.6971 55.8169 32.6851C56.4071 32.6366 56.9816 32.5784 57.5367 32.5113C57.6531 32.4971 57.7628 32.48 57.8777 32.465C58.3247 32.4068 58.7597 32.3434 59.1835 32.274C59.3372 32.2486 59.4902 32.2233 59.6409 32.1964C60.0856 32.1173 60.5183 32.033 60.9354 31.942C61.0011 31.9278 61.0712 31.9151 61.1361 31.9009C61.6092 31.795 62.0599 31.6793 62.4964 31.5592C62.618 31.5256 62.7344 31.4906 62.853 31.4562C63.1821 31.36 63.4999 31.2607 63.8073 31.157C63.917 31.1197 64.029 31.0839 64.1357 31.0459C64.5222 30.9086 64.8945 30.7668 65.2437 30.6183C65.2937 30.5974 65.3384 30.575 65.3877 30.5534C65.6884 30.4221 65.9742 30.2878 66.2465 30.149C66.3398 30.1012 66.4308 30.0535 66.5203 30.005C66.7643 29.8744 66.9964 29.7409 67.2157 29.6036C67.2725 29.5685 67.3336 29.5342 67.3881 29.4991C67.65 29.3297 67.8917 29.1566 68.1156 28.9798C68.1715 28.935 68.2215 28.8902 68.276 28.8455C68.373 28.7649 68.4752 28.6851 68.5648 28.6037ZM51.4034 20.1775C61.5174 20.1775 68.5648 23.1263 68.5648 25.7736C68.5648 28.4209 61.5174 31.3697 51.4034 31.3697C41.2894 31.3697 34.2421 28.4209 34.2421 25.7736C34.2421 23.1263 41.2894 20.1775 51.4034 20.1775ZM68.5648 52.7863C68.5543 52.8191 68.5469 52.8527 68.5409 52.887C68.1178 55.4679 61.1302 58.2309 51.4034 58.2309C41.6767 58.2309 34.689 55.4679 34.266 52.887C34.26 52.8535 34.2518 52.8206 34.2421 52.7893V46.5112C34.263 46.5306 34.2891 46.5493 34.3107 46.5687C34.4734 46.7119 34.639 46.8544 34.8256 46.9917C37.6363 49.1175 43.257 50.7695 51.4034 50.7695C59.5155 50.7695 65.1221 49.1309 67.9447 47.0178C68.1701 46.8537 68.373 46.6843 68.564 46.512L68.5648 52.7863Z"
          fill="white"
        />
      </g>
      <defs>
        <clipPath id="clip0_1_2">
          <rect
            width="41.038"
            height="41.038"
            fill="white"
            transform="translate(30.8844 18.6852)"
          />
        </clipPath>
      </defs>
    </svg>
  ),
  installDLEIcon: (
    <svg
      width="128"
      height="54"
      viewBox="0 0 128 54"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect
        y="0.444588"
        width="128"
        height="17.1193"
        rx="8.55967"
        fill="#FF6112"
      />
      <rect
        y="35.918"
        width="128"
        height="17.1193"
        rx="8.55967"
        fill="#FF6112"
      />
      <rect
        y="18.1813"
        width="128"
        height="17.1193"
        rx="8.55967"
        fill="#FF6112"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M89.4032 44.5434C92.8391 43.6562 95.2864 41.7434 95.6625 39.4027C95.6968 39.3074 95.7161 39.1974 95.7161 39.0801V31.083V30.7498V30.4166V23.0859V22.7527V22.4195V14.7556V14.4223C95.7161 14.3011 95.6895 14.1938 95.6536 14.0958C95.2842 11.9655 93.1415 9.86111 89.4032 8.92679V10.3074C92.7551 11.2034 94.8599 13.0495 94.8599 14.7556C94.8599 16.4616 92.7551 18.3077 89.4032 19.2037V20.5802C89.4281 20.574 89.4529 20.5678 89.4777 20.5615C89.5659 20.5388 89.6536 20.5161 89.7401 20.4922C89.9952 20.4215 90.2435 20.3462 90.4828 20.2649C90.5011 20.2588 90.52 20.2529 90.5388 20.2471C90.5588 20.2409 90.5788 20.2348 90.598 20.2283C90.8694 20.1336 91.1279 20.0303 91.3784 19.923C91.426 19.9025 91.4723 19.8814 91.5185 19.8603C91.54 19.8506 91.5614 19.8408 91.583 19.8311C91.7718 19.7451 91.9541 19.6565 92.1305 19.5638C92.1531 19.5518 92.176 19.54 92.1987 19.5282C92.2393 19.5072 92.2797 19.4863 92.3188 19.4645C92.5406 19.3419 92.7542 19.2153 92.9545 19.0827C92.9712 19.0718 92.9869 19.0605 93.0026 19.0492C93.0139 19.041 93.0253 19.0328 93.0372 19.0247C93.2097 18.9074 93.3736 18.7874 93.5299 18.6635C93.5834 18.6208 93.6356 18.5782 93.687 18.5349C93.827 18.4182 93.9601 18.2989 94.0859 18.1763C94.0996 18.1632 94.1136 18.1502 94.1276 18.1373C94.1472 18.1192 94.1666 18.1012 94.1848 18.083C94.3351 17.9317 94.4738 17.7771 94.6022 17.6192C94.6205 17.5963 94.6378 17.5735 94.655 17.5506C94.6679 17.5335 94.6808 17.5164 94.6942 17.4992C94.7108 17.4778 94.7276 17.4565 94.7444 17.4352C94.7841 17.3848 94.8238 17.3344 94.8599 17.2833V22.2309C94.8419 22.3262 94.8359 22.4268 94.8466 22.5274C94.8548 22.6021 94.8599 22.6774 94.8599 22.7527C94.8599 22.8526 94.8447 22.9531 94.8294 23.0537C94.8283 23.0611 94.8272 23.0685 94.8261 23.0759C94.8141 23.1565 94.7974 23.2365 94.7764 23.3178C94.7593 23.3838 94.7383 23.4498 94.7152 23.5157C94.6865 23.5977 94.6544 23.6797 94.6163 23.7616C94.5881 23.8236 94.556 23.8849 94.5226 23.9462C94.4751 24.0336 94.4245 24.1209 94.3672 24.2075C94.333 24.2594 94.2955 24.3106 94.2575 24.3625L94.2559 24.3648C94.1857 24.4601 94.1125 24.5547 94.0307 24.6487C94.0032 24.6805 93.9741 24.7116 93.9449 24.7428C93.9368 24.7514 93.9287 24.76 93.9207 24.7686C93.824 24.8726 93.7229 24.9759 93.6121 25.0772C93.5919 25.0961 93.5706 25.1144 93.5494 25.1328C93.54 25.1409 93.5306 25.149 93.5213 25.1571C93.3937 25.2691 93.2606 25.3804 93.1168 25.4884C93.1019 25.4997 93.0865 25.5106 93.0711 25.5213C93.0675 25.5239 93.0639 25.5265 93.0603 25.529C92.8997 25.647 92.7319 25.7629 92.5526 25.8749C92.55 25.8766 92.5474 25.8781 92.5449 25.8796C92.5423 25.8811 92.5397 25.8826 92.5372 25.8842C91.6859 26.4135 90.6265 26.8692 89.4032 27.1981V28.5812C91.7424 27.9963 93.4571 26.9532 94.5042 25.7329C94.6334 25.5863 94.7499 25.435 94.8595 25.2811L94.8599 30.228C94.8419 30.3233 94.8359 30.4239 94.8466 30.5245C94.8548 30.5992 94.8599 30.6745 94.8599 30.7498C94.8599 30.8497 94.8447 30.9503 94.8294 31.0508C94.8283 31.0582 94.8272 31.0656 94.8261 31.073C94.8141 31.1537 94.7974 31.2336 94.7764 31.3149C94.7593 31.3809 94.7383 31.4469 94.7152 31.5129C94.6865 31.5948 94.6544 31.6768 94.6163 31.7588C94.5881 31.8207 94.556 31.8821 94.5226 31.9434C94.4751 32.0307 94.4245 32.118 94.3672 32.2046C94.333 32.2565 94.2955 32.3078 94.2575 32.3597L94.2559 32.3619C94.1857 32.4572 94.1125 32.5518 94.0307 32.6458C94.0032 32.6776 93.9741 32.7087 93.9449 32.7399C93.9368 32.7485 93.9288 32.7571 93.9207 32.7657C93.824 32.8697 93.7229 32.973 93.6121 33.0743C93.5919 33.0933 93.5706 33.1116 93.5494 33.1299C93.54 33.138 93.5306 33.1461 93.5213 33.1543C93.3937 33.2662 93.2606 33.3775 93.1168 33.4855C93.1019 33.4968 93.0865 33.5077 93.0712 33.5184C93.0675 33.521 93.0639 33.5236 93.0603 33.5261C92.8997 33.6441 92.7319 33.76 92.5526 33.872C92.55 33.8737 92.5474 33.8752 92.5449 33.8767C92.5423 33.8782 92.5397 33.8797 92.5372 33.8813C91.6859 34.4106 90.6265 34.8663 89.4032 35.1952V36.5783C91.7424 35.9934 93.4571 34.9503 94.5042 33.7301C94.6334 33.5834 94.7499 33.4322 94.8595 33.2782L94.8599 38.8822C94.8539 38.9115 94.8496 38.9415 94.8462 38.9722C94.6736 40.6116 92.5961 42.3332 89.4032 43.1909V44.5434Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M81.0933 44.5432C84.529 43.656 86.9763 41.7433 87.3524 39.4026C87.3867 39.3073 87.4059 39.1974 87.4059 39.0801V31.083V30.7497V30.4165V23.0858V22.7526V22.4194V14.7555V14.4223C87.4059 14.301 87.3794 14.1937 87.3434 14.0957C86.9741 11.9655 84.8315 9.86114 81.0933 8.92679V10.3074C84.445 11.2034 86.5498 13.0495 86.5498 14.7555C86.5498 16.4615 84.445 18.3076 81.0933 19.2036V20.5801C81.1181 20.5739 81.1429 20.5677 81.1676 20.5614C81.2557 20.5387 81.3435 20.5161 81.43 20.4921C81.6851 20.4215 81.9334 20.3462 82.1727 20.2648C82.1909 20.2587 82.2098 20.2529 82.2287 20.2471C82.2487 20.2409 82.2686 20.2347 82.2878 20.2282C82.5592 20.1336 82.8178 20.0303 83.0682 19.923C83.1159 19.9025 83.1622 19.8814 83.2084 19.8603C83.2298 19.8505 83.2513 19.8407 83.2728 19.831C83.4616 19.745 83.644 19.6564 83.8203 19.5638C83.843 19.5518 83.8658 19.5399 83.8886 19.5281C83.9291 19.5072 83.9695 19.4862 84.0087 19.4645C84.2304 19.3418 84.4441 19.2152 84.6444 19.0826C84.6611 19.0718 84.6767 19.0605 84.6924 19.0491C84.7038 19.0409 84.7152 19.0327 84.727 19.0246C84.8995 18.9073 85.0635 18.7874 85.2197 18.6634C85.2732 18.6208 85.3255 18.5781 85.3768 18.5348C85.5168 18.4182 85.65 18.2989 85.7758 18.1763C85.7894 18.1632 85.8035 18.1502 85.8175 18.1372C85.837 18.1192 85.8565 18.1012 85.8747 18.083C86.0249 17.9317 86.1636 17.7771 86.2921 17.6191C86.3104 17.5963 86.3276 17.5734 86.3449 17.5506C86.3578 17.5334 86.3707 17.5163 86.3841 17.4992C86.4006 17.4778 86.4174 17.4565 86.4342 17.4351C86.474 17.3847 86.5137 17.3343 86.5498 17.2833V22.2308C86.5318 22.3261 86.5258 22.4267 86.5365 22.5274C86.5446 22.602 86.5498 22.6773 86.5498 22.7526C86.5498 22.8526 86.5345 22.9531 86.5193 23.0537C86.5182 23.061 86.5171 23.0684 86.5159 23.0758C86.504 23.1565 86.4873 23.2364 86.4663 23.3177C86.4492 23.3837 86.4282 23.4497 86.4051 23.5157C86.3764 23.5976 86.3443 23.6796 86.3062 23.7616C86.2779 23.8236 86.2458 23.8849 86.2124 23.9462C86.1649 24.0335 86.1144 24.1208 86.057 24.2074C86.0229 24.2593 85.9854 24.3106 85.9474 24.3625L85.9458 24.3647C85.8755 24.46 85.8023 24.5546 85.7206 24.6486C85.6931 24.6805 85.664 24.7115 85.6347 24.7427C85.6267 24.7513 85.6186 24.7599 85.6106 24.7686C85.5138 24.8725 85.4128 24.9758 85.3019 25.0771C85.2817 25.0961 85.2605 25.1144 85.2393 25.1327C85.2299 25.1408 85.2205 25.1489 85.2112 25.1571C85.0836 25.269 84.9505 25.3803 84.8066 25.4883C84.7918 25.4996 84.7763 25.5105 84.761 25.5213C84.7574 25.5238 84.7537 25.5264 84.7501 25.529C84.5896 25.6469 84.4218 25.7629 84.2424 25.8748C84.2373 25.8782 84.2322 25.8808 84.227 25.8842C83.3758 26.4134 82.3165 26.8691 81.0933 27.198V28.581C83.4324 27.9961 85.147 26.9531 86.194 25.7329C86.3233 25.5863 86.4397 25.435 86.5493 25.281L86.5498 30.2279C86.5318 30.3232 86.5258 30.4239 86.5365 30.5245C86.5446 30.5991 86.5498 30.6744 86.5498 30.7497C86.5498 30.8497 86.5345 30.9502 86.5193 31.0508C86.5182 31.0582 86.5171 31.0656 86.5159 31.073C86.504 31.1536 86.4873 31.2336 86.4663 31.3149C86.4492 31.3808 86.4282 31.4468 86.4051 31.5128C86.3764 31.5948 86.3443 31.6767 86.3062 31.7587C86.2779 31.8207 86.2458 31.882 86.2124 31.9433C86.1649 32.0306 86.1144 32.1179 86.057 32.2046C86.0229 32.2565 85.9854 32.3077 85.9474 32.3596L85.9458 32.3618C85.8755 32.4571 85.8023 32.5518 85.7206 32.6457C85.6931 32.6776 85.664 32.7086 85.6348 32.7398C85.6267 32.7484 85.6186 32.757 85.6106 32.7657C85.5138 32.8696 85.4128 32.9729 85.3019 33.0742C85.2817 33.0932 85.2605 33.1115 85.2392 33.1299C85.2299 33.1379 85.2205 33.146 85.2112 33.1542C85.0836 33.2662 84.9505 33.3775 84.8066 33.4854C84.7882 33.4994 84.769 33.5127 84.7501 33.5261C84.5896 33.644 84.4218 33.76 84.2424 33.872C84.2373 33.8753 84.2322 33.878 84.227 33.8813C83.3758 34.4105 82.3165 34.8662 81.0933 35.1951V36.5782C83.4324 35.9933 85.147 34.9502 86.194 33.73C86.3233 33.5834 86.4397 33.4321 86.5493 33.2782L86.5498 38.8821C86.5438 38.9115 86.5395 38.9415 86.5361 38.9721C86.3635 40.6115 84.2861 42.333 81.0933 43.1908V44.5432Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M72.7826 44.5432C76.2183 43.656 78.6655 41.7433 79.0417 39.4026C79.0759 39.3073 79.0952 39.1974 79.0952 39.0801V31.083V30.7497V30.4165V23.0858V22.7526V22.4194V14.7555V14.4223C79.0952 14.301 79.0686 14.1937 79.0327 14.0957C78.6633 11.9655 76.5207 9.86114 72.7826 8.92679V10.3074C76.1343 11.2034 78.239 13.0495 78.239 14.7555C78.239 16.4615 76.1343 18.3076 72.7826 19.2036V20.5801C72.8074 20.5739 72.8321 20.5677 72.8568 20.5614C72.945 20.5387 73.0327 20.5161 73.1192 20.4921C73.3743 20.4215 73.6226 20.3462 73.8619 20.2648C73.8802 20.2587 73.8991 20.2529 73.9179 20.2471C73.9379 20.2409 73.9579 20.2347 73.9771 20.2282C74.2485 20.1336 74.507 20.0303 74.7575 19.923C74.8051 19.9025 74.8514 19.8814 74.8976 19.8603C74.9191 19.8505 74.9405 19.8407 74.9621 19.831C75.1509 19.745 75.3332 19.6564 75.5096 19.5638C75.5322 19.5518 75.5551 19.54 75.5778 19.5281C75.6184 19.5072 75.6588 19.4862 75.6979 19.4645C75.9197 19.3418 76.1333 19.2152 76.3336 19.0826C76.3503 19.0718 76.366 19.0605 76.3817 19.0491C76.393 19.0409 76.4044 19.0327 76.4163 19.0246C76.5888 18.9073 76.7527 18.7874 76.909 18.6634C76.9625 18.6208 77.0147 18.5781 77.0661 18.5348C77.2061 18.4182 77.3392 18.2989 77.465 18.1763C77.4787 18.1632 77.4927 18.1502 77.5067 18.1372C77.5263 18.1192 77.5458 18.1012 77.5639 18.083C77.7142 17.9317 77.8529 17.7771 77.9813 17.6191C77.9997 17.5963 78.0169 17.5734 78.0341 17.5506C78.047 17.5334 78.06 17.5163 78.0733 17.4992C78.0899 17.4778 78.1067 17.4565 78.1235 17.4351C78.1632 17.3847 78.2029 17.3343 78.239 17.2833V22.2308C78.221 22.3261 78.215 22.4267 78.2257 22.5274C78.2339 22.602 78.239 22.6773 78.239 22.7526C78.239 22.8526 78.2238 22.9531 78.2085 23.0537C78.2074 23.061 78.2063 23.0684 78.2052 23.0758C78.1932 23.1565 78.1765 23.2364 78.1555 23.3177C78.1384 23.3837 78.1174 23.4497 78.0943 23.5157C78.0656 23.5976 78.0335 23.6796 77.9954 23.7616C77.9672 23.8236 77.9351 23.8849 77.9017 23.9462C77.8542 24.0335 77.8037 24.1208 77.7463 24.2074C77.7121 24.2593 77.6746 24.3106 77.6366 24.3625L77.635 24.3647C77.5648 24.46 77.4916 24.5546 77.4098 24.6486C77.3823 24.6805 77.3532 24.7115 77.324 24.7427C77.3159 24.7513 77.3079 24.7599 77.2998 24.7686C77.2031 24.8725 77.102 24.9758 76.9912 25.0771C76.971 25.0961 76.9497 25.1144 76.9285 25.1327C76.9191 25.1408 76.9097 25.1489 76.9004 25.1571C76.7728 25.269 76.6397 25.3803 76.4959 25.4883C76.481 25.4996 76.4656 25.5105 76.4502 25.5213C76.4466 25.5238 76.443 25.5264 76.4394 25.529C76.2788 25.6469 76.111 25.7629 75.9317 25.8748C75.9291 25.8765 75.9265 25.878 75.924 25.8795C75.9214 25.881 75.9188 25.8825 75.9163 25.8842C75.065 26.4134 74.0057 26.8691 72.7826 27.198V28.581C75.1217 27.9961 76.8363 26.9531 77.8833 25.7329C78.0126 25.5863 78.129 25.435 78.2386 25.281L78.239 30.2279C78.221 30.3232 78.215 30.4239 78.2257 30.5245C78.2339 30.5991 78.239 30.6744 78.239 30.7497C78.239 30.8497 78.2238 30.9502 78.2085 31.0508C78.2074 31.0582 78.2063 31.0656 78.2052 31.073C78.1932 31.1536 78.1765 31.2336 78.1555 31.3149C78.1384 31.3808 78.1174 31.4468 78.0943 31.5128C78.0656 31.5948 78.0335 31.6767 77.9954 31.7587C77.9672 31.8207 77.9351 31.882 77.9017 31.9433C77.8542 32.0306 77.8037 32.1179 77.7463 32.2046C77.7121 32.2565 77.6746 32.3077 77.6366 32.3596L77.635 32.3618C77.5648 32.4571 77.4916 32.5518 77.4098 32.6457C77.3823 32.6776 77.3532 32.7086 77.324 32.7398C77.3159 32.7484 77.3079 32.757 77.2998 32.7657C77.2031 32.8696 77.102 32.9729 76.9912 33.0742C76.971 33.0932 76.9497 33.1115 76.9285 33.1299C76.9191 33.1379 76.9097 33.146 76.9004 33.1542C76.7728 33.2662 76.6397 33.3775 76.4959 33.4854C76.481 33.4967 76.4656 33.5076 76.4503 33.5184C76.4466 33.521 76.443 33.5235 76.4394 33.5261C76.2788 33.644 76.111 33.76 75.9317 33.872C75.9291 33.8736 75.9265 33.8751 75.924 33.8766C75.9214 33.8781 75.9188 33.8796 75.9163 33.8813C75.065 34.4105 74.0057 34.8662 72.7826 35.1951V36.5782C75.1217 35.9933 76.8363 34.9502 77.8833 33.73C78.0126 33.5834 78.129 33.4321 78.2386 33.2782L78.239 38.8821C78.233 38.9115 78.2287 38.9415 78.2253 38.9721C78.0527 40.6115 75.9753 42.333 72.7826 43.1908V44.5432Z"
        fill="white"
      />
      <g clipPath="url(#clip0_1_36)">
        <path
          d="M70.6791 13.1031C69.8415 10.0003 63.6077 6.94805 52.7029 6.94805C41.7981 6.94805 35.5635 10.0003 34.7267 13.1031C34.6659 13.2094 34.6211 13.3259 34.6211 13.4575V13.8191V22.1368V22.4984V22.86V30.816V31.1777V31.5393V40.2186C34.6211 40.3357 34.6522 40.4464 34.7057 40.5448C35.5599 44.0852 43.202 46.728 52.7029 46.728C62.1821 46.728 69.8119 44.096 70.6943 40.5686C70.7521 40.4652 70.7847 40.3459 70.7847 40.2186V31.5393V31.1777V30.816V22.86V22.4984V22.1368V13.8191V13.4575C70.7847 13.3259 70.7398 13.2094 70.6791 13.1031ZM69.281 31.5284C69.2608 31.616 69.2325 31.7028 69.1971 31.791C69.1682 31.8626 69.1327 31.9342 69.0937 32.0058C69.0452 32.0948 68.991 32.1837 68.9266 32.2727C68.8789 32.34 68.8246 32.4065 68.7682 32.473C68.6879 32.5678 68.6026 32.6625 68.5057 32.7566C68.4471 32.8137 68.3827 32.8701 68.3176 32.9273C68.199 33.0307 68.0753 33.1334 67.9372 33.2354C67.8779 33.2795 67.8142 33.3222 67.7513 33.3656C67.5878 33.4784 67.4171 33.5905 67.2298 33.7004C67.1806 33.7301 67.1278 33.7583 67.0765 33.7872C66.8609 33.9087 66.636 34.0295 66.393 34.1467C66.3619 34.1619 66.3293 34.1763 66.2975 34.1908C66.0263 34.3188 65.7428 34.4447 65.4397 34.5662C65.431 34.5698 65.4224 34.5727 65.4137 34.5763C63.7711 35.2323 61.67 35.7842 59.2217 36.1458C59.2094 36.1473 59.1972 36.1487 59.1849 36.1509C58.7089 36.221 58.2207 36.2832 57.7195 36.3382C57.6378 36.3469 57.5517 36.3527 57.4693 36.3613C57.0317 36.4069 56.589 36.4489 56.1334 36.4821C55.9251 36.4973 55.7066 36.5046 55.4947 36.5176C55.1519 36.5378 54.8127 36.5602 54.4612 36.5725C53.8869 36.5906 53.301 36.6022 52.7029 36.6022C52.1047 36.6022 51.5189 36.5906 50.9439 36.5704C50.5924 36.5581 50.2532 36.5349 49.9103 36.5154C49.6984 36.5031 49.48 36.4952 49.2717 36.48C48.816 36.4467 48.3734 36.4047 47.9358 36.3592C47.8534 36.3505 47.7673 36.3447 47.6856 36.336C47.1843 36.2811 46.6961 36.2181 46.2202 36.1487C46.2079 36.1473 46.1956 36.1458 46.1833 36.1436C43.735 35.782 41.6339 35.2302 39.9914 34.5741C39.9827 34.5713 39.974 34.5676 39.9653 34.564C39.6623 34.4425 39.3781 34.3167 39.1075 34.1886C39.0764 34.1735 39.0432 34.159 39.0121 34.1445C38.7691 34.0274 38.5441 33.9073 38.3286 33.7851C38.278 33.7561 38.2244 33.7279 38.1753 33.6983C37.9879 33.5883 37.8172 33.4762 37.6538 33.3634C37.5916 33.32 37.5272 33.2773 37.4679 33.2332C37.3297 33.1312 37.2061 33.0285 37.0875 32.9251C37.0231 32.8687 36.958 32.8123 36.8994 32.7544C36.8025 32.6604 36.7171 32.5663 36.6369 32.4709C36.5804 32.4043 36.5262 32.3378 36.4785 32.2705C36.4148 32.1816 36.3606 32.0926 36.3114 32.0036C36.2723 31.932 36.2376 31.8604 36.208 31.7888C36.1725 31.7013 36.1443 31.6138 36.1241 31.5263C36.0973 31.4113 36.0676 31.2941 36.0676 31.1777C36.0676 31.0959 36.077 31.0142 36.0901 30.9332C36.1081 30.824 36.098 30.7148 36.0676 30.6113V25.2418C36.0879 25.2606 36.1132 25.2787 36.1342 25.2975C36.2919 25.4363 36.4524 25.5745 36.6332 25.7076C39.3578 27.7682 44.8062 29.3695 52.7029 29.3695C60.5663 29.3695 66.001 27.7812 68.7371 25.7329C68.9555 25.5737 69.1523 25.4096 69.3374 25.2425L69.3381 30.6113C69.3078 30.7148 69.2976 30.824 69.3157 30.9332C69.3295 31.0142 69.3381 31.0959 69.3381 31.1777C69.3381 31.2941 69.3085 31.4113 69.281 31.5284ZM69.3381 16.5625V21.9321C69.3078 22.0355 69.2976 22.1447 69.3157 22.2539C69.3295 22.3349 69.3381 22.4167 69.3381 22.4984C69.3381 22.6148 69.3085 22.732 69.281 22.8492C69.2608 22.9367 69.2325 23.0235 69.1971 23.1117C69.1682 23.1833 69.1327 23.2549 69.0937 23.3265C69.0452 23.4155 68.991 23.5045 68.9266 23.5934C68.8789 23.6607 68.8246 23.7272 68.7682 23.7938C68.6879 23.8885 68.6026 23.9833 68.5057 24.0773C68.4471 24.1344 68.3827 24.1909 68.3176 24.248C68.199 24.3514 68.0753 24.4541 67.9372 24.5561C67.8779 24.6002 67.8142 24.6429 67.7513 24.6863C67.5878 24.7991 67.4171 24.9112 67.2298 25.0212C67.1806 25.0508 67.1278 25.079 67.0765 25.108C66.8609 25.2295 66.636 25.3503 66.393 25.4674C66.3619 25.4826 66.3293 25.4971 66.2975 25.5115C66.0263 25.6396 65.7428 25.7654 65.4397 25.8869C65.431 25.8905 65.4224 25.8934 65.4137 25.8971C63.7711 26.5531 61.67 27.1049 59.2217 27.4666C59.2094 27.468 59.1972 27.4694 59.1849 27.4716C58.7089 27.5418 58.2207 27.604 57.7195 27.6589C57.6378 27.6676 57.5517 27.6734 57.4693 27.6821C57.0317 27.7277 56.589 27.7696 56.1334 27.8029C55.9251 27.8181 55.7066 27.8253 55.4947 27.8383C55.1519 27.8586 54.8127 27.881 54.4612 27.8933C53.8869 27.9114 53.301 27.9229 52.7029 27.9229C52.1047 27.9229 51.5189 27.9114 50.9439 27.8911C50.5924 27.8788 50.2532 27.8557 49.9103 27.8361C49.6984 27.8238 49.48 27.8159 49.2717 27.8007C48.816 27.7674 48.3734 27.7255 47.9358 27.6799C47.8534 27.6712 47.7673 27.6655 47.6856 27.6568C47.1843 27.6018 46.6961 27.5389 46.2202 27.4694C46.2079 27.468 46.1956 27.4666 46.1833 27.4644C43.735 27.1027 41.6339 26.5509 39.9914 25.8949C39.9827 25.892 39.974 25.8884 39.9653 25.8848C39.6623 25.7632 39.3781 25.6374 39.1075 25.5094C39.0764 25.4942 39.0432 25.4797 39.0121 25.4653C38.7691 25.3481 38.5441 25.228 38.3286 25.1058C38.278 25.0769 38.2244 25.0487 38.1753 25.019C37.9879 24.9091 37.8172 24.797 37.6538 24.6841C37.5916 24.6407 37.5272 24.5981 37.4679 24.5539C37.3297 24.452 37.2061 24.3493 37.0875 24.2458C37.0231 24.1894 36.958 24.133 36.8994 24.0751C36.8025 23.9811 36.7171 23.8871 36.6369 23.7916C36.5804 23.7251 36.5262 23.6585 36.4785 23.5913C36.4148 23.5023 36.3606 23.4133 36.3114 23.3244C36.2723 23.2528 36.2376 23.1812 36.208 23.1096C36.1725 23.022 36.1443 22.9345 36.1241 22.847C36.0973 22.732 36.0676 22.6148 36.0676 22.4984C36.0676 22.4167 36.077 22.3349 36.0901 22.2539C36.1081 22.1447 36.098 22.0355 36.0676 21.9321V16.5625C36.1544 16.6413 36.2535 16.7187 36.3475 16.7968C36.3996 16.8402 36.4481 16.8836 36.503 16.927C36.72 17.0977 36.9544 17.2662 37.2082 17.4304C37.261 17.4644 37.3203 17.4977 37.3753 17.5317C37.588 17.664 37.8129 17.7935 38.0494 17.9208C38.1369 17.9678 38.2244 18.0141 38.3148 18.0604C38.5788 18.1949 38.8559 18.3258 39.1473 18.4524C39.1951 18.4734 39.2385 18.4951 39.2869 18.5153C39.6261 18.6593 39.9863 18.7967 40.361 18.9298C40.4644 18.9667 40.5729 19.0014 40.6792 19.0375C40.9772 19.1381 41.2853 19.2343 41.6043 19.3276C41.7193 19.3608 41.8321 19.3956 41.95 19.4274C42.3731 19.5446 42.81 19.6559 43.2685 19.7586C43.3315 19.7731 43.3994 19.7847 43.4631 19.7984C43.8674 19.8867 44.2869 19.9684 44.718 20.0451C44.8641 20.0711 45.0123 20.0957 45.1613 20.1203C45.5714 20.1875 45.9938 20.249 46.4271 20.3054C46.5384 20.3199 46.6448 20.3365 46.7576 20.3503C47.2957 20.4154 47.8526 20.4711 48.4247 20.5188C48.5658 20.5304 48.7126 20.5391 48.8558 20.5492C49.3136 20.5824 49.7816 20.6099 50.2604 20.6316C50.4347 20.6396 50.6083 20.6475 50.7862 20.6541C51.4097 20.675 52.0447 20.6902 52.7029 20.6902C53.3611 20.6902 53.9961 20.675 54.6196 20.6541C54.7968 20.6475 54.9703 20.6396 55.1454 20.6316C55.6242 20.6099 56.0921 20.5824 56.55 20.5492C56.6932 20.5383 56.8393 20.5304 56.981 20.5188C57.5532 20.4718 58.1101 20.4154 58.6482 20.3503C58.761 20.3365 58.8673 20.3199 58.9787 20.3054C59.412 20.249 59.8336 20.1875 60.2444 20.1203C60.3934 20.0957 60.5417 20.0711 60.6878 20.0451C61.1189 19.9684 61.5384 19.8867 61.9427 19.7984C62.0063 19.7847 62.0743 19.7724 62.1372 19.7586C62.5958 19.6559 63.0327 19.5438 63.4558 19.4274C63.5737 19.3948 63.6865 19.3608 63.8015 19.3276C64.1205 19.2343 64.4286 19.1381 64.7266 19.0375C64.8329 19.0014 64.9414 18.9667 65.0448 18.9298C65.4195 18.7967 65.7804 18.6593 66.1189 18.5153C66.1673 18.4951 66.2107 18.4734 66.2585 18.4524C66.5499 18.3251 66.8269 18.1949 67.0909 18.0604C67.1814 18.0141 67.2696 17.9678 67.3564 17.9208C67.5929 17.7942 67.8178 17.6648 68.0305 17.5317C68.0854 17.4977 68.1447 17.4644 68.1975 17.4304C68.4514 17.2662 68.6858 17.0984 68.9027 16.927C68.957 16.8836 69.0054 16.8402 69.0582 16.7968C69.1523 16.7187 69.2514 16.6413 69.3381 16.5625ZM52.7029 8.3946C62.5068 8.3946 69.3381 11.253 69.3381 13.8191C69.3381 16.3853 62.5068 19.2437 52.7029 19.2437C42.8989 19.2437 36.0676 16.3853 36.0676 13.8191C36.0676 11.253 42.8989 8.3946 52.7029 8.3946ZM69.3381 40.0037C69.328 40.0356 69.3208 40.0681 69.315 40.1014C68.9049 42.6032 62.1315 45.2815 52.7029 45.2815C43.2743 45.2815 36.5009 42.6032 36.0908 40.1014C36.085 40.0688 36.077 40.037 36.0676 40.0066V33.921C36.0879 33.9398 36.1132 33.9579 36.1342 33.9767C36.2919 34.1156 36.4524 34.2537 36.6332 34.3868C39.3578 36.4474 44.8062 38.0487 52.7029 38.0487C60.5663 38.0487 66.001 36.4604 68.7371 34.4121C68.9555 34.253 69.1523 34.0888 69.3374 33.9218L69.3381 40.0037Z"
          fill="white"
        />
      </g>
      <defs>
        <clipPath id="clip0_1_36">
          <rect
            width="39.78"
            height="39.78"
            fill="white"
            transform="translate(32.8129 6.94805)"
          />
        </clipPath>
      </defs>
    </svg>
  ),
  aiBotIcon: (
    <svg xmlSpace="preserve" width="14" height="14" viewBox="0 0 122.88 93.04">
      <path
        d="M7.09 43.87h7.11v-1.65c0-2.2.44-4.3 1.24-6.22.83-1.99 2.04-3.79 3.55-5.29 1.5-1.5 3.3-2.72 5.29-3.55 1.92-.8 4.02-1.24 6.22-1.24h28.29V15.65c-.46-.17-.9-.38-1.32-.62a8.084 8.084 0 0 1-3.36-3.87 8.095 8.095 0 0 1 0-6.16A8.084 8.084 0 0 1 58.48.63c.95-.4 2-.61 3.08-.61s2.13.22 3.08.61A8.084 8.084 0 0 1 69.01 5a8.095 8.095 0 0 1 0 6.16c-.41.99-1.01 1.88-1.75 2.62l-.04.04c-.47.46-1 .87-1.57 1.21-.42.25-.86.46-1.32.62v10.27h28.29c2.2 0 4.3.44 6.22 1.24 2 .83 3.79 2.04 5.29 3.55 1.5 1.5 2.72 3.3 3.55 5.29.8 1.92 1.24 4.02 1.24 6.22v1.65h6.86c.95 0 1.87.19 2.71.54.87.36 1.65.89 2.3 1.54l.04.04c.64.65 1.15 1.41 1.5 2.26.35.84.54 1.75.54 2.71v18.92c0 .95-.19 1.87-.54 2.71-.36.86-.89 1.65-1.54 2.3a7.084 7.084 0 0 1-5.01 2.08h-6.87c-.03 2.11-.47 4.14-1.24 5.99-.83 2-2.04 3.79-3.55 5.29-1.5 1.5-3.3 2.72-5.29 3.55-1.92.8-4.02 1.24-6.22 1.24H30.5c-2.2 0-4.3-.44-6.22-1.24-2-.83-3.79-2.04-5.29-3.55-1.5-1.5-2.72-3.3-3.55-5.29-.77-1.85-1.21-3.88-1.24-5.99H7.09c-.95 0-1.87-.19-2.71-.54-.87-.36-1.65-.89-2.3-1.54l-.04-.04a7.029 7.029 0 0 1-1.5-2.26C.19 71.75 0 70.83 0 69.88V50.96c0-.95.19-1.87.54-2.71.36-.87.89-1.65 1.54-2.3.65-.65 1.43-1.18 2.3-1.54.84-.35 1.75-.54 2.71-.54zM47 74.3a2.16 2.16 0 0 1-.37-.37c-.33-.4-.5-.86-.51-1.33-.01-.47.14-.94.45-1.35.11-.14.23-.27.38-.39.52-.43 1.21-.66 1.89-.67.68-.01 1.36.19 1.9.6 1.86 1.43 3.7 2.47 5.52 3.16 1.8.68 3.58 1 5.34.98 1.77-.02 3.56-.39 5.39-1.08 1.85-.7 3.71-1.75 5.6-3.1.56-.4 1.25-.58 1.93-.55.68.03 1.36.27 1.87.72.13.12.25.25.36.4.3.42.44.9.41 1.37-.03.47-.22.93-.56 1.32-.12.13-.26.26-.42.37-2.37 1.71-4.75 3.01-7.16 3.9-2.42.89-4.87 1.36-7.35 1.39-2.49.03-4.95-.39-7.4-1.28-2.43-.88-4.85-2.23-7.23-4.06L47 74.3zm-6.23-30.58c.6 0 1.2.06 1.77.18.58.12 1.15.29 1.7.52.56.23 1.09.51 1.58.84.48.32.93.68 1.33 1.08l.06.05c.42.42.8.88 1.13 1.38l.02.03c.32.48.6 1 .82 1.55.23.55.4 1.12.52 1.7.11.58.18 1.17.18 1.77 0 .6-.06 1.2-.18 1.77-.12.58-.29 1.15-.52 1.71a9.044 9.044 0 0 1-1.97 2.96c-.83.83-1.84 1.51-2.97 1.97-.55.23-1.12.4-1.71.52-.58.11-1.17.17-1.77.17s-1.2-.06-1.77-.17c-.58-.12-1.15-.29-1.71-.52a9.044 9.044 0 0 1-4.09-3.35l-.02-.03c-.32-.48-.6-1-.82-1.55-.23-.55-.4-1.12-.52-1.7a9.48 9.48 0 0 1-.17-1.77c0-.6.06-1.2.17-1.77.12-.58.29-1.15.52-1.7a9.044 9.044 0 0 1 3.35-4.09l.03-.02c.48-.32 1-.6 1.55-.82.55-.23 1.12-.4 1.7-.52.59-.13 1.19-.19 1.79-.19zm1.96 4.38c-.3-.12-.62-.22-.95-.29-.32-.06-.66-.1-1.01-.1s-.69.03-1.01.1c-.34.07-.66.16-.95.29a4.96 4.96 0 0 0-1.66 1.12c-.25.25-.46.51-.65.78-.19.28-.34.57-.47.87-.12.3-.22.62-.29.95-.06.32-.1.66-.1 1.01s.03.69.1 1.01c.07.34.16.66.29.95.13.31.28.6.47.87.18.27.4.53.65.78s.51.46.78.65c.27.18.57.34.88.47l.03.02c.29.12.59.21.92.27.32.06.66.1 1.01.1s.69-.03 1.01-.1c.34-.07.65-.16.95-.28.31-.13.6-.29.88-.47.27-.18.53-.4.78-.65s.46-.51.65-.78c.19-.28.34-.57.47-.87.12-.3.22-.62.29-.95.06-.32.1-.66.1-1.01s-.03-.69-.1-1.01a4.58 4.58 0 0 0-.29-.95c-.13-.31-.28-.6-.47-.88-.19-.28-.4-.54-.64-.78l-.05-.05c-.23-.22-.47-.42-.73-.59-.28-.2-.58-.36-.89-.48zm39.62-4.38c.6 0 1.2.06 1.77.18.58.12 1.15.29 1.7.52a8.832 8.832 0 0 1 2.89 1.91c.02.02.05.04.07.06.42.42.8.88 1.13 1.38l.02.03c.32.48.6 1 .82 1.55.23.55.4 1.12.52 1.7.11.58.17 1.17.17 1.77 0 .6-.06 1.2-.17 1.77-.12.58-.29 1.15-.52 1.71a9.044 9.044 0 0 1-3.35 4.09l-.03.02c-.49.32-1 .6-1.55.82-.55.23-1.12.4-1.71.52-.58.11-1.17.17-1.77.17-.6 0-1.2-.06-1.77-.17-.58-.12-1.15-.29-1.71-.52-.57-.24-1.1-.52-1.58-.84l-.05-.04a9.42 9.42 0 0 1-1.33-1.09c-.42-.42-.8-.88-1.13-1.38l-.02-.03c-.32-.48-.6-1-.82-1.55-.23-.55-.4-1.12-.52-1.7-.11-.58-.18-1.17-.18-1.77 0-.6.06-1.2.18-1.77.12-.58.29-1.15.52-1.7a9.044 9.044 0 0 1 1.97-2.96c.41-.41.88-.79 1.38-1.13.49-.33 1.02-.61 1.58-.85a9.058 9.058 0 0 1 3.49-.7zm1.97 4.38c-.3-.12-.62-.22-.95-.29-.32-.06-.66-.1-1.01-.1s-.69.03-1.01.1c-.34.07-.66.16-.95.29a4.96 4.96 0 0 0-1.66 1.12c-.25.25-.46.51-.65.78-.19.28-.34.57-.47.87-.12.3-.22.62-.29.95-.06.32-.1.66-.1 1.01s.03.69.1 1.01c.07.34.16.66.29.95.13.31.28.6.47.87.18.27.4.53.65.78s.51.46.78.65c.27.18.57.34.88.47l.03.02c.29.12.59.21.92.27.32.06.66.1 1.01.1s.69-.03 1.01-.1c.34-.07.65-.16.95-.28.31-.13.6-.29.88-.47a5.312 5.312 0 0 0 1.43-1.42c.19-.28.34-.57.47-.87.12-.3.22-.62.29-.95.06-.32.1-.66.1-1.01s-.03-.69-.1-1.01a4.58 4.58 0 0 0-.29-.95c-.13-.31-.28-.6-.47-.88-.19-.28-.4-.54-.64-.78l-.05-.05c-.23-.22-.47-.42-.73-.59-.29-.21-.58-.37-.89-.49zm-66.13-2.23v30.87c0 1.66.33 3.24.93 4.69a12.5 12.5 0 0 0 2.68 4c1.14 1.14 2.5 2.06 4 2.68 1.44.6 3.03.93 4.69.93h62.13c1.66 0 3.24-.33 4.69-.93 1.5-.63 2.86-1.54 4-2.68s2.06-2.5 2.68-4c.6-1.44.93-3.03.93-4.69V42.22c0-1.66-.33-3.25-.93-4.69a12.5 12.5 0 0 0-2.68-4c-1.14-1.14-2.5-2.06-4-2.68-1.44-.6-3.03-.93-4.69-.93H30.5c-1.66 0-3.24.33-4.69.93a12.5 12.5 0 0 0-4 2.68c-1.14 1.14-2.06 2.5-2.68 4-.6 1.44-.93 3.03-.93 4.69v3.65h-.01zm-3.99 1.99H7.09c-.42 0-.82.08-1.18.23-.38.16-.72.39-1.01.68l-.04.03c-.27.28-.49.61-.64.97-.15.36-.23.76-.23 1.18v18.92c0 .42.08.82.23 1.18.16.38.39.72.68 1.01.56.56 1.33.91 2.18.91h7.11V47.86h.01zm101.59 0h-6.86v25.11h6.86c.42 0 .82-.08 1.18-.23.38-.16.72-.39 1.01-.68.29-.29.52-.63.68-1.01.15-.36.23-.76.23-1.18V50.96c0-.42-.08-.82-.23-1.18-.16-.38-.39-.72-.68-1.01-.29-.29-.63-.52-1.01-.68-.36-.14-.76-.23-1.18-.23z"/>
    </svg>
  ),
  auditLogIcon: (
    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 512 512">
      <path
        fillRule="evenodd"
        d="m384 85.3333337 85.333333 85.3333333v256H42.66666678L42.66525 193.996358c10.0983011 15.352321 24.2153849 33.106855 42.6673443 48.165701L85.3333334 384H426.666667V181.333334l-53.333334-53.3333337-39.735846.0017872c-5.439498-10.6533523-14.584184-26.4898523-27.734229-42.6683963zM384 320v21.333334H128.0000001V320zm0-64v21.333334H256l-.000063-20.370657c.541196-.318106 1.079687-.63898 1.615477-.962551zM181.333333 42.666667C278.4 42.666667 320 149.333334 320 149.333334S278.4 256 181.333333 256C84.2666668 256 42.66666678 149.333334 42.66666678 149.333334S84.2666668 42.666667 181.333333 42.666667zm0 26.6666667c-61.2906662 0-97.0666662 57.0666666-108.2986662 80.0000003 11.232 22.933333 47.008 80 108.2986662 80 61.290667 0 97.066667-57.066667 108.298667-80-11.232-22.9333337-47.008-80.0000003-108.298667-80.0000003zm0 33.3333333c26.80422 0 48.533334 20.8933783 48.533334 46.666667 0 25.773288-21.729114 46.666666-48.533334 46.666666-26.804219 0-48.5333329-20.893378-48.5333329-46.666666 0-25.7732887 21.7291139-46.666667 48.5333329-46.666667zm0 26.6666667c-11.487522 0-20.8 8.954305-20.8 20.0000003 0 11.045695 9.312478 20 20.8 20 11.487523 0 20.8-8.954305 20.8-20 0-11.0456953-9.312477-20.0000003-20.8-20.0000003z"
      />
    </svg>
  ),
  consultingIcon: (
    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 16 16">
      <path
        d="M13 3c-.538.515-1.185.92-1.902 1.178-.748.132-2.818-.828-3.838.152-.17.17-.38.34-.6.51-.48-.21-1.22-.53-1.76-.84S3 3 3 3L0 6.5s.74 1 1.2 1.66c.3.44.67 1.11.91 1.56l-.34.4c-.058.115-.093.25-.093.393 0 .235.092.449.243.607.138.103.311.165.5.165s.362-.062.502-.167c-.094.109-.149.249-.149.402 0 .193.088.365.226.479.144.085.317.135.501.135s.357-.05.505-.137c-.112.139-.177.313-.177.503s.065.364.174.502c.099.035.214.056.334.056.207 0 .399-.063.558-.17-.043.095-.065.203-.065.317 0 .234.096.445.252.595.13.059.283.093.443.093.226 0 .437-.068.611-.185l.516-.467c.472.47 1.123.761 1.842.761.02 0 .041 0 .061-.001.494-.042.908-.356 1.094-.791.146.056.312.094.488.094.236 0 .455-.068.64-.185.585-.387.445-.687.445-.687.125.055.27.087.423.087.321 0 .61-.142.806-.366.176-.181.283-.427.283-.697 0-.19-.053-.367-.145-.518.008.005.015.005.021.005.421 0 .787-.232.978-.574.068-.171.105-.363.105-.563 0-.342-.11-.659-.296-.917l.003.005c.82-.16.79-.57 1.19-1.17.384-.494.852-.902 1.387-1.208zm-.05 7.06c-.44.44-.78.25-1.53-.32S9.18 8.1 9.18 8.1c.061.305.202.57.401.781.319.359 1.269 1.179 1.719 1.599.28.26 1 .78.58 1.18s-.75 0-1.44-.56-2.23-1.94-2.23-1.94c-.001.018-.002.038-.002.059 0 .258.104.491.272.661.17.2 1.12 1.12 1.52 1.54s.75.67.41 1-1.03-.19-1.41-.58c-.59-.57-1.76-1.63-1.76-1.63-.001.016-.001.034-.001.053 0 .284.098.544.263.75.288.378.848.868 1.188 1.248s.54.7 0 1-1.34-.44-1.69-.8v-.002c0-.103-.038-.197-.1-.269-.159-.147-.374-.238-.609-.238-.104 0-.204.018-.297.05.128-.114.204-.274.204-.452s-.076-.338-.198-.45c-.126-.095-.284-.152-.455-.152s-.33.057-.457.153c.117-.113.189-.268.189-.441 0-.213-.109-.4-.274-.509-.153-.097-.336-.153-.532-.153-.244 0-.468.088-.642.233.095-.114.151-.26.151-.42 0-.195-.085-.37-.219-.491-.178-.165-.417-.266-.679-.266-.185 0-.358.05-.507.138L1.91 8.069c-.46-.73-1-1.49-1-1.49l2.28-2.77s.81.5 1.48.88c.33.19.9.44 1.33.64-.68.51-1.25 1-1.08 1.34.297.214.668.343 1.069.343.376 0 .726-.113 1.018-.307.373-.251.84-.403 1.343-.403.347 0 .677.072.976.203.554.374 1.574 1.294 2.504 1.874 1.17.85 1.4 1.4 1.12 1.68z"/>
    </svg>
  )
}
