export const LogoIcon = ({ className }: { className?: string }) => (
  <svg
    width="36"
    height="23"
    viewBox="0 0 36 23"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    className={className}
  >
    <path
      d="M20.286 14.3262C20.3077 14.2722 20.325 14.219 20.3374 14.1655C20.3386 14.1605 20.3397 14.1556 20.3409 14.1507C20.3566 14.0839 20.3724 14.0171 20.3724 13.9507C20.3724 13.9006 20.3671 13.8506 20.3587 13.801C20.3476 13.7341 20.3538 13.6672 20.3724 13.6039L20.372 10.3164C20.2586 10.4187 20.1381 10.5192 20.0044 10.6167C18.329 11.8709 15.0012 12.8435 10.1862 12.8435C5.35086 12.8435 2.01465 11.8629 0.346331 10.6012C0.235611 10.5197 0.137292 10.4351 0.0407447 10.3501C0.0347377 10.3447 0.0281494 10.3394 0.0215689 10.3341C0.0140798 10.3281 0.00660071 10.3221 0 10.316V13.6039C0.0186009 13.6672 0.0248012 13.7341 0.0137293 13.801C0.00575748 13.8506 0 13.9006 0 13.9507C0 14.0166 0.0155424 14.083 0.0308448 14.1483C0.0320824 14.1536 0.0333184 14.1589 0.0345445 14.1641C0.0469451 14.2177 0.0642172 14.2713 0.0859182 14.3249C0.104076 14.3687 0.125334 14.4126 0.14925 14.4564C0.179366 14.5109 0.212582 14.5654 0.251555 14.6199C0.280785 14.661 0.314001 14.7018 0.348545 14.7425C0.397705 14.801 0.449964 14.8586 0.50931 14.9161C0.542264 14.9487 0.578582 14.9805 0.61483 15.0122L0.624458 15.0207C0.69709 15.084 0.772823 15.1469 0.857412 15.2093C0.88246 15.228 0.908983 15.2462 0.935528 15.2644C0.947469 15.2726 0.959414 15.2808 0.971232 15.289C1.07132 15.3581 1.17584 15.4268 1.29055 15.4941C1.30932 15.5054 1.32913 15.5164 1.3489 15.5273C1.36084 15.534 1.37276 15.5406 1.38444 15.5472C1.51642 15.6221 1.65415 15.6956 1.80296 15.7674C1.80992 15.7706 1.81706 15.7738 1.82425 15.7771C1.83672 15.7827 1.84934 15.7885 1.86142 15.7944C2.02705 15.8728 2.20111 15.9498 2.38667 16.0242C2.39196 16.0264 2.39732 16.0287 2.40261 16.0304C3.40839 16.4321 4.69495 16.77 6.1941 16.9915C6.20163 16.9928 6.20915 16.9937 6.21668 16.9946C6.5081 17.0371 6.80704 17.0756 7.11395 17.1093C7.13923 17.112 7.16518 17.1142 7.19119 17.1164C7.21667 17.1186 7.2422 17.1208 7.26719 17.1234C7.53513 17.1513 7.80617 17.177 8.08519 17.1974C8.16478 17.2032 8.24678 17.2073 8.32873 17.2114C8.3781 17.2138 8.42746 17.2163 8.47625 17.2191C8.52845 17.2221 8.58051 17.2252 8.63258 17.2283C8.78993 17.2377 8.9474 17.2471 9.10912 17.2528C9.46121 17.2652 9.81994 17.2723 10.1862 17.2723C10.5525 17.2723 10.9112 17.2652 11.2628 17.2541C11.4393 17.2479 11.6107 17.2376 11.7824 17.2272C11.8202 17.2249 11.8579 17.2227 11.8957 17.2204C11.9501 17.2171 12.0052 17.2144 12.0603 17.2117C12.1366 17.2079 12.2127 17.2041 12.2868 17.1987C12.5658 17.1784 12.8368 17.1527 13.1048 17.1248C13.1298 17.1221 13.1553 17.1199 13.1808 17.1178C13.2068 17.1155 13.2327 17.1133 13.258 17.1106C13.5649 17.0769 13.8639 17.0389 14.1553 16.9959C14.1628 16.9946 14.1703 16.9937 14.1779 16.9928C15.677 16.7714 16.9636 16.4334 17.9693 16.0318C17.972 16.0306 17.9747 16.0296 17.9773 16.0286C17.98 16.0277 17.9826 16.0267 17.9853 16.0255C18.1709 15.9511 18.3445 15.8741 18.5105 15.7957C18.5143 15.794 18.5181 15.7923 18.5218 15.7906C18.5377 15.7834 18.5536 15.7762 18.569 15.7687C18.7178 15.6969 18.8555 15.623 18.9875 15.5486C18.9972 15.5431 19.0069 15.5378 19.0166 15.5324C19.0386 15.5202 19.0605 15.508 19.0814 15.4954C19.1961 15.4281 19.3006 15.3595 19.4007 15.2904C19.4091 15.2846 19.4174 15.2789 19.4258 15.2731C19.456 15.2524 19.4861 15.2318 19.5145 15.2107C19.5991 15.1482 19.6749 15.0853 19.7475 15.022L19.7492 15.0205C19.7885 14.986 19.8273 14.952 19.8626 14.9175C19.922 14.8599 19.9743 14.8019 20.0234 14.7439C20.058 14.7031 20.0912 14.6624 20.1204 14.6212C20.1598 14.5667 20.193 14.5122 20.2227 14.4578C20.2466 14.4139 20.2683 14.3701 20.286 14.3262Z"
      fill="white"
    />
    <path
      d="M20.3724 8.28935V5.00142C20.3351 5.03535 20.294 5.06884 20.2529 5.10235C20.2355 5.11652 20.2181 5.1307 20.201 5.14492C20.1872 5.1563 20.1738 5.16769 20.1604 5.17908C20.1426 5.19427 20.1248 5.20945 20.1058 5.22463C19.9729 5.3296 19.8294 5.43234 19.674 5.53288C19.6552 5.54499 19.635 5.55695 19.6148 5.56893C19.6003 5.57755 19.5858 5.58617 19.5717 5.59488C19.4415 5.67637 19.3037 5.75565 19.1589 5.83315C19.1058 5.86194 19.0517 5.89028 18.9964 5.91863C18.8347 6.001 18.6651 6.08072 18.4866 6.15866C18.4744 6.16405 18.4626 6.16951 18.4509 6.17495C18.4346 6.18249 18.4184 6.18999 18.4011 6.1972C18.1939 6.28533 17.9729 6.36947 17.7435 6.45096C17.7029 6.46542 17.6611 6.47933 17.6192 6.49328C17.5957 6.50113 17.572 6.50898 17.5486 6.51695C17.3661 6.57851 17.1775 6.63742 16.9822 6.69455C16.9599 6.701 16.9377 6.7075 16.9155 6.71401C16.8676 6.72802 16.8198 6.74205 16.7705 6.75566C16.5114 6.82697 16.2439 6.89561 15.9631 6.9585C15.9433 6.96284 15.9226 6.96694 15.9019 6.97104C15.8824 6.97491 15.8629 6.97878 15.844 6.98286C15.5964 7.03689 15.3395 7.08694 15.0756 7.13388C14.9861 7.14983 14.8953 7.16488 14.8041 7.17994C14.5525 7.22113 14.2943 7.25877 14.0291 7.29332C13.9997 7.29713 13.9709 7.3012 13.9421 7.30526C13.904 7.31062 13.866 7.31599 13.8267 7.32078C13.4972 7.36064 13.1561 7.39518 12.8058 7.42397C12.7573 7.42793 12.708 7.43119 12.6587 7.43446C12.6196 7.43705 12.5806 7.43964 12.5419 7.44257C12.2615 7.46294 11.975 7.47977 11.6818 7.49306L11.6692 7.49363C11.5663 7.49831 11.4641 7.50296 11.3598 7.50679C10.9781 7.51963 10.5892 7.52893 10.1862 7.52893C9.78318 7.52893 9.39434 7.51963 9.01258 7.50679C8.90576 7.50288 8.8015 7.49812 8.69687 7.49334L8.6906 7.49306C8.39742 7.47977 8.11087 7.46294 7.83053 7.44257C7.80073 7.44046 7.77067 7.43846 7.74059 7.43645C7.68214 7.43255 7.62359 7.42865 7.56658 7.42397C7.21626 7.39474 6.87524 7.36064 6.54574 7.32078C6.50642 7.31599 6.46838 7.31062 6.43033 7.30526C6.40153 7.3012 6.37273 7.29713 6.34335 7.29332C6.07806 7.25877 5.81942 7.22113 5.56831 7.17994C5.47708 7.16488 5.38629 7.14983 5.29682 7.13388C5.03287 7.08694 4.776 7.03689 4.52843 6.98286C4.51139 6.97918 4.49383 6.97576 4.47626 6.97232C4.45364 6.96791 4.43098 6.96349 4.4093 6.9585C4.12851 6.89561 3.86101 6.82741 3.60193 6.75566C3.55302 6.74246 3.50552 6.72844 3.45808 6.71444C3.4355 6.70778 3.41294 6.70112 3.39023 6.69455C3.19492 6.63742 3.00626 6.57851 2.82379 6.51695C2.80035 6.50898 2.77674 6.50112 2.75317 6.49328C2.71126 6.47933 2.66946 6.46542 2.62893 6.45096C2.39951 6.36947 2.17896 6.28533 1.97125 6.1972C1.95401 6.18999 1.93781 6.18249 1.92154 6.17494C1.9098 6.1695 1.89802 6.16405 1.88578 6.15866C1.7073 6.08116 1.53767 6.001 1.37602 5.91863C1.32066 5.89028 1.26707 5.86194 1.21349 5.83315C1.06867 5.7552 0.93093 5.67593 0.800724 5.59488C0.786643 5.58617 0.772097 5.57754 0.757573 5.56893C0.737378 5.55694 0.717224 5.54499 0.698419 5.53288C0.542969 5.43234 0.399476 5.32915 0.266613 5.22463C0.244975 5.20755 0.224984 5.19047 0.204993 5.17339C0.193887 5.1639 0.182782 5.15441 0.171394 5.14492C0.154282 5.1307 0.136897 5.11652 0.119517 5.10235C0.078419 5.06884 0.0373502 5.03535 0 5.00142V8.28935C0.0186009 8.35268 0.0248012 8.41956 0.0137293 8.48643C0.00575748 8.53603 0 8.58608 0 8.63612C0 8.70209 0.0155427 8.76844 0.0308453 8.83377C0.0320827 8.83905 0.0333186 8.84433 0.0345445 8.84959C0.0469451 8.90318 0.0642172 8.95677 0.0859182 9.01036C0.104076 9.0542 0.125334 9.09805 0.14925 9.14189C0.179366 9.19637 0.212582 9.25084 0.251555 9.30531C0.280785 9.3465 0.314001 9.38725 0.348545 9.42799C0.397705 9.48645 0.449964 9.54403 0.50931 9.6016C0.542252 9.63414 0.578554 9.66592 0.614789 9.69765C0.618013 9.70047 0.621237 9.7033 0.624458 9.70612C0.69709 9.76945 0.772823 9.83234 0.857412 9.89478C0.882463 9.91342 0.908988 9.93163 0.935535 9.94986C0.947474 9.95806 0.959417 9.96626 0.971232 9.9745C1.07132 10.0436 1.17584 10.1122 1.29055 10.1796C1.30932 10.1909 1.32913 10.2019 1.3489 10.2128C1.36084 10.2194 1.37276 10.226 1.38444 10.2327C1.51642 10.3075 1.65415 10.3811 1.80296 10.4528C1.80992 10.456 1.81706 10.4593 1.82424 10.4625C1.83672 10.4682 1.84933 10.4739 1.86142 10.4798C2.02705 10.5582 2.20111 10.6353 2.38667 10.7097C2.39196 10.7119 2.39732 10.7141 2.40261 10.7159C3.40839 11.1176 4.69495 11.4555 6.1941 11.6769C6.20163 11.6783 6.20915 11.6791 6.21668 11.68C6.5081 11.7225 6.80704 11.7611 7.11395 11.7947C7.13922 11.7974 7.16516 11.7996 7.19115 11.8019C7.21665 11.8041 7.24219 11.8063 7.26719 11.8089C7.53513 11.8368 7.80617 11.8625 8.08519 11.8829C8.16476 11.8887 8.24674 11.8927 8.32867 11.8968C8.37806 11.8993 8.42744 11.9017 8.47625 11.9046C8.52843 11.9075 8.58048 11.9106 8.63255 11.9138C8.78991 11.9232 8.94739 11.9326 9.10912 11.9382C9.46121 11.9506 9.81994 11.9577 10.1862 11.9577C10.5525 11.9577 10.9112 11.9506 11.2628 11.9396C11.4393 11.9334 11.6108 11.923 11.7825 11.9127C11.8202 11.9104 11.8579 11.9081 11.8957 11.9059C11.9501 11.9026 12.0052 11.8998 12.0603 11.8971C12.1365 11.8934 12.2127 11.8896 12.2868 11.8842C12.5658 11.8638 12.8368 11.8381 13.1048 11.8102C13.1298 11.8076 13.1553 11.8054 13.1808 11.8032C13.2068 11.801 13.2327 11.7987 13.258 11.7961C13.5649 11.7624 13.8639 11.7243 14.1553 11.6814C14.1576 11.6809 14.16 11.6806 14.1623 11.6802C14.1675 11.6795 14.1727 11.6789 14.1779 11.6783C15.677 11.4568 16.9636 11.1189 17.9693 10.7172C17.972 10.7161 17.9747 10.7151 17.9773 10.7141C17.98 10.7131 17.9826 10.7121 17.9853 10.711C18.1709 10.6366 18.3445 10.5595 18.5105 10.4812C18.5143 10.4794 18.5181 10.4777 18.5219 10.476C18.5377 10.4689 18.5536 10.4616 18.569 10.4541C18.7178 10.3824 18.8555 10.3084 18.9875 10.234C18.9972 10.2286 19.0069 10.2232 19.0166 10.2178C19.0386 10.2056 19.0605 10.1935 19.0814 10.1809C19.1961 10.1136 19.3006 10.0449 19.4007 9.97583C19.409 9.97009 19.4174 9.96437 19.4257 9.95866C19.456 9.93793 19.4861 9.91729 19.5145 9.89611C19.5991 9.83367 19.6749 9.77078 19.7475 9.70745L19.7492 9.70597C19.7885 9.67149 19.8273 9.63742 19.8626 9.60293C19.922 9.54535 19.9743 9.48734 20.0234 9.42932C20.058 9.38858 20.0912 9.34783 20.1204 9.30664C20.1598 9.25217 20.193 9.1977 20.2227 9.14322C20.2466 9.09938 20.2683 9.05553 20.286 9.01169C20.3077 8.95765 20.325 8.90451 20.3374 8.85092C20.3386 8.84601 20.3397 8.8411 20.3409 8.83619C20.3566 8.76936 20.3724 8.70255 20.3724 8.63612C20.3724 8.58608 20.3671 8.53603 20.3587 8.48643C20.3476 8.41956 20.3538 8.35268 20.3724 8.28935Z"
      fill="white"
    />
    <path
      d="M20.3724 3.32159C20.3724 1.75025 16.1894 0 10.1862 0C4.18299 0 0 1.75025 0 3.32159C0 4.89292 4.18299 6.64317 10.1862 6.64317C16.1894 6.64317 20.3724 4.89292 20.3724 3.32159Z"
      fill="white"
    />
    <path
      d="M20.3582 19.4149C20.3618 19.3945 20.3662 19.3746 20.3724 19.3551L20.372 15.6309C20.2586 15.7332 20.1381 15.8338 20.0044 15.9312C18.329 17.1854 15.0012 18.158 10.1862 18.158C5.35086 18.158 2.01465 17.1775 0.346331 15.9157C0.235611 15.8342 0.137292 15.7496 0.0407447 15.6646C0.0347374 15.6592 0.0281488 15.6539 0.0215679 15.6486C0.0140791 15.6426 0.00660043 15.6366 0 15.6305V19.3569C0.00575742 19.3755 0.010629 19.395 0.0141721 19.4149C0.265284 20.9468 4.41284 22.5868 10.1862 22.5868C15.9596 22.5868 20.1071 20.9468 20.3582 19.4149Z"
      fill="white"
    />
    <path
      d="M32.6584 1.17179C34.711 1.72037 36 2.8509 36 3.89559C36 4.94029 34.711 6.07081 32.6584 6.61939V1.17179Z"
      fill="white"
    />
    <path
      d="M32.6584 7.46228L32.7043 7.4507C32.7583 7.43683 32.8121 7.42295 32.865 7.40826C33.0212 7.36501 33.1733 7.3189 33.3198 7.26911C33.331 7.26535 33.3425 7.26179 33.3541 7.25823C33.3663 7.25444 33.3786 7.25066 33.3903 7.24667C33.5565 7.18872 33.7148 7.12547 33.8682 7.05977C33.8973 7.04724 33.9256 7.03432 33.9539 7.02141L33.9935 7.00346C34.109 6.95082 34.2207 6.89654 34.3287 6.83982L34.3705 6.81801C34.3953 6.80516 34.4201 6.79234 34.444 6.77902C34.5798 6.70393 34.7106 6.6264 34.8333 6.54519C34.8435 6.53856 34.8531 6.53165 34.8627 6.5247C34.8696 6.51969 34.8766 6.51465 34.8839 6.50969C34.9895 6.43787 35.0899 6.36442 35.1856 6.28852C35.2183 6.2624 35.2503 6.23629 35.2818 6.20976C35.3675 6.13835 35.449 6.0653 35.5261 5.99022C35.5344 5.9822 35.543 5.97425 35.5516 5.96632C35.5636 5.95528 35.5755 5.94424 35.5866 5.93309C35.6786 5.84046 35.7636 5.74578 35.8422 5.64907C35.8534 5.63508 35.864 5.62109 35.8745 5.60709C35.8824 5.59661 35.8904 5.5861 35.8986 5.57562C35.9087 5.56252 35.919 5.54946 35.9293 5.5364C35.9536 5.50552 35.9779 5.47466 36 5.4434V8.47292C35.989 8.53127 35.9853 8.59289 35.9919 8.65451C35.9969 8.70022 36 8.74633 36 8.79244C36 8.85364 35.9907 8.91519 35.9813 8.97677L35.9793 8.99035C35.972 9.03973 35.9617 9.0887 35.9489 9.13848C35.9384 9.17888 35.9256 9.21928 35.9114 9.25968C35.8938 9.30987 35.8742 9.36007 35.8508 9.41026C35.8335 9.44821 35.8139 9.48575 35.7934 9.52329C35.7644 9.57675 35.7334 9.63021 35.6983 9.68326C35.6774 9.71504 35.6544 9.74643 35.6311 9.77821L35.6301 9.77956C35.5872 9.83792 35.5423 9.89586 35.4923 9.9534C35.4754 9.9729 35.4576 9.99191 35.4397 10.011L35.4249 10.0269C35.3657 10.0905 35.3038 10.1538 35.2359 10.2158C35.2236 10.2274 35.2106 10.2386 35.1976 10.2498L35.1803 10.2648C35.1022 10.3333 35.0207 10.4015 34.9326 10.4676C34.9235 10.4745 34.9141 10.4812 34.9047 10.4878L34.898 10.4925C34.7997 10.5647 34.697 10.6357 34.5872 10.7042L34.5777 10.71C34.0564 11.0341 33.4076 11.3132 32.6584 11.5146V7.46228Z"
      fill="white"
    />
    <path
      d="M32.6584 12.3615C34.0909 12.0033 35.141 11.3646 35.7822 10.6173C35.8613 10.5276 35.9326 10.4349 35.9997 10.3407L36 13.3698C35.989 13.4281 35.9853 13.4897 35.9919 13.5514C35.9969 13.5971 36 13.6432 36 13.6893C36 13.7505 35.9907 13.812 35.9813 13.8736L35.9793 13.8872C35.972 13.9366 35.9617 13.9855 35.9489 14.0353C35.9384 14.0757 35.9256 14.1161 35.9114 14.1565C35.8938 14.2067 35.8742 14.2569 35.8508 14.3071C35.8335 14.3451 35.8139 14.3826 35.7934 14.4201C35.7644 14.4736 35.7334 14.5271 35.6983 14.5801C35.6774 14.6119 35.6544 14.6433 35.6311 14.6751L35.6301 14.6764C35.5872 14.7348 35.5423 14.7927 35.4923 14.8502C35.4754 14.8697 35.4576 14.8887 35.4398 14.9078L35.4249 14.9237C35.3657 14.9874 35.3038 15.0506 35.2359 15.1126C35.2236 15.1242 35.2106 15.1354 35.1975 15.1467L35.1803 15.1616C35.1022 15.2302 35.0207 15.2983 34.9326 15.3644C34.9235 15.3713 34.9141 15.378 34.9047 15.3846C34.9025 15.3862 34.9002 15.3877 34.898 15.3893C34.7997 15.4615 34.697 15.5325 34.5872 15.6011L34.5777 15.6068C34.0564 15.931 33.4076 16.21 32.6584 16.4114V12.3615Z"
      fill="white"
    />
    <path
      d="M32.6584 17.2583C34.0909 16.9002 35.141 16.2614 35.7822 15.5142C35.8613 15.4244 35.9326 15.3318 35.9997 15.2375L36 18.669C35.9963 18.6869 35.9937 18.7053 35.9916 18.7241C35.8859 19.728 34.6137 20.7822 32.6584 21.3074V17.2583Z"
      fill="white"
    />
    <path
      d="M27.5742 1.1689C29.6267 1.71751 30.9155 2.84798 30.9155 3.89262C30.9155 4.93726 29.6267 6.06773 27.5742 6.61634V1.1689Z"
      fill="white"
    />
    <path
      d="M27.5742 7.45923L27.6198 7.44773C27.6738 7.43385 27.7276 7.41998 27.7805 7.40529C27.9367 7.36203 28.0888 7.31592 28.2353 7.26614C28.2465 7.26238 28.258 7.25881 28.2696 7.25525C28.2818 7.25147 28.2941 7.24769 28.3058 7.24369C28.472 7.18575 28.6303 7.1225 28.7837 7.0568C28.8128 7.04426 28.8411 7.03135 28.8694 7.01844L28.909 7.00048C29.0246 6.94784 29.1362 6.89357 29.2442 6.83685L29.286 6.81503C29.3108 6.80219 29.3356 6.78936 29.3596 6.77604C29.4953 6.70096 29.6261 6.62343 29.7488 6.54222C29.759 6.53558 29.7686 6.52867 29.7782 6.52173C29.7852 6.51672 29.7921 6.51168 29.7994 6.50672C29.905 6.4349 30.0054 6.36144 30.1011 6.28554C30.1339 6.25943 30.1658 6.23331 30.1973 6.20679C30.283 6.13537 30.3645 6.06233 30.4416 5.98724C30.4499 5.97923 30.4585 5.97128 30.4671 5.96334C30.4791 5.95231 30.491 5.94127 30.5021 5.93011C30.5941 5.83748 30.6791 5.74281 30.7577 5.6461C30.7689 5.6321 30.7795 5.61811 30.79 5.60412C30.798 5.59363 30.8059 5.58314 30.8141 5.57264C30.8242 5.55955 30.8345 5.54648 30.8448 5.53342C30.8691 5.50255 30.8934 5.47169 30.9155 5.44043V8.46994C30.9045 8.5283 30.9008 8.58992 30.9074 8.65154C30.9124 8.69724 30.9155 8.74335 30.9155 8.78946C30.9155 8.85066 30.9062 8.91222 30.8969 8.97379L30.8948 8.98738C30.8875 9.03676 30.8772 9.08572 30.8644 9.13551C30.8539 9.17591 30.8411 9.21631 30.8269 9.25671C30.8094 9.3069 30.7897 9.35709 30.7664 9.40728C30.7491 9.44523 30.7294 9.48278 30.709 9.52032C30.6799 9.57378 30.6489 9.62723 30.6138 9.68028C30.5929 9.71207 30.5699 9.74346 30.5466 9.77523L30.5457 9.77659C30.5027 9.83494 30.4578 9.89289 30.4078 9.95043C30.3909 9.96993 30.3731 9.98894 30.3552 10.008L30.3404 10.0239C30.2812 10.0875 30.2193 10.1508 30.1514 10.2128C30.1391 10.2244 30.1261 10.2356 30.1131 10.2468L30.0959 10.2618C30.0177 10.3303 29.9362 10.3985 29.8481 10.4646C29.839 10.4715 29.8296 10.4782 29.8202 10.4848L29.8135 10.4895C29.7153 10.5617 29.6125 10.6327 29.5027 10.7013L29.4932 10.707C28.972 11.0311 28.3233 11.3101 27.5742 11.5115V7.45923Z"
      fill="white"
    />
    <path
      d="M27.5742 12.3584C29.0066 12.0003 30.0566 11.3616 30.6977 10.6144C30.7768 10.5246 30.8481 10.4319 30.9152 10.3377L30.9155 13.3668C30.9045 13.4251 30.9008 13.4868 30.9074 13.5484C30.9124 13.5941 30.9155 13.6402 30.9155 13.6863C30.9155 13.7475 30.9062 13.8091 30.8969 13.8706L30.8948 13.8842C30.8875 13.9336 30.8772 13.9826 30.8644 14.0324C30.8539 14.0728 30.8411 14.1132 30.8269 14.1536C30.8094 14.2037 30.7897 14.2539 30.7664 14.3041C30.7491 14.3421 30.7294 14.3796 30.709 14.4172C30.6799 14.4706 30.6489 14.5241 30.6138 14.5771C30.5929 14.6089 30.5699 14.6403 30.5466 14.6721L30.5457 14.6734C30.5027 14.7318 30.4578 14.7897 30.4078 14.8473C30.3909 14.8668 30.3731 14.8858 30.3553 14.9048L30.3404 14.9207C30.2812 14.9844 30.2193 15.0476 30.1514 15.1097C30.1391 15.1213 30.1261 15.1325 30.1131 15.1437L30.0959 15.1586C30.0177 15.2272 29.9362 15.2953 29.8481 15.3614C29.839 15.3684 29.8296 15.375 29.8202 15.3816L29.8135 15.3863C29.7153 15.4586 29.6125 15.5296 29.5027 15.5981L29.4932 15.6038C28.972 15.9279 28.3233 16.207 27.5742 16.4084V12.3584Z"
      fill="white"
    />
    <path
      d="M27.5742 17.2553C29.0066 16.8971 30.0566 16.2584 30.6977 15.5112C30.7768 15.4214 30.8481 15.3288 30.9152 15.2345L30.9155 18.666C30.9118 18.6839 30.9092 18.7023 30.9071 18.7211C30.8014 19.7249 29.5293 20.7791 27.5742 21.3043V17.2553Z"
      fill="white"
    />
    <path
      d="M22.4845 1.16878C24.537 1.71737 25.826 2.84787 25.826 3.89254C25.826 4.93721 24.537 6.06771 22.4845 6.61631V1.16878Z"
      fill="white"
    />
    <path
      d="M22.4845 7.45919L22.5303 7.44765C22.5843 7.43378 22.638 7.4199 22.691 7.40521C22.8472 7.36196 22.9992 7.31585 23.1458 7.26606C23.1569 7.2623 23.1685 7.25874 23.18 7.25518C23.1923 7.25139 23.2045 7.24761 23.2163 7.24362C23.3825 7.18567 23.5408 7.12242 23.6941 7.05672C23.7233 7.04418 23.7516 7.03127 23.7799 7.01836L23.8194 7.00041C23.935 6.94776 24.0467 6.89349 24.1547 6.83677L24.1965 6.81495C24.2213 6.8021 24.246 6.78929 24.27 6.77597C24.4058 6.70088 24.5366 6.62335 24.6593 6.54214C24.6695 6.53551 24.679 6.5286 24.6887 6.52165C24.6956 6.51664 24.7026 6.5116 24.7099 6.50664C24.8155 6.43482 24.9159 6.36137 25.0116 6.28547C25.0443 6.25935 25.0763 6.23323 25.1078 6.20671C25.1935 6.1353 25.275 6.06225 25.3521 5.98717C25.3604 5.97915 25.369 5.9712 25.3776 5.96327C25.3895 5.95223 25.4015 5.94119 25.4126 5.93004C25.5046 5.83741 25.5895 5.74273 25.6682 5.64602C25.6794 5.63203 25.69 5.61804 25.7005 5.60404C25.7084 5.59356 25.7163 5.58305 25.7245 5.57257C25.7347 5.55947 25.7449 5.5464 25.7552 5.53335C25.7796 5.50247 25.8039 5.47161 25.826 5.44035V8.46987C25.815 8.52822 25.8113 8.58984 25.8178 8.65146C25.8228 8.69716 25.826 8.74328 25.826 8.78939C25.826 8.85059 25.8166 8.91214 25.8073 8.97372L25.8053 8.9873C25.7979 9.03668 25.7877 9.08565 25.7749 9.13543C25.7644 9.17583 25.7515 9.21623 25.7374 9.25663C25.7198 9.30682 25.7002 9.35701 25.6768 9.40721C25.6595 9.44516 25.6399 9.4827 25.6194 9.52024C25.5903 9.5737 25.5594 9.62716 25.5243 9.68021C25.5033 9.71199 25.4804 9.74338 25.4571 9.77516L25.4561 9.77651C25.4131 9.83486 25.3683 9.89281 25.3182 9.95035C25.3014 9.96986 25.2836 9.98888 25.2657 10.008L25.2509 10.0238C25.1916 10.0875 25.1298 10.1507 25.0619 10.2127C25.0495 10.2243 25.0365 10.2355 25.0235 10.2468L25.0063 10.2617C24.9282 10.3303 24.8467 10.3984 24.7586 10.4645C24.7495 10.4714 24.74 10.4781 24.7306 10.4847L24.724 10.4894C24.6257 10.5616 24.523 10.6326 24.4131 10.7012L24.4037 10.7069C23.8824 11.031 23.2336 11.3101 22.4845 11.5115V7.45919Z"
      fill="white"
    />
    <path
      d="M22.4845 12.3584C23.917 12.0002 24.967 11.3615 25.6081 10.6143C25.6873 10.5245 25.7586 10.4319 25.8257 10.3376L25.826 13.3667C25.815 13.4251 25.8113 13.4867 25.8178 13.5483C25.8228 13.594 25.826 13.6401 25.826 13.6862C25.826 13.7474 25.8166 13.809 25.8073 13.8706L25.8053 13.8841C25.7979 13.9335 25.7877 13.9825 25.7749 14.0323C25.7644 14.0727 25.7515 14.1131 25.7374 14.1535C25.7198 14.2037 25.7002 14.2539 25.6768 14.3041C25.6595 14.342 25.6399 14.3795 25.6194 14.4171C25.5903 14.4705 25.5594 14.524 25.5243 14.5771C25.5033 14.6088 25.4803 14.6402 25.4571 14.672L25.4561 14.6734C25.4131 14.7317 25.3683 14.7897 25.3182 14.8472C25.3014 14.8667 25.2836 14.8857 25.2657 14.9048L25.2509 14.9206C25.1916 14.9843 25.1298 15.0476 25.0619 15.1096C25.0495 15.1212 25.0365 15.1324 25.0235 15.1436L25.0063 15.1586C24.9282 15.2271 24.8467 15.2953 24.7586 15.3614C24.7495 15.3683 24.74 15.375 24.7306 15.3816L24.724 15.3863C24.6257 15.4585 24.523 15.5295 24.4131 15.598L24.4037 15.6038C23.8824 15.9279 23.2336 16.2069 22.4845 16.4083V12.3584Z"
      fill="white"
    />
    <path
      d="M22.4845 17.2552C23.917 16.8971 24.967 16.2584 25.6081 15.5111C25.6873 15.4213 25.7586 15.3287 25.8257 15.2345L25.826 18.6659C25.8223 18.6839 25.8197 18.7022 25.8176 18.721C25.7119 19.7249 24.4397 20.7791 22.4845 21.3043V17.2552Z"
      fill="white"
    />
  </svg>
)

export const StarsIcon = ({ className }: { className?: string }) => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    className={className}
  >
    <g clipPath="url(#clip0_3156:7537)">
      <path
        d="M15.5319 4.94739C14.5807 4.94739 13.6874 5.31433 13.0162 5.98071C12.3453 6.64673 11.976 7.53381 11.976 8.47852C11.976 8.73743 11.766 8.94727 11.5072 8.94727C11.2483 8.94727 11.0385 8.73743 11.0385 8.47852C11.0385 7.53381 10.6689 6.64673 9.99805 5.98071C9.32691 5.31433 8.43359 4.94739 7.48242 4.94739C7.22351 4.94739 7.01367 4.73755 7.01367 4.47864C7.01367 4.21973 7.22351 4.00989 7.48242 4.00989C9.44312 4.00989 11.0385 2.42115 11.0385 0.468388C11.0385 0.209476 11.2483 -0.000362396 11.5072 -0.000362396C11.766 -0.000362396 11.976 0.209476 11.976 0.468388C11.976 2.42115 13.5712 4.00989 15.5319 4.00989C15.7908 4.00989 16.0006 4.21973 16.0006 4.47864C16.0006 4.73755 15.7908 4.94739 15.5319 4.94739ZM11.5072 2.45923C11.0719 3.32996 10.3604 4.04053 9.48779 4.47608C9.91565 4.68823 10.3107 4.96997 10.6586 5.31543C11.0081 5.66235 11.2928 6.05664 11.5071 6.48389C11.7214 6.05664 12.0062 5.66235 12.3556 5.31543C12.7035 4.96997 13.0986 4.68823 13.5264 4.47608C12.6539 4.04053 11.9424 3.32996 11.5072 2.45923Z"
        fill="currentColor"
      />
      <path
        d="M6.41357 8.61328C5.03308 8.61328 3.90991 9.72815 3.90991 11.0986C3.90991 11.3574 3.70007 11.5674 3.44116 11.5674C3.18225 11.5674 2.97241 11.3574 2.97241 11.0986C2.97241 9.72815 1.84924 8.61328 0.46875 8.61328C0.209839 8.61328 0 8.40332 0 8.14453C0 7.88562 0.209839 7.67578 0.46875 7.67578C1.84924 7.67578 2.97241 6.55737 2.97241 5.18274C2.97241 4.92395 3.18225 4.71399 3.44116 4.71399C3.70007 4.71399 3.90991 4.92395 3.90991 5.18274C3.90991 6.55737 5.03308 7.67578 6.41357 7.67578C6.67249 7.67578 6.88232 7.88562 6.88232 8.14453C6.88232 8.40332 6.67249 8.61328 6.41357 8.61328ZM3.44116 6.90979C3.14221 7.41919 2.71521 7.84534 2.20459 8.14392C2.71521 8.4419 3.14221 8.86707 3.44116 9.37537C3.74011 8.86707 4.16711 8.4419 4.67773 8.14392C4.16711 7.84534 3.74011 7.41931 3.44116 6.90979Z"
        fill="currentColor"
      />
      <path
        d="M7.17578 12.7607C8.19104 12.7607 9.01709 11.941 9.01709 10.9336C9.01709 10.6748 9.22693 10.4648 9.48584 10.4648C9.74475 10.4648 9.95459 10.6748 9.95459 10.9336C9.95459 11.9443 10.7806 12.7666 11.7959 12.7666C12.0548 12.7666 12.2646 12.9766 12.2646 13.2354C12.2646 13.4943 12.0548 13.7041 11.7959 13.7041C10.7806 13.7041 9.95459 14.5238 9.95459 15.5312C9.95459 15.7902 9.74475 16 9.48584 16C9.22693 16 9.01709 15.7902 9.01709 15.5312C9.01709 14.5205 8.19104 13.6982 7.17578 13.6982C6.91687 13.6982 6.70703 13.4884 6.70703 13.2295C6.70703 12.9706 6.91687 12.7607 7.17578 12.7607ZM9.48694 13.9945C9.68921 13.6947 9.94885 13.4363 10.2501 13.2349C9.94775 13.0323 9.68738 12.7722 9.48474 12.4703C9.28247 12.7701 9.02283 13.0286 8.72156 13.23C9.02393 13.4325 9.28442 13.6926 9.48694 13.9945Z"
        fill="currentColor"
      />
    </g>
    <defs>
      <clipPath id="clip0_3156:7537">
        <rect
          width="16"
          height="16"
          fill="white"
          transform="matrix(1 0 0 -1 0 16)"
        />
      </clipPath>
    </defs>
  </svg>
)
