<div align="center">
  <img width="500" src="../assets/dle.svg" border="0" />
  <sub><br /><a href="./README.german.md">Deutsch</a> | <a href="./README.portuguese-br.md">Português (BR)</a> | <a href="./README.russian.md">Русский</a> | <a href="./README.spanish.md">Español</a> | <a href="./README.ukrainian.md">Українська</a></sub>
</div>

<br />

<div align="center"><h1 align="center">Database Lab Engine (DLE)</h1></div>

<div align="center">
  <a href="https://twitter.com/intent/tweet?via=Database_Lab&url=https://github.com/postgres-ai/database-lab-engine/&text=Thin%20@PostgreSQL%20clones%20–%20DLE%20provides%20blazing-fast%20database%20cloning%20to%20build%20powerful%20development,%20test,%20QA,%20staging%20environments.">
    <img src="https://img.shields.io/twitter/url/https/github.com/postgres-ai/database-lab-engine.svg?style=for-the-badge" alt="twitter">
  </a>
</div>

<div align="center">
  <strong>:zap: Blitzschnelles Klonen von PostgreSQL-Datenbanken :elephant:</strong><br>
  Thin Clons von PostgreSQL zum Erstellen leistungsstarker Entwicklungs-, Test-, QA- und Staging-Umgebungen.<br>
  <sub>Verfügbar für jedes PostgreSQL, einschließlich AWS RDS, GCP CloudSQL, Heroku, Digital Ocean und selbstverwalteter Instanzen.</sub>
</div>

<br />

<div align="center">
  <a href="https://postgres.ai" target="blank"><img src="https://img.shields.io/badge/Postgres-AI-orange.svg?style=flat" /></a> <a href="https://github.com/postgres-ai/database-lab-engine/releases/latest"><img src="https://img.shields.io/github/v/release/postgres-ai/database-lab-engine?color=orange&label=Database+Lab&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACYAAAAYCAYAAACWTY9zAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAPYSURBVHgBrVc9SCNBFH7JpVCrjdpotVgFES9qp8LdgaXNFWLnJY2lsVC0zIGKQeEujRw2508lNndqISKaA38a/4Io/qBGQc2B6IKgImLufYPj7W42Jsb9YNidb2ffvHnzzZsZB1mgra3to9Pp9Docjvdc9XJR3G63qm9zdXUV44fGJZZIJKKPj4+R/v7+CNkEh3wJBoPKzc1NIC8vr7WoqEgpLS2l4uJiYodEscLd3R2dnZ2Jcnh4SNvb23ByiG2E2R6cpo6Oju/s9EZfX9+Q/C8F95O5P5ITjnV2dqq5ubnz1dXVam1tLeXk5FA24CjS6uoqLS4uxtjpT729vbGLi4ujubk5lflf3IcfDuu4CHOfJbe8vKwuLCwITno7f3p6mrALBwcHCdiEba4egYP97u7uYDru8vIy0dPT8835NFg1Pz+f7MLT1Kt6DrIoKyv7ko7Dvx6Pxycdo3A4LKbirYDWRkdHLb/t7u5mxO3t7SkuWWlubhYGoa+qqiriBSBGlAkwoK2tLYhf1Ovr62lwcNDwfXJykgoLCzPiELVnx1BpaWkRK2xtbU2IGA3Bw1kWpMGZ29tb0jRNPNGmpKSE6urqxFOPgYEBcrlcwtmVlZWMOF48/x2TQJT0kZIpwQzpbKpUIuHz+YjTh4FrbGykgoKCFzmX3gGrNAHOHIXXwOwUYHbKinsWP+YWzr0VsDE+Pp7EQxZmoafisIAMGoNgkfFl1n8NMN0QP7RZU1Nj+IaOZmdnDUJ/iTOIH8LFasTHqakp0ZHUG6bTrCUpfk6I4h+0w4ACgYBoDxsAbzFUUVFBTU1NNDMzkxGH2TOIH53DORQZBdm5Ocehc6SUyspKQnJOtY21t7dnxSWtSj3MK/StQJQz4aDTZ/Fjbu2ClS1EfGdnJ4k7OTlJ4jBTLj2B1YRpzDY9SPHqp5WPUrS0tCQ64z3QwKG9FL+eM4i/oaFBkHzsoJGREeFcOvGfn5+LJ/7DO9rI7M9HKdFubGyMysvLBT8xMWHgsA1acQiQQWMwKKOFzuQBEOI35zg4gcyvKArhDCcHYIbf78+KSyl+vZN24f7+XjNzVuJHOyn+GCJjF5721pieQ+Ll8lvPoc/19fUkbnNzc1hEjC8dfj7yzHPGViH+dBtzKmC6oVEcrWETHJ+tKBqNwqlwKBQKWnCtVtw7kGxM83q9w8fHx3/ZqIdHrFxfX9PDw4PQEY4jVsBKhuhxFpuenkbR9vf3Q9ze39XVFUcb3sTd8Xj8K3f2Q/6XCeew6pBX1Ee+seD69oGrChfV6vrGR3SN22zg+sbXvQ2+fETIJvwDtXvnpBGzG2wAAAAASUVORK5CYII=" alt="Neueste Erscheinung" /></a>

  <a href="https://gitlab.com/postgres-ai/database-lab/-/pipelines" target="blank"><img src="https://gitlab.com/postgres-ai/database-lab//badges/master/pipeline.svg" alt="CI pipeline status" /></a> <a href="https://goreportcard.com/report/gitlab.com/postgres-ai/database-lab" target="blank"><img src="https://goreportcard.com/badge/gitlab.com/postgres-ai/database-lab" alt="Go report" /></a>  <a href="https://depshield.github.io" target="blank"><img src="https://depshield.sonatype.org/badges/postgres-ai/database-lab-engine/depshield.svg" alt="DepShield Badge" /></a>

  <a href="../CODE_OF_CONDUCT.md"><img src="https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg?logoColor=black&labelColor=white&color=blue" alt="Contributor Covenant" /></a> <a href="https://slack.postgres.ai" target="blank"><img src="https://img.shields.io/badge/Chat-Slack-blue.svg?logo=slack&style=flat&logoColor=black&labelColor=white&color=blue" alt="Community Slack" /></a> <a href="https://twitter.com/intent/follow?screen_name=Database_Lab" target="blank"><img src="https://img.shields.io/twitter/follow/Database_Lab.svg?style=social&maxAge=3600" alt="Twitter Follow" /></a>
</div>

<div align="center">
  <h3>
    <a href="#features">Funktionen</a>
    <span> | </span>
    <a href="https://postgres.ai/docs">Dokumentation</a>
    <span> | </span>
    <a href="https://postgres.ai/blog/tags/database-lab-engine">Blog</a>
    <span> | </span>
    <a href="#community--support">Community & Support</a>
    <span> | </span>
    <a href="../CONTRIBUTING.md">Contributing</a>
  </h3>
</div>

## Warum DLE?
- Sie können Entwicklungs-/QA-/Staging-Umgebungen basierend auf produktionsähnlichen Datenbanken in voller Größe erstellen.
- Sie können temporäre Datenbankklone in voller Größe für die Analyse und Optimierung von SQL-Abfragen bereitstellen (siehe auch: [SQL-Optimierungs-Chatbot Joe](https://gitlab.com/postgres-ai/joe)).
- Sie können Datenbankänderungen in CI/CD-Pipelines automatisch testen, um Störungen in der Produktion zu vermeiden.

Zum Beispiel dauert das Klonen einer PostgreSQL-Datenbank mit 1 TiB ca. 10 Sekunden. Dutzende von unabhängigen Klonen laufen auf einem einzigen Computer und unterstützen viele Entwicklungs- und Testaktivitäten, ohne die Kosten für Hardware zu erhöhen.

<p><img src="../assets/dle-demo-animated.gif" border="0" /></p>

Probieren Sie es gleich selbst aus:
- Geben Sie [die Database Lab Platform](https://console.postgres.ai/) ein, schließen Sie sich der "Demo"-Organisation an und testen Sie das Klonen von ~1 TiB-Demodatenbank, oder
- Probieren Sie ein anderes Demo-Setup, DLE CE: https://nik-tf-test.aws.postgres.ai:446/instance, verwenden Sie das Token „demo“, um es einzugeben (dieses Setup hat selbstsignierte Zertifikate, ignorieren Sie also die Beschwerden des Browsers).

## Wie es funktioniert
Thin Cloning ist schnell, weil es [Copy-on-Write (CoW)](https://en.wikipedia.org/wiki/Copy-on-write#In_computer_storage) verwendet. DLE unterstützt zwei Technologien, um CoW und Thin Cloning zu ermöglichen: [ZFS](https://en.wikipedia.org/wiki/ZFS) (Standard) und [LVM](https://en.wikipedia.org/wiki/Logical_Volume_Manager_ (Linux)).

Mit ZFS erstellt Database Lab Engine regelmäßig einen neuen Snapshot des Datenverzeichnisses und macht eine Reihe von Snapshots, wobei alte und nicht verwendete Snapshots gelöscht werden. Beim Anfordern eines neuen Klons können die Benutzer auswählen, welchen Snapshot zu verwenden.

Weiterlesen:
- [Wie es funktioniert](https://postgres.ai/products/how-it-works)
- [Testen der Datenbankmigration](https://postgres.ai/products/database-migration-testing)
- [SQL-Optimierung mit Joe Bot](https://postgres.ai/products/joe)
- [Fragen und Antworten](https://postgres.ai/docs/questions-and-answers)

## Wo soll man anfangen
- [Database Lab-Tutorial für jede PostgreSQL-Datenbank](https://postgres.ai/docs/tutorials/database-lab-tutorial)
- [Database Lab-Tutorial für Amazon RDS](https://postgres.ai/docs/tutorials/database-lab-tutorial-amazon-rds)
- [Terraform-Modulvorlage (AWS)](https://postgres.ai/docs/how-to-guides/administration/install-database-lab-with-terraform)

## Fallstudien
- Qiwi: [Wie Qiwi die Daten kontrolliert, um die Entwicklung zu beschleunigen](https://postgres.ai/resources/case-studies/qiwi)
- GitLab: [Wie GitLab die SQL-Leistungsoptimierung durchführt, um das Risiko von Ausfallzeiten zu reduzieren](https://postgres.ai/resources/case-studies/gitlab)

## Merkmale
- Blitzschnelles Klonen von Postgres-Datenbanken. Es wird ein paar Sekunden gebraucht, um einen neuen Klon zu erstellen, der bereit ist, Verbindungen und Abfragen zu akzeptieren, unabhängig von der Datenbankgröße.
- Die theoretische maximale Anzahl von Snapshots und Klonen beträgt 2<sup>64</sup> ([ZFS](https://en.wikipedia.org/wiki/ZFS), Standard).
- Theoretische maximale Größe des PostgreSQL-Datenverzeichnisses: 256 Billiarden Zebibyte oder 2<sup>128</sup> Byte ([ZFS](https://en.wikipedia.org/wiki/ZFS), Standard).
- Unterstützte Hauptversionen von PostgreSQL: 9.6–14.
- Zwei Technologien werden unterstützt, um Thin Cloning zu ermöglichen ([CoW](https://en.wikipedia.org/wiki/Copy-on-write)): [ZFS](https://en.wikipedia.org/wiki/ ZFS) und [LVM](https://en.wikipedia.org/wiki/Logical_Volume_Manager_(Linux)).
- Alle Komponenten sind in Docker-Containern verpackt.
- UI macht die manuelle Arbeit bequemer.
- API und CLI zur Automatisierung der Arbeit mit DLE-Snapshots und Clones.
- Standardmäßig enthalten PostgreSQL-Container viele beliebte Erweiterungen ([docs](https://postgres.ai/docs/database-lab/supported-databases#extensions-included-by-default)).
- PostgreSQL-Container können angepasst werden ([docs](https://postgres.ai/docs/database-lab/supported-databases#how-to-add-more-extensions)).
- Die Quelldatenbank kann sich überall befinden (selbstverwaltetes Postgres, AWS RDS, GCP CloudSQL, Azure, Timescale Cloud usw.) und erfordert KEINE Anpassungen. Es gibt KEINE Anforderungen, ZFS oder Docker in den Quelldatenbanken (Produktionsdatenbanken) zu installieren.
- Die anfängliche Datenbereitstellung kann entweder auf physischer (pg_basebackup, Sicherungs-/Archivierungstools wie WAL-G oder pgBackRest) oder auf logischer Ebene (Dump/Wiederherstellung direkt von der Quelle oder von Dateien, die in AWS S3 gespeichert sind) erfolgen.
- Für den logischen Modus wird der partielle Datenabruf unterstützt (bestimmte Datenbanken, bestimmte Tabellen).
- Für den physischen Modus wird ein kontinuierlich aktualisierter Status ("Sync-Container") unterstützt, was DLE zu einer spezialisierten Version von Standby-Postgres macht.
– Für den logischen Modus wird die regelmäßige vollständige Aktualisierung von DLE unterstützt, automatisiert und gesteuert. Es ist möglich, mehrere Datenträger mit unterschiedlichen Versionen der Datenbank zu verwenden, sodass eine vollständige Aktualisierung keine Ausfallzeit erfordert.
- Fast Point-in-Time-Recovery (PITR) zu den Punkten, die in DLE-Snapshots verfügbar sind.
- Nicht verwendete Klone werden automatisch gelöscht.
- Das Flag "Löschschutz" kann verwendet werden, um das automatische oder manuelle Löschen von Klonen zu blockieren.
– Snapshot-Aufbewahrungsrichtlinien werden in der DLE-Konfiguration unterstützt.
- Dauerhafte Klone: ​​Klone überleben DLE-Neustarts (einschließlich vollständiger VM-Neustarts).
- Mit dem Befehl „reset“ kann auf eine andere Version der Daten umgeschaltet werden.
- Die Komponente DB Migration Checker sammelt verschiedene Artefakte, die für DB-Tests in CI nützlich sind ([docs](https://postgres.ai/docs/db-migration-checker)).
- SSH-Portweiterleitung für API- und Postgres-Verbindungen.
- Docker-Container-Konfigurationsparameter können in der DLE-Konfiguration angegeben werden.
- Ressourcennutzungskontingente für Klone: ​​CPU, RAM (Containerkontingente, unterstützt von Docker)
- Postgres-Konfigurationsparameter können in der DLE-Konfiguration angegeben werden (getrennt für Klone, den „Sync“-Container und den „Promote“-Container).
- Überwachung: auth-freier `/healthz` API-Endpunkt, erweitertes `/status` (erfordert auth), [Netdata module](https://gitlab.com/postgres-ai/netdata_for_dle).

## Beitrag leisten
### Geben Sie dem Projekt einen Stern
Der einfachste Weg, einen Beitrag zu leisten, besteht darin, dem Projekt einen GitHub/GitLab-Stern zu geben:

![Stern hinzufügen](../assets/star.gif)

### Weitersagen
Posten Sie einen Tweet mit der Erwähnung von [@Database_Lab](https://twitter.com/Database_Lab) oder teilen Sie den Link zu diesem Repo in Ihrem bevorzugten sozialen Netzwerk.

Wenn Sie DLE aktiv nutzen, erzählen Sie anderen von Ihren Erfahrungen. Sie können das unten referenzierte und im Ordner „./assets“ gespeicherte Logo verwenden. Sie können sie gerne in Ihre Dokumente, Präsentationen, Anwendungen und Website-Schnittstellen einfügen, um zu zeigen, dass Sie DLE verwenden.

HTML-Snippet für hellere Hintergründe:
<p>
  <img width="400" src="https://postgres.ai/assets/powered-by-dle-for-light-background.svg" />
</p>

```html
<a href="http://databaselab.io">
  <img width="400" src="https://postgres.ai/assets/powered-by-dle-for-light-background.svg" />
</a>
```

Für dunklere Hintergründe:
<p style="background-color: #bbb">
  <img width="400" src="https://postgres.ai/assets/powered-by-dle-for-dark-background.svg" />
</p>

```html
<a href="http://databaselab.io">
  <img width="400" src="https://postgres.ai/assets/powered-by-dle-for-dark-background.svg" />
</a>
```

### Schlagen Sie eine Idee vor oder melden Sie einen Fehler
Weitere Informationen finden Sie in unserem [Contributing Guide](../CONTRIBUTING.md).

### Beteiligen Sie sich an der Entwicklung
Weitere Informationen finden Sie in unserem [Contributing Guide](../CONTRIBUTING.md).

### Übersetze die README
Database Lab Engine für Ingenieure auf der ganzen Welt zugänglicher zu machen, ist eine große Hilfe für das Projekt. Einzelheiten finden Sie im [Übersetzungsabschnitt des Contributing Guide](../CONTRIBUTING.md#Translation).

### Referenzhandbücher
- [DLE-Komponenten](https://postgres.ai/docs/reference-guides/database-lab-engine-components)
- [DLE-Konfigurationsreferenz](https://postgres.ai/docs/database-lab/config-reference)
- [DLE-API-Referenz](https://postgres.ai/swagger-ui/dblab/)
- [Client-CLI-Referenz](https://postgres.ai/docs/database-lab/cli-reference)

### Anleitungen
- [So installieren Sie Database Lab mit Terraform auf AWS](https://postgres.ai/docs/how-to-guides/administration/install-database-lab-with-terraform)
- [How to install and initialize Database Lab CLI](https://postgres.ai/docs/guides/cli/cli-install-init)
- [DLE verwalten](https://postgres.ai/docs/how-to-guides/administration)
- [Arbeiten mit Klonen](https://postgres.ai/docs/how-to-guides/cloning)

Weitere Informationen finden Sie im [Abschnitt „Anleitungen“](https://postgres.ai/docs/how-to-guides) der Dokumentation.

### Sonstig
- [DLE-Docker-Images](https://hub.docker.com/r/postgresai/dblab-server)
- [Erweiterte Docker-Images für PostgreSQL (mit vielen Erweiterungen)](https://hub.docker.com/r/postgresai/extended-postgres)
- [SQL-Optimierungs-Chatbot (Joe Bot)](https://postgres.ai/docs/joe-bot)
- [DB-Migrationsprüfer](https://postgres.ai/docs/db-migration-checker)

## Lizenz
Der DLE-Quellcode ist unter der vom OSI genehmigten Open-Source-Lizenz GNU Affero General Public License Version 3 (AGPLv3) lizenziert.

Wenden Sie sich an das Postgres.ai-Team, wenn Sie eine Test- oder kommerzielle Lizenz wünschen, die die GPL-Klauseln nicht enthält: [Kontaktseite](https://postgres.ai/contact).

## Gemeinschaftliche Unterstützung
- ["Verhaltenskodex der Database Lab Engine Community Covenant"](../CODE_OF_CONDUCT.md)
- Wo Sie Hilfe bekommen: [Kontaktseite](https://postgres.ai/contact)
- [Community-Slack](https://slack.postgres.ai)
- Wenn Sie ein Sicherheitsproblem melden müssen, befolgen Sie die Anweisungen in den ["Database Lab Engine-Sicherheitsrichtlinien"](../SECURITY.md).

[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg?color=blue)](../CODE_OF_CONDUCT.md)
