# coding: utf-8

"""
    Patch API V2

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: 2
    Contact: engineering@usepatch.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from patch_api.configuration import Configuration


class CreateOrderRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "project_id": "str",
        "metadata": "object",
        "state": "str",
        "vintage_year": "int",
        "vintage_start_year": "int",
        "vintage_end_year": "int",
        "total_price": "int",
        "currency": "str",
        "amount": "int",
        "unit": "str",
        "issued_to": "OrderIssuedTo",
    }

    attribute_map = {
        "project_id": "project_id",
        "metadata": "metadata",
        "state": "state",
        "vintage_year": "vintage_year",
        "vintage_start_year": "vintage_start_year",
        "vintage_end_year": "vintage_end_year",
        "total_price": "total_price",
        "currency": "currency",
        "amount": "amount",
        "unit": "unit",
        "issued_to": "issued_to",
    }

    def __init__(
        self,
        project_id=None,
        metadata=None,
        state=None,
        vintage_year=None,
        vintage_start_year=None,
        vintage_end_year=None,
        total_price=None,
        currency=None,
        amount=None,
        unit=None,
        issued_to=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """CreateOrderRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._project_id = None
        self._metadata = None
        self._state = None
        self._vintage_year = None
        self._vintage_start_year = None
        self._vintage_end_year = None
        self._total_price = None
        self._currency = None
        self._amount = None
        self._unit = None
        self._issued_to = None
        self.discriminator = None

        self.project_id = project_id
        self.metadata = metadata
        self.state = state
        self.vintage_year = vintage_year
        self.vintage_start_year = vintage_start_year
        self.vintage_end_year = vintage_end_year
        self.total_price = total_price
        self.currency = currency
        self.amount = amount
        self.unit = unit
        if issued_to is not None:
            self.issued_to = issued_to

    @property
    def project_id(self):
        """Gets the project_id of this CreateOrderRequest.  # noqa: E501


        :return: The project_id of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this CreateOrderRequest.


        :param project_id: The project_id of this CreateOrderRequest.  # noqa: E501
        :type: str
        """

        self._project_id = project_id

    @property
    def metadata(self):
        """Gets the metadata of this CreateOrderRequest.  # noqa: E501


        :return: The metadata of this CreateOrderRequest.  # noqa: E501
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this CreateOrderRequest.


        :param metadata: The metadata of this CreateOrderRequest.  # noqa: E501
        :type: object
        """

        self._metadata = metadata

    @property
    def state(self):
        """Gets the state of this CreateOrderRequest.  # noqa: E501


        :return: The state of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CreateOrderRequest.


        :param state: The state of this CreateOrderRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None, "draft", "reserved", "placed"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and state not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}".format(  # noqa: E501
                    state, allowed_values
                )
            )

        self._state = state

    @property
    def vintage_year(self):
        """Gets the vintage_year of this CreateOrderRequest.  # noqa: E501


        :return: The vintage_year of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._vintage_year

    @vintage_year.setter
    def vintage_year(self, vintage_year):
        """Sets the vintage_year of this CreateOrderRequest.


        :param vintage_year: The vintage_year of this CreateOrderRequest.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and vintage_year is not None
            and vintage_year > 2225
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `vintage_year`, must be a value less than or equal to `2225`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and vintage_year is not None
            and vintage_year < 1900
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `vintage_year`, must be a value greater than or equal to `1900`"
            )  # noqa: E501

        self._vintage_year = vintage_year

    @property
    def vintage_start_year(self):
        """Gets the vintage_start_year of this CreateOrderRequest.  # noqa: E501


        :return: The vintage_start_year of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._vintage_start_year

    @vintage_start_year.setter
    def vintage_start_year(self, vintage_start_year):
        """Sets the vintage_start_year of this CreateOrderRequest.


        :param vintage_start_year: The vintage_start_year of this CreateOrderRequest.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and vintage_start_year is not None
            and vintage_start_year > 2225
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `vintage_start_year`, must be a value less than or equal to `2225`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and vintage_start_year is not None
            and vintage_start_year < 1900
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `vintage_start_year`, must be a value greater than or equal to `1900`"
            )  # noqa: E501

        self._vintage_start_year = vintage_start_year

    @property
    def vintage_end_year(self):
        """Gets the vintage_end_year of this CreateOrderRequest.  # noqa: E501


        :return: The vintage_end_year of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._vintage_end_year

    @vintage_end_year.setter
    def vintage_end_year(self, vintage_end_year):
        """Sets the vintage_end_year of this CreateOrderRequest.


        :param vintage_end_year: The vintage_end_year of this CreateOrderRequest.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and vintage_end_year is not None
            and vintage_end_year > 2225
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `vintage_end_year`, must be a value less than or equal to `2225`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and vintage_end_year is not None
            and vintage_end_year < 1900
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `vintage_end_year`, must be a value greater than or equal to `1900`"
            )  # noqa: E501

        self._vintage_end_year = vintage_end_year

    @property
    def total_price(self):
        """Gets the total_price of this CreateOrderRequest.  # noqa: E501


        :return: The total_price of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._total_price

    @total_price.setter
    def total_price(self, total_price):
        """Sets the total_price of this CreateOrderRequest.


        :param total_price: The total_price of this CreateOrderRequest.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and total_price is not None
            and total_price < 2
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `total_price`, must be a value greater than or equal to `2`"
            )  # noqa: E501

        self._total_price = total_price

    @property
    def currency(self):
        """Gets the currency of this CreateOrderRequest.  # noqa: E501


        :return: The currency of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this CreateOrderRequest.


        :param currency: The currency of this CreateOrderRequest.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def amount(self):
        """Gets the amount of this CreateOrderRequest.  # noqa: E501


        :return: The amount of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this CreateOrderRequest.


        :param amount: The amount of this CreateOrderRequest.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and amount is not None
            and amount > 100000000000000
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `amount`, must be a value less than or equal to `100000000000000`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and amount is not None
            and amount < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `amount`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._amount = amount

    @property
    def unit(self):
        """Gets the unit of this CreateOrderRequest.  # noqa: E501


        :return: The unit of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """Sets the unit of this CreateOrderRequest.


        :param unit: The unit of this CreateOrderRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None, "g"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and unit not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `unit` ({0}), must be one of {1}".format(  # noqa: E501
                    unit, allowed_values
                )
            )

        self._unit = unit

    @property
    def issued_to(self):
        """Gets the issued_to of this CreateOrderRequest.  # noqa: E501


        :return: The issued_to of this CreateOrderRequest.  # noqa: E501
        :rtype: OrderIssuedTo
        """
        return self._issued_to

    @issued_to.setter
    def issued_to(self, issued_to):
        """Sets the issued_to of this CreateOrderRequest.


        :param issued_to: The issued_to of this CreateOrderRequest.  # noqa: E501
        :type: OrderIssuedTo
        """

        self._issued_to = issued_to

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateOrderRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateOrderRequest):
            return True

        return self.to_dict() != other.to_dict()
