/// **************************************************************************
/// Copyright 2022, Optimizely, Inc. and contributors                        *
///                                                                          *
/// Licensed under the Apache License, Version 2.0 (the "License");          *
/// you may not use this file except in compliance with the License.         *
/// You may obtain a copy of the License at                                  *
///                                                                          *
///    http://www.apache.org/licenses/LICENSE-2.0                            *
///                                                                          *
/// Unless required by applicable law or agreed to in writing, software      *
/// distributed under the License is distributed on an "AS IS" BASIS,        *
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. *
/// See the License for the specific language governing permissions and      *
/// limitations under the License.                                           *
///**************************************************************************/

import 'package:optimizely_flutter_sdk/src/utils/constants.dart';

class LogEventListenerResponse {
  String url = '';
  Map<String, dynamic> params = {};

  LogEventListenerResponse(Map<String, dynamic> json) {
    if (json[Constants.url] is String) {
      url = json[Constants.url];
    }

    if (json[Constants.params] is Map<dynamic, dynamic>) {
      params = Map<String, dynamic>.from(json[Constants.params]);
    }
  }
}
