//
//  CurrencyCompactor.swift
//
// Copyright 2021 FlowAllocator LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

import Foundation

public class CurrencyCompactor: NumberCompactor {
    
    @available(*, deprecated, message: "use init(ifZero: String?, roundSmallToWhole: Bool) instead")
    public convenience init(blankIfZero: Bool = false,
                            roundSmallToWhole: Bool = true) {
        self.init(ifZero: blankIfZero ? "" : nil,
                  roundSmallToWhole: roundSmallToWhole)
    }
    
    public override init(ifZero: String? = nil,
                         roundSmallToWhole: Bool = true) {
        
        super.init(ifZero: ifZero,
                   roundSmallToWhole: roundSmallToWhole)
        
        self.numberStyle = .currency
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
