# StackableTableView

A `UITableView` subclass that enables setting an array of views for both headers and footers utilizing `UIStackView`

[![Version](https://img.shields.io/cocoapods/v/StackableTableView.svg?style=flat)](https://cocoapods.org/pods/StackableTableView)
[![License](https://img.shields.io/cocoapods/l/StackableTableView.svg?style=flat)](https://cocoapods.org/pods/StackableTableView)
[![Platform](https://img.shields.io/cocoapods/p/StackableTableView.svg?style=flat)](https://cocoapods.org/pods/StackableTableView)

![Demo](https://github.com/omaralbeik/StackableTableView/blob/master/Assets/demo.gif)

## Requirements

- iOS 11.0+

## Installation

### Swift Package Manager (Recommended)

Once you have your Swift package set up, adding `StackableTableView` as a dependency is as easy as adding it to the dependencies value of your `Package.swift`.

```swift
dependencies: [
    .package(url: "https://github.com/omaralbeik/StackableTableView.git", from: "0.1.0")
]
```

### CocoaPods

To integrate `StackableTableView` into your Xcode project using [CocoaPods](http://cocoapods.org), specify it in your `Podfile`

```ruby
pod 'StackableTableView'
```

### Carthage

To integrate StackableTableView into your Xcode project using [Carthage](https://github.com/Carthage/Carthage), specify it in your `Cartfile`

```ruby
github "omaralbeik/StackableTableView" ~> 0.1.0
```

### Manually

Add the [Sources](<a href="https://github.com/omaralbeik/StackableTableView/tree/master/Sources">) folder to your Xcode project.

## License

StackableTableView is available under the MIT license. See the [LICENSE](https://github.com/omaralbeik/StackableTableView/blob/master/LICENSE) file for more info.
