# Integrating with Backend Framework

If you are building a purely-static app (one that is deployed separately from the backend API), then you probably don't even need to edit `config/index.js`. However, if you want to integrate this template with an existing backend framework, e.g. Rails/Django/Laravel, which comes with their own project structures, you can edit `config/index.js` to directly generate front-end assets into your backend project.

Let's take a look at the default `config/index.js`:

``` js
// config/index.js
var path = require('path')

module.exports = {
  build: {
    index: path.resolve(__dirname, 'dist/index.html'),
    assetsRoot: path.resolve(__dirname, 'dist'),
    assetsSubDirectory: 'static',
    assetsPublicPath: '/',
    productionSourceMap: true
  },
  dev: {
    port: 8080,
    proxyTable: {}
  }
}
```

Inside the `build` section, we have the following options:

### `build.index`

> Must be an absolute path on your local file system.

This is where the `index.html` (with injected asset URLs) will be generated.

If you are using this template with a backend-framework, you can edit `index.html` accordingly and point this path to a view file rendered by your backend app, e.g. `app/views/layouts/application.html.erb` for a Rails app, or `resources/views/index.blade.php` for a Laravel app.

### `build.assetsRoot`

> Must be an absolute path on your local file system.

This should point to the root directory that contains all the static assets for your app. For example, `public/` for both Rails/Laravel.

### `build.assetsSubDirectory`

Nest webpack-generated assets under this directory in `build.assetsRoot`, so that they are not mixed with other files you may have in `build.assetsRoot`. For example, if `build.assetsRoot` is `/path/to/dist`, and `build.assetsSubDirectory` is `static`, then all Webpack assets will be generated in `path/to/dist/static`.

This directory will be cleaned before each build, so it should only contain assets generated by the build.

Files inside `static/` will be copied into this directory as-is during build. This means if you change this prefix, all your absolute URLs referencing files in `static/` will also need to be changed. See [Handling Static Assets](static.md) for more details.

### `build.assetsPublicPath`

This should be the URL path where your `build.assetsRoot` will be served from over HTTP. In most cases, this will be root (`/`). Only change this if your backend framework serves static assets with a path prefix. Internally, this is passed to Webpack as `output.publicPath`.

### `build.productionSourceMap`

Whether to generate source maps for production build.

### `dev.port`

Specify the port for the dev server to listen to.

### `dev.proxyTable`

Define proxy rules for the dev server. See [API Proxying During Development](proxy.md) for more details.
