For support and discussions, please use our [Discourse forums](https://discourse.mozilla.org/c/deep-speech).

If you've found a bug, or have a feature request, then please create an issue with the following information:

- **Have I written custom code (as opposed to running examples on an unmodified clone of the repository)**:
- **OS Platform and Distribution (e.g., Linux Ubuntu 16.04)**:
- **TensorFlow installed from (our builds, or upstream TensorFlow)**:
- **TensorFlow version (use command below)**:
- **Python version**: 
- **Bazel version (if compiling from source)**:
- **GCC/Compiler version (if compiling from source)**:
- **CUDA/cuDNN version**:
- **GPU model and memory**:
- **Exact command to reproduce**:

You can obtain the TensorFlow version with

```bash
python -c "import tensorflow as tf; print(tf.GIT_VERSION, tf.VERSION)"
```

Please describe the problem clearly. Be sure to convey here why it's a bug or a feature request.

Include any logs or source code that would be helpful to diagnose the problem. For larger logs, link to a Gist, not a screenshot. If including tracebacks, please include the full traceback. Try to provide a reproducible test case.
