# CVE-2021-XXXX

| CVSS v3.1 Severity and Metrics | |
|---|---|
| CVSS v3.1 Vector | [AV:N/AC:L/PR:N/UI:N/<br>S:U/C:N/I:N/A:H/E:U/<br>RL:O/RC:C/CR:H/IR:H/<br>AR:M/MAV:N/MAC:L/<br>MPR:N/MUI:N/MS:U/<br>MC:N/MI:N/MA:H](https://nvd.nist.gov/vuln-metrics/cvss/v3-calculator?vector=AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:H/E:F/RL:O/RC:C/CR:H/IR:H/AR:M/MAV:N/MAC:L/MPR:N/MUI:N/MS:C/MC:N/MI:H/MA:H&version=3.1) |
| CVSS Base Score | 10.0 |
| Impact Subscore | 5.8 |
| Exploitability Subscore | 3.9 |
| CVSS Temporal Score | 9.3 |
| CVSS Environmental Score | 9.3 |
| Modified Impact Subscore | 6.1 |
|**Overall CVSS Score** | **9.3 - CRITICAL** |

## Summary

_This vulnerability has not yet been assigned a CVE ID._

MW/Grin versions lower than 5.0.2 skip verification of a rangeproof for an output commitment if that rangeproof had recently been verified, even if the earlier verification was for a different output commitment. This vulnerability can be used to artificially inflate the supply.

**An attacker attempted to exploit this vulnerability in block 1136081 but the attack was ultimately mitigated with a longer proof-of-work chain with proper validation. The attack was not successful in creating long-term undetectable inflaction.**

## Recommended actions

- Nodes should upgrade to 5.0.4

## Background

Grin transactions require rangeproofs to prove that outputs do not commit to negative values. If a rangeproof is insufficiently validated, it would be possible for an attacker to artificially inflate the token supply by minting themselves new tokens.

```
Simple Malicious Tx Example:
Input: [1 grin]
Outputs: [-99 grin][malicious rangeproof] + [100 grin][valid rangeproof]
```

The above inputs and outputs allow an attacker to mint themselves 99 grin without owning outputs containing enough for that amount, while still balancing out to 0. Without a valid rangeproof and sufficient validation logic, this transaction can create undetectable inflation.

In this case, while there was not sufficient validation logic in the MW/Grin implementation, there was in the Grin++ implementation which detected the malicious transaction containing the invalid rangeproof.

### Disclosure

The issue was initially detected by a Grin++ user and was relayed to David Burkett who disclosed the vulnerability to the MW/Grin team. 

As per [Grin's security process document](https://github.com/mimblewimble/grin/blob/master/SECURITY.md#bilateral-responsible-disclosure-agreements), the project does not currently have any established bilateral disclosure agreements. However, in this case, due to the critical nature of the vulnerability, the following disclosures were made:
- Epic Cash
- MimbleWimble Coin

### Timeline of events

- Mar 18 2021 01:50 UTC: A malicious output was created and included in block height `1136081`, hash `0002897182d8cf7631e86d56ad546b7cf0893bda811592aa9312ae633ce04813`[1][2][3]
- Mar 18 2021 08:18 UTC: A Grin++ user informs the Grin++ support channel that their node stopped syncing
- Mar 18 2021 09:03 UTC: The malicious block and invalid output is identified as being the source of the syncing issues
- Mar 18 2021 10:21 UTC: A private keybase channel is created by the Grin Security Team for investigation of the issue
- Mar 18 2021 11:38 UTC: The issue in the code is identified
- Mar 18 2021 12:14 UTC: A fix is submitted as a PR to stop using the faulty cache[5]
- Mar 18 2021 12:42-13:06 UTC: Partial disclosures are made to Epic Cash and MWC to mitigate downstream losses
- Mar 18 2021 14:06 UTC: Version 5.0.2 is released: hotfix to remove bulletproof verification caching
- Mar 18 2021 16:55 UTC: Version 5.0.3 is released: hotfix to rewind invalid block
- Mar 19 2021 02:09 UTC: CVE ID is requested from Mitre
- Mar 19 2021 02:51 UTC: Version 5.0.4 is released: hotfix to rewind bad headers, improve peer ban logic
- Mar 19 2021 21:18 UTC: Valid chain overtakes invalid chain at [block height 1137458](https://grinexplorer.net/block/1137458), network fully healed
- Mar 20 2021 00:57 UTC: [Detailed post](https://forum.grin.mw/t/resolved-d-o-n-o-t-u-s-e-g-r-i-n-g-r-i-n-w-a-l-l-e-t-g-r-i-n-i-r-o-n-b-e-l-l-y-u-n-t-i-l-f-u-r-t-h-e-r-n-o-t-i-c-e/8620/52) on forum publishing initial details of attack and mitigations
- Mar 30 2021 15:00 UTC: Publication of this document in [security repo](https://github.com/mimblewimble/grin-security)

## Technical details

Mimblewimble outputs consist of a pedersen commitment and a rangeproof which proves the commitment is to a non-negative value.

Verification of outputs requires validating the (commitment, rangeproof) pair. This is a computationally expensive operation. A cache was used to track verified rangeproofs to avoid needing to re-verify multiple times. 

The caching logic was incorrect as the cache key was based solely on the rangeproof without guaranteeing consistency of the (commitment, rangeproof) pair. In effect it was possible to "swap out" the rangeproof associated with an output with an arbitrary previously verified rangeproof.

In this case, an attacker was able to reuse a rangeproof from a valid (commitment, rangeproof) pair, where the malicious output is at MMR leaf index 4714977 (using 0 based leaf indices), reusing the rangeproof of output commitment `09d7674490bb1fe7a03c60de29250f4b9c07062ee626e5c4bfc72d7f3940373fa9`[3] in block height `1136064` from MMR leaf index 4714948 (29 outputs earlier).

The malicious rangeproof:
```
635aacb515ebebdb09090788fe46b2a84d9e3d4a53aa074d653263637d9dbc5d1f6141536979592cab9594cc68ccb385c1f5271389e7b048c9fc39ce2b942d190212898616156e33049ef690c23d5fbec496a58b7360a5c44c541da3a1281fc37a0986d6c189e7e969ee147aaacc6cd09cedcf8815115822f5837e84e75e4db8d6992c87693ad6fd3ccce2b6ce05ee2d0b063dbd08cdaf4e921bc639bcfb22490e74911165d534eae238500e488b7bef0339ccd284027ee4b5a9affb30469f0798ec5798f732934607283347ab6306682e30e94b805229453acb7f921f43a2517051e81d01115c1caa0cbde2888bab2cab945d3ea68bcafc28aea8fbed50549105393bc0bdba65db299248481f1440a88c433ef35f4a3579ee9a50b6d3173f75e5be36c311ebff50f3af8faabc222ca4967b233d7c59be2d1c3d94e9806f7fd1dc623c6094ee339e3eebe870ac52954e8754c8470e2e7eebacdb923d103ad2d3d01901fed3e0037f58a92120d9cd8db6db477d388e4acdfc90aa18c6ce2211f37256d8bb7e81f3334a15ce1213e7feee29a516a3b80900814abed963ac70239edba9cf45527344f4df0181049e6d22179fe8903c0bc5dc86075a8845bff2ae0d5773a104181578ef0a995c754a1197c843f629d14aa329c75657d1cb195809e28e91c7dc8631b8ae7d9340a897e8031acbde01dab4065a9f421037d392cd5c4d9d7e6f47e3dc2bfc21b7dd6e9e0f0115d908da506136be90753b6ff2a5b7c82448c7513c7abaebb275ec6253b2203a7c754d27c9fc9f75fcb5a8f7f47b7dc269a601d6cf382c66bc7d07a6c44bf7bea5c19c7f8b53178a4882d1ef832bcce4b95094e3fb3427d84130136922645780a8b3b218b49054fdc7edc868ddc0d0de1e4bb4920d332ac61e7185201b8b3f2c07381e201cca0eebd9fe7e3878a8dcb83981418d
```
with a `proof_hash` of:
```
4afbe41721ff638f2e66155ee2cfe56979df62c5a4297ce8278093ef470c428e
```

## Fix necessity

Without a fix, an attacker could artificially inflate the token supply for up to a week until it would then be detectable when MW/Grin nodes would fail to sync from scratch.

## Fix details

The following steps were taken by nodes when applying the hotfixes:
- Fix rangeproof validation by removing verification cache
- Rewind block 1136081 that contains invalid rangeproof
- Rewind headers with bad blocks built on invalid rangeproof block
- Improve peer banning around serving invalid blocks/headers

The hotfixes were rolled out over a series of releases to heal the network as quickly as possible:
- [v5.0.2](https://github.com/mimblewimble/grin/releases/tag/v5.0.2)
	- [#3598, Removing verifier caches](https://github.com/mimblewimble/grin/pull/3598)
	- Notes: removed verification cache logic
- [v5.0.3](https://github.com/mimblewimble/grin/releases/tag/v5.0.3)
	- [#3600, Rewind bad block](https://github.com/mimblewimble/grin/pull/3600)
	- Notes: not required anymore, was hotfix to help initially heal network beyond the invalid fork
- [v5.0.4](https://github.com/mimblewimble/grin/releases/tag/v5.0.4)
	- [#3603, rewind bad headers, ban on explicit bad headers](https://github.com/mimblewimble/grin/pull/3603)
	- Notes: rewind bad headers no longer required, was hotfix to move beyond invalid fork in some edge cases
	- Notes: peer banning logic should have further improvements

[This issue](https://github.com/mimblewimble/grin/issues/3605) tracks the state of the hotfixes and any further required fixes and changes related to this CVE.

## Links

[1] https://grinexplorer.net/block/0002897182d8cf7631e86d56ad546b7cf0893bda811592aa9312ae633ce04813

[2] https://grinexplorer.net/output/0816a399319c4e77ede3e40f68e37c7d26a904702c7f5102ee2d666f538b1d884c

[3] https://grinexplorer.net/output/09d7674490bb1fe7a03c60de29250f4b9c07062ee626e5c4bfc72d7f3940373fa9

[4] https://github.com/mimblewimble/grin/issues/3605

[5] https://github.com/mimblewimble/grin/pull/3598

[6] https://github.com/mimblewimble/grin/pull/3600

[7] https://github.com/mimblewimble/grin/pull/3603