# CVE-2020-12439

## Summary

During an investigation into how the `output_pos` index in the database is handled during the "rewind" process for Grin nodes versioned lower than v3.1.0, a consensus related issue was discovered that could have potentially allowed an attacker with a large graphrate to craft blocks that could force a node to rewind and apply the blocks, forcing the node out of consensus without a way to recover. This issue was assigned [CVE-2020-12439](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-12439).

## Recommended Actions

- Grin nodes should upgrade to version 3.1.0 or higher.

## Background

### Disclosure

This public disclosure timeline was based on a 90 day window as opposed to 30 or 60 days for a few reasons. The issue was not disclosed by a third party, it was consensus related and it could not wait until the next HF to be fixed. This resulted in the need to monitor the Grin network once the fix was released to determine the ratio of nodes that had successfully upgraded before a public disclosure could safely occur.

Note that while there is not a formal disclosure agreement with Grin++ it was determined that informing the maintainer of Grin++ of the issue would be the best decision for the security of the Grin network so that the Grin++ nodes helping to secure the Grin network could be upgraded as well. This was a result of both the type and possible impact of this particular CVE.

### Timeline of events

- Feb 17 2020: Routine investigation leads to discovery of potential issue
- Feb 21 2020: Potential fix submitted for review
- Feb 24 2020: Fix merged and tagged with v3.1.0 release
- Feb-March 2020: Network monitored for percentage of nodes with updated fix
- March 2020: Vulnerability determined to also be present in Grin++ which is responsible for a nontrivial amount of nodes on the network
- March 26 2020: Grin++ is notified of issue and given time to get their users to upgrade
- May 5 2020: CVE details published once issue has been mitigated for the majority of the Grin network

## Technical Details

UTXOs are unique but outputs may be reused. This means that a UTXO can be spent and recreated with a different position in the output MMR. Previously this was not accounted for in some rewind scenarios. An incorrect position would be used, as the UTXO was assumed to be in the later position when rewound. This could force a node to see a transaction (or block) as invalid, when it would otherwise be correctly seen as valid by other nodes.

## Fix Details

The issue was fixed in [this PR](https://github.com/mimblewimble/grin/pull/3236) by correctly tracking the previous position and was included in the v3.1.0 release.

## Links

https://github.com/mimblewimble/grin/pull/3236

https://github.com/mimblewimble/grin/issues/3235

https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-12439
