# Table of Contents

!!! tip ""
    **This wiki contains a high level technical overview of Grin.**
    For more details about the implentation, please look at the Grin documentation on docs.rs

    - grin: [api](https://docs.rs/grin_api/latest), [core](https://docs.rs/grin_core/latest), [chain](https://docs.rs/grin_chain/latest), [util](https://docs.rs/grin_util/latest), [store](https://docs.rs/grin_store/latest), [keychain](https://docs.rs/grin_keychain/latest), [p2p](https://docs.rs/grin_p2p/latest), [pool](https://docs.rs/grin_pool/latest), [config](https://docs.rs/grin_config/latest), [servers](https://docs.rs/grin_servers/latest).
    - grin_wallet: [wallet_api](https://docs.rs/grin_wallet_api/latest), [wallet](https://docs.rs/grin_wallet/latest).

## Introduction

- [Grin for Bitcoiners](introduction/grin-for-bitcoiners.md) - Explaining Grin from a Bitcoiner's perspective
- [Mimblewimble](introduction/mimblewimble/mimblewimble.md) - A technical introduction to Mimblewimble </br>
    1. [Elliptic Curves](introduction/mimblewimble/ecc.md)
    1. [Commitments](introduction/mimblewimble/commitments.md)
    1. [Mimblewimble](introduction/mimblewimble/mimblewimble.md)

## Transactions

- [Slates](transactions/slates.md)
- [Slatepack](transactions/slatepack.md)
- [Payment Proofs](transactions/payment-proofs.md)
- [Contracts](transactions/contracts.md)

## Blocks

- [Header](blocks/block-header.md)
- [Body](blocks/block-body.md)
- [Fees & Weight](blocks/fees-and-weight.md)

## Chain State

- [Merkle Mountain Ranges](chain-state/merkle-mountain-range.md)
- [State & Pruning](chain-state/state-and-pruning.md)
- [Chain Sync](chain-state/chain-sync.md)

## Miscellaneous

- [Cuckoo Cycle](miscellaneous/cuckoo-cycle.md)
- [Dandelion](miscellaneous/dandelion.md)
- [Switch Commitments](miscellaneous/switch-commitments.md)
- [Coinbase Maturity Rule](miscellaneous/coinbase-maturity-rule.md)
- [NRD Kernels](miscellaneous/nrd-kernels.md)

## API

- [Node API](api/node-api.md)
- [Wallet API](api/wallet-api.md)
- [Stratum RPC](api/stratum-rpc.md)

## Security Process

- [Grin's Security Process](security-process/grin-security-process.md)
- [Security Team](security-process/security-team.md)
- [Code Audits](security-process/code-audits.md)

## Services

- [List of Services](services/list-of-services.md)
- [Slatepack Integration Guide](services/slatepack-integration.md)

## More

- [Resources](resources.md)
