# Code Audits

Continued code reviews and audits are important for the security of Grin.
As such, we highly encourage interested security researchers to:

* Review our code, even if no contributions are planned.
* Publish their findings in accordance with our
[responsible disclosure standard](https://github.com/RD-Crypto-Spec/Responsible-Disclosure/tree/82e08d2736ea9dbe43484a3317e4bce214163bd0#a-standard-for-responsible-disclosure-in-cryptocurrency-and-related-software),
even if no particular bug or vulnerability was found. We can all learn from new
sets of eyes and benefit from increased scrutiny. While we may disagree with some small points of design or trade-offs, we will always do so respectfully.

All code review and audit contributions are welcome regardless of depth, area
or background of the contributor. Many contributions from many different
perspectives can help ensure long term security for the Grin codebase.

!!! note ""
    A complete list of PGP keys, canaries, CVEs and audits can be found in the [grin-security](https://github.com/mimblewimble/grin-security) repository.

## Past Audits

|  Audit     | Results      |
| :--------: | :----------: |
| JP Aumasson, secp256k1 extensions | [report](https://github.com/mimblewimble/grin-security/blob/master/audits/001-secp256k1-extensions-report.pdf) - [status](https://github.com/mimblewimble/grin-security/blob/master/audits/001-secp256k1-extensions-status.md)             |
| Coinspect, code audit v1.0.1      | [report](https://github.com/mimblewimble/grin-security/blob/master/audits/002-coinspect-2019-report.pdf) - [status](https://github.com/mimblewimble/grin-security/blob/master/audits/002-coinspect-2019-status.md)             |
| Nym Seddon, code audit v4.0.0 | [report](https://github.com/mimblewimble/grin-security/blob/master/audits/003-nym-seddon-2020-report.md) - status
