# Resources

## More Documents

- [Build and run automation](extra-documents/build-run-automation.md) 
- [Run a node on google cloud for free](extra-documents/google-cloud-node.md) 
- [How to mine with grin-miner](extra-documents/how-to-mine.md) 
- [Monetary policy](extra-documents/monetary-policy.md) 


## Talks

#### Playlists

- [grincon0](https://www.youtube.com/playlist?list=PLvgCPbagiHgqYdVUj-ylqhsXOifWrExiq) 
- [grinconUS(0)](https://www.youtube.com/playlist?list=PLvgCPbagiHgqOe0z_xgrIsGq-ayVZcNjy) 
- [grinAmsterdam](https://www.youtube.com/playlist?list=PLvgCPbagiHgpJXhrKAJu0Q-mbCVhpqgu7) 
- [grincon1](https://www.youtube.com/playlist?list=PLvgCPbagiHgrQa5KVt4XixK9t_NbfpkuP) 

#### Other

- [Mimblewimble, Scaling Bitcoin'16](https://www.youtube.com/watch?v=8BLWUUPfh2Q&t=1h29m20s) 
- [Mimblewimble, SF Bitcoin Developers`16](https://www.youtube.com/watch?v=aHTRlbCaUyM&t=133s)
- [Mimblewimble, BPASE'17](https://www.youtube.com/watch?v=XiUGu48JTd0&feature=youtu.be)
- [Mimblewimble & Scriptless Scripts, RWC'18](https://www.youtube.com/watch?v=EN-JMlzr8Qw)
- [A View on Grin, HCPP'19](https://www.youtube.com/watch?v=NShVKX6Ra7Y), [Slides](https://docs.google.com/presentation/d/1PbtPV8WwDcWdnqBZHUMU7Cgr0P98NzDnuRRt2y251nU/edit#slide=id.g1a9d89a04cc779b5_0) 

## Forum

### Announcements
- [Hardforks on Grin v5.0.0 and beyond](https://forum.grin.mw/t/network-upgrades-hard-forks-on-grin-v5-0-0-and-beyond/7231) 
- [Dismantling the core team and governance structure](https://forum.grin.mw/t/dismantling-the-core-team-and-governance-structure/7801)

### Development and  Technical Discussions

- [How to store Grin in cold storage?](https://forum.grin.mw/t/how-to-store-grin-in-cold-storage/5375)
- [Raspberry Pi 4 - Standalone Grin-Node PoC by Grinnode.live](https://forum.grin.mw/t/raspberry-pi-4-standalone-grin-node-poc-by-grinnode-live/7796) 
- [How to open port 3414 (and why)](https://forum.grin.mw/t/how-to-open-port-3414-and-why/7825)
- [Use of NRD kernels in payment channels](https://forum.grin.mw/t/use-of-nrd-kernels-in-grin-payment-channels/7298)
- [Transaction Aggregation](https://forum.grin.mw/t/grin-transaction-aggregation/418)
- [TX Graph Confidentality](https://forum.grin.mw/t/tx-graph-confidentiality/1260)
- [Queries about transaction aggregation](https://forum.grin.mw/t/some-queries-about-transaction-aggregation/1753)
- [Aggregate merkle proofs](https://forum.grin.mw/t/aggregate-merkle-proofs/4948)
- [Unique kernels thread #73](https://forum.grin.mw/t/unique-kernel-thread-73/7688/14)
- [Sending a transaction to more parties than originally intended](https://forum.grin.mw/t/sending-a-transaction-to-more-different-parties-than-originally-intended/4985)
- [Reasoning behind block weight limit](https://forum.grin.mw/t/reasoning-behind-block-weight-limit/6310)
- [Play attacks and possible mitigations](https://forum.grin.mw/t/play-attacks-and-possible-mitigations/7527)
- [Replay attacks and possible mitigations](https://forum.grin.mw/t/replay-attacks-and-possible-mitigations/7415)
- [Grin transactions user interactivity](https://forum.grin.mw/t/grin-transactions-user-interactivity/7738)
- [Eliminate finalize step](https://forum.grin.mw/t/eliminating-finalize-step/7621)
- [Integrated payment proofs and round minimization](https://forum.grin.mw/t/integrated-payment-proofs-and-round-minimization/7745)
- [Communicating with grin-wallet API (Tutorial)](https://forum.grin.mw/t/communicating-with-grin-wallet-api-tutorial/9925/4)
- [Pep talk for one sided transactions](https://forum.grin.mw/t/pep-talk-for-one-sided-transactions/7361)

### Emmission Model

-  [Emission Rate of GRIN](https://forum.grin.mw/t/emission-rate-of-grin/171)
-  [Questioning core assumptions on emmission model](https://forum.grin.mw/t/questioning-core-assumptions-on-our-emissions-model/1414)
-  [Linear emmission is fair to late adopters](https://forum.grin.mw/t/question-for-statement-linear-emission-is-fair-for-late-adopters/6285)


#### Mining

- [PoW specification](https://forum.grin.mw/t/pow-specification/7963)
- [Scheduled PoW upgrades proposal](https://forum.grin.mw/t/scheduled-pow-upgrades-proposal/820)
- [Choice of ASIC Resistant PoW for GPU miners](https://forum.grin.mw/t/choice-of-asic-resistant-pow-for-gpu-miners/1017)
- [Put later phase-outs on hold proposal](https://forum.grin.mw/t/grin-improvement-proposal-1-put-later-phase-outs-on-hold-and-rephrase-primary-pow-commitment/4653)
- [All about C31 fade out, the C29 scale and C32](https://forum.grin.mw/t/all-about-c31-fade-out-the-c29-scale-and-c32/6914)
- [Being ASIC resistant or not](https://forum.grin.mw/t/being-asic-resistant-or-not/372)
- [Grin ASIC iPOLLO-G1 Mining Tutorial](https://forum.grin.mw/t/how-to-mine-grin-with-g1-mini-steps/9796)

### Miscellaneous

- [Response to Reavealing TX Graph](https://forum.grin.mw/t/my-full-response-to-the-blocks-questions/6566)
- [Some toughts on Privacy](https://forum.grin.mw/t/some-thoughts-on-privacy/6581)
- [On Igno's absence](https://forum.grin.mw/t/on-ignos-absence/5301) 
- [Genesis block message](https://forum.grin.mw/t/genesis-block-message/250)


### Research

- [Coinbase outputs as regular outputs](https://forum.grin.mw/t/coinbase-outputs-as-transaction-outputs/7441) 
- [Is there a potential hidden inflation problem](https://forum.grin.mw/t/is-there-a-potential-hidden-inflation-problem-with-all-mw-coins/6400)
- [Confidential Assets](https://forum.grin.mw/t/confidential-assets/1217)
- [Bidirectional Payment Proofs](https://forum.grin.mw/t/bidirectional-payment-proofs/9175) 
- [Grin AUDIT 4.0.0 Release]( https://forum.grin.mw/t/grin-audit-for-4-0-0-release/7473/3)
- [Grinvestigation](https://phyro.github.io/grinvestigation/)
- [Coinswap Proposal](https://forum.grin.mw/t/mimblewimble-coinswap-proposal/8322) 

   
## Medium

- [Grin Money Explained](https://medium.com/@CryptoProfG/grin-money-explained-4-exploring-grins-monetary-model-e48b1761653) 
- [Grin's Mythical Fair Launch](https://uncommoncore.co/grin-and-the-mythical-fair-launch/)
- [Grin Transactions Explained, Step-by-Step](https://medium.com/@brandonarvanaghi/grin-transactions-explained-step-by-step-fdceb905a853) 
- [What’s inside a Grin Transaction File?](https://medium.com/@brandonarvanaghi/whats-inside-a-grin-transaction-file-f062a0dcbf99)
- [Breaking Mimblewimble’s Privacy Model](https://medium.com/dragonfly-research/breaking-mimblewimble-privacy-model-84bcd67bfe52)
- [Factual inaccuracies of “Breaking Mimblewimble’s Privacy Model”](https://medium.com/grin-mimblewimble/factual-inaccuracies-of-breaking-mimblewimbles-privacy-model-8063371839b9)
- [Mimblewimble Without the Scary Math](https://blog.qtum.org/mimblewimble-without-scary-math-e894cb841b98) 
- [Behind Mimblewimble](https://medium.com/scalar-capital/behind-mimblewimble-cd9da78a00e9) 
- [An Introduction to Grin Proof-of-Work](https://blog.blockcypher.com/an-introduction-to-grin-proof-of-work-103aaa9f66ce) 
- [A Case for using soft total supply](https://john-tromp.medium.com/a-case-for-using-soft-total-supply-1169a188d153)

## Podcasts

- [[Bitcoin Wednesday] Introducing Mimblewimble and Grin @jaspervdm](https://www.youtube.com/watch?v=mzHswLujMYc) 
- [[Unchained] Grin: A More Private, Lighter Bitcoin @lehnberg @yeastplume](https://unchainedcrypto.com/grin-a-more-private-lighter-bitcoin/) 
- [[The Crypto Show] Mimblewimble with Andrew Poelstra and Peter Wuillie](https://soundcloud.com/heryptohow/mimblewimble-andrew-poelstra-peter-wuille-brian-deery-and-chris-odom)
- [[Zero Knowledge] Grin @lehnberg](https://fireside.fm/s/3yp1oIzN+6BedPBky) 
- [[Captain Crypto Show] Grin @yeastplume](https://www.youtube.com/watch?v=nwi9pMqUBQI) 
- [[What Bitcoin Did] Grin's Mimblewimble Implementation @yeastplume](https://medium.com/@whatbitcoindid/grins-michael-cordner-aka-yeastplume-on-implementing-mimblewimble-461d5ae386b9) 
- [[Let's Talk Bitcoin] Privacy with Mimblewimble @yeastplume @andreas @adam.b.levine](https://play.fountain.fm/episode/5Qk589TqsHFFx2W6F1uZ)
    

## Miscellaneous

- [[Launchpad] Mimblewimble Mailing List Archive](https://lists.launchpad.net/mimblewimble/)
- [[Reddit] Mimblewimble introduced to r/bitcoin](https://www.reddit.com/r/Bitcoin/comments/4vub3y/mimblewimble_noninteractive_coinjoin_and_better/) 
- [[Youtube] Aantonop Bitcoin Q&A: Mimblewimble and Dandelion](https://www.youtube.com/watch?v=LjDJGTpK_lE)
- [[Coindesk] Harry Potter Characters Join Mimblewimble 2016](https://www.coindesk.com/coders-harry-potter-bitcoin-mimblewimble) 
- [[Github] Meeting Notes](https://github.com/mimblewimble/grin-pm#2020)
- [[Reddit] On Grin's Privacy](https://www.reddit.com/r/grincoin/comments/g43fhe/is_there_any_progress_on_reducing_linkability_of/fnv7lfh/)
- [[Launchpad] Scripting observations and Lightning Network implementation](https://lists.launchpad.net/mimblewimble/msg00029.html)
- [[GitHub] Grin difficulty, C29, C31 fade out and C32](https://github.com/Lolliedieb/lolMiner-releases/wiki/All-you-need-to-know-about-Grin-difficulty,-C29,-C31-fade-out-and-C32)
- [[GitHub] Fees in Mining](https://github.com/mimblewimble/grin/wiki/fees-mining) 
- [[Google] Replay Attacks Summary](https://docs.google.com/document/d/1BbXhgFd3byP_gfvnteRq4BmfXjtv5PJtJwI13CJsZT8/edit#) 
- [[Blog] A Relatively Easy to Understand Primer on ECC](https://blog.cloudflare.com/a-relatively-easy-to-understand-primer-on-elliptic-curve-cryptography/)


#### RFCs

- [[Github] All Accepted RFCs](https://github.com/mimblewimble/grin-rfcs#list-of-accepted-rfcs)
-  [[Github] All Pending RFCs](https://github.com/mimblewimble/grin-rfcs/pulls)

## Papers

- [Confidential Assets](https://blockstream.com/bitcoin17-final41.pdf)
- [OWAS](https://download.wpsoftware.net/bitcoin/wizardry/horasyuanmouton-owas.pdf) 
- Bulletproofs](https://eprint.iacr.org/2017/1066.pdf)
- [Cuckoo Cycle](https://github.com/tromp/cuckoo/blob/master/doc/cuckoo.pdf) 
