# User Stories Use Cases

> By [sesam](https://github.com/sesam), Jun 29 2018

_Or, how non-developers are expected to use and abuse the grin software._

In [#750](https://github.com/mimblewimble/grin/issues/750) we're calling for help with a user guide.

Users often want to get started trying things out, instead of reading instructions.

The now modern on-boarding screens/animations that just take seconds to click through are often ignored or furiously clicked at to make them go away.

For users, the nicest option is to just pick out the software and start using it.

Then, the best guide is perhaps one that follows the user and suggests what the user can do next, without forcing the user to do anything special.

`git` is an example of a hard-to-understand blockchain-ish transaction-ish application that gives its users small hints on correcting user mistakes and getting good configuration settings where good defaults are not an option.

## How will the first non-crypto fans be able to use grin?

### Sym the gym coach

Background story: As a coach, things not on the mobile phone are not usable. Sym only uses the web wallet to spend and earn grins with some friends who are also testing this out. One of them installed grin on the gym hall's reception computer, so it's mining some grins and helps heating the space during the winter months.

Use cases:

- Open the web wallet on mobile.
- Look at the wallet balance.
- Send some of the mined coins to Roe (who in turn brings bottled drinks that the gym then can sell to its customers)
- Accept payments for drinks in grin, with the web wallet emitting different sounds for different incoming transactions (Example: "cheers!" for each incoming drink payment, or "eet smakelijk" for sandwich payments), making it possible for Sym to both work with customers and keep an eye and ear on the almost automated snacks bar side-business.

### Pat the internet café attendant somewhere in Asia

- The cafe's computers, when idle, run a "screen saver" that activates the grin-goldminer, ensuring the investment in good gaming computers is never cooling down too much. The café customers like it warm and toasty.
- Whether not trusting its multiple ISP uplinks or wanting to save on bandwidth, the café maintains its own local mining pool. That pool connects to 4 full grin nodes on different continents, making sure that even the worst possible internet weather and cut under-sea cables can't interrupt the continuous flow of grin blocks.

### Misty the museum owner

- As a somewhat idealistic person, Misty accepts entrance fee payments in just about any Mimblewimble coin and most testnet coins.
- On a glass shell in the corner stands a great though aged open computer case with a name tag "The Yeastmonster" subtexted "The First Great Grin Miner". Most visitors feel its importance and snap a photo before moving along to the graphical user interfaces exhibition hall, but only those with testnet grins can pay to the monster directly to get it to start up its text UI and mine for one minute.
