# Regarding Foundations

## Introduction

Official Foundations are sometimes seen as an obvious 'must-have' requirement for any serious cryptocurrency project. The purpose of this document is to evaluate whether there's just cause for such a foundation in the context of the Grin project. Experiences from other crypto projects are considered, followed by identifying the potential use cases a foundation is supposed to solve for. Each of these are then discussed in the context of a foundation, and what the alternative to that could be.

It should be pointed out that it's not possible or intended to prevent foundations from being set up. Any individual, group, or other entity may freely decide to set up a foundation, as is it within their right. What's being evaluated is rather whether a foundation in "official" capacity can be mandated or not.

## Current status

September 13, 2018: There are no current or future plans to create an official Grin Foundation. Other entities wishing to set up foundations or other organisations with intentions to support the project are welcomed.

## Selected experiences of other projects

* **Bitcoin** Foundation has been [mired in controversies](https://en.wikipedia.org/wiki/Bitcoin_Foundation) regarding its leadership and received cease and desist letters from US institutions.
* The **Tezos** Foundation ended up in a vicious legal dispute with the project founders whilst some $400m in funds at the time were locked.
* The **Monero** community opted not to create a foundation in the first place, [this post](https://monero.stackexchange.com/questions/311/will-there-ever-be-a-monero-foundation) sums up some of the thinking behind this.
* **Aragon** has announced that they seek to work towards [decentralising their foundation](https://blog.aragon.org/decentralizing-aragons-development-ii-minimum-viable-foundation-8ec1f9a13ebc/) and reducing its responsibilities.
* **Zcash** Foundation has published [results from their Governance process](https://zfnd.org/zcash-foundation-governance-process-results/), which sheds light into some of their activities, challenges, and feedback from their community. Their [mission statement](https://github.com/ZcashFoundation/ZcashFoundation/blob/master/MISSION.md) identify Community, Protocol/Governance, and Science as the three key pillars of the foundation. A recently expressed goal by the Foundation board was to ["exist long enough to become irrelevant / unnecessary"](https://github.com/ZcashFoundation/ZcashFoundation/blob/master/board-documents/minutes/2018-06-28.md).
* **MakerDAO** have announced a [a foundation proposal](https://medium.com/makerdao/foundation-proposal-caeb382465c1) as part of their Maker Governance Framework. As part of their proposal, 'gradual decentralisation' is to be realised through the work of the foundation.
* **Cardano Foundation** representative's [issue](https://hackernoon.com/cardano-foundation-chairman-resigns-following-community-effort-50453efd3d3c).

## Possible Foundation Use Cases

* **To own/manage assets.** Owning assets that are valuable to the community, such as domain names, trademarks, IP, Login info, account privileges, art  & media assets etc.
* **To act as official representative.** A spokesperson of sorts for the project. For PR & media related enquiries. Issuing "official" statements.
* **To offer legal protection.** Assume legal liability for the project in order to deflect and protect developers and others in the community from being sued or targeted for legal prosecution.
* **To offer legal advice.** Legal counsel used to offer advice to community members and support in the event of legal conflicts.
* **To accept charitable donations.** A destination for community members to send donations to that can then be used to promote the project's interests.
* **To fund development projects and research.** Using donations and foundation resources to fund development efforts that are important for the project. Fund research efforts.
* **To educate, lobby, network.** To educate authorities about what the protocol does and doesn't do, to make arguments to politicians about why they should not try to ban privacy coins, to demonstrate how the project is compliant with a local regulation, to participate in  alliances with other charitable organisations that value privacy, etc.
* **To nurture and grow the community.** Community building exercises, conferences, symposiums, supporting meet ups, hosting speakers, etc.
* **To make protocol/governance related decisions**. Contentious topic. Some foundations explicitly avoid taking an active role in governance. Others seem more active and responsible in "steering" the community and offering advice in times of hard forks and protocol conflicts.

## Weighing different approaches

| | Using a foundation | Not using a foundation |
|---|---|---|
|**To own/manage assets**| <ul><li>Straight forward.<li>Does not ensure assets are managed the right way.<li>Can act as a deterrent for abuse/infringement.</ul> | <ul><li>What are the assets that _have_ to be owned by a central entity? Are there alternatives?<li>Trademarks and IP will be difficult to protect and enforce and requires active defending. Does the project need to own trademarks?<li>Redundancy for account access, privileges, etc. might possible to be handled in the community.<li>How can domains be owned without a central entity? Do they need to be?</ul>|
|**To act as official representative**|<ul><li>Might make marketing/pr easier.<li>Does it make sense to have a central entity speaking for the entire project?<li>Does a central, official representative make an easy target for harassment by law enforcement?|<ul><li>Opting not to have an official representative can be a deliberate design decision.<li>If the community really feel that a spokesperson is important, this can be appointed without the need for a foundation.<li>Similarly, statements can also be drafted and issued through a community effort.|
|**To offer legal protection**|<ul><li>Will require significant legal effort to draft air-tight defence.<li>To what extent would a foundation then need to have authority over the project? Is that in conflict with governance models? Does it make the project centralised? |<ul><li>What is the real risk for developers and community members?<li>Can a foundation prevent individuals from being targeted?|
|**To offer legal advice**|<ul><li>How likely is there that the foundation will employ permanent counsel?|<ul><li>By not avoiding a central organisation, can legal risk be reduced?<li>Fundraising by the community could support developers who get into legal trouble.<li>This would allow legal advice to be better tailored to the needs of the individual and the circumstance.|
|**To accept charitable donations**|<ul><li>Does it make sense to raise funds without stating explicitly how they are to be spent?<li>Can the overhead of a foundation be justified?<li>There may be tax benefits by registering as a charitable foundation.<li>There is real risk for misappropriation of funds.|<ul><li>Community 'slush funds' can still be organised.<li>Setting this up as a decentralised entity can be a challenge.<li>Who decides how funds are spent?|
|**To fund development projects and research**|<ul><li>Who decides what projects to fund?<li>Can the overhead of a foundation be justified for this?<li>What does it mean in terms of centralisation?</ul>|<ul><li>[Monero's FFS model](https://forum.getmonero.org/7/open-tasks/2379/forum-funding-system-ffs-sticky) is an example of community funding without a centralised foundation structure.<li>There are also [other alternatives](https://github.com/nayafia/lemonade-stand) for funding open source projects.|
|**To educate, lobby, network**|<ul><li>There's a logic for why a central, official, organisation will have greater chance of success in these efforts.<li>Community efforts will be harder to get focused and organised around specific causes.|<ul><li>Nothing is preventing interest organisations from forming around specific causes and missions, including the Grin project itself. These can lobby and influence as required. But would not do so in any official capacity of the foundation.|
|**To nurture and grow the community**|<ul><li>A foundation can designate resources to be responsible for this on a continuous basis.<li>Paying for professionals to work on this might lead to more professional activities and increase performance.<li>It may also centralise decision making around the direction the community should grow in and introduce bias.|<ul><li>It seems intuitive to expect the community to take care of itself in a decentralised project.<li>This however also assumes the community is engaged and committed to put in the effort required.<li>On the other hand, if the community is not, then a centralised community management function will have little impact either way.|
|**To make protocol/governance related decisions**|<ul><li>A foundation can be the "last resort", ready to step in to take responsibility in times of crisis or extra-ordinary events.<li>Can ensure that there is proper planning, and that the project is progressing.<li>Can suffer from legitimacy issues. Might struggle to make decisions that are in line with the will of the community, and therefore lead to friction or forks.|<ul><li>The community can make these decisions, assuming a governance model is in place that functions and is seen as legitimate by the community.<li>Easier said than done correctly, though.|

## Concluding remarks

There are many use cases where foundations may be useful. In general, it seems however that a foundation is not a prerequisite to solve for these, and that they also can be solved on a per case basis via an engaged and committed community. It's not clear that a foundation will do a better job. Having a foundation creates overhead and centralises power and authority into a physical legal entity.  For a project that strives to be decentralised, this seems contradictory. On the other hand, there are efficiency and accountability benefits that can be realised with a professionally run foundation compared to community efforts carried out ad-hoc, which may or may not be done properly. There's a real trade-off there and the community should decide what is valued most.
