# Monetary Policy

Currently, a new grin is emitted every second, and it's likely to stay that way forever, meaning that the supply inflation rate stays constant. Why? Consider the following points.

## It's very close to Bitcoin in the first decade

[The first four years of Bitcoin emission rate are identical to the first four of Grin.](https://plot.ly/~Bobby_Digital/1/#/) Bitcoin had a full reward for 4 years, followed by half that for the following 4 years. So compared to a constant supply, after 8 years, the total amount of coins emitted is only 25% less. Compare that to daily price fluctuations.

## It's more similar to Ethereum

Ethereum's reward stayed at 5 ether per block until late 2017. It then changed to 3 ether per block, with plan to 2 ether per block after Constantinople upgrade.

## It's even **more** similar to gold

Gold has historically had a linear emission, like Grin. [See this graph](https://plot.ly/~Bobby_Digital/1/#/) comparing Bitcoin, Grin, and gold emissions.


## New supply falls below 10% after 10 years

Every year that passes makes the overall dilution smaller. After 10 years, this falls below 10%. After 20, below 5%. After 25 years Grin will have 4% supply inflation, the same as Bitcoin 10 years after its genesis (2018).

## It's highly likely that at least 2% of coins get lost per year

Multiple studies have shown that a considerable amount of coins get lost, burnt and generally disappear from circulation with no chance to get them back. The rate at which coins get lost has been conservatively estimated at 2%, but is likely slightly higher.

## Tail emission may be required for long term stability

Currencies with set supply are extremely experimental. Miners likely need incentives to secure the chain beyond only fees.

## Sound money has more to do with transparent emission than a capped supply

One of the pitfalls of monetary inflation in fiat currencies is governments can inflate the monetary supply on a whim. This has been used to disastrous effect throughout history. A non-sovereign, open source, consensus based currency solves this issue by making the emission policy well known ahead of time, and makes it difficult if not impossible to change. *Based on this definition of soundness, Grin is just as much "sound money" as Bitcoin.* Removing central authorities with arbitrary control is much more what makes Bitcoin important than the arbitrary amount of its capped supply.

!!! quote ""
    Nick Szabo [commented](https://twitter.com/NickSzabo4/status/1077317105148547072) on Bitcoin's fixed supply:
    > a wide variety of supply algos would have worked, as long as they are predictable. […] Security/trust minimization is responsible for more of the value.

There are plenty of cryptocurrencies identical to Bitcoin but with smaller capped supplies, how many of them can you name?

## Inflation may make price more stable

As an experimental hypothesis, Grin's inflation rate may discourage hoarding early on, improving its distribution. Inflation disincentivizes "whales," who have an inordinate amount of control over the price of an asset, and should act to downplay speculative bubbles and price swings. Early adopters get just as much out of grin as those who adopt later.
This argument is discussed at length in [Bitcoins are not digital greenbacks](https://www.lesswrong.com/posts/P9jggxRZTMJcjnaPw/bitcoins-are-not-digital-greenbacks), in which Wei Dai himself considers "Bitcoin to have failed with regard to its monetary policy". Grin is aiming for as equal access and utility as possible for all users, now and in the future.

Constant emission could provide enhanced supply/demand certainty for all types of users, and allow transparent and natural pricing. Note: Bitcoin becoming widely usable as a method of exchange versus a strict store of value depends on the concept of "[Keynesian beauty contests.](https://jpkoning.blogspot.com/2018/10/bitcoin-and-bubble-theory-of-money.html)" The experiment is ongoing.

## There are already better store of values or "get rich quick" coins

Grin is focused on privacy, scalability and fairness. If groups or individuals "get rich quick," they will have power to influence the entire grin economy more than others. Grin is not for creating technocrats, but for providing private digital cash to as many people as possible. Hoarding is a huge centralization pressure, and grin emission policy hopes to mitigate this.

The idea is to use grin like you use your bicycle, to get you around and make you more efficient, not to store in your garage hoping its value goes up.

## It will get forked into a "get rich quick" coin

Fine. But the keyword in "get rich quick" is _quick_. Moderate yearly variations in supply are fairly slow in comparison. Grin isn't for getting rich quick.

## Confidential Assets allow parallel monetary policies to be soft-forked in later

If the current monetary policy is keeping you from contributing to Grin, you should still stick around. [Confidential Assets](https://lists.launchpad.net/mimblewimble/msg00103.html), an invention by early Mimblewimble contributor Andrew Poelstra, allow alternative assets (with differing cryptography, emission rates, and more; including coins pegged to other assets/blockchains) to be added to Grin later on via soft fork. These assets add very little to the chain size, make all other assets (like the native grin token) more private, and can be embraced or ignored as one wishes without compromising any other asset (grin or otherwise) on the chain. Grin is a minimal Mimblewimble implementation, but it will grow and evolve. Mimblewimble is nimble.

## We are in the early days of cryptoeconomics

Experiments in transparent, collaborative monetary policies are very immature. Bitcoin is only ten years old and the experiment is still going strong. The time is ripe not for copycat experiments, but novel variations. Only time will tell, but the sooner we start running alternative monetary policy experiments the sooner we get useful data.

There are only ~28 million Bitcoin wallets today (many of them not in active use, or secondary wallets for single users). That means less than one-half of one percent of the global population has their own wallet. Because you are here means you care about the entire premise of cryptocurrencies, it is important to be open minded when things are so new and uncertain.

Onward.

## Further discussion

There is a long discussion regarding Grin's monetary policy in the community [forum](https://forum.grin.mw/t/emmission-rate-of-grin/171).

[Igno's thoughts](https://forum.grin.mw/t/emmission-rate-of-grin/171/88) on soliciting productive feedback:

> With respect to this whole thread and future ones, if you want to provide constructive criticisms on the emission curve, at least give it some decent thoughts. Repeating what you read on Reddit doesn’t count.
>
> To be more specific:
>
> * At a minimum consider the loss rate when building supply curve. Ever wondered at which point 50% of those 21M bitcoins will have disappeared, for example?
> * Compare with other slow emission coins. After 8 years, grin only has 25% more supply than bitcoin or, to pick something more recent, zcash. Argue why this matters (or not).
> * Compare with fast emissions coins. Monero had over half emitted in 17 months. How does that affect long term adoption? How about use?
> * Rich lists and coin decentralization. What affects them.
> * Analyze average crypto user and investor behavior. How does multi-year emission curves, fast or slow, influence them? What are the real adoption drivers, both long and short term?
> * Do not use econ101 in your arguments. That can be used to argue anything and its opposite equally well. And before telling us we don’t understand economics, convince Nouriel. Then maybe I’ll listen.
> * Consider different strategies and how they can play the strengths or weaknesses of various blockchains. What is the effect on Ethereum when daily supply is hard forked for example?
> * Facts and real research. Unsubstantiated opinions are a nanogrin a dozen.
>
> The grin team is earnest, if you can provide well substantiated real research that shows a different supply curve would be be better for grin, we will most definitely listen. But don’t think you can flyby post your knee-jerk reaction 5 min after having heard of grin, which we’ve spent the last 2 years building, and expect us to listen to you.

[Informed ideas are more than welcome!](https://forum.grin.mw/t/emmission-rate-of-grin/171)
