# Build

> *Read this in other languages: [Español](https://github.com/mimblewimble/grin/blob/master/doc/translations/build_ES.md), [Korean](https://github.com/mimblewimble/grin/blob/master/doc/translations/build_KR.md), [日本語](https://github.com/mimblewimble/grin/blob/master/doc/translations/build_JP.md), [简体中文](https://github.com/mimblewimble/grin/blob/master/doc/translations/build_ZH-CN.md).*

## Requirements

### Rust

Install using [rustup.rs](https://rustup.rs):

```text
curl https://sh.rustup.rs -sSf | sh; source $HOME/.cargo/env
```

 If rust is already installed, you should update to the latest version by running `rustup update`.

Grin currently does not support a minimum version of Rust, so it's recommended to build using the latest version.

### Dependencies

git &#9679; tor &#9679; clang &#9679; ncurses and libs (ncurses, ncursesw5) &#9679; zlib libs (zlib1g-dev or zlib-devel) &#9679; pkg-config &#9679; libssl-dev &#9679; llvm &#9679; linux-headers (needed on Alpine linux)

For Debian-based distributions (Ubuntu, Mint etc):

```text
apt install build-essential git tor cmake git libgit2-dev clang libncurses5-dev libncursesw5-dev zlib1g-dev pkg-config libssl-dev llvm
```

For macOS:

```text
xcode-select --install
brew install --with-toolchain llvm
brew install pkg-config
brew install openssl
```

## Build

```text
git clone https://github.com/mimblewimble/grin.git
cd grin
git checkout v4.0.2
cargo build --release
```

!!! note ""
    Grin can also be built in debug mode (using the `--debug` or the `--verbose` flags) but this will render fast sync prohibitively slow due to the large overhead of cryptographic operations.

??? note "Build errors &#8628;"
    **Build error: Could not compile `tokio-retry`**

    You might want to remove any previous rust installations to avoid conflicts. Use `rustup` to [reinstall rust and cargo as described](build.md).

    NOTE: If you install rust or cargo with your package manager (most Linuxes anno 2017) you’ll get too old versions. On Debian, you might have to manually compile cmake or get it from non-detault repositories.

    **Build error: `failed to select a version for ‘serde_json’`**

    Run `cargo update` to fix this

    **Build error: can’t compile crate `bitflags`**

    Chech `rustc –version` and note that bitflags requires rust 1.21 or newer. Install via `rustup` and recommended you also remove any rust/cargo installed via your package manager.

    **Build error: can’t locate stdarg.h**

    If librocksdb-sys fails to build, try symlinking stddef.h and stdarg.h from the gcc5 include directory. So probably from /usr/lib to /usr/include

    **Build error: ` /usr/bin/ld: cannot find -lz`**

    On Ubuntu install the zlib development headers: `apt install zlib1g-dev`.

    **Build error: `/usr/bin/ld: cannot find -lncursesw`**

    On Ubuntu install the ncurses development headers: `apt install libncursesw5-dev`.

### Upgrading

```text
rustup update
cd ~/grin
git checkout master
git pull
git checkout [determine latest build you want e.g. v5.0.0]
cargo build --release
```

## What was built?

Let's review what a successful build gets you.

### Binary

`target/release/grin` is your main grin binary, located inside the build directory.

To add it to your path, type:

```text
export PATH=`pwd`/target/release:$PATH
```

You can then run `grin` from anywhere on your system.

### Data Files

All data, configuration and log files created and used by grin are located by default in the hidden `~/.grin` directory (under your user home directory).

You can modify configuration values by editing the `grin-server.toml` file, located in `~/.grin/main/grin-server.toml`.

!!! info ""
    You can have grin create its data files in the *current directory*. To do this, run:

    ```text
    grin server config
    ```

    This will generate a `grin-server.toml` file in the current directory. Running grin from a directory that contains `grin-server.toml` will use the values in that file which will also be pre-configured to use the current directory for all of the node's data.

## Configuration

Grin attempts to run with sensible defaults, and can be further configured via
the `grin-server.toml` file, generated by grin on its first run. The file contains documentation on each available option.

While it is recommended that you perform all grin server configuration via
`grin-server.toml`, it's also possible to supply command line switches to grin that override any settings in the file.

For help on grin commands and their switches, try:

```text
grin help
grin server help
grin client help
```

??? info "Mining"
    Once your grin node is up and running, you can start mining by building and running [grin-miner](https://github.com/mimblewimble/grin-miner) against your node.

    For grin-miner to be able to communicate with your grin node, make sure that you have `enable_stratum_server = true` in your `grin-server.toml` configuration file and you have a wallet listener running (`grin-wallet listen`).

## Docker

*(Running grin in a container)*

```text
docker build -t grin -f etc/Dockerfile .
```

!!! note ""
    For floonet, use `etc/Dockerfile.floonet` instead

You can bind-mount your grin cache to run inside the container.

```sh
docker run -it -d -v $HOME/.grin:/root/.grin grin
```

If you prefer to use a docker named volume, you can pass `-v dotgrin:/root/.grin` instead. Using a named volume copies default configurations upon volume creation.
