import Foundation
import XCTest

#if !SWIFT_PACKAGE
extension Bundle {
    static var module: Bundle {
        return Bundle(for: Fixture.self)
    }
}
#endif

class Fixture {
    class func stringFromFileNamed(name: String) -> String {
        guard let path = Bundle.module.path(forResource: name, ofType: "json") else {
            XCTAssert(false, "Fixture \(name) not found.")
            return ""
        }
        do {
            return try String(contentsOfFile: path, encoding: .utf8)
        } catch {
            XCTAssert(false, "Unable to decode fixture at \(path): \(error).")
            return ""
        }
    }

    class func JSONFromFileNamed(name: String) -> [String: Any] {
        guard let path = Bundle.module.path(forResource: name, ofType: "json") else {
            XCTAssert(false, "Fixture \(name) not found.")
            return [:]
        }
        guard let data = NSData(contentsOfFile: path) as Data? else {
            XCTAssert(false, "No data found at \(path).")
            return [:]
        }
        do {
            return try JSONSerialization.jsonObject(with: data, options: []) as! [String: Any]
        } catch {
            XCTAssert(false, "Unable to decode JSON fixture at \(path): \(error).")
            return [:]
        }
    }
}
