//
//  LanesStyleKit.swift
//  Mapbox Navigation
//
//  Created on 2021-10-22.
//  Copyright © 2021 Mapbox. All rights reserved.
//
//  Generated by PaintCode
//  http://www.paintcodeapp.com
//

import UIKit

@_documentation(visibility: internal)
public class LanesStyleKit: NSObject {
    //// Drawing Methods

    @objc
    public dynamic class func drawLaneSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.98, y: frame.minY + 13.11)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5.04, y: 0.64))
        bezier3Path.addCurve(
            to: CGPoint(x: -0.98, y: -6.11),
            controlPoint1: CGPoint(x: 5.04, y: 0.64),
            controlPoint2: CGPoint(x: 2.02, y: -5.11)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.3, y: -1.5),
            controlPoint1: CGPoint(x: -3.98, y: -7.11),
            controlPoint2: CGPoint(x: -5.98, y: -5.11)
        )
        bezier3Path.addLine(to: CGPoint(x: -6.3, y: 13.77))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 13.95, y: 4.03)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.02, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32)
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: frame.minX + 13, y: frame.minY + 11, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: frame.minX + 13.01, y: frame.minY + 12.92))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 13.02, y: frame.minY + 11.66))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.66))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.46),
            controlPoint1: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.6),
            controlPoint2: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 12.53, y: frame.minY + 10.94),
            controlPoint1: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.17),
            controlPoint2: CGPoint(x: frame.minX + 12.82, y: frame.minY + 10.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 12.43, y: frame.minY + 10.94),
            controlPoint1: CGPoint(x: frame.minX + 12.5, y: frame.minY + 10.94),
            controlPoint2: CGPoint(x: frame.minX + 12.46, y: frame.minY + 10.94)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 12.44, y: frame.minY + 10.94))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 9.71, y: frame.minY + 11.93))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 9.71, y: frame.minY + 11.93))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 9.52, y: frame.minY + 11.97),
            controlPoint1: CGPoint(x: frame.minX + 9.65, y: frame.minY + 11.96),
            controlPoint2: CGPoint(x: frame.minX + 9.59, y: frame.minY + 11.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 9, y: frame.minY + 11.45),
            controlPoint1: CGPoint(x: frame.minX + 9.23, y: frame.minY + 11.97),
            controlPoint2: CGPoint(x: frame.minX + 9, y: frame.minY + 11.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 9.16, y: frame.minY + 11.07),
            controlPoint1: CGPoint(x: frame.minX + 9, y: frame.minY + 11.3),
            controlPoint2: CGPoint(x: frame.minX + 9.06, y: frame.minY + 11.17)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 9.16, y: frame.minY + 11.08))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 15.02, y: frame.minY + 3))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 20.86, y: frame.minY + 11.14))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 20.86, y: frame.minY + 11.14))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 21.02, y: frame.minY + 11.52),
            controlPoint1: CGPoint(x: frame.minX + 20.96, y: frame.minY + 11.23),
            controlPoint2: CGPoint(x: frame.minX + 21.02, y: frame.minY + 11.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 20.5, y: frame.minY + 12.03),
            controlPoint1: CGPoint(x: frame.minX + 21.02, y: frame.minY + 11.8),
            controlPoint2: CGPoint(x: frame.minX + 20.79, y: frame.minY + 12.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 20.31, y: frame.minY + 11.99),
            controlPoint1: CGPoint(x: frame.minX + 20.43, y: frame.minY + 12.03),
            controlPoint2: CGPoint(x: frame.minX + 20.37, y: frame.minY + 12.02)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 20.31, y: frame.minY + 11.99))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17.58, y: frame.minY + 11))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17.59, y: frame.minY + 11.01))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 17.49, y: frame.minY + 11),
            controlPoint1: CGPoint(x: frame.minX + 17.56, y: frame.minY + 11),
            controlPoint2: CGPoint(x: frame.minX + 17.52, y: frame.minY + 11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.52),
            controlPoint1: CGPoint(x: frame.minX + 17.2, y: frame.minY + 11),
            controlPoint2: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.73),
            controlPoint1: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.59),
            controlPoint2: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.66)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17, y: frame.minY + 11.72))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17.01, y: frame.minY + 12.99))
        bezierPath.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.89, y: frame.minY + 15.95)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.11, y: 4.05))
        bezierPath.addLine(to: CGPoint(x: 4.11, y: -4.69))
        bezierPath.addCurve(
            to: CGPoint(x: -0.89, y: -10.95),
            controlPoint1: CGPoint(x: 4.11, y: -6.33),
            controlPoint2: CGPoint(x: 4.11, y: -10.95)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.89, y: -4.95),
            controlPoint1: CGPoint(x: -5.89, y: -10.95),
            controlPoint2: CGPoint(x: -5.89, y: -4.95)
        )
        bezierPath.addLine(to: CGPoint(x: -5.89, y: 11.05))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 6.13, y: 2.1))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.12, y: 3.36),
            controlPoint1: CGPoint(x: 6.13, y: 2.1),
            controlPoint2: CGPoint(x: 6.12, y: 3.28)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.13, y: 3.56),
            controlPoint1: CGPoint(x: 6.12, y: 3.43),
            controlPoint2: CGPoint(x: 6.13, y: 3.5)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.61, y: 4.09),
            controlPoint1: CGPoint(x: 6.13, y: 3.85),
            controlPoint2: CGPoint(x: 6.32, y: 4.09)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.43, y: 3.09),
            controlPoint1: CGPoint(x: 6.81, y: 4.04),
            controlPoint2: CGPoint(x: 9.31, y: 3.13)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.62, y: 3.06),
            controlPoint1: CGPoint(x: 9.49, y: 3.07),
            controlPoint2: CGPoint(x: 9.55, y: 3.06)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 10.11, y: 3.4),
            controlPoint1: CGPoint(x: 9.84, y: 3.06),
            controlPoint2: CGPoint(x: 10.04, y: 3.2)
        )
        bezier2Path.addLine(to: CGPoint(x: 10.11, y: 3.57))
        bezier2Path.addLine(to: CGPoint(x: 10.11, y: 3.75))
        bezier2Path.addCurve(
            to: CGPoint(x: 9.98, y: 3.95),
            controlPoint1: CGPoint(x: 10.08, y: 3.82),
            controlPoint2: CGPoint(x: 10.03, y: 3.89)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.12, y: 11.02),
            controlPoint1: CGPoint(x: 9.85, y: 4.11),
            controlPoint2: CGPoint(x: 4.12, y: 11.02)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.41, y: 6.5),
            controlPoint1: CGPoint(x: 4.12, y: 11.02),
            controlPoint2: CGPoint(x: 2.08, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.72, y: 3.89),
            controlPoint1: CGPoint(x: -0.71, y: 5.12),
            controlPoint2: CGPoint(x: -1.67, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.88, y: 3.51),
            controlPoint1: CGPoint(x: -1.82, y: 3.79),
            controlPoint2: CGPoint(x: -1.88, y: 3.66)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.37, y: 2.99),
            controlPoint1: CGPoint(x: -1.88, y: 3.22),
            controlPoint2: CGPoint(x: -1.65, y: 2.99)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.18, y: 3.03),
            controlPoint1: CGPoint(x: -1.3, y: 2.99),
            controlPoint2: CGPoint(x: -1.23, y: 3.01)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.55, y: 4.02),
            controlPoint1: CGPoint(x: -1.06, y: 3.07),
            controlPoint2: CGPoint(x: 1.44, y: 3.98)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.13, y: 3.5),
            controlPoint1: CGPoint(x: 1.94, y: 4.02),
            controlPoint2: CGPoint(x: 2.13, y: 3.79)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.13, y: 3.3),
            controlPoint1: CGPoint(x: 2.13, y: 3.43),
            controlPoint2: CGPoint(x: 2.13, y: 3.36)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.13, y: 2.04),
            controlPoint1: CGPoint(x: 2.13, y: 3.22),
            controlPoint2: CGPoint(x: 2.13, y: 2.04)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.13, y: 2.1))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.98, y: frame.minY + 13.11)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 0.87, y: -3.35))
        bezier3Path.addLine(to: CGPoint(x: -4.82, y: 1.92))
        bezier3Path.addCurve(
            to: CGPoint(x: -6.3, y: 6.5),
            controlPoint1: CGPoint(x: -5.7, y: 3.24),
            controlPoint2: CGPoint(x: -6.3, y: 4.85)
        )
        bezier3Path.addLine(to: CGPoint(x: -6.3, y: 13.63))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 3.95, y: -13.97)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.01, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.98, y: frame.minY + 15.02)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 1.47, y: -11.01))
        bezierPath.addCurve(
            to: CGPoint(x: 1.79, y: -10.85),
            controlPoint1: CGPoint(x: 1.57, y: -11.01),
            controlPoint2: CGPoint(x: 1.7, y: -10.95)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.87, y: -5),
            controlPoint1: CGPoint(x: 1.95, y: -10.72),
            controlPoint2: CGPoint(x: 8.87, y: -5)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.73, y: 0.84),
            controlPoint1: CGPoint(x: 8.87, y: -5),
            controlPoint2: CGPoint(x: 1.89, y: 0.71)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.35, y: 1),
            controlPoint1: CGPoint(x: 1.63, y: 0.94),
            controlPoint2: CGPoint(x: 1.5, y: 1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.84, y: 0.49),
            controlPoint1: CGPoint(x: 1.07, y: 1),
            controlPoint2: CGPoint(x: 0.84, y: 0.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.87, y: 0.3),
            controlPoint1: CGPoint(x: 0.84, y: 0.42),
            controlPoint2: CGPoint(x: 0.85, y: 0.36)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -2.43),
            controlPoint1: CGPoint(x: 0.92, y: 0.18),
            controlPoint2: CGPoint(x: 1.82, y: -2.32)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.34, y: -3.01),
            controlPoint1: CGPoint(x: 1.87, y: -2.81),
            controlPoint2: CGPoint(x: 1.63, y: -3.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.15, y: -3.01),
            controlPoint1: CGPoint(x: 1.28, y: -3.01),
            controlPoint2: CGPoint(x: 1.21, y: -3.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0.12, y: -3.01),
            controlPoint1: CGPoint(x: 1.06, y: -3.01),
            controlPoint2: CGPoint(x: -0.12, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -0.06, y: -7))
        bezierPath.addCurve(
            to: CGPoint(x: 1.2, y: -7),
            controlPoint1: CGPoint(x: -0.06, y: -7),
            controlPoint2: CGPoint(x: 1.12, y: -7)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.4, y: -7.01),
            controlPoint1: CGPoint(x: 1.27, y: -7),
            controlPoint2: CGPoint(x: 1.34, y: -7.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.93, y: -7.49),
            controlPoint1: CGPoint(x: 1.7, y: -7.01),
            controlPoint2: CGPoint(x: 1.93, y: -7.2)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.94, y: -10.3),
            controlPoint1: CGPoint(x: 1.89, y: -7.69),
            controlPoint2: CGPoint(x: 0.98, y: -10.19)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.9, y: -10.5),
            controlPoint1: CGPoint(x: 0.91, y: -10.37),
            controlPoint2: CGPoint(x: 0.9, y: -10.43)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.41, y: -11.02),
            controlPoint1: CGPoint(x: 0.9, y: -10.78),
            controlPoint2: CGPoint(x: 1.13, y: -11.01)
        )
        bezierPath.addLine(to: CGPoint(x: 1.47, y: -11.01))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5.98, y: 11.98))
        bezier2Path.addLine(to: CGPoint(x: -5.92, y: -1.45))
        bezier2Path.addCurve(
            to: CGPoint(x: -2.05, y: -4.98),
            controlPoint1: CGPoint(x: -5.92, y: -1.45),
            controlPoint2: CGPoint(x: -5.64, y: -4.98)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.05, y: -4.98))
        secondaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.98, y: frame.minY + 13.11)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 0.87, y: -3.35))
        bezier3Path.addLine(to: CGPoint(x: -4.82, y: 1.92))
        bezier3Path.addCurve(
            to: CGPoint(x: -6.3, y: 6.5),
            controlPoint1: CGPoint(x: -5.7, y: 3.24),
            controlPoint2: CGPoint(x: -6.3, y: 4.85)
        )
        bezier3Path.addLine(to: CGPoint(x: -6.3, y: 13.63))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 3.95, y: -13.97)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.01, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.98, y: frame.minY + 15.02)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 1.47, y: -11.01))
        bezierPath.addCurve(
            to: CGPoint(x: 1.79, y: -10.85),
            controlPoint1: CGPoint(x: 1.57, y: -11.01),
            controlPoint2: CGPoint(x: 1.7, y: -10.95)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.87, y: -5),
            controlPoint1: CGPoint(x: 1.95, y: -10.72),
            controlPoint2: CGPoint(x: 8.87, y: -5)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.73, y: 0.84),
            controlPoint1: CGPoint(x: 8.87, y: -5),
            controlPoint2: CGPoint(x: 1.89, y: 0.71)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.35, y: 1),
            controlPoint1: CGPoint(x: 1.63, y: 0.94),
            controlPoint2: CGPoint(x: 1.5, y: 1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.84, y: 0.49),
            controlPoint1: CGPoint(x: 1.07, y: 1),
            controlPoint2: CGPoint(x: 0.84, y: 0.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.87, y: 0.3),
            controlPoint1: CGPoint(x: 0.84, y: 0.42),
            controlPoint2: CGPoint(x: 0.85, y: 0.36)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -2.43),
            controlPoint1: CGPoint(x: 0.92, y: 0.18),
            controlPoint2: CGPoint(x: 1.82, y: -2.32)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.34, y: -3.01),
            controlPoint1: CGPoint(x: 1.87, y: -2.81),
            controlPoint2: CGPoint(x: 1.63, y: -3.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.15, y: -3.01),
            controlPoint1: CGPoint(x: 1.28, y: -3.01),
            controlPoint2: CGPoint(x: 1.21, y: -3.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0.12, y: -3.01),
            controlPoint1: CGPoint(x: 1.06, y: -3.01),
            controlPoint2: CGPoint(x: -0.12, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -0.06, y: -7))
        bezierPath.addCurve(
            to: CGPoint(x: 1.2, y: -7),
            controlPoint1: CGPoint(x: -0.06, y: -7),
            controlPoint2: CGPoint(x: 1.12, y: -7)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.4, y: -7.01),
            controlPoint1: CGPoint(x: 1.27, y: -7),
            controlPoint2: CGPoint(x: 1.34, y: -7.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.93, y: -7.49),
            controlPoint1: CGPoint(x: 1.7, y: -7.01),
            controlPoint2: CGPoint(x: 1.93, y: -7.2)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.94, y: -10.3),
            controlPoint1: CGPoint(x: 1.89, y: -7.69),
            controlPoint2: CGPoint(x: 0.98, y: -10.19)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.9, y: -10.5),
            controlPoint1: CGPoint(x: 0.91, y: -10.37),
            controlPoint2: CGPoint(x: 0.9, y: -10.43)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.41, y: -11.02),
            controlPoint1: CGPoint(x: 0.9, y: -10.78),
            controlPoint2: CGPoint(x: 1.13, y: -11.01)
        )
        bezierPath.addLine(to: CGPoint(x: 1.47, y: -11.01))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5.98, y: 11.98))
        bezier2Path.addLine(to: CGPoint(x: -5.92, y: -1.45))
        bezier2Path.addCurve(
            to: CGPoint(x: -2.05, y: -4.98),
            controlPoint1: CGPoint(x: -5.92, y: -1.45),
            controlPoint2: CGPoint(x: -5.64, y: -4.98)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.05, y: -4.98))
        primaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32)
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: frame.minX + 13, y: frame.minY + 11, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: frame.minX + 13.01, y: frame.minY + 12.92))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 13.02, y: frame.minY + 11.66))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.66))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.46),
            controlPoint1: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.6),
            controlPoint2: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 12.53, y: frame.minY + 10.94),
            controlPoint1: CGPoint(x: frame.minX + 13.01, y: frame.minY + 11.17),
            controlPoint2: CGPoint(x: frame.minX + 12.82, y: frame.minY + 10.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 12.43, y: frame.minY + 10.94),
            controlPoint1: CGPoint(x: frame.minX + 12.5, y: frame.minY + 10.94),
            controlPoint2: CGPoint(x: frame.minX + 12.46, y: frame.minY + 10.94)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 12.44, y: frame.minY + 10.94))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 9.71, y: frame.minY + 11.93))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 9.71, y: frame.minY + 11.93))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 9.52, y: frame.minY + 11.97),
            controlPoint1: CGPoint(x: frame.minX + 9.65, y: frame.minY + 11.96),
            controlPoint2: CGPoint(x: frame.minX + 9.59, y: frame.minY + 11.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 9, y: frame.minY + 11.45),
            controlPoint1: CGPoint(x: frame.minX + 9.23, y: frame.minY + 11.97),
            controlPoint2: CGPoint(x: frame.minX + 9, y: frame.minY + 11.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 9.16, y: frame.minY + 11.07),
            controlPoint1: CGPoint(x: frame.minX + 9, y: frame.minY + 11.3),
            controlPoint2: CGPoint(x: frame.minX + 9.06, y: frame.minY + 11.17)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 9.16, y: frame.minY + 11.08))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 15.02, y: frame.minY + 3))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 20.86, y: frame.minY + 11.14))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 20.86, y: frame.minY + 11.14))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 21.02, y: frame.minY + 11.52),
            controlPoint1: CGPoint(x: frame.minX + 20.96, y: frame.minY + 11.23),
            controlPoint2: CGPoint(x: frame.minX + 21.02, y: frame.minY + 11.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 20.5, y: frame.minY + 12.03),
            controlPoint1: CGPoint(x: frame.minX + 21.02, y: frame.minY + 11.8),
            controlPoint2: CGPoint(x: frame.minX + 20.79, y: frame.minY + 12.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 20.31, y: frame.minY + 11.99),
            controlPoint1: CGPoint(x: frame.minX + 20.43, y: frame.minY + 12.03),
            controlPoint2: CGPoint(x: frame.minX + 20.37, y: frame.minY + 12.02)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 20.31, y: frame.minY + 11.99))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17.58, y: frame.minY + 11))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17.59, y: frame.minY + 11.01))
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 17.49, y: frame.minY + 11),
            controlPoint1: CGPoint(x: frame.minX + 17.56, y: frame.minY + 11),
            controlPoint2: CGPoint(x: frame.minX + 17.52, y: frame.minY + 11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.52),
            controlPoint1: CGPoint(x: frame.minX + 17.2, y: frame.minY + 11),
            controlPoint2: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.73),
            controlPoint1: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.59),
            controlPoint2: CGPoint(x: frame.minX + 17.01, y: frame.minY + 11.66)
        )
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17, y: frame.minY + 11.72))
        bezierPath.addLine(to: CGPoint(x: frame.minX + 17.01, y: frame.minY + 12.99))
        bezierPath.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneUturnUsingUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.89, y: frame.minY + 15.95)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.11, y: 4.05))
        bezierPath.addLine(to: CGPoint(x: 4.11, y: -4.69))
        bezierPath.addCurve(
            to: CGPoint(x: -0.89, y: -10.95),
            controlPoint1: CGPoint(x: 4.11, y: -6.33),
            controlPoint2: CGPoint(x: 4.11, y: -10.95)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.89, y: -4.95),
            controlPoint1: CGPoint(x: -5.89, y: -10.95),
            controlPoint2: CGPoint(x: -5.89, y: -4.95)
        )
        bezierPath.addLine(to: CGPoint(x: -5.89, y: 11.05))
        primaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 6.13, y: 2.1))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.12, y: 3.36),
            controlPoint1: CGPoint(x: 6.13, y: 2.1),
            controlPoint2: CGPoint(x: 6.12, y: 3.28)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.13, y: 3.56),
            controlPoint1: CGPoint(x: 6.12, y: 3.43),
            controlPoint2: CGPoint(x: 6.13, y: 3.5)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.61, y: 4.09),
            controlPoint1: CGPoint(x: 6.13, y: 3.85),
            controlPoint2: CGPoint(x: 6.32, y: 4.09)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.43, y: 3.09),
            controlPoint1: CGPoint(x: 6.81, y: 4.04),
            controlPoint2: CGPoint(x: 9.31, y: 3.13)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.62, y: 3.06),
            controlPoint1: CGPoint(x: 9.49, y: 3.07),
            controlPoint2: CGPoint(x: 9.55, y: 3.06)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 10.11, y: 3.4),
            controlPoint1: CGPoint(x: 9.84, y: 3.06),
            controlPoint2: CGPoint(x: 10.04, y: 3.2)
        )
        bezier2Path.addLine(to: CGPoint(x: 10.11, y: 3.57))
        bezier2Path.addLine(to: CGPoint(x: 10.11, y: 3.75))
        bezier2Path.addCurve(
            to: CGPoint(x: 9.98, y: 3.95),
            controlPoint1: CGPoint(x: 10.08, y: 3.82),
            controlPoint2: CGPoint(x: 10.03, y: 3.89)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.12, y: 11.02),
            controlPoint1: CGPoint(x: 9.85, y: 4.11),
            controlPoint2: CGPoint(x: 4.12, y: 11.02)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.41, y: 6.5),
            controlPoint1: CGPoint(x: 4.12, y: 11.02),
            controlPoint2: CGPoint(x: 2.08, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.72, y: 3.89),
            controlPoint1: CGPoint(x: -0.71, y: 5.12),
            controlPoint2: CGPoint(x: -1.67, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.88, y: 3.51),
            controlPoint1: CGPoint(x: -1.82, y: 3.79),
            controlPoint2: CGPoint(x: -1.88, y: 3.66)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.37, y: 2.99),
            controlPoint1: CGPoint(x: -1.88, y: 3.22),
            controlPoint2: CGPoint(x: -1.65, y: 2.99)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.18, y: 3.03),
            controlPoint1: CGPoint(x: -1.3, y: 2.99),
            controlPoint2: CGPoint(x: -1.23, y: 3.01)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.55, y: 4.02),
            controlPoint1: CGPoint(x: -1.06, y: 3.07),
            controlPoint2: CGPoint(x: 1.44, y: 3.98)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.13, y: 3.5),
            controlPoint1: CGPoint(x: 1.94, y: 4.02),
            controlPoint2: CGPoint(x: 2.13, y: 3.79)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.13, y: 3.3),
            controlPoint1: CGPoint(x: 2.13, y: 3.43),
            controlPoint2: CGPoint(x: 2.13, y: 3.36)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.13, y: 2.04),
            controlPoint1: CGPoint(x: 2.13, y: 3.22),
            controlPoint2: CGPoint(x: 2.13, y: 2.04)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.13, y: 2.1))
        bezier2Path.close()
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSharpTurnUsingSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 14.98, y: frame.minY + 13.11)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5.04, y: 0.64))
        bezier3Path.addCurve(
            to: CGPoint(x: -0.98, y: -6.11),
            controlPoint1: CGPoint(x: 5.04, y: 0.64),
            controlPoint2: CGPoint(x: 2.02, y: -5.11)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.3, y: -1.5),
            controlPoint1: CGPoint(x: -3.98, y: -7.11),
            controlPoint2: CGPoint(x: -5.98, y: -5.11)
        )
        bezier3Path.addLine(to: CGPoint(x: -6.3, y: 13.77))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 13.95, y: 4.03)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.02, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrSharpTurnUsingSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 0.15, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -3, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -7, y: 7),
            controlPoint1: CGPoint(x: -6, y: 1),
            controlPoint2: CGPoint(x: -7, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 3.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: -0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 4.3, y: 4.75))
        bezier3Path.addCurve(
            to: CGPoint(x: -1, y: -1),
            controlPoint1: CGPoint(x: 4.3, y: 4.75),
            controlPoint2: CGPoint(x: 2, y: -0)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -7, y: 6),
            controlPoint1: CGPoint(x: -4, y: -2),
            controlPoint2: CGPoint(x: -6.69, y: 2.39)
        )
        bezier3Path.addLine(to: CGPoint(x: -7, y: 12))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 13.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurnOrSharpTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 3, y: 4))
        bezierPath.addCurve(
            to: CGPoint(x: -4, y: -3),
            controlPoint1: CGPoint(x: 3, y: 4),
            controlPoint2: CGPoint(x: -1, y: -2)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9, y: 4),
            controlPoint1: CGPoint(x: -7, y: -4),
            controlPoint2: CGPoint(x: -8.69, y: 0.39)
        )
        bezierPath.addLine(to: CGPoint(x: -9, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.lineJoinStyle = .round
        bezierPath.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 12.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 4.46, y: -12))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.77, y: -11.84),
            controlPoint1: CGPoint(x: 4.55, y: -12),
            controlPoint2: CGPoint(x: 4.68, y: -11.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 11.85, y: -5.98),
            controlPoint1: CGPoint(x: 4.93, y: -11.71),
            controlPoint2: CGPoint(x: 11.85, y: -5.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.72, y: -0.14),
            controlPoint1: CGPoint(x: 11.85, y: -5.98),
            controlPoint2: CGPoint(x: 4.87, y: -0.27)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.34, y: 0.02),
            controlPoint1: CGPoint(x: 4.62, y: -0.04),
            controlPoint2: CGPoint(x: 4.48, y: 0.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.82, y: -0.5),
            controlPoint1: CGPoint(x: 4.05, y: 0.02),
            controlPoint2: CGPoint(x: 3.82, y: -0.21)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.86, y: -0.69),
            controlPoint1: CGPoint(x: 3.82, y: -0.56),
            controlPoint2: CGPoint(x: 3.83, y: -0.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.85, y: -3.41),
            controlPoint1: CGPoint(x: 3.9, y: -0.8),
            controlPoint2: CGPoint(x: 4.81, y: -3.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.33, y: -3.99),
            controlPoint1: CGPoint(x: 4.85, y: -3.8),
            controlPoint2: CGPoint(x: 4.62, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.13, y: -3.99),
            controlPoint1: CGPoint(x: 4.26, y: -3.99),
            controlPoint2: CGPoint(x: 4.19, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.87, y: -3.99),
            controlPoint1: CGPoint(x: 4.05, y: -4),
            controlPoint2: CGPoint(x: 2.87, y: -3.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 2.93, y: -7.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.19, y: -7.98),
            controlPoint1: CGPoint(x: 2.93, y: -7.99),
            controlPoint2: CGPoint(x: 4.1, y: -7.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.39, y: -7.99),
            controlPoint1: CGPoint(x: 4.25, y: -7.99),
            controlPoint2: CGPoint(x: 4.32, y: -7.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.91, y: -8.47),
            controlPoint1: CGPoint(x: 4.68, y: -7.99),
            controlPoint2: CGPoint(x: 4.91, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.92, y: -11.29),
            controlPoint1: CGPoint(x: 4.87, y: -8.68),
            controlPoint2: CGPoint(x: 3.96, y: -11.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.88, y: -11.48),
            controlPoint1: CGPoint(x: 3.9, y: -11.35),
            controlPoint2: CGPoint(x: 3.88, y: -11.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.39, y: -12),
            controlPoint1: CGPoint(x: 3.88, y: -11.77),
            controlPoint2: CGPoint(x: 4.11, y: -12)
        )
        bezier3Path.addLine(to: CGPoint(x: 4.46, y: -12))
        bezier3Path.close()
        primaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -9, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -9, y: 4))
        bezier4Path.addCurve(
            to: CGPoint(x: -1, y: -6),
            controlPoint1: CGPoint(x: -9, y: 4),
            controlPoint2: CGPoint(x: -8, y: -6)
        )
        bezier4Path.addLine(to: CGPoint(x: 3, y: -6))
        primaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrUturnUsingUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 1.15, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -2, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -6, y: 6),
            controlPoint1: CGPoint(x: -5, y: 1),
            controlPoint2: CGPoint(x: -6, y: 2)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 4.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.02, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4, y: 5))
        bezierPath.addLine(to: CGPoint(x: 4, y: 4.26))
        bezierPath.addCurve(
            to: CGPoint(x: -1, y: -1),
            controlPoint1: CGPoint(x: 4, y: 2.62),
            controlPoint2: CGPoint(x: 4, y: -1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: 5),
            controlPoint1: CGPoint(x: -6, y: -1),
            controlPoint2: CGPoint(x: -6, y: 5)
        )
        bezierPath.addLine(to: CGPoint(x: -6, y: 12))
        primaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 6.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.01, y: 4.31),
            controlPoint1: CGPoint(x: 6.02, y: 3.05),
            controlPoint2: CGPoint(x: 6.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.02, y: 4.51),
            controlPoint1: CGPoint(x: 6.02, y: 4.37),
            controlPoint2: CGPoint(x: 6.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.5, y: 5.03),
            controlPoint1: CGPoint(x: 6.02, y: 4.8),
            controlPoint2: CGPoint(x: 6.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.32, y: 4.04),
            controlPoint1: CGPoint(x: 6.71, y: 4.99),
            controlPoint2: CGPoint(x: 9.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.51, y: 4),
            controlPoint1: CGPoint(x: 9.38, y: 4.02),
            controlPoint2: CGPoint(x: 9.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 10, y: 4.34),
            controlPoint1: CGPoint(x: 9.74, y: 4),
            controlPoint2: CGPoint(x: 9.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 10, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 10, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 9.87, y: 4.89),
            controlPoint1: CGPoint(x: 9.97, y: 4.77),
            controlPoint2: CGPoint(x: 9.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 11.97),
            controlPoint1: CGPoint(x: 9.74, y: 5.05),
            controlPoint2: CGPoint(x: 4.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.31, y: 7.44),
            controlPoint1: CGPoint(x: 4.02, y: 11.97),
            controlPoint2: CGPoint(x: 1.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.83, y: 4.84),
            controlPoint1: CGPoint(x: -0.82, y: 6.07),
            controlPoint2: CGPoint(x: -1.77, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.99, y: 4.46),
            controlPoint1: CGPoint(x: -1.93, y: 4.74),
            controlPoint2: CGPoint(x: -1.99, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.47, y: 3.94),
            controlPoint1: CGPoint(x: -1.99, y: 4.17),
            controlPoint2: CGPoint(x: -1.76, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.28, y: 3.98),
            controlPoint1: CGPoint(x: -1.4, y: 3.94),
            controlPoint2: CGPoint(x: -1.34, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.44, y: 4.97),
            controlPoint1: CGPoint(x: -1.17, y: 4.02),
            controlPoint2: CGPoint(x: 1.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 4.45),
            controlPoint1: CGPoint(x: 1.83, y: 4.97),
            controlPoint2: CGPoint(x: 2.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.03, y: 4.25),
            controlPoint1: CGPoint(x: 2.02, y: 4.38),
            controlPoint2: CGPoint(x: 2.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 2.99),
            controlPoint1: CGPoint(x: 2.03, y: 4.17),
            controlPoint2: CGPoint(x: 2.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: 3.05))
        bezier2Path.close()
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.05, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 5.31, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 5.31, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.51, y: -0.41),
            controlPoint1: CGPoint(x: 5.37, y: -0.41),
            controlPoint2: CGPoint(x: 5.44, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.9),
            controlPoint1: CGPoint(x: 5.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.03, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.99),
            controlPoint1: CGPoint(x: 6.03, y: -0.93),
            controlPoint2: CGPoint(x: 6.03, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.03, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 5.04, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 5.04, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 5, y: -3.91),
            controlPoint1: CGPoint(x: 5.02, y: -3.77),
            controlPoint2: CGPoint(x: 5, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.52, y: -4.42),
            controlPoint1: CGPoint(x: 5, y: -4.19),
            controlPoint2: CGPoint(x: 5.23, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.9, y: -4.26),
            controlPoint1: CGPoint(x: 5.67, y: -4.42),
            controlPoint2: CGPoint(x: 5.8, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.9, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 5.83, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 5.84, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.46, y: 7.6),
            controlPoint1: CGPoint(x: 5.74, y: 7.53),
            controlPoint2: CGPoint(x: 5.6, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.94, y: 7.08),
            controlPoint1: CGPoint(x: 5.17, y: 7.6),
            controlPoint2: CGPoint(x: 4.94, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.98, y: 6.89),
            controlPoint1: CGPoint(x: 4.94, y: 7.01),
            controlPoint2: CGPoint(x: 4.95, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.98, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 5.97, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 5.97, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.97, y: 4.07),
            controlPoint1: CGPoint(x: 5.97, y: 4.14),
            controlPoint2: CGPoint(x: 5.97, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.45, y: 3.59),
            controlPoint1: CGPoint(x: 5.97, y: 3.78),
            controlPoint2: CGPoint(x: 5.74, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.25, y: 3.58),
            controlPoint1: CGPoint(x: 5.38, y: 3.59),
            controlPoint2: CGPoint(x: 5.31, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.25, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 3.99, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -7.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -7.97, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -6, y: 3.61),
            controlPoint1: CGPoint(x: -7.97, y: 6.23),
            controlPoint2: CGPoint(x: -7.27, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.16, y: 1.61),
            controlPoint1: CGPoint(x: -4.77, y: 2.61),
            controlPoint2: CGPoint(x: -3.07, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.03, y: 1.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -0.85, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -4, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -8, y: 7),
            controlPoint1: CGPoint(x: -7, y: 1),
            controlPoint2: CGPoint(x: -8, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -8.02, y: 12.02))
        primaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 2.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrUturnUsingUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -3.98, y: -13))
        bezier3Path.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezier3Path.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezier3Path.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezier3Path.addLine(to: CGPoint(x: -3.98, y: -13))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 6, y: 5))
        bezierPath.addLine(to: CGPoint(x: 6, y: 4.26))
        bezierPath.addCurve(
            to: CGPoint(x: 1, y: -1),
            controlPoint1: CGPoint(x: 6, y: 2.62),
            controlPoint2: CGPoint(x: 6, y: -1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4, y: 4),
            controlPoint1: CGPoint(x: -4, y: -1),
            controlPoint2: CGPoint(x: -4, y: 4)
        )
        bezierPath.addLine(to: CGPoint(x: -4, y: 12))
        primaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 8.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 4.31),
            controlPoint1: CGPoint(x: 8.02, y: 3.05),
            controlPoint2: CGPoint(x: 8.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.02, y: 4.51),
            controlPoint1: CGPoint(x: 8.02, y: 4.37),
            controlPoint2: CGPoint(x: 8.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.5, y: 5.03),
            controlPoint1: CGPoint(x: 8.02, y: 4.8),
            controlPoint2: CGPoint(x: 8.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.32, y: 4.04),
            controlPoint1: CGPoint(x: 8.71, y: 4.99),
            controlPoint2: CGPoint(x: 11.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.51, y: 4),
            controlPoint1: CGPoint(x: 11.38, y: 4.02),
            controlPoint2: CGPoint(x: 11.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 12, y: 4.34),
            controlPoint1: CGPoint(x: 11.74, y: 4),
            controlPoint2: CGPoint(x: 11.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 12, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 12, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 11.87, y: 4.89),
            controlPoint1: CGPoint(x: 11.97, y: 4.77),
            controlPoint2: CGPoint(x: 11.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.02, y: 11.97),
            controlPoint1: CGPoint(x: 11.74, y: 5.05),
            controlPoint2: CGPoint(x: 6.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.31, y: 7.44),
            controlPoint1: CGPoint(x: 6.02, y: 11.97),
            controlPoint2: CGPoint(x: 3.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.17, y: 4.84),
            controlPoint1: CGPoint(x: 1.18, y: 6.07),
            controlPoint2: CGPoint(x: 0.23, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.01, y: 4.46),
            controlPoint1: CGPoint(x: 0.07, y: 4.74),
            controlPoint2: CGPoint(x: 0.01, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.53, y: 3.94),
            controlPoint1: CGPoint(x: 0.01, y: 4.17),
            controlPoint2: CGPoint(x: 0.24, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.72, y: 3.98),
            controlPoint1: CGPoint(x: 0.6, y: 3.94),
            controlPoint2: CGPoint(x: 0.66, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.44, y: 4.97),
            controlPoint1: CGPoint(x: 0.83, y: 4.02),
            controlPoint2: CGPoint(x: 3.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 4.45),
            controlPoint1: CGPoint(x: 3.83, y: 4.97),
            controlPoint2: CGPoint(x: 4.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.03, y: 4.25),
            controlPoint1: CGPoint(x: 4.02, y: 4.38),
            controlPoint2: CGPoint(x: 4.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 2.99),
            controlPoint1: CGPoint(x: 4.03, y: 4.17),
            controlPoint2: CGPoint(x: 4.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 8.02, y: 3.05))
        bezier2Path.close()
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurnOrUturnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 2, y: 6.27))
        bezierPath.addLine(to: CGPoint(x: 2, y: -0.88))
        bezierPath.addCurve(
            to: CGPoint(x: -3, y: -6),
            controlPoint1: CGPoint(x: 2, y: -2.22),
            controlPoint2: CGPoint(x: 2, y: -6)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -8, y: -1.09),
            controlPoint1: CGPoint(x: -8, y: -6),
            controlPoint2: CGPoint(x: -8, y: -1.09)
        )
        bezierPath.addLine(to: CGPoint(x: -8, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.02, y: 0.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 1.31),
            controlPoint1: CGPoint(x: 4.02, y: 0.05),
            controlPoint2: CGPoint(x: 4.01, y: 1.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 1.51),
            controlPoint1: CGPoint(x: 4.02, y: 1.37),
            controlPoint2: CGPoint(x: 4.02, y: 1.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.5, y: 2.03),
            controlPoint1: CGPoint(x: 4.02, y: 1.8),
            controlPoint2: CGPoint(x: 4.21, y: 2.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.32, y: 1.04),
            controlPoint1: CGPoint(x: 4.71, y: 1.99),
            controlPoint2: CGPoint(x: 7.21, y: 1.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.51, y: 1),
            controlPoint1: CGPoint(x: 7.38, y: 1.02),
            controlPoint2: CGPoint(x: 7.45, y: 1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 1.34),
            controlPoint1: CGPoint(x: 7.74, y: 1),
            controlPoint2: CGPoint(x: 7.93, y: 1.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 1.52))
        bezier2Path.addLine(to: CGPoint(x: 8, y: 1.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 7.87, y: 1.89),
            controlPoint1: CGPoint(x: 7.97, y: 1.77),
            controlPoint2: CGPoint(x: 7.93, y: 1.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 8.97),
            controlPoint1: CGPoint(x: 7.74, y: 2.05),
            controlPoint2: CGPoint(x: 2.02, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.69, y: 4.44),
            controlPoint1: CGPoint(x: 2.02, y: 8.97),
            controlPoint2: CGPoint(x: -0.02, y: 6.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.83, y: 1.84),
            controlPoint1: CGPoint(x: -2.82, y: 3.07),
            controlPoint2: CGPoint(x: -3.77, y: 1.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.99, y: 1.46),
            controlPoint1: CGPoint(x: -3.93, y: 1.74),
            controlPoint2: CGPoint(x: -3.99, y: 1.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.47, y: 0.94),
            controlPoint1: CGPoint(x: -3.99, y: 1.17),
            controlPoint2: CGPoint(x: -3.76, y: 0.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.28, y: 0.98),
            controlPoint1: CGPoint(x: -3.4, y: 0.94),
            controlPoint2: CGPoint(x: -3.34, y: 0.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0.56, y: 1.97),
            controlPoint1: CGPoint(x: -3.17, y: 1.02),
            controlPoint2: CGPoint(x: -0.66, y: 1.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.02, y: 1.45),
            controlPoint1: CGPoint(x: -0.17, y: 1.97),
            controlPoint2: CGPoint(x: 0.02, y: 1.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.03, y: 1.25),
            controlPoint1: CGPoint(x: 0.02, y: 1.38),
            controlPoint2: CGPoint(x: 0.03, y: 1.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.02, y: -0.01),
            controlPoint1: CGPoint(x: 0.03, y: 1.17),
            controlPoint2: CGPoint(x: 0.02, y: -0.01)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 0.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5.46, y: -12))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.77, y: -11.84),
            controlPoint1: CGPoint(x: 5.55, y: -12),
            controlPoint2: CGPoint(x: 5.68, y: -11.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 12.85, y: -5.98),
            controlPoint1: CGPoint(x: 5.93, y: -11.71),
            controlPoint2: CGPoint(x: 12.85, y: -5.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.72, y: -0.14),
            controlPoint1: CGPoint(x: 12.85, y: -5.98),
            controlPoint2: CGPoint(x: 5.87, y: -0.27)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.34, y: 0.02),
            controlPoint1: CGPoint(x: 5.62, y: -0.04),
            controlPoint2: CGPoint(x: 5.48, y: 0.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.82, y: -0.5),
            controlPoint1: CGPoint(x: 5.05, y: 0.02),
            controlPoint2: CGPoint(x: 4.82, y: -0.21)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.86, y: -0.69),
            controlPoint1: CGPoint(x: 4.82, y: -0.56),
            controlPoint2: CGPoint(x: 4.83, y: -0.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.85, y: -3.41),
            controlPoint1: CGPoint(x: 4.9, y: -0.8),
            controlPoint2: CGPoint(x: 5.81, y: -3.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.33, y: -3.99),
            controlPoint1: CGPoint(x: 5.85, y: -3.8),
            controlPoint2: CGPoint(x: 5.62, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.13, y: -3.99),
            controlPoint1: CGPoint(x: 5.26, y: -3.99),
            controlPoint2: CGPoint(x: 5.19, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.87, y: -3.99),
            controlPoint1: CGPoint(x: 5.05, y: -4),
            controlPoint2: CGPoint(x: 3.87, y: -3.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 3.93, y: -7.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.19, y: -7.98),
            controlPoint1: CGPoint(x: 3.93, y: -7.99),
            controlPoint2: CGPoint(x: 5.1, y: -7.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.39, y: -7.99),
            controlPoint1: CGPoint(x: 5.25, y: -7.99),
            controlPoint2: CGPoint(x: 5.32, y: -7.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.91, y: -8.47),
            controlPoint1: CGPoint(x: 5.68, y: -7.99),
            controlPoint2: CGPoint(x: 5.91, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.92, y: -11.29),
            controlPoint1: CGPoint(x: 5.87, y: -8.68),
            controlPoint2: CGPoint(x: 4.96, y: -11.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.88, y: -11.48),
            controlPoint1: CGPoint(x: 4.9, y: -11.35),
            controlPoint2: CGPoint(x: 4.88, y: -11.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.39, y: -12),
            controlPoint1: CGPoint(x: 4.88, y: -11.77),
            controlPoint2: CGPoint(x: 5.11, y: -12)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.46, y: -12))
        bezier3Path.close()
        primaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -8, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -8, y: -1))
        bezier4Path.addCurve(
            to: CGPoint(x: -3, y: -6),
            controlPoint1: CGPoint(x: -8, y: -1),
            controlPoint2: CGPoint(x: -8, y: -6)
        )
        bezier4Path.addLine(to: CGPoint(x: 4, y: -6))
        primaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurnOrUturnUsingUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5.46, y: -12))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.77, y: -11.84),
            controlPoint1: CGPoint(x: 5.55, y: -12),
            controlPoint2: CGPoint(x: 5.68, y: -11.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 12.85, y: -5.98),
            controlPoint1: CGPoint(x: 5.93, y: -11.71),
            controlPoint2: CGPoint(x: 12.85, y: -5.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.72, y: -0.14),
            controlPoint1: CGPoint(x: 12.85, y: -5.98),
            controlPoint2: CGPoint(x: 5.87, y: -0.27)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.34, y: 0.02),
            controlPoint1: CGPoint(x: 5.62, y: -0.04),
            controlPoint2: CGPoint(x: 5.48, y: 0.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.82, y: -0.5),
            controlPoint1: CGPoint(x: 5.05, y: 0.02),
            controlPoint2: CGPoint(x: 4.82, y: -0.21)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.86, y: -0.69),
            controlPoint1: CGPoint(x: 4.82, y: -0.56),
            controlPoint2: CGPoint(x: 4.83, y: -0.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.85, y: -3.41),
            controlPoint1: CGPoint(x: 4.9, y: -0.8),
            controlPoint2: CGPoint(x: 5.81, y: -3.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.33, y: -3.99),
            controlPoint1: CGPoint(x: 5.85, y: -3.8),
            controlPoint2: CGPoint(x: 5.62, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.13, y: -3.99),
            controlPoint1: CGPoint(x: 5.26, y: -3.99),
            controlPoint2: CGPoint(x: 5.19, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.87, y: -3.99),
            controlPoint1: CGPoint(x: 5.05, y: -4),
            controlPoint2: CGPoint(x: 3.87, y: -3.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 3.93, y: -7.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.19, y: -7.98),
            controlPoint1: CGPoint(x: 3.93, y: -7.99),
            controlPoint2: CGPoint(x: 5.1, y: -7.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.39, y: -7.99),
            controlPoint1: CGPoint(x: 5.25, y: -7.99),
            controlPoint2: CGPoint(x: 5.32, y: -7.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.91, y: -8.47),
            controlPoint1: CGPoint(x: 5.68, y: -7.99),
            controlPoint2: CGPoint(x: 5.91, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.92, y: -11.29),
            controlPoint1: CGPoint(x: 5.87, y: -8.68),
            controlPoint2: CGPoint(x: 4.96, y: -11.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.88, y: -11.48),
            controlPoint1: CGPoint(x: 4.9, y: -11.35),
            controlPoint2: CGPoint(x: 4.88, y: -11.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.39, y: -12),
            controlPoint1: CGPoint(x: 4.88, y: -11.77),
            controlPoint2: CGPoint(x: 5.11, y: -12)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.46, y: -12))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -8, y: -1))
        bezier4Path.addLine(to: CGPoint(x: -8, y: -1))
        bezier4Path.addCurve(
            to: CGPoint(x: -3, y: -6),
            controlPoint1: CGPoint(x: -8, y: -1),
            controlPoint2: CGPoint(x: -8, y: -6)
        )
        bezier4Path.addLine(to: CGPoint(x: 4, y: -6))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 2, y: 6.27))
        bezierPath.addLine(to: CGPoint(x: 2, y: -0.88))
        bezierPath.addCurve(
            to: CGPoint(x: -3, y: -6),
            controlPoint1: CGPoint(x: 2, y: -2.22),
            controlPoint2: CGPoint(x: 2, y: -6)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -8, y: -1.09),
            controlPoint1: CGPoint(x: -8, y: -6),
            controlPoint2: CGPoint(x: -8, y: -1.09)
        )
        bezierPath.addLine(to: CGPoint(x: -8, y: 12))
        primaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.02, y: 0.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 1.31),
            controlPoint1: CGPoint(x: 4.02, y: 0.05),
            controlPoint2: CGPoint(x: 4.01, y: 1.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 1.51),
            controlPoint1: CGPoint(x: 4.02, y: 1.37),
            controlPoint2: CGPoint(x: 4.02, y: 1.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.5, y: 2.03),
            controlPoint1: CGPoint(x: 4.02, y: 1.8),
            controlPoint2: CGPoint(x: 4.21, y: 2.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.32, y: 1.04),
            controlPoint1: CGPoint(x: 4.71, y: 1.99),
            controlPoint2: CGPoint(x: 7.21, y: 1.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.51, y: 1),
            controlPoint1: CGPoint(x: 7.38, y: 1.02),
            controlPoint2: CGPoint(x: 7.45, y: 1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 1.34),
            controlPoint1: CGPoint(x: 7.74, y: 1),
            controlPoint2: CGPoint(x: 7.93, y: 1.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 1.52))
        bezier2Path.addLine(to: CGPoint(x: 8, y: 1.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 7.87, y: 1.89),
            controlPoint1: CGPoint(x: 7.97, y: 1.77),
            controlPoint2: CGPoint(x: 7.93, y: 1.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 8.97),
            controlPoint1: CGPoint(x: 7.74, y: 2.05),
            controlPoint2: CGPoint(x: 2.02, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.69, y: 4.44),
            controlPoint1: CGPoint(x: 2.02, y: 8.97),
            controlPoint2: CGPoint(x: -0.02, y: 6.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.83, y: 1.84),
            controlPoint1: CGPoint(x: -2.82, y: 3.07),
            controlPoint2: CGPoint(x: -3.77, y: 1.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.99, y: 1.46),
            controlPoint1: CGPoint(x: -3.93, y: 1.74),
            controlPoint2: CGPoint(x: -3.99, y: 1.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.47, y: 0.94),
            controlPoint1: CGPoint(x: -3.99, y: 1.17),
            controlPoint2: CGPoint(x: -3.76, y: 0.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.28, y: 0.98),
            controlPoint1: CGPoint(x: -3.4, y: 0.94),
            controlPoint2: CGPoint(x: -3.34, y: 0.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0.56, y: 1.97),
            controlPoint1: CGPoint(x: -3.17, y: 1.02),
            controlPoint2: CGPoint(x: -0.66, y: 1.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.02, y: 1.45),
            controlPoint1: CGPoint(x: -0.17, y: 1.97),
            controlPoint2: CGPoint(x: 0.02, y: 1.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.03, y: 1.25),
            controlPoint1: CGPoint(x: 0.02, y: 1.38),
            controlPoint2: CGPoint(x: 0.03, y: 1.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.02, y: -0.01),
            controlPoint1: CGPoint(x: 0.03, y: 1.17),
            controlPoint2: CGPoint(x: 0.02, y: -0.01)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 0.05))
        bezier2Path.close()
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurnOrSharpTurnUsingSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 4.46, y: -12))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.77, y: -11.84),
            controlPoint1: CGPoint(x: 4.55, y: -12),
            controlPoint2: CGPoint(x: 4.68, y: -11.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 11.85, y: -5.98),
            controlPoint1: CGPoint(x: 4.93, y: -11.71),
            controlPoint2: CGPoint(x: 11.85, y: -5.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.72, y: -0.14),
            controlPoint1: CGPoint(x: 11.85, y: -5.98),
            controlPoint2: CGPoint(x: 4.87, y: -0.27)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.34, y: 0.02),
            controlPoint1: CGPoint(x: 4.62, y: -0.04),
            controlPoint2: CGPoint(x: 4.48, y: 0.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.82, y: -0.5),
            controlPoint1: CGPoint(x: 4.05, y: 0.02),
            controlPoint2: CGPoint(x: 3.82, y: -0.21)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.86, y: -0.69),
            controlPoint1: CGPoint(x: 3.82, y: -0.56),
            controlPoint2: CGPoint(x: 3.83, y: -0.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.85, y: -3.41),
            controlPoint1: CGPoint(x: 3.9, y: -0.8),
            controlPoint2: CGPoint(x: 4.81, y: -3.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.33, y: -3.99),
            controlPoint1: CGPoint(x: 4.85, y: -3.8),
            controlPoint2: CGPoint(x: 4.62, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.13, y: -3.99),
            controlPoint1: CGPoint(x: 4.26, y: -3.99),
            controlPoint2: CGPoint(x: 4.19, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.87, y: -3.99),
            controlPoint1: CGPoint(x: 4.05, y: -4),
            controlPoint2: CGPoint(x: 2.87, y: -3.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 2.93, y: -7.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.19, y: -7.98),
            controlPoint1: CGPoint(x: 2.93, y: -7.99),
            controlPoint2: CGPoint(x: 4.1, y: -7.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.39, y: -7.99),
            controlPoint1: CGPoint(x: 4.25, y: -7.99),
            controlPoint2: CGPoint(x: 4.32, y: -7.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.91, y: -8.47),
            controlPoint1: CGPoint(x: 4.68, y: -7.99),
            controlPoint2: CGPoint(x: 4.91, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.92, y: -11.29),
            controlPoint1: CGPoint(x: 4.87, y: -8.68),
            controlPoint2: CGPoint(x: 3.96, y: -11.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.88, y: -11.48),
            controlPoint1: CGPoint(x: 3.9, y: -11.35),
            controlPoint2: CGPoint(x: 3.88, y: -11.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.39, y: -12),
            controlPoint1: CGPoint(x: 3.88, y: -11.77),
            controlPoint2: CGPoint(x: 4.11, y: -12)
        )
        bezier3Path.addLine(to: CGPoint(x: 4.46, y: -12))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -9, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -9, y: 4))
        bezier4Path.addCurve(
            to: CGPoint(x: -1, y: -6),
            controlPoint1: CGPoint(x: -9, y: 4),
            controlPoint2: CGPoint(x: -8, y: -6)
        )
        bezier4Path.addLine(to: CGPoint(x: 3, y: -6))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 3, y: 4))
        bezierPath.addCurve(
            to: CGPoint(x: -4, y: -3),
            controlPoint1: CGPoint(x: 3, y: 4),
            controlPoint2: CGPoint(x: -1, y: -2)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9, y: 4),
            controlPoint1: CGPoint(x: -7, y: -4),
            controlPoint2: CGPoint(x: -8.69, y: 0.39)
        )
        bezierPath.addLine(to: CGPoint(x: -9, y: 12))
        primaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.lineJoinStyle = .round
        bezierPath.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 12.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSharpTurnUsingSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 7.3, y: 4.75))
        bezier3Path.addCurve(
            to: CGPoint(x: 2, y: -1),
            controlPoint1: CGPoint(x: 7.3, y: 4.75),
            controlPoint2: CGPoint(x: 5, y: 0)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -4, y: 5),
            controlPoint1: CGPoint(x: -1, y: -2),
            controlPoint2: CGPoint(x: -3.69, y: 1.39)
        )
        bezier3Path.addLine(to: CGPoint(x: -4, y: 12))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 16.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: -0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -5.95, y: -11))
        bezier3Path.addCurve(
            to: CGPoint(x: -6.2, y: -10.84),
            controlPoint1: CGPoint(x: -6.02, y: -11),
            controlPoint2: CGPoint(x: -6.13, y: -10.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -11.85, y: -4.98),
            controlPoint1: CGPoint(x: -6.33, y: -10.71),
            controlPoint2: CGPoint(x: -11.85, y: -4.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.16, y: 0.86),
            controlPoint1: CGPoint(x: -11.85, y: -4.98),
            controlPoint2: CGPoint(x: -6.28, y: 0.73)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.85, y: 1.02),
            controlPoint1: CGPoint(x: -6.08, y: 0.96),
            controlPoint2: CGPoint(x: -5.97, y: 1.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.44, y: 0.5),
            controlPoint1: CGPoint(x: -5.63, y: 1.02),
            controlPoint2: CGPoint(x: -5.44, y: 0.79)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.47, y: 0.31),
            controlPoint1: CGPoint(x: -5.44, y: 0.44),
            controlPoint2: CGPoint(x: -5.45, y: 0.37)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.26, y: -2.41),
            controlPoint1: CGPoint(x: -5.51, y: 0.2),
            controlPoint2: CGPoint(x: -6.23, y: -2.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.85, y: -2.99),
            controlPoint1: CGPoint(x: -6.27, y: -2.8),
            controlPoint2: CGPoint(x: -6.08, y: -2.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.69, y: -2.99),
            controlPoint1: CGPoint(x: -5.79, y: -2.99),
            controlPoint2: CGPoint(x: -5.74, y: -2.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -4.68, y: -2.99),
            controlPoint1: CGPoint(x: -5.62, y: -3),
            controlPoint2: CGPoint(x: -4.68, y: -2.99)
        )
        bezier3Path.addLine(to: CGPoint(x: -4.73, y: -6.99))
        bezier3Path.addCurve(
            to: CGPoint(x: -5.74, y: -6.98),
            controlPoint1: CGPoint(x: -4.73, y: -6.99),
            controlPoint2: CGPoint(x: -5.67, y: -6.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.9, y: -6.99),
            controlPoint1: CGPoint(x: -5.79, y: -6.99),
            controlPoint2: CGPoint(x: -5.84, y: -6.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.31, y: -7.47),
            controlPoint1: CGPoint(x: -6.13, y: -6.99),
            controlPoint2: CGPoint(x: -6.31, y: -7.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.52, y: -10.29),
            controlPoint1: CGPoint(x: -6.28, y: -7.68),
            controlPoint2: CGPoint(x: -5.55, y: -10.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.49, y: -10.48),
            controlPoint1: CGPoint(x: -5.5, y: -10.35),
            controlPoint2: CGPoint(x: -5.49, y: -10.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.9, y: -11),
            controlPoint1: CGPoint(x: -5.49, y: -10.77),
            controlPoint2: CGPoint(x: -5.67, y: -11)
        )
        bezier3Path.addLine(to: CGPoint(x: -5.95, y: -11))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -0, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -0.05, y: -1.44))
        bezier4Path.addCurve(
            to: CGPoint(x: -3.14, y: -4.97),
            controlPoint1: CGPoint(x: -0.05, y: -1.44),
            controlPoint2: CGPoint(x: -0.27, y: -4.97)
        )
        bezier4Path.addLine(to: CGPoint(x: -8.8, y: -4.97))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 5.95, y: -11))
        bezierPath.addCurve(
            to: CGPoint(x: 6.2, y: -10.84),
            controlPoint1: CGPoint(x: 6.02, y: -11),
            controlPoint2: CGPoint(x: 6.13, y: -10.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.85, y: -4.98),
            controlPoint1: CGPoint(x: 6.33, y: -10.71),
            controlPoint2: CGPoint(x: 11.85, y: -4.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.16, y: 0.86),
            controlPoint1: CGPoint(x: 11.85, y: -4.98),
            controlPoint2: CGPoint(x: 6.28, y: 0.73)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: 1.02),
            controlPoint1: CGPoint(x: 6.08, y: 0.96),
            controlPoint2: CGPoint(x: 5.97, y: 1.02)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.44, y: 0.5),
            controlPoint1: CGPoint(x: 5.63, y: 1.02),
            controlPoint2: CGPoint(x: 5.44, y: 0.79)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.47, y: 0.31),
            controlPoint1: CGPoint(x: 5.44, y: 0.44),
            controlPoint2: CGPoint(x: 5.45, y: 0.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.26, y: -2.41),
            controlPoint1: CGPoint(x: 5.51, y: 0.2),
            controlPoint2: CGPoint(x: 6.23, y: -2.3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: -2.99),
            controlPoint1: CGPoint(x: 6.27, y: -2.8),
            controlPoint2: CGPoint(x: 6.08, y: -2.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.69, y: -2.99),
            controlPoint1: CGPoint(x: 5.79, y: -2.99),
            controlPoint2: CGPoint(x: 5.74, y: -2.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 4.68, y: -2.99),
            controlPoint1: CGPoint(x: 5.62, y: -3),
            controlPoint2: CGPoint(x: 4.68, y: -2.99)
        )
        bezierPath.addLine(to: CGPoint(x: 4.73, y: -6.99))
        bezierPath.addCurve(
            to: CGPoint(x: 5.74, y: -6.98),
            controlPoint1: CGPoint(x: 4.73, y: -6.99),
            controlPoint2: CGPoint(x: 5.67, y: -6.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -6.99),
            controlPoint1: CGPoint(x: 5.79, y: -6.99),
            controlPoint2: CGPoint(x: 5.84, y: -6.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.31, y: -7.47),
            controlPoint1: CGPoint(x: 6.13, y: -6.99),
            controlPoint2: CGPoint(x: 6.31, y: -7.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.52, y: -10.29),
            controlPoint1: CGPoint(x: 6.28, y: -7.68),
            controlPoint2: CGPoint(x: 5.55, y: -10.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.49, y: -10.48),
            controlPoint1: CGPoint(x: 5.5, y: -10.35),
            controlPoint2: CGPoint(x: 5.49, y: -10.42)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -11),
            controlPoint1: CGPoint(x: 5.49, y: -10.77),
            controlPoint2: CGPoint(x: 5.67, y: -11)
        )
        bezierPath.addLine(to: CGPoint(x: 5.95, y: -11))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 0, y: 12))
        bezier2Path.addLine(to: CGPoint(x: 0.05, y: -1.44))
        bezier2Path.addCurve(
            to: CGPoint(x: 3.14, y: -4.97),
            controlPoint1: CGPoint(x: 0.05, y: -1.44),
            controlPoint2: CGPoint(x: 0.27, y: -4.97)
        )
        bezier2Path.addLine(to: CGPoint(x: 8.8, y: -4.97))
        primaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrSharpTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 4.3, y: 4.75))
        bezier3Path.addCurve(
            to: CGPoint(x: -1, y: -1),
            controlPoint1: CGPoint(x: 4.3, y: 4.75),
            controlPoint2: CGPoint(x: 2, y: -0)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -7, y: 6),
            controlPoint1: CGPoint(x: -4, y: -2),
            controlPoint2: CGPoint(x: -6.69, y: 2.39)
        )
        bezier3Path.addLine(to: CGPoint(x: -7, y: 12))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 13.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 0.15, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -3, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -7, y: 7),
            controlPoint1: CGPoint(x: -6, y: 1),
            controlPoint2: CGPoint(x: -7, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.02, y: 12.02))
        primaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 3.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: -0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrUturnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 6, y: 5))
        bezierPath.addLine(to: CGPoint(x: 6, y: 4.26))
        bezierPath.addCurve(
            to: CGPoint(x: 1, y: -1),
            controlPoint1: CGPoint(x: 6, y: 2.62),
            controlPoint2: CGPoint(x: 6, y: -1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4, y: 4),
            controlPoint1: CGPoint(x: -4, y: -1),
            controlPoint2: CGPoint(x: -4, y: 4)
        )
        bezierPath.addLine(to: CGPoint(x: -4, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 8.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 4.31),
            controlPoint1: CGPoint(x: 8.02, y: 3.05),
            controlPoint2: CGPoint(x: 8.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.02, y: 4.51),
            controlPoint1: CGPoint(x: 8.02, y: 4.37),
            controlPoint2: CGPoint(x: 8.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.5, y: 5.03),
            controlPoint1: CGPoint(x: 8.02, y: 4.8),
            controlPoint2: CGPoint(x: 8.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.32, y: 4.04),
            controlPoint1: CGPoint(x: 8.71, y: 4.99),
            controlPoint2: CGPoint(x: 11.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.51, y: 4),
            controlPoint1: CGPoint(x: 11.38, y: 4.02),
            controlPoint2: CGPoint(x: 11.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 12, y: 4.34),
            controlPoint1: CGPoint(x: 11.74, y: 4),
            controlPoint2: CGPoint(x: 11.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 12, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 12, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 11.87, y: 4.89),
            controlPoint1: CGPoint(x: 11.97, y: 4.77),
            controlPoint2: CGPoint(x: 11.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.02, y: 11.97),
            controlPoint1: CGPoint(x: 11.74, y: 5.05),
            controlPoint2: CGPoint(x: 6.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.31, y: 7.44),
            controlPoint1: CGPoint(x: 6.02, y: 11.97),
            controlPoint2: CGPoint(x: 3.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.17, y: 4.84),
            controlPoint1: CGPoint(x: 1.18, y: 6.07),
            controlPoint2: CGPoint(x: 0.23, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.01, y: 4.46),
            controlPoint1: CGPoint(x: 0.07, y: 4.74),
            controlPoint2: CGPoint(x: 0.01, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.53, y: 3.94),
            controlPoint1: CGPoint(x: 0.01, y: 4.17),
            controlPoint2: CGPoint(x: 0.24, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.72, y: 3.98),
            controlPoint1: CGPoint(x: 0.6, y: 3.94),
            controlPoint2: CGPoint(x: 0.66, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.44, y: 4.97),
            controlPoint1: CGPoint(x: 0.83, y: 4.02),
            controlPoint2: CGPoint(x: 3.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 4.45),
            controlPoint1: CGPoint(x: 3.83, y: 4.97),
            controlPoint2: CGPoint(x: 4.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.03, y: 4.25),
            controlPoint1: CGPoint(x: 4.02, y: 4.38),
            controlPoint2: CGPoint(x: 4.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 2.99),
            controlPoint1: CGPoint(x: 4.03, y: 4.17),
            controlPoint2: CGPoint(x: 4.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 8.02, y: 3.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -3.98, y: -13))
        bezier3Path.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezier3Path.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezier3Path.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezier3Path.addLine(to: CGPoint(x: -3.98, y: -13))
        bezier3Path.close()
        primaryColor.setFill()
        bezier3Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSlightTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.95),
            controlPoint2: CGPoint(x: 1.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.49),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5.01),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.02),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.41),
            controlPoint2: CGPoint(x: -5.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.07),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.04),
            controlPoint1: CGPoint(x: -9.35, y: -4.05),
            controlPoint2: CGPoint(x: -9.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.55),
            controlPoint1: CGPoint(x: -9.77, y: -4.04),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.93),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 3.15, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: 0, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: -4, y: 7),
            controlPoint1: CGPoint(x: -3, y: 1),
            controlPoint2: CGPoint(x: -4, y: 5.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -4.02, y: 12.02))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 6.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrSlightTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5, y: -5))
        bezier2Path.addLine(to: CGPoint(x: -3, y: -3))
        bezier2Path.addLine(to: CGPoint(x: -1.47, y: -0.97))
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 3.61),
            controlPoint1: CGPoint(x: -0.6, y: 0.35),
            controlPoint2: CGPoint(x: -0, y: 1.96)
        )
        bezier2Path.addLine(to: CGPoint(x: -0, y: 11.74))
        secondaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.lineJoinStyle = .round
        bezier2Path.stroke()

        //// Bezier 4 Drawing
        context.saveGState()
        context.translateBy(x: -8.6, y: -15.86)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier4Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier4Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier4Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier4Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier4Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier4Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier4Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier4Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier4Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier4Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5, y: -5))
        bezier3Path.addLine(to: CGPoint(x: 3, y: -3))
        bezier3Path.addLine(to: CGPoint(x: 1.47, y: -0.97))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 3.61),
            controlPoint1: CGPoint(x: 0.6, y: 0.35),
            controlPoint2: CGPoint(x: 0, y: 1.96)
        )
        bezier3Path.addLine(to: CGPoint(x: 0, y: 11.74))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 8.25, y: -15.86)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.01, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 3.05, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 4.31, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 4.31, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.51, y: -0.41),
            controlPoint1: CGPoint(x: 4.37, y: -0.41),
            controlPoint2: CGPoint(x: 4.44, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.03, y: -0.9),
            controlPoint1: CGPoint(x: 4.8, y: -0.41),
            controlPoint2: CGPoint(x: 5.03, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.03, y: -0.99),
            controlPoint1: CGPoint(x: 5.03, y: -0.93),
            controlPoint2: CGPoint(x: 5.03, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.03, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 4.04, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 4.04, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 4, y: -3.91),
            controlPoint1: CGPoint(x: 4.02, y: -3.77),
            controlPoint2: CGPoint(x: 4, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.52, y: -4.42),
            controlPoint1: CGPoint(x: 4, y: -4.19),
            controlPoint2: CGPoint(x: 4.23, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.9, y: -4.26),
            controlPoint1: CGPoint(x: 4.67, y: -4.42),
            controlPoint2: CGPoint(x: 4.8, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.9, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 11.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 4.83, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 4.84, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.46, y: 7.6),
            controlPoint1: CGPoint(x: 4.74, y: 7.53),
            controlPoint2: CGPoint(x: 4.6, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.94, y: 7.08),
            controlPoint1: CGPoint(x: 4.17, y: 7.6),
            controlPoint2: CGPoint(x: 3.94, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.98, y: 6.89),
            controlPoint1: CGPoint(x: 3.94, y: 7.01),
            controlPoint2: CGPoint(x: 3.95, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.98, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 4.97, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 4.97, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.97, y: 4.07),
            controlPoint1: CGPoint(x: 4.97, y: 4.14),
            controlPoint2: CGPoint(x: 4.97, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.45, y: 3.59),
            controlPoint1: CGPoint(x: 4.97, y: 3.78),
            controlPoint2: CGPoint(x: 4.74, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.25, y: 3.58),
            controlPoint1: CGPoint(x: 4.38, y: 3.59),
            controlPoint2: CGPoint(x: 4.31, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.25, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 2.99, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -3.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -3.97, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -2, y: 3.61),
            controlPoint1: CGPoint(x: -3.97, y: 6.23),
            controlPoint2: CGPoint(x: -3.27, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.84, y: 1.61),
            controlPoint1: CGPoint(x: -0.77, y: 2.61),
            controlPoint2: CGPoint(x: 0.93, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.03, y: 1.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrUturnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4, y: 5))
        bezierPath.addLine(to: CGPoint(x: 4, y: 4.26))
        bezierPath.addCurve(
            to: CGPoint(x: -1, y: -1),
            controlPoint1: CGPoint(x: 4, y: 2.62),
            controlPoint2: CGPoint(x: 4, y: -1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: 5),
            controlPoint1: CGPoint(x: -6, y: -1),
            controlPoint2: CGPoint(x: -6, y: 5)
        )
        bezierPath.addLine(to: CGPoint(x: -6, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 6.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.01, y: 4.31),
            controlPoint1: CGPoint(x: 6.02, y: 3.05),
            controlPoint2: CGPoint(x: 6.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.02, y: 4.51),
            controlPoint1: CGPoint(x: 6.02, y: 4.37),
            controlPoint2: CGPoint(x: 6.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.5, y: 5.03),
            controlPoint1: CGPoint(x: 6.02, y: 4.8),
            controlPoint2: CGPoint(x: 6.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.32, y: 4.04),
            controlPoint1: CGPoint(x: 6.71, y: 4.99),
            controlPoint2: CGPoint(x: 9.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.51, y: 4),
            controlPoint1: CGPoint(x: 9.38, y: 4.02),
            controlPoint2: CGPoint(x: 9.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 10, y: 4.34),
            controlPoint1: CGPoint(x: 9.74, y: 4),
            controlPoint2: CGPoint(x: 9.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 10, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 10, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 9.87, y: 4.89),
            controlPoint1: CGPoint(x: 9.97, y: 4.77),
            controlPoint2: CGPoint(x: 9.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 11.97),
            controlPoint1: CGPoint(x: 9.74, y: 5.05),
            controlPoint2: CGPoint(x: 4.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.31, y: 7.44),
            controlPoint1: CGPoint(x: 4.02, y: 11.97),
            controlPoint2: CGPoint(x: 1.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.83, y: 4.84),
            controlPoint1: CGPoint(x: -0.82, y: 6.07),
            controlPoint2: CGPoint(x: -1.77, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.99, y: 4.46),
            controlPoint1: CGPoint(x: -1.93, y: 4.74),
            controlPoint2: CGPoint(x: -1.99, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.47, y: 3.94),
            controlPoint1: CGPoint(x: -1.99, y: 4.17),
            controlPoint2: CGPoint(x: -1.76, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.28, y: 3.98),
            controlPoint1: CGPoint(x: -1.4, y: 3.94),
            controlPoint2: CGPoint(x: -1.34, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.44, y: 4.97),
            controlPoint1: CGPoint(x: -1.17, y: 4.02),
            controlPoint2: CGPoint(x: 1.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 4.45),
            controlPoint1: CGPoint(x: 1.83, y: 4.97),
            controlPoint2: CGPoint(x: 2.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.03, y: 4.25),
            controlPoint1: CGPoint(x: 2.02, y: 4.38),
            controlPoint2: CGPoint(x: 2.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 2.99),
            controlPoint1: CGPoint(x: 2.03, y: 4.17),
            controlPoint2: CGPoint(x: 2.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: 3.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 1.15, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -2, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -6, y: 6),
            controlPoint1: CGPoint(x: -5, y: 1),
            controlPoint2: CGPoint(x: -6, y: 2)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.02, y: 12.02))
        primaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 4.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.02, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSlightTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 3.15, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: 0, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: -4, y: 7),
            controlPoint1: CGPoint(x: -3, y: 1),
            controlPoint2: CGPoint(x: -4, y: 5.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -4.02, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 6.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.95),
            controlPoint2: CGPoint(x: 1.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.49),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5.01),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.02),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.41),
            controlPoint2: CGPoint(x: -5.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.07),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.04),
            controlPoint1: CGPoint(x: -9.35, y: -4.05),
            controlPoint2: CGPoint(x: -9.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.55),
            controlPoint1: CGPoint(x: -9.77, y: -4.04),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.93),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSharpTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 7.3, y: 4.75))
        bezier3Path.addCurve(
            to: CGPoint(x: 2, y: -1),
            controlPoint1: CGPoint(x: 7.3, y: 4.75),
            controlPoint2: CGPoint(x: 5, y: 0)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -4, y: 5),
            controlPoint1: CGPoint(x: -1, y: -2),
            controlPoint2: CGPoint(x: -3.69, y: 1.39)
        )
        bezier3Path.addLine(to: CGPoint(x: -4, y: 12))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 16.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: -0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 3.05, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 4.31, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 4.31, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.51, y: -0.41),
            controlPoint1: CGPoint(x: 4.37, y: -0.41),
            controlPoint2: CGPoint(x: 4.44, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.03, y: -0.9),
            controlPoint1: CGPoint(x: 4.8, y: -0.41),
            controlPoint2: CGPoint(x: 5.03, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.03, y: -0.99),
            controlPoint1: CGPoint(x: 5.03, y: -0.93),
            controlPoint2: CGPoint(x: 5.03, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.03, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 4.04, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 4.04, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 4, y: -3.91),
            controlPoint1: CGPoint(x: 4.02, y: -3.77),
            controlPoint2: CGPoint(x: 4, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.52, y: -4.42),
            controlPoint1: CGPoint(x: 4, y: -4.19),
            controlPoint2: CGPoint(x: 4.23, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.9, y: -4.26),
            controlPoint1: CGPoint(x: 4.67, y: -4.42),
            controlPoint2: CGPoint(x: 4.8, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.9, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 11.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 4.83, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 4.84, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.46, y: 7.6),
            controlPoint1: CGPoint(x: 4.74, y: 7.53),
            controlPoint2: CGPoint(x: 4.6, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.94, y: 7.08),
            controlPoint1: CGPoint(x: 4.17, y: 7.6),
            controlPoint2: CGPoint(x: 3.94, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.98, y: 6.89),
            controlPoint1: CGPoint(x: 3.94, y: 7.01),
            controlPoint2: CGPoint(x: 3.95, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.98, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 4.97, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 4.97, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.97, y: 4.07),
            controlPoint1: CGPoint(x: 4.97, y: 4.14),
            controlPoint2: CGPoint(x: 4.97, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.45, y: 3.59),
            controlPoint1: CGPoint(x: 4.97, y: 3.78),
            controlPoint2: CGPoint(x: 4.74, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.25, y: 3.58),
            controlPoint1: CGPoint(x: 4.38, y: 3.59),
            controlPoint2: CGPoint(x: 4.31, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.25, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 2.99, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -3.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -3.97, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -2, y: 3.61),
            controlPoint1: CGPoint(x: -3.97, y: 6.23),
            controlPoint2: CGPoint(x: -3.27, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.84, y: 1.61),
            controlPoint1: CGPoint(x: -0.77, y: 2.61),
            controlPoint2: CGPoint(x: 0.93, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.03, y: 1.61))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -0.85, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -4, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -8, y: 7),
            controlPoint1: CGPoint(x: -7, y: 1),
            controlPoint2: CGPoint(x: -8, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -8.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 2.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.05, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 5.31, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 5.31, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.51, y: -0.41),
            controlPoint1: CGPoint(x: 5.37, y: -0.41),
            controlPoint2: CGPoint(x: 5.44, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.9),
            controlPoint1: CGPoint(x: 5.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.03, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.99),
            controlPoint1: CGPoint(x: 6.03, y: -0.93),
            controlPoint2: CGPoint(x: 6.03, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.03, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 5.04, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 5.04, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 5, y: -3.91),
            controlPoint1: CGPoint(x: 5.02, y: -3.77),
            controlPoint2: CGPoint(x: 5, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.52, y: -4.42),
            controlPoint1: CGPoint(x: 5, y: -4.19),
            controlPoint2: CGPoint(x: 5.23, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.9, y: -4.26),
            controlPoint1: CGPoint(x: 5.67, y: -4.42),
            controlPoint2: CGPoint(x: 5.8, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.9, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 5.83, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 5.84, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.46, y: 7.6),
            controlPoint1: CGPoint(x: 5.74, y: 7.53),
            controlPoint2: CGPoint(x: 5.6, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.94, y: 7.08),
            controlPoint1: CGPoint(x: 5.17, y: 7.6),
            controlPoint2: CGPoint(x: 4.94, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.98, y: 6.89),
            controlPoint1: CGPoint(x: 4.94, y: 7.01),
            controlPoint2: CGPoint(x: 4.95, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.98, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 5.97, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 5.97, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.97, y: 4.07),
            controlPoint1: CGPoint(x: 5.97, y: 4.14),
            controlPoint2: CGPoint(x: 5.97, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.45, y: 3.59),
            controlPoint1: CGPoint(x: 5.97, y: 3.78),
            controlPoint2: CGPoint(x: 5.74, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.25, y: 3.58),
            controlPoint1: CGPoint(x: 5.38, y: 3.59),
            controlPoint2: CGPoint(x: 5.31, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.25, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 3.99, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -7.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -7.97, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -6, y: 3.61),
            controlPoint1: CGPoint(x: -7.97, y: 6.23),
            controlPoint2: CGPoint(x: -7.27, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.16, y: 1.61),
            controlPoint1: CGPoint(x: -4.77, y: 2.61),
            controlPoint2: CGPoint(x: -3.07, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.03, y: 1.61))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrSlightTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5.95, y: -7))
        bezier2Path.addCurve(
            to: CGPoint(x: -6.2, y: -6.84),
            controlPoint1: CGPoint(x: -6.02, y: -7),
            controlPoint2: CGPoint(x: -6.13, y: -6.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.85, y: -0.98),
            controlPoint1: CGPoint(x: -6.33, y: -6.71),
            controlPoint2: CGPoint(x: -11.85, y: -0.98)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -6.16, y: 4.86),
            controlPoint1: CGPoint(x: -11.85, y: -0.98),
            controlPoint2: CGPoint(x: -6.28, y: 4.73)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.85, y: 5.02),
            controlPoint1: CGPoint(x: -6.08, y: 4.96),
            controlPoint2: CGPoint(x: -5.97, y: 5.02)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.44, y: 4.5),
            controlPoint1: CGPoint(x: -5.63, y: 5.02),
            controlPoint2: CGPoint(x: -5.44, y: 4.79)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.47, y: 4.31),
            controlPoint1: CGPoint(x: -5.44, y: 4.44),
            controlPoint2: CGPoint(x: -5.45, y: 4.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -6.26, y: 1.59),
            controlPoint1: CGPoint(x: -5.51, y: 4.2),
            controlPoint2: CGPoint(x: -6.23, y: 1.7)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.85, y: 1.01),
            controlPoint1: CGPoint(x: -6.27, y: 1.2),
            controlPoint2: CGPoint(x: -6.08, y: 1.01)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.69, y: 1.01),
            controlPoint1: CGPoint(x: -5.79, y: 1.01),
            controlPoint2: CGPoint(x: -5.74, y: 1.01)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -4.68, y: 1.01),
            controlPoint1: CGPoint(x: -5.62, y: 1),
            controlPoint2: CGPoint(x: -4.68, y: 1.01)
        )
        bezier2Path.addLine(to: CGPoint(x: -4.73, y: -2.99))
        bezier2Path.addCurve(
            to: CGPoint(x: -5.74, y: -2.98),
            controlPoint1: CGPoint(x: -4.73, y: -2.99),
            controlPoint2: CGPoint(x: -5.67, y: -2.98)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.9, y: -2.99),
            controlPoint1: CGPoint(x: -5.79, y: -2.99),
            controlPoint2: CGPoint(x: -5.84, y: -2.99)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -6.31, y: -3.47),
            controlPoint1: CGPoint(x: -6.13, y: -2.99),
            controlPoint2: CGPoint(x: -6.31, y: -3.18)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.52, y: -6.29),
            controlPoint1: CGPoint(x: -6.28, y: -3.68),
            controlPoint2: CGPoint(x: -5.55, y: -6.18)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.49, y: -6.48),
            controlPoint1: CGPoint(x: -5.5, y: -6.35),
            controlPoint2: CGPoint(x: -5.49, y: -6.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.9, y: -7),
            controlPoint1: CGPoint(x: -5.49, y: -6.77),
            controlPoint2: CGPoint(x: -5.67, y: -7)
        )
        bezier2Path.addLine(to: CGPoint(x: -5.95, y: -7))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -0, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -0.05, y: 2.56))
        bezier4Path.addCurve(
            to: CGPoint(x: -4.14, y: -0.97),
            controlPoint1: CGPoint(x: -0.05, y: 2.56),
            controlPoint2: CGPoint(x: -0.27, y: -0.97)
        )
        bezier4Path.addLine(to: CGPoint(x: -8.8, y: -0.97))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5, y: -5))
        bezier3Path.addLine(to: CGPoint(x: 3, y: -3))
        bezier3Path.addLine(to: CGPoint(x: 1.47, y: -0.97))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 3.61),
            controlPoint1: CGPoint(x: 0.6, y: 0.35),
            controlPoint2: CGPoint(x: 0, y: 1.96)
        )
        bezier3Path.addLine(to: CGPoint(x: 0, y: 11.74))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 8.25, y: -15.86)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.01, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5, y: -5))
        bezier2Path.addLine(to: CGPoint(x: -3, y: -3))
        bezier2Path.addLine(to: CGPoint(x: -1.47, y: -0.97))
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 3.61),
            controlPoint1: CGPoint(x: -0.6, y: 0.35),
            controlPoint2: CGPoint(x: -0, y: 1.96)
        )
        bezier2Path.addLine(to: CGPoint(x: -0, y: 11.74))
        secondaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.lineJoinStyle = .round
        bezier2Path.stroke()

        //// Bezier 4 Drawing
        context.saveGState()
        context.translateBy(x: -8.6, y: -15.86)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier4Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier4Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier4Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier4Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier4Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier4Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier4Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier4Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier4Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier4Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 5.95, y: -7))
        bezierPath.addCurve(
            to: CGPoint(x: 6.2, y: -6.84),
            controlPoint1: CGPoint(x: 6.02, y: -7),
            controlPoint2: CGPoint(x: 6.13, y: -6.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.85, y: -0.98),
            controlPoint1: CGPoint(x: 6.33, y: -6.71),
            controlPoint2: CGPoint(x: 11.85, y: -0.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.16, y: 4.86),
            controlPoint1: CGPoint(x: 11.85, y: -0.98),
            controlPoint2: CGPoint(x: 6.28, y: 4.73)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: 5.02),
            controlPoint1: CGPoint(x: 6.08, y: 4.96),
            controlPoint2: CGPoint(x: 5.97, y: 5.02)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.44, y: 4.5),
            controlPoint1: CGPoint(x: 5.63, y: 5.02),
            controlPoint2: CGPoint(x: 5.44, y: 4.79)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.47, y: 4.31),
            controlPoint1: CGPoint(x: 5.44, y: 4.44),
            controlPoint2: CGPoint(x: 5.45, y: 4.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.26, y: 1.59),
            controlPoint1: CGPoint(x: 5.51, y: 4.2),
            controlPoint2: CGPoint(x: 6.23, y: 1.7)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: 1.01),
            controlPoint1: CGPoint(x: 6.27, y: 1.2),
            controlPoint2: CGPoint(x: 6.08, y: 1.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.69, y: 1.01),
            controlPoint1: CGPoint(x: 5.79, y: 1.01),
            controlPoint2: CGPoint(x: 5.74, y: 1.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 4.68, y: 1.01),
            controlPoint1: CGPoint(x: 5.62, y: 1),
            controlPoint2: CGPoint(x: 4.68, y: 1.01)
        )
        bezierPath.addLine(to: CGPoint(x: 4.73, y: -2.99))
        bezierPath.addCurve(
            to: CGPoint(x: 5.74, y: -2.98),
            controlPoint1: CGPoint(x: 4.73, y: -2.99),
            controlPoint2: CGPoint(x: 5.67, y: -2.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -2.99),
            controlPoint1: CGPoint(x: 5.79, y: -2.99),
            controlPoint2: CGPoint(x: 5.84, y: -2.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.31, y: -3.47),
            controlPoint1: CGPoint(x: 6.13, y: -2.99),
            controlPoint2: CGPoint(x: 6.31, y: -3.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.52, y: -6.29),
            controlPoint1: CGPoint(x: 6.28, y: -3.68),
            controlPoint2: CGPoint(x: 5.55, y: -6.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.49, y: -6.48),
            controlPoint1: CGPoint(x: 5.5, y: -6.35),
            controlPoint2: CGPoint(x: 5.49, y: -6.42)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -7),
            controlPoint1: CGPoint(x: 5.49, y: -6.77),
            controlPoint2: CGPoint(x: 5.67, y: -7)
        )
        bezierPath.addLine(to: CGPoint(x: 5.95, y: -7))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 0, y: 12))
        bezier3Path.addLine(to: CGPoint(x: 0.05, y: 2.56))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.14, y: -0.97),
            controlPoint1: CGPoint(x: 0.05, y: 2.56),
            controlPoint2: CGPoint(x: 0.27, y: -0.97)
        )
        bezier3Path.addLine(to: CGPoint(x: 8.8, y: -0.97))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 6, y: 5))
        bezierPath.addLine(to: CGPoint(x: 6, y: 4.26))
        bezierPath.addCurve(
            to: CGPoint(x: 1, y: -1),
            controlPoint1: CGPoint(x: 6, y: 2.62),
            controlPoint2: CGPoint(x: 6, y: -1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4, y: 4),
            controlPoint1: CGPoint(x: -4, y: -1),
            controlPoint2: CGPoint(x: -4, y: 4)
        )
        bezierPath.addLine(to: CGPoint(x: -4, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 8.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 4.31),
            controlPoint1: CGPoint(x: 8.02, y: 3.05),
            controlPoint2: CGPoint(x: 8.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.02, y: 4.51),
            controlPoint1: CGPoint(x: 8.02, y: 4.37),
            controlPoint2: CGPoint(x: 8.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.5, y: 5.03),
            controlPoint1: CGPoint(x: 8.02, y: 4.8),
            controlPoint2: CGPoint(x: 8.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.32, y: 4.04),
            controlPoint1: CGPoint(x: 8.71, y: 4.99),
            controlPoint2: CGPoint(x: 11.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.51, y: 4),
            controlPoint1: CGPoint(x: 11.38, y: 4.02),
            controlPoint2: CGPoint(x: 11.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 12, y: 4.34),
            controlPoint1: CGPoint(x: 11.74, y: 4),
            controlPoint2: CGPoint(x: 11.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 12, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 12, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 11.87, y: 4.89),
            controlPoint1: CGPoint(x: 11.97, y: 4.77),
            controlPoint2: CGPoint(x: 11.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.02, y: 11.97),
            controlPoint1: CGPoint(x: 11.74, y: 5.05),
            controlPoint2: CGPoint(x: 6.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.31, y: 7.44),
            controlPoint1: CGPoint(x: 6.02, y: 11.97),
            controlPoint2: CGPoint(x: 3.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.17, y: 4.84),
            controlPoint1: CGPoint(x: 1.18, y: 6.07),
            controlPoint2: CGPoint(x: 0.23, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.01, y: 4.46),
            controlPoint1: CGPoint(x: 0.07, y: 4.74),
            controlPoint2: CGPoint(x: 0.01, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.53, y: 3.94),
            controlPoint1: CGPoint(x: 0.01, y: 4.17),
            controlPoint2: CGPoint(x: 0.24, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.72, y: 3.98),
            controlPoint1: CGPoint(x: 0.6, y: 3.94),
            controlPoint2: CGPoint(x: 0.66, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.44, y: 4.97),
            controlPoint1: CGPoint(x: 0.83, y: 4.02),
            controlPoint2: CGPoint(x: 3.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 4.45),
            controlPoint1: CGPoint(x: 3.83, y: 4.97),
            controlPoint2: CGPoint(x: 4.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.03, y: 4.25),
            controlPoint1: CGPoint(x: 4.02, y: 4.38),
            controlPoint2: CGPoint(x: 4.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 2.99),
            controlPoint1: CGPoint(x: 4.03, y: 4.17),
            controlPoint2: CGPoint(x: 4.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 8.02, y: 3.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -3.98, y: -13))
        bezier3Path.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezier3Path.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezier3Path.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezier3Path.addLine(to: CGPoint(x: -3.98, y: -13))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 3.15, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: 0, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: -4, y: 7),
            controlPoint1: CGPoint(x: -3, y: 1),
            controlPoint2: CGPoint(x: -4, y: 5.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -4.02, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 6.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.95),
            controlPoint2: CGPoint(x: 1.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.49),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5.01),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.02),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.41),
            controlPoint2: CGPoint(x: -5.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.07),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.04),
            controlPoint1: CGPoint(x: -9.35, y: -4.05),
            controlPoint2: CGPoint(x: -9.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.55),
            controlPoint1: CGPoint(x: -9.77, y: -4.04),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.93),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 7.3, y: 4.75))
        bezier3Path.addCurve(
            to: CGPoint(x: 2, y: -1),
            controlPoint1: CGPoint(x: 7.3, y: 4.75),
            controlPoint2: CGPoint(x: 5, y: 0)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -4, y: 5),
            controlPoint1: CGPoint(x: -1, y: -2),
            controlPoint2: CGPoint(x: -3.69, y: 1.39)
        )
        bezier3Path.addLine(to: CGPoint(x: -4, y: 12))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 16.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: -0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 3.05, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 4.31, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 4.31, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.51, y: -0.41),
            controlPoint1: CGPoint(x: 4.37, y: -0.41),
            controlPoint2: CGPoint(x: 4.44, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.03, y: -0.9),
            controlPoint1: CGPoint(x: 4.8, y: -0.41),
            controlPoint2: CGPoint(x: 5.03, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.03, y: -0.99),
            controlPoint1: CGPoint(x: 5.03, y: -0.93),
            controlPoint2: CGPoint(x: 5.03, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.03, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 4.04, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 4.04, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 4, y: -3.91),
            controlPoint1: CGPoint(x: 4.02, y: -3.77),
            controlPoint2: CGPoint(x: 4, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.52, y: -4.42),
            controlPoint1: CGPoint(x: 4, y: -4.19),
            controlPoint2: CGPoint(x: 4.23, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.9, y: -4.26),
            controlPoint1: CGPoint(x: 4.67, y: -4.42),
            controlPoint2: CGPoint(x: 4.8, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.9, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 11.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 4.83, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 4.84, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.46, y: 7.6),
            controlPoint1: CGPoint(x: 4.74, y: 7.53),
            controlPoint2: CGPoint(x: 4.6, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.94, y: 7.08),
            controlPoint1: CGPoint(x: 4.17, y: 7.6),
            controlPoint2: CGPoint(x: 3.94, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.98, y: 6.89),
            controlPoint1: CGPoint(x: 3.94, y: 7.01),
            controlPoint2: CGPoint(x: 3.95, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.98, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 4.97, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 4.97, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.97, y: 4.07),
            controlPoint1: CGPoint(x: 4.97, y: 4.14),
            controlPoint2: CGPoint(x: 4.97, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.45, y: 3.59),
            controlPoint1: CGPoint(x: 4.97, y: 3.78),
            controlPoint2: CGPoint(x: 4.74, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.25, y: 3.58),
            controlPoint1: CGPoint(x: 4.38, y: 3.59),
            controlPoint2: CGPoint(x: 4.31, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.25, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 2.99, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -3.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -3.97, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -2, y: 3.61),
            controlPoint1: CGPoint(x: -3.97, y: 6.23),
            controlPoint2: CGPoint(x: -3.27, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.84, y: 1.61),
            controlPoint1: CGPoint(x: -0.77, y: 2.61),
            controlPoint2: CGPoint(x: 0.93, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.03, y: 1.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -6, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -3.98, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 1.86, y: -4.87),
            controlPoint1: CGPoint(x: -3.94, y: -12.94),
            controlPoint2: CGPoint(x: 1.74, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.02, y: -4.48),
            controlPoint1: CGPoint(x: 1.96, y: -4.77),
            controlPoint2: CGPoint(x: 2.02, y: -4.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.5, y: -3.97),
            controlPoint1: CGPoint(x: 2.02, y: -4.2),
            controlPoint2: CGPoint(x: 1.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 1.31, y: -4.01),
            controlPoint1: CGPoint(x: 1.44, y: -3.97),
            controlPoint2: CGPoint(x: 1.37, y: -3.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.41, y: -5),
            controlPoint1: CGPoint(x: 1.2, y: -4.05),
            controlPoint2: CGPoint(x: -1.31, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.48),
            controlPoint1: CGPoint(x: -1.8, y: -5),
            controlPoint2: CGPoint(x: -1.99, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -4.28),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -3.01),
            controlPoint1: CGPoint(x: -2, y: -4.2),
            controlPoint2: CGPoint(x: -1.99, y: -3.01)
        )
        bezierPath.addLine(to: CGPoint(x: -5.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -5.98, y: -4.34),
            controlPoint1: CGPoint(x: -5.99, y: -3.08),
            controlPoint2: CGPoint(x: -5.98, y: -4.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.99, y: -4.54),
            controlPoint1: CGPoint(x: -5.99, y: -4.4),
            controlPoint2: CGPoint(x: -5.99, y: -4.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.47, y: -5.06),
            controlPoint1: CGPoint(x: -5.99, y: -4.83),
            controlPoint2: CGPoint(x: -6.18, y: -5.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.29, y: -4.07),
            controlPoint1: CGPoint(x: -6.68, y: -5.02),
            controlPoint2: CGPoint(x: -9.18, y: -4.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.48, y: -4.03),
            controlPoint1: CGPoint(x: -9.35, y: -4.04),
            controlPoint2: CGPoint(x: -9.42, y: -4.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -10, y: -4.54),
            controlPoint1: CGPoint(x: -9.77, y: -4.03),
            controlPoint2: CGPoint(x: -10, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.84, y: -4.92),
            controlPoint1: CGPoint(x: -10, y: -4.7),
            controlPoint2: CGPoint(x: -9.94, y: -4.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -3.99, y: -13),
            controlPoint1: CGPoint(x: -9.72, y: -5.1),
            controlPoint2: CGPoint(x: -4.03, y: -12.94)
        )
        bezierPath.addLine(to: CGPoint(x: -3.98, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.05, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 5.31, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 5.31, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.51, y: -0.41),
            controlPoint1: CGPoint(x: 5.37, y: -0.41),
            controlPoint2: CGPoint(x: 5.44, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.9),
            controlPoint1: CGPoint(x: 5.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.03, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.99),
            controlPoint1: CGPoint(x: 6.03, y: -0.93),
            controlPoint2: CGPoint(x: 6.03, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.03, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 5.04, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 5.04, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 5, y: -3.91),
            controlPoint1: CGPoint(x: 5.02, y: -3.77),
            controlPoint2: CGPoint(x: 5, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.52, y: -4.42),
            controlPoint1: CGPoint(x: 5, y: -4.19),
            controlPoint2: CGPoint(x: 5.23, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.9, y: -4.26),
            controlPoint1: CGPoint(x: 5.67, y: -4.42),
            controlPoint2: CGPoint(x: 5.8, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.9, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 5.83, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 5.84, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.46, y: 7.6),
            controlPoint1: CGPoint(x: 5.74, y: 7.53),
            controlPoint2: CGPoint(x: 5.6, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.94, y: 7.08),
            controlPoint1: CGPoint(x: 5.17, y: 7.6),
            controlPoint2: CGPoint(x: 4.94, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.98, y: 6.89),
            controlPoint1: CGPoint(x: 4.94, y: 7.01),
            controlPoint2: CGPoint(x: 4.95, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.98, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 5.97, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 5.97, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.97, y: 4.07),
            controlPoint1: CGPoint(x: 5.97, y: 4.14),
            controlPoint2: CGPoint(x: 5.97, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.45, y: 3.59),
            controlPoint1: CGPoint(x: 5.97, y: 3.78),
            controlPoint2: CGPoint(x: 5.74, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.25, y: 3.58),
            controlPoint1: CGPoint(x: 5.38, y: 3.59),
            controlPoint2: CGPoint(x: 5.31, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.25, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 3.99, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -7.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -7.97, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -6, y: 3.61),
            controlPoint1: CGPoint(x: -7.97, y: 6.23),
            controlPoint2: CGPoint(x: -7.27, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -1.16, y: 1.61),
            controlPoint1: CGPoint(x: -4.77, y: 2.61),
            controlPoint2: CGPoint(x: -3.07, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.03, y: 1.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -0.85, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -4, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -8, y: 7),
            controlPoint1: CGPoint(x: -7, y: 1),
            controlPoint2: CGPoint(x: -8, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -8.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 2.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 4.3, y: 4.75))
        bezier3Path.addCurve(
            to: CGPoint(x: -1, y: -1),
            controlPoint1: CGPoint(x: 4.3, y: 4.75),
            controlPoint2: CGPoint(x: 2, y: -0)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -7, y: 6),
            controlPoint1: CGPoint(x: -4, y: -2),
            controlPoint2: CGPoint(x: -6.69, y: 2.39)
        )
        bezier3Path.addLine(to: CGPoint(x: -7, y: 12))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 13.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.59, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 0.15, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -3, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -7, y: 7),
            controlPoint1: CGPoint(x: -6, y: 1),
            controlPoint2: CGPoint(x: -7, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 3.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: -0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneSlightTurnOrUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4, y: 5))
        bezierPath.addLine(to: CGPoint(x: 4, y: 4.26))
        bezierPath.addCurve(
            to: CGPoint(x: -1, y: -1),
            controlPoint1: CGPoint(x: 4, y: 2.62),
            controlPoint2: CGPoint(x: 4, y: -1)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: 5),
            controlPoint1: CGPoint(x: -6, y: -1),
            controlPoint2: CGPoint(x: -6, y: 5)
        )
        bezierPath.addLine(to: CGPoint(x: -6, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 6.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.01, y: 4.31),
            controlPoint1: CGPoint(x: 6.02, y: 3.05),
            controlPoint2: CGPoint(x: 6.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.02, y: 4.51),
            controlPoint1: CGPoint(x: 6.02, y: 4.37),
            controlPoint2: CGPoint(x: 6.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.5, y: 5.03),
            controlPoint1: CGPoint(x: 6.02, y: 4.8),
            controlPoint2: CGPoint(x: 6.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.32, y: 4.04),
            controlPoint1: CGPoint(x: 6.71, y: 4.99),
            controlPoint2: CGPoint(x: 9.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9.51, y: 4),
            controlPoint1: CGPoint(x: 9.38, y: 4.02),
            controlPoint2: CGPoint(x: 9.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 10, y: 4.34),
            controlPoint1: CGPoint(x: 9.74, y: 4),
            controlPoint2: CGPoint(x: 9.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 10, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 10, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 9.87, y: 4.89),
            controlPoint1: CGPoint(x: 9.97, y: 4.77),
            controlPoint2: CGPoint(x: 9.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 11.97),
            controlPoint1: CGPoint(x: 9.74, y: 5.05),
            controlPoint2: CGPoint(x: 4.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.31, y: 7.44),
            controlPoint1: CGPoint(x: 4.02, y: 11.97),
            controlPoint2: CGPoint(x: 1.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.83, y: 4.84),
            controlPoint1: CGPoint(x: -0.82, y: 6.07),
            controlPoint2: CGPoint(x: -1.77, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.99, y: 4.46),
            controlPoint1: CGPoint(x: -1.93, y: 4.74),
            controlPoint2: CGPoint(x: -1.99, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.47, y: 3.94),
            controlPoint1: CGPoint(x: -1.99, y: 4.17),
            controlPoint2: CGPoint(x: -1.76, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.28, y: 3.98),
            controlPoint1: CGPoint(x: -1.4, y: 3.94),
            controlPoint2: CGPoint(x: -1.34, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.44, y: 4.97),
            controlPoint1: CGPoint(x: -1.17, y: 4.02),
            controlPoint2: CGPoint(x: 1.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 4.45),
            controlPoint1: CGPoint(x: 1.83, y: 4.97),
            controlPoint2: CGPoint(x: 2.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.03, y: 4.25),
            controlPoint1: CGPoint(x: 2.02, y: 4.38),
            controlPoint2: CGPoint(x: 2.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 2.99),
            controlPoint1: CGPoint(x: 2.03, y: 4.17),
            controlPoint2: CGPoint(x: 2.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.02, y: 3.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 1.15, y: -4.97))
        bezier4Path.addLine(to: CGPoint(x: -2, y: -2))
        bezier4Path.addCurve(
            to: CGPoint(x: -6, y: 6),
            controlPoint1: CGPoint(x: -5, y: 1),
            controlPoint2: CGPoint(x: -6, y: 2)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 4.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: 0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: 0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.02, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8.01, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurnOrSharpTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 3, y: 4))
        bezierPath.addCurve(
            to: CGPoint(x: -4, y: -3),
            controlPoint1: CGPoint(x: 3, y: 4),
            controlPoint2: CGPoint(x: -1, y: -2)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9, y: 4),
            controlPoint1: CGPoint(x: -7, y: -4),
            controlPoint2: CGPoint(x: -8.69, y: 0.39)
        )
        bezierPath.addLine(to: CGPoint(x: -9, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.lineJoinStyle = .round
        bezierPath.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 12.21, y: 8.14)
        context.rotate(by: 149.53 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 4.46, y: -12))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.77, y: -11.84),
            controlPoint1: CGPoint(x: 4.55, y: -12),
            controlPoint2: CGPoint(x: 4.68, y: -11.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 11.85, y: -5.98),
            controlPoint1: CGPoint(x: 4.93, y: -11.71),
            controlPoint2: CGPoint(x: 11.85, y: -5.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.72, y: -0.14),
            controlPoint1: CGPoint(x: 11.85, y: -5.98),
            controlPoint2: CGPoint(x: 4.87, y: -0.27)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.34, y: 0.02),
            controlPoint1: CGPoint(x: 4.62, y: -0.04),
            controlPoint2: CGPoint(x: 4.48, y: 0.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.82, y: -0.5),
            controlPoint1: CGPoint(x: 4.05, y: 0.02),
            controlPoint2: CGPoint(x: 3.82, y: -0.21)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.86, y: -0.69),
            controlPoint1: CGPoint(x: 3.82, y: -0.56),
            controlPoint2: CGPoint(x: 3.83, y: -0.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.85, y: -3.41),
            controlPoint1: CGPoint(x: 3.9, y: -0.8),
            controlPoint2: CGPoint(x: 4.81, y: -3.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.33, y: -3.99),
            controlPoint1: CGPoint(x: 4.85, y: -3.8),
            controlPoint2: CGPoint(x: 4.62, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.13, y: -3.99),
            controlPoint1: CGPoint(x: 4.26, y: -3.99),
            controlPoint2: CGPoint(x: 4.19, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 2.87, y: -3.99),
            controlPoint1: CGPoint(x: 4.05, y: -4),
            controlPoint2: CGPoint(x: 2.87, y: -3.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 2.93, y: -7.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.19, y: -7.98),
            controlPoint1: CGPoint(x: 2.93, y: -7.99),
            controlPoint2: CGPoint(x: 4.1, y: -7.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.39, y: -7.99),
            controlPoint1: CGPoint(x: 4.25, y: -7.99),
            controlPoint2: CGPoint(x: 4.32, y: -7.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.91, y: -8.47),
            controlPoint1: CGPoint(x: 4.68, y: -7.99),
            controlPoint2: CGPoint(x: 4.91, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.92, y: -11.29),
            controlPoint1: CGPoint(x: 4.87, y: -8.68),
            controlPoint2: CGPoint(x: 3.96, y: -11.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.88, y: -11.48),
            controlPoint1: CGPoint(x: 3.9, y: -11.35),
            controlPoint2: CGPoint(x: 3.88, y: -11.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.39, y: -12),
            controlPoint1: CGPoint(x: 3.88, y: -11.77),
            controlPoint2: CGPoint(x: 4.11, y: -12)
        )
        bezier3Path.addLine(to: CGPoint(x: 4.46, y: -12))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -9, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -9, y: 4))
        bezier4Path.addCurve(
            to: CGPoint(x: -1, y: -6),
            controlPoint1: CGPoint(x: -9, y: 4),
            controlPoint2: CGPoint(x: -8, y: -6)
        )
        bezier4Path.addLine(to: CGPoint(x: 3, y: -6))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneTurnOrUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 2, y: 6.27))
        bezierPath.addLine(to: CGPoint(x: 2, y: -0.88))
        bezierPath.addCurve(
            to: CGPoint(x: -3, y: -6),
            controlPoint1: CGPoint(x: 2, y: -2.22),
            controlPoint2: CGPoint(x: 2, y: -6)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -8, y: -1.09),
            controlPoint1: CGPoint(x: -8, y: -6),
            controlPoint2: CGPoint(x: -8, y: -1.09)
        )
        bezierPath.addLine(to: CGPoint(x: -8, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.02, y: 0.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 1.31),
            controlPoint1: CGPoint(x: 4.02, y: 0.05),
            controlPoint2: CGPoint(x: 4.01, y: 1.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.02, y: 1.51),
            controlPoint1: CGPoint(x: 4.02, y: 1.37),
            controlPoint2: CGPoint(x: 4.02, y: 1.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 4.5, y: 2.03),
            controlPoint1: CGPoint(x: 4.02, y: 1.8),
            controlPoint2: CGPoint(x: 4.21, y: 2.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.32, y: 1.04),
            controlPoint1: CGPoint(x: 4.71, y: 1.99),
            controlPoint2: CGPoint(x: 7.21, y: 1.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.51, y: 1),
            controlPoint1: CGPoint(x: 7.38, y: 1.02),
            controlPoint2: CGPoint(x: 7.45, y: 1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 1.34),
            controlPoint1: CGPoint(x: 7.74, y: 1),
            controlPoint2: CGPoint(x: 7.93, y: 1.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 1.52))
        bezier2Path.addLine(to: CGPoint(x: 8, y: 1.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 7.87, y: 1.89),
            controlPoint1: CGPoint(x: 7.97, y: 1.77),
            controlPoint2: CGPoint(x: 7.93, y: 1.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 2.02, y: 8.97),
            controlPoint1: CGPoint(x: 7.74, y: 2.05),
            controlPoint2: CGPoint(x: 2.02, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -1.69, y: 4.44),
            controlPoint1: CGPoint(x: 2.02, y: 8.97),
            controlPoint2: CGPoint(x: -0.02, y: 6.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.83, y: 1.84),
            controlPoint1: CGPoint(x: -2.82, y: 3.07),
            controlPoint2: CGPoint(x: -3.77, y: 1.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.99, y: 1.46),
            controlPoint1: CGPoint(x: -3.93, y: 1.74),
            controlPoint2: CGPoint(x: -3.99, y: 1.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.47, y: 0.94),
            controlPoint1: CGPoint(x: -3.99, y: 1.17),
            controlPoint2: CGPoint(x: -3.76, y: 0.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.28, y: 0.98),
            controlPoint1: CGPoint(x: -3.4, y: 0.94),
            controlPoint2: CGPoint(x: -3.34, y: 0.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0.56, y: 1.97),
            controlPoint1: CGPoint(x: -3.17, y: 1.02),
            controlPoint2: CGPoint(x: -0.66, y: 1.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.02, y: 1.45),
            controlPoint1: CGPoint(x: -0.17, y: 1.97),
            controlPoint2: CGPoint(x: 0.02, y: 1.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.03, y: 1.25),
            controlPoint1: CGPoint(x: 0.02, y: 1.38),
            controlPoint2: CGPoint(x: 0.03, y: 1.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.02, y: -0.01),
            controlPoint1: CGPoint(x: 0.03, y: 1.17),
            controlPoint2: CGPoint(x: 0.02, y: -0.01)
        )
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 0.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5.46, y: -12))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.77, y: -11.84),
            controlPoint1: CGPoint(x: 5.55, y: -12),
            controlPoint2: CGPoint(x: 5.68, y: -11.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 12.85, y: -5.98),
            controlPoint1: CGPoint(x: 5.93, y: -11.71),
            controlPoint2: CGPoint(x: 12.85, y: -5.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.72, y: -0.14),
            controlPoint1: CGPoint(x: 12.85, y: -5.98),
            controlPoint2: CGPoint(x: 5.87, y: -0.27)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.34, y: 0.02),
            controlPoint1: CGPoint(x: 5.62, y: -0.04),
            controlPoint2: CGPoint(x: 5.48, y: 0.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.82, y: -0.5),
            controlPoint1: CGPoint(x: 5.05, y: 0.02),
            controlPoint2: CGPoint(x: 4.82, y: -0.21)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.86, y: -0.69),
            controlPoint1: CGPoint(x: 4.82, y: -0.56),
            controlPoint2: CGPoint(x: 4.83, y: -0.63)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.85, y: -3.41),
            controlPoint1: CGPoint(x: 4.9, y: -0.8),
            controlPoint2: CGPoint(x: 5.81, y: -3.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.33, y: -3.99),
            controlPoint1: CGPoint(x: 5.85, y: -3.8),
            controlPoint2: CGPoint(x: 5.62, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.13, y: -3.99),
            controlPoint1: CGPoint(x: 5.26, y: -3.99),
            controlPoint2: CGPoint(x: 5.19, y: -3.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 3.87, y: -3.99),
            controlPoint1: CGPoint(x: 5.05, y: -4),
            controlPoint2: CGPoint(x: 3.87, y: -3.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 3.93, y: -7.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.19, y: -7.98),
            controlPoint1: CGPoint(x: 3.93, y: -7.99),
            controlPoint2: CGPoint(x: 5.1, y: -7.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.39, y: -7.99),
            controlPoint1: CGPoint(x: 5.25, y: -7.99),
            controlPoint2: CGPoint(x: 5.32, y: -7.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.91, y: -8.47),
            controlPoint1: CGPoint(x: 5.68, y: -7.99),
            controlPoint2: CGPoint(x: 5.91, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.92, y: -11.29),
            controlPoint1: CGPoint(x: 5.87, y: -8.68),
            controlPoint2: CGPoint(x: 4.96, y: -11.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.88, y: -11.48),
            controlPoint1: CGPoint(x: 4.9, y: -11.35),
            controlPoint2: CGPoint(x: 4.88, y: -11.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.39, y: -12),
            controlPoint1: CGPoint(x: 4.88, y: -11.77),
            controlPoint2: CGPoint(x: 5.11, y: -12)
        )
        bezier3Path.addLine(to: CGPoint(x: 5.46, y: -12))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -8, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -8, y: -1))
        bezier4Path.addCurve(
            to: CGPoint(x: -3, y: -6),
            controlPoint1: CGPoint(x: -8, y: -1),
            controlPoint2: CGPoint(x: -8, y: -6)
        )
        bezier4Path.addLine(to: CGPoint(x: 4, y: -6))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5.95, y: -7))
        bezier2Path.addCurve(
            to: CGPoint(x: -6.2, y: -6.84),
            controlPoint1: CGPoint(x: -6.02, y: -7),
            controlPoint2: CGPoint(x: -6.13, y: -6.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.85, y: -0.98),
            controlPoint1: CGPoint(x: -6.33, y: -6.71),
            controlPoint2: CGPoint(x: -11.85, y: -0.98)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -6.16, y: 4.86),
            controlPoint1: CGPoint(x: -11.85, y: -0.98),
            controlPoint2: CGPoint(x: -6.28, y: 4.73)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.85, y: 5.02),
            controlPoint1: CGPoint(x: -6.08, y: 4.96),
            controlPoint2: CGPoint(x: -5.97, y: 5.02)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.44, y: 4.5),
            controlPoint1: CGPoint(x: -5.63, y: 5.02),
            controlPoint2: CGPoint(x: -5.44, y: 4.79)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.47, y: 4.31),
            controlPoint1: CGPoint(x: -5.44, y: 4.44),
            controlPoint2: CGPoint(x: -5.45, y: 4.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -6.26, y: 1.59),
            controlPoint1: CGPoint(x: -5.51, y: 4.2),
            controlPoint2: CGPoint(x: -6.23, y: 1.7)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.85, y: 1.01),
            controlPoint1: CGPoint(x: -6.27, y: 1.2),
            controlPoint2: CGPoint(x: -6.08, y: 1.01)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.69, y: 1.01),
            controlPoint1: CGPoint(x: -5.79, y: 1.01),
            controlPoint2: CGPoint(x: -5.74, y: 1.01)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -4.68, y: 1.01),
            controlPoint1: CGPoint(x: -5.62, y: 1),
            controlPoint2: CGPoint(x: -4.68, y: 1.01)
        )
        bezier2Path.addLine(to: CGPoint(x: -4.73, y: -2.99))
        bezier2Path.addCurve(
            to: CGPoint(x: -5.74, y: -2.98),
            controlPoint1: CGPoint(x: -4.73, y: -2.99),
            controlPoint2: CGPoint(x: -5.67, y: -2.98)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.9, y: -2.99),
            controlPoint1: CGPoint(x: -5.79, y: -2.99),
            controlPoint2: CGPoint(x: -5.84, y: -2.99)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -6.31, y: -3.47),
            controlPoint1: CGPoint(x: -6.13, y: -2.99),
            controlPoint2: CGPoint(x: -6.31, y: -3.18)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.52, y: -6.29),
            controlPoint1: CGPoint(x: -6.28, y: -3.68),
            controlPoint2: CGPoint(x: -5.55, y: -6.18)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.49, y: -6.48),
            controlPoint1: CGPoint(x: -5.5, y: -6.35),
            controlPoint2: CGPoint(x: -5.49, y: -6.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -5.9, y: -7),
            controlPoint1: CGPoint(x: -5.49, y: -6.77),
            controlPoint2: CGPoint(x: -5.67, y: -7)
        )
        bezier2Path.addLine(to: CGPoint(x: -5.95, y: -7))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -0, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -0.05, y: 2.56))
        bezier4Path.addCurve(
            to: CGPoint(x: -4.14, y: -0.97),
            controlPoint1: CGPoint(x: -0.05, y: 2.56),
            controlPoint2: CGPoint(x: -0.27, y: -0.97)
        )
        bezier4Path.addLine(to: CGPoint(x: -8.8, y: -0.97))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5, y: -5))
        bezier3Path.addLine(to: CGPoint(x: 3, y: -3))
        bezier3Path.addLine(to: CGPoint(x: 1.47, y: -0.97))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 3.61),
            controlPoint1: CGPoint(x: 0.6, y: 0.35),
            controlPoint2: CGPoint(x: 0, y: 1.96)
        )
        bezier3Path.addLine(to: CGPoint(x: 0, y: 11.74))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 8.25, y: -15.86)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.01, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -5.95, y: -11))
        bezier3Path.addCurve(
            to: CGPoint(x: -6.2, y: -10.84),
            controlPoint1: CGPoint(x: -6.02, y: -11),
            controlPoint2: CGPoint(x: -6.13, y: -10.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -11.85, y: -4.98),
            controlPoint1: CGPoint(x: -6.33, y: -10.71),
            controlPoint2: CGPoint(x: -11.85, y: -4.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.16, y: 0.86),
            controlPoint1: CGPoint(x: -11.85, y: -4.98),
            controlPoint2: CGPoint(x: -6.28, y: 0.73)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.85, y: 1.02),
            controlPoint1: CGPoint(x: -6.08, y: 0.96),
            controlPoint2: CGPoint(x: -5.97, y: 1.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.44, y: 0.5),
            controlPoint1: CGPoint(x: -5.63, y: 1.02),
            controlPoint2: CGPoint(x: -5.44, y: 0.79)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.47, y: 0.31),
            controlPoint1: CGPoint(x: -5.44, y: 0.44),
            controlPoint2: CGPoint(x: -5.45, y: 0.37)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.26, y: -2.41),
            controlPoint1: CGPoint(x: -5.51, y: 0.2),
            controlPoint2: CGPoint(x: -6.23, y: -2.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.85, y: -2.99),
            controlPoint1: CGPoint(x: -6.27, y: -2.8),
            controlPoint2: CGPoint(x: -6.08, y: -2.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.69, y: -2.99),
            controlPoint1: CGPoint(x: -5.79, y: -2.99),
            controlPoint2: CGPoint(x: -5.74, y: -2.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -4.68, y: -2.99),
            controlPoint1: CGPoint(x: -5.62, y: -3),
            controlPoint2: CGPoint(x: -4.68, y: -2.99)
        )
        bezier3Path.addLine(to: CGPoint(x: -4.73, y: -6.99))
        bezier3Path.addCurve(
            to: CGPoint(x: -5.74, y: -6.98),
            controlPoint1: CGPoint(x: -4.73, y: -6.99),
            controlPoint2: CGPoint(x: -5.67, y: -6.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.9, y: -6.99),
            controlPoint1: CGPoint(x: -5.79, y: -6.99),
            controlPoint2: CGPoint(x: -5.84, y: -6.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -6.31, y: -7.47),
            controlPoint1: CGPoint(x: -6.13, y: -6.99),
            controlPoint2: CGPoint(x: -6.31, y: -7.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.52, y: -10.29),
            controlPoint1: CGPoint(x: -6.28, y: -7.68),
            controlPoint2: CGPoint(x: -5.55, y: -10.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.49, y: -10.48),
            controlPoint1: CGPoint(x: -5.5, y: -10.35),
            controlPoint2: CGPoint(x: -5.49, y: -10.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -5.9, y: -11),
            controlPoint1: CGPoint(x: -5.49, y: -10.77),
            controlPoint2: CGPoint(x: -5.67, y: -11)
        )
        bezier3Path.addLine(to: CGPoint(x: -5.95, y: -11))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -0, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -0.05, y: -1.44))
        bezier4Path.addCurve(
            to: CGPoint(x: -3.14, y: -4.97),
            controlPoint1: CGPoint(x: -0.05, y: -1.44),
            controlPoint2: CGPoint(x: -0.27, y: -4.97)
        )
        bezier4Path.addLine(to: CGPoint(x: -8.8, y: -4.97))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 5.95, y: -11))
        bezierPath.addCurve(
            to: CGPoint(x: 6.2, y: -10.84),
            controlPoint1: CGPoint(x: 6.02, y: -11),
            controlPoint2: CGPoint(x: 6.13, y: -10.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.85, y: -4.98),
            controlPoint1: CGPoint(x: 6.33, y: -10.71),
            controlPoint2: CGPoint(x: 11.85, y: -4.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.16, y: 0.86),
            controlPoint1: CGPoint(x: 11.85, y: -4.98),
            controlPoint2: CGPoint(x: 6.28, y: 0.73)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: 1.02),
            controlPoint1: CGPoint(x: 6.08, y: 0.96),
            controlPoint2: CGPoint(x: 5.97, y: 1.02)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.44, y: 0.5),
            controlPoint1: CGPoint(x: 5.63, y: 1.02),
            controlPoint2: CGPoint(x: 5.44, y: 0.79)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.47, y: 0.31),
            controlPoint1: CGPoint(x: 5.44, y: 0.44),
            controlPoint2: CGPoint(x: 5.45, y: 0.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.26, y: -2.41),
            controlPoint1: CGPoint(x: 5.51, y: 0.2),
            controlPoint2: CGPoint(x: 6.23, y: -2.3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: -2.99),
            controlPoint1: CGPoint(x: 6.27, y: -2.8),
            controlPoint2: CGPoint(x: 6.08, y: -2.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.69, y: -2.99),
            controlPoint1: CGPoint(x: 5.79, y: -2.99),
            controlPoint2: CGPoint(x: 5.74, y: -2.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 4.68, y: -2.99),
            controlPoint1: CGPoint(x: 5.62, y: -3),
            controlPoint2: CGPoint(x: 4.68, y: -2.99)
        )
        bezierPath.addLine(to: CGPoint(x: 4.73, y: -6.99))
        bezierPath.addCurve(
            to: CGPoint(x: 5.74, y: -6.98),
            controlPoint1: CGPoint(x: 4.73, y: -6.99),
            controlPoint2: CGPoint(x: 5.67, y: -6.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -6.99),
            controlPoint1: CGPoint(x: 5.79, y: -6.99),
            controlPoint2: CGPoint(x: 5.84, y: -6.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.31, y: -7.47),
            controlPoint1: CGPoint(x: 6.13, y: -6.99),
            controlPoint2: CGPoint(x: 6.31, y: -7.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.52, y: -10.29),
            controlPoint1: CGPoint(x: 6.28, y: -7.68),
            controlPoint2: CGPoint(x: 5.55, y: -10.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.49, y: -10.48),
            controlPoint1: CGPoint(x: 5.5, y: -10.35),
            controlPoint2: CGPoint(x: 5.49, y: -10.42)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -11),
            controlPoint1: CGPoint(x: 5.49, y: -10.77),
            controlPoint2: CGPoint(x: 5.67, y: -11)
        )
        bezierPath.addLine(to: CGPoint(x: 5.95, y: -11))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 0, y: 12))
        bezier2Path.addLine(to: CGPoint(x: 0.05, y: -1.44))
        bezier2Path.addCurve(
            to: CGPoint(x: 3.14, y: -4.97),
            controlPoint1: CGPoint(x: 0.05, y: -1.44),
            controlPoint2: CGPoint(x: 0.27, y: -4.97)
        )
        bezier2Path.addLine(to: CGPoint(x: 8.8, y: -4.97))
        secondaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5, y: -5))
        bezier2Path.addLine(to: CGPoint(x: -3, y: -3))
        bezier2Path.addLine(to: CGPoint(x: -1.47, y: -0.97))
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 3.61),
            controlPoint1: CGPoint(x: -0.6, y: 0.35),
            controlPoint2: CGPoint(x: -0, y: 1.96)
        )
        bezier2Path.addLine(to: CGPoint(x: -0, y: 11.74))
        secondaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.lineJoinStyle = .round
        bezier2Path.stroke()

        //// Bezier 4 Drawing
        context.saveGState()
        context.translateBy(x: -8.6, y: -15.86)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier4Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier4Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier4Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier4Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier4Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier4Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier4Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier4Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier4Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier4Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 5, y: -5))
        bezier3Path.addLine(to: CGPoint(x: 3, y: -3))
        bezier3Path.addLine(to: CGPoint(x: 1.47, y: -0.97))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 3.61),
            controlPoint1: CGPoint(x: 0.6, y: 0.35),
            controlPoint2: CGPoint(x: 0, y: 1.96)
        )
        bezier3Path.addLine(to: CGPoint(x: 0, y: 11.74))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier Drawing
        context.saveGState()
        context.translateBy(x: 8.25, y: -15.86)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 4.01, y: 9.92))
        bezierPath.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezierPath.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezierPath.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezierPath.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezierPath.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezierPath.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezierPath.addLine(to: CGPoint(x: 6.01, y: 0))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezierPath.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezierPath.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezierPath.addLine(to: CGPoint(x: 8.58, y: 8))
        bezierPath.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezierPath.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezierPath.addLine(to: CGPoint(x: 8, y: 8.72))
        bezierPath.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezierPath.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -5, y: -5))
        bezier2Path.addLine(to: CGPoint(x: -3, y: -3))
        bezier2Path.addLine(to: CGPoint(x: -1.47, y: -0.97))
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 3.61),
            controlPoint1: CGPoint(x: -0.6, y: 0.35),
            controlPoint2: CGPoint(x: -0, y: 1.96)
        )
        bezier2Path.addLine(to: CGPoint(x: -0, y: 11.74))
        secondaryColor.setStroke()
        bezier2Path.lineWidth = 4
        bezier2Path.lineJoinStyle = .round
        bezier2Path.stroke()

        //// Bezier 4 Drawing
        context.saveGState()
        context.translateBy(x: -8.6, y: -15.86)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier4Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier4Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier4Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier4Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier4Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier4Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier4Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier4Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier4Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier4Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier4Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier4Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier4Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 5.95, y: -7))
        bezierPath.addCurve(
            to: CGPoint(x: 6.2, y: -6.84),
            controlPoint1: CGPoint(x: 6.02, y: -7),
            controlPoint2: CGPoint(x: 6.13, y: -6.94)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 11.85, y: -0.98),
            controlPoint1: CGPoint(x: 6.33, y: -6.71),
            controlPoint2: CGPoint(x: 11.85, y: -0.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.16, y: 4.86),
            controlPoint1: CGPoint(x: 11.85, y: -0.98),
            controlPoint2: CGPoint(x: 6.28, y: 4.73)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: 5.02),
            controlPoint1: CGPoint(x: 6.08, y: 4.96),
            controlPoint2: CGPoint(x: 5.97, y: 5.02)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.44, y: 4.5),
            controlPoint1: CGPoint(x: 5.63, y: 5.02),
            controlPoint2: CGPoint(x: 5.44, y: 4.79)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.47, y: 4.31),
            controlPoint1: CGPoint(x: 5.44, y: 4.44),
            controlPoint2: CGPoint(x: 5.45, y: 4.37)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.26, y: 1.59),
            controlPoint1: CGPoint(x: 5.51, y: 4.2),
            controlPoint2: CGPoint(x: 6.23, y: 1.7)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.85, y: 1.01),
            controlPoint1: CGPoint(x: 6.27, y: 1.2),
            controlPoint2: CGPoint(x: 6.08, y: 1.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.69, y: 1.01),
            controlPoint1: CGPoint(x: 5.79, y: 1.01),
            controlPoint2: CGPoint(x: 5.74, y: 1.01)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 4.68, y: 1.01),
            controlPoint1: CGPoint(x: 5.62, y: 1),
            controlPoint2: CGPoint(x: 4.68, y: 1.01)
        )
        bezierPath.addLine(to: CGPoint(x: 4.73, y: -2.99))
        bezierPath.addCurve(
            to: CGPoint(x: 5.74, y: -2.98),
            controlPoint1: CGPoint(x: 4.73, y: -2.99),
            controlPoint2: CGPoint(x: 5.67, y: -2.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -2.99),
            controlPoint1: CGPoint(x: 5.79, y: -2.99),
            controlPoint2: CGPoint(x: 5.84, y: -2.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.31, y: -3.47),
            controlPoint1: CGPoint(x: 6.13, y: -2.99),
            controlPoint2: CGPoint(x: 6.31, y: -3.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.52, y: -6.29),
            controlPoint1: CGPoint(x: 6.28, y: -3.68),
            controlPoint2: CGPoint(x: 5.55, y: -6.18)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.49, y: -6.48),
            controlPoint1: CGPoint(x: 5.5, y: -6.35),
            controlPoint2: CGPoint(x: 5.49, y: -6.42)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.9, y: -7),
            controlPoint1: CGPoint(x: 5.49, y: -6.77),
            controlPoint2: CGPoint(x: 5.67, y: -7)
        )
        bezierPath.addLine(to: CGPoint(x: 5.95, y: -7))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 0, y: 12))
        bezier3Path.addLine(to: CGPoint(x: 0.05, y: 2.56))
        bezier3Path.addCurve(
            to: CGPoint(x: 4.14, y: -0.97),
            controlPoint1: CGPoint(x: 0.05, y: 2.56),
            controlPoint2: CGPoint(x: 0.27, y: -0.97)
        )
        bezier3Path.addLine(to: CGPoint(x: 8.8, y: -0.97))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrStraightOrTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -6, width: 4, height: 18))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -6.48),
            controlPoint1: CGPoint(x: 0.06, y: -12.96),
            controlPoint2: CGPoint(x: 5.74, y: -6.62)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -6.18),
            controlPoint1: CGPoint(x: 5.96, y: -6.4),
            controlPoint2: CGPoint(x: 6.02, y: -6.3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -5.77),
            controlPoint1: CGPoint(x: 6.02, y: -5.95),
            controlPoint2: CGPoint(x: 5.79, y: -5.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -5.79),
            controlPoint1: CGPoint(x: 5.44, y: -5.77),
            controlPoint2: CGPoint(x: 5.37, y: -5.78)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -6.59),
            controlPoint1: CGPoint(x: 5.2, y: -5.83),
            controlPoint2: CGPoint(x: 2.69, y: -6.56)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -6.17),
            controlPoint1: CGPoint(x: 2.2, y: -6.59),
            controlPoint2: CGPoint(x: 2.01, y: -6.4)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -6.01),
            controlPoint1: CGPoint(x: 2.01, y: -6.12),
            controlPoint2: CGPoint(x: 2, y: -6.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -5),
            controlPoint1: CGPoint(x: 2, y: -5.95),
            controlPoint2: CGPoint(x: 2.01, y: -5)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -5.05))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -6.06),
            controlPoint1: CGPoint(x: -1.99, y: -5.05),
            controlPoint2: CGPoint(x: -1.98, y: -5.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -6.22),
            controlPoint1: CGPoint(x: -1.99, y: -6.11),
            controlPoint2: CGPoint(x: -1.99, y: -6.17)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -6.64),
            controlPoint1: CGPoint(x: -1.99, y: -6.45),
            controlPoint2: CGPoint(x: -2.18, y: -6.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -5.85),
            controlPoint1: CGPoint(x: -2.68, y: -6.61),
            controlPoint2: CGPoint(x: -5.18, y: -5.88)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -5.81),
            controlPoint1: CGPoint(x: -5.35, y: -5.83),
            controlPoint2: CGPoint(x: -5.42, y: -5.81)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -6.22),
            controlPoint1: CGPoint(x: -5.77, y: -5.81),
            controlPoint2: CGPoint(x: -6, y: -6)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -6.53),
            controlPoint1: CGPoint(x: -6, y: -6.35),
            controlPoint2: CGPoint(x: -5.94, y: -6.46)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -6.67),
            controlPoint2: CGPoint(x: -0.03, y: -12.96)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.91, y: -0.41),
            controlPoint1: CGPoint(x: -6.8, y: -0.41),
            controlPoint2: CGPoint(x: -6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.34, y: -0.9),
            controlPoint1: CGPoint(x: -7.15, y: -0.41),
            controlPoint2: CGPoint(x: -7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.33, y: -0.99),
            controlPoint1: CGPoint(x: -7.34, y: -0.93),
            controlPoint2: CGPoint(x: -7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.5, y: -3.91),
            controlPoint1: CGPoint(x: -6.51, y: -3.77),
            controlPoint2: CGPoint(x: -6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.92, y: -4.42),
            controlPoint1: CGPoint(x: -6.5, y: -4.19),
            controlPoint2: CGPoint(x: -6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.23, y: -4.26),
            controlPoint1: CGPoint(x: -7.04, y: -4.42),
            controlPoint2: CGPoint(x: -7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: -12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.87, y: 7.6),
            controlPoint1: CGPoint(x: -7.1, y: 7.53),
            controlPoint2: CGPoint(x: -6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.45, y: 7.08),
            controlPoint1: CGPoint(x: -6.64, y: 7.6),
            controlPoint2: CGPoint(x: -6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.48, y: 6.89),
            controlPoint1: CGPoint(x: -6.45, y: 7.01),
            controlPoint2: CGPoint(x: -6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: -7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: -7.28, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: -7.29, y: 4.07),
            controlPoint1: CGPoint(x: -7.29, y: 4.14),
            controlPoint2: CGPoint(x: -7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.86, y: 3.59),
            controlPoint1: CGPoint(x: -7.29, y: 3.78),
            controlPoint2: CGPoint(x: -7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.7, y: 3.58),
            controlPoint1: CGPoint(x: -6.81, y: 3.59),
            controlPoint2: CGPoint(x: -6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.7, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: -5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: -0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: -1.63, y: 3.61),
            controlPoint1: CGPoint(x: -0.03, y: 6.23),
            controlPoint2: CGPoint(x: -0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.56, y: 1.61),
            controlPoint1: CGPoint(x: -2.63, y: 2.61),
            controlPoint2: CGPoint(x: -4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.73, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.91, y: -0.41),
            controlPoint1: CGPoint(x: 6.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.86, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.9),
            controlPoint1: CGPoint(x: 7.15, y: -0.41),
            controlPoint2: CGPoint(x: 7.34, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.33, y: -0.99),
            controlPoint1: CGPoint(x: 7.34, y: -0.93),
            controlPoint2: CGPoint(x: 7.34, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.34, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 6.53, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 6.53, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.5, y: -3.91),
            controlPoint1: CGPoint(x: 6.51, y: -3.77),
            controlPoint2: CGPoint(x: 6.5, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.92, y: -4.42),
            controlPoint1: CGPoint(x: 6.5, y: -4.19),
            controlPoint2: CGPoint(x: 6.69, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.23, y: -4.26),
            controlPoint1: CGPoint(x: 7.04, y: -4.42),
            controlPoint2: CGPoint(x: 7.15, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.23, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 7.18, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 7.18, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.87, y: 7.6),
            controlPoint1: CGPoint(x: 7.1, y: 7.53),
            controlPoint2: CGPoint(x: 6.99, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.45, y: 7.08),
            controlPoint1: CGPoint(x: 6.64, y: 7.6),
            controlPoint2: CGPoint(x: 6.45, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.48, y: 6.89),
            controlPoint1: CGPoint(x: 6.45, y: 7.01),
            controlPoint2: CGPoint(x: 6.46, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.48, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 7.28, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 7.29, y: 4.07),
            controlPoint1: CGPoint(x: 7.29, y: 4.14),
            controlPoint2: CGPoint(x: 7.29, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.86, y: 3.59),
            controlPoint1: CGPoint(x: 7.29, y: 3.78),
            controlPoint2: CGPoint(x: 7.1, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.7, y: 3.58),
            controlPoint1: CGPoint(x: 6.81, y: 3.59),
            controlPoint2: CGPoint(x: 6.75, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.7, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 5.68, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 0.03, y: 12))
        bezier3Path.addLine(to: CGPoint(x: 0.03, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: 1.63, y: 3.61),
            controlPoint1: CGPoint(x: 0.03, y: 6.23),
            controlPoint2: CGPoint(x: 0.6, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.56, y: 1.61),
            controlPoint1: CGPoint(x: 2.63, y: 2.61),
            controlPoint2: CGPoint(x: 4.01, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 7.33, y: 1.61))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrStraightOrTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.91, y: -0.41),
            controlPoint1: CGPoint(x: -6.8, y: -0.41),
            controlPoint2: CGPoint(x: -6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.34, y: -0.9),
            controlPoint1: CGPoint(x: -7.15, y: -0.41),
            controlPoint2: CGPoint(x: -7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.33, y: -0.99),
            controlPoint1: CGPoint(x: -7.34, y: -0.93),
            controlPoint2: CGPoint(x: -7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.5, y: -3.91),
            controlPoint1: CGPoint(x: -6.51, y: -3.77),
            controlPoint2: CGPoint(x: -6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.92, y: -4.42),
            controlPoint1: CGPoint(x: -6.5, y: -4.19),
            controlPoint2: CGPoint(x: -6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.23, y: -4.26),
            controlPoint1: CGPoint(x: -7.04, y: -4.42),
            controlPoint2: CGPoint(x: -7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: -12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.87, y: 7.6),
            controlPoint1: CGPoint(x: -7.1, y: 7.53),
            controlPoint2: CGPoint(x: -6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.45, y: 7.08),
            controlPoint1: CGPoint(x: -6.64, y: 7.6),
            controlPoint2: CGPoint(x: -6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.48, y: 6.89),
            controlPoint1: CGPoint(x: -6.45, y: 7.01),
            controlPoint2: CGPoint(x: -6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: -7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: -7.28, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: -7.29, y: 4.07),
            controlPoint1: CGPoint(x: -7.29, y: 4.14),
            controlPoint2: CGPoint(x: -7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.86, y: 3.59),
            controlPoint1: CGPoint(x: -7.29, y: 3.78),
            controlPoint2: CGPoint(x: -7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.7, y: 3.58),
            controlPoint1: CGPoint(x: -6.81, y: 3.59),
            controlPoint2: CGPoint(x: -6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.7, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: -5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: -0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: -1.63, y: 3.61),
            controlPoint1: CGPoint(x: -0.03, y: 6.23),
            controlPoint2: CGPoint(x: -0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.56, y: 1.61),
            controlPoint1: CGPoint(x: -2.63, y: 2.61),
            controlPoint2: CGPoint(x: -4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.73, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.91, y: -0.41),
            controlPoint1: CGPoint(x: 6.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.86, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.9),
            controlPoint1: CGPoint(x: 7.15, y: -0.41),
            controlPoint2: CGPoint(x: 7.34, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.33, y: -0.99),
            controlPoint1: CGPoint(x: 7.34, y: -0.93),
            controlPoint2: CGPoint(x: 7.34, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.34, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 6.53, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 6.53, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.5, y: -3.91),
            controlPoint1: CGPoint(x: 6.51, y: -3.77),
            controlPoint2: CGPoint(x: 6.5, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.92, y: -4.42),
            controlPoint1: CGPoint(x: 6.5, y: -4.19),
            controlPoint2: CGPoint(x: 6.69, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.23, y: -4.26),
            controlPoint1: CGPoint(x: 7.04, y: -4.42),
            controlPoint2: CGPoint(x: 7.15, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.23, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 7.18, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 7.18, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.87, y: 7.6),
            controlPoint1: CGPoint(x: 7.1, y: 7.53),
            controlPoint2: CGPoint(x: 6.99, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.45, y: 7.08),
            controlPoint1: CGPoint(x: 6.64, y: 7.6),
            controlPoint2: CGPoint(x: 6.45, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.48, y: 6.89),
            controlPoint1: CGPoint(x: 6.45, y: 7.01),
            controlPoint2: CGPoint(x: 6.46, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.48, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 7.28, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 7.29, y: 4.07),
            controlPoint1: CGPoint(x: 7.29, y: 4.14),
            controlPoint2: CGPoint(x: 7.29, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.86, y: 3.59),
            controlPoint1: CGPoint(x: 7.29, y: 3.78),
            controlPoint2: CGPoint(x: 7.1, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.7, y: 3.58),
            controlPoint1: CGPoint(x: 6.81, y: 3.59),
            controlPoint2: CGPoint(x: 6.75, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.7, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 5.68, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 0.03, y: 12))
        bezier3Path.addLine(to: CGPoint(x: 0.03, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: 1.63, y: 3.61),
            controlPoint1: CGPoint(x: 0.03, y: 6.23),
            controlPoint2: CGPoint(x: 0.6, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.56, y: 1.61),
            controlPoint1: CGPoint(x: 2.63, y: 2.61),
            controlPoint2: CGPoint(x: 4.01, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group 5
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -6, width: 4, height: 18))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -6.48),
            controlPoint1: CGPoint(x: 0.06, y: -12.96),
            controlPoint2: CGPoint(x: 5.74, y: -6.62)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -6.18),
            controlPoint1: CGPoint(x: 5.96, y: -6.4),
            controlPoint2: CGPoint(x: 6.02, y: -6.3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -5.77),
            controlPoint1: CGPoint(x: 6.02, y: -5.95),
            controlPoint2: CGPoint(x: 5.79, y: -5.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -5.79),
            controlPoint1: CGPoint(x: 5.44, y: -5.77),
            controlPoint2: CGPoint(x: 5.37, y: -5.78)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -6.59),
            controlPoint1: CGPoint(x: 5.2, y: -5.83),
            controlPoint2: CGPoint(x: 2.69, y: -6.56)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -6.17),
            controlPoint1: CGPoint(x: 2.2, y: -6.59),
            controlPoint2: CGPoint(x: 2.01, y: -6.4)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -6.01),
            controlPoint1: CGPoint(x: 2.01, y: -6.12),
            controlPoint2: CGPoint(x: 2, y: -6.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -5),
            controlPoint1: CGPoint(x: 2, y: -5.95),
            controlPoint2: CGPoint(x: 2.01, y: -5)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -5.05))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -6.06),
            controlPoint1: CGPoint(x: -1.99, y: -5.05),
            controlPoint2: CGPoint(x: -1.98, y: -5.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -6.22),
            controlPoint1: CGPoint(x: -1.99, y: -6.11),
            controlPoint2: CGPoint(x: -1.99, y: -6.17)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -6.64),
            controlPoint1: CGPoint(x: -1.99, y: -6.45),
            controlPoint2: CGPoint(x: -2.18, y: -6.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -5.85),
            controlPoint1: CGPoint(x: -2.68, y: -6.61),
            controlPoint2: CGPoint(x: -5.18, y: -5.88)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -5.81),
            controlPoint1: CGPoint(x: -5.35, y: -5.83),
            controlPoint2: CGPoint(x: -5.42, y: -5.81)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -6.22),
            controlPoint1: CGPoint(x: -5.77, y: -5.81),
            controlPoint2: CGPoint(x: -6, y: -6)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -6.53),
            controlPoint1: CGPoint(x: -6, y: -6.35),
            controlPoint2: CGPoint(x: -5.94, y: -6.46)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -6.67),
            controlPoint2: CGPoint(x: -0.03, y: -12.96)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrTurnOrUturnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 3, y: 9.27))
        bezierPath.addLine(to: CGPoint(x: 3, y: 2.12))
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: 3, y: 0.78),
            controlPoint2: CGPoint(x: 2, y: -3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: 1.91),
            controlPoint1: CGPoint(x: -6, y: -3),
            controlPoint2: CGPoint(x: -6, y: 1.91)
        )
        bezierPath.addLine(to: CGPoint(x: -6, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.01, y: 4.31),
            controlPoint1: CGPoint(x: 5.02, y: 3.05),
            controlPoint2: CGPoint(x: 5.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.02, y: 4.51),
            controlPoint1: CGPoint(x: 5.02, y: 4.37),
            controlPoint2: CGPoint(x: 5.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.5, y: 5.03),
            controlPoint1: CGPoint(x: 5.02, y: 4.8),
            controlPoint2: CGPoint(x: 5.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.32, y: 4.04),
            controlPoint1: CGPoint(x: 5.71, y: 4.99),
            controlPoint2: CGPoint(x: 8.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.51, y: 4),
            controlPoint1: CGPoint(x: 8.38, y: 4.02),
            controlPoint2: CGPoint(x: 8.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9, y: 4.34),
            controlPoint1: CGPoint(x: 8.74, y: 4),
            controlPoint2: CGPoint(x: 8.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.87, y: 4.89),
            controlPoint1: CGPoint(x: 8.97, y: 4.77),
            controlPoint2: CGPoint(x: 8.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.02, y: 11.97),
            controlPoint1: CGPoint(x: 8.74, y: 5.05),
            controlPoint2: CGPoint(x: 3.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0.69, y: 7.44),
            controlPoint1: CGPoint(x: 3.02, y: 11.97),
            controlPoint2: CGPoint(x: 0.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.83, y: 4.84),
            controlPoint1: CGPoint(x: -1.82, y: 6.07),
            controlPoint2: CGPoint(x: -2.77, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.99, y: 4.46),
            controlPoint1: CGPoint(x: -2.93, y: 4.74),
            controlPoint2: CGPoint(x: -2.99, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.47, y: 3.94),
            controlPoint1: CGPoint(x: -2.99, y: 4.17),
            controlPoint2: CGPoint(x: -2.76, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.28, y: 3.98),
            controlPoint1: CGPoint(x: -2.4, y: 3.94),
            controlPoint2: CGPoint(x: -2.34, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.44, y: 4.97),
            controlPoint1: CGPoint(x: -2.17, y: 4.02),
            controlPoint2: CGPoint(x: 0.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 4.45),
            controlPoint1: CGPoint(x: 0.83, y: 4.97),
            controlPoint2: CGPoint(x: 1.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.03, y: 4.25),
            controlPoint1: CGPoint(x: 1.02, y: 4.38),
            controlPoint2: CGPoint(x: 1.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 2.99),
            controlPoint1: CGPoint(x: 1.03, y: 4.17),
            controlPoint2: CGPoint(x: 1.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.addCurve(
            to: CGPoint(x: 6.38, y: -8.84),
            controlPoint1: CGPoint(x: 6.2, y: -9),
            controlPoint2: CGPoint(x: 6.31, y: -8.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 12, y: -2.98),
            controlPoint1: CGPoint(x: 6.51, y: -8.71),
            controlPoint2: CGPoint(x: 12, y: -2.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.33, y: 2.86),
            controlPoint1: CGPoint(x: 12, y: -2.98),
            controlPoint2: CGPoint(x: 6.46, y: 2.73)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: 3.02),
            controlPoint1: CGPoint(x: 6.26, y: 2.96),
            controlPoint2: CGPoint(x: 6.15, y: 3.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.62, y: 2.5),
            controlPoint1: CGPoint(x: 5.81, y: 3.02),
            controlPoint2: CGPoint(x: 5.62, y: 2.79)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.65, y: 2.31),
            controlPoint1: CGPoint(x: 5.62, y: 2.44),
            controlPoint2: CGPoint(x: 5.63, y: 2.37)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.44, y: -0.41),
            controlPoint1: CGPoint(x: 5.69, y: 2.2),
            controlPoint2: CGPoint(x: 6.41, y: -0.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.99),
            controlPoint1: CGPoint(x: 6.44, y: -0.8),
            controlPoint2: CGPoint(x: 6.26, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.97, y: -0.99),
            controlPoint2: CGPoint(x: 5.92, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.8, y: -1),
            controlPoint2: CGPoint(x: 4.87, y: -0.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 4.91, y: -4.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.92, y: -4.98),
            controlPoint1: CGPoint(x: 4.91, y: -4.99),
            controlPoint2: CGPoint(x: 5.85, y: -4.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.07, y: -4.99),
            controlPoint1: CGPoint(x: 5.97, y: -4.99),
            controlPoint2: CGPoint(x: 6.02, y: -4.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.49, y: -5.47),
            controlPoint1: CGPoint(x: 6.31, y: -4.99),
            controlPoint2: CGPoint(x: 6.49, y: -5.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.7, y: -8.29),
            controlPoint1: CGPoint(x: 6.46, y: -5.68),
            controlPoint2: CGPoint(x: 5.74, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.67, y: -8.48),
            controlPoint1: CGPoint(x: 5.68, y: -8.35),
            controlPoint2: CGPoint(x: 5.67, y: -8.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.08, y: -9),
            controlPoint1: CGPoint(x: 5.67, y: -8.77),
            controlPoint2: CGPoint(x: 5.85, y: -9)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -6, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -6, y: 2))
        bezier4Path.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: -6, y: 2),
            controlPoint2: CGPoint(x: -6, y: -3)
        )
        bezier4Path.addLine(to: CGPoint(x: 6, y: -3))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group 5
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -8, y: -6, width: 4, height: 18))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.addCurve(
            to: CGPoint(x: -0.14, y: -6.48),
            controlPoint1: CGPoint(x: -5.94, y: -12.96),
            controlPoint2: CGPoint(x: -0.26, y: -6.62)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.02, y: -6.18),
            controlPoint1: CGPoint(x: -0.04, y: -6.4),
            controlPoint2: CGPoint(x: 0.02, y: -6.3)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.5, y: -5.77),
            controlPoint1: CGPoint(x: 0.02, y: -5.95),
            controlPoint2: CGPoint(x: -0.21, y: -5.77)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.69, y: -5.79),
            controlPoint1: CGPoint(x: -0.56, y: -5.77),
            controlPoint2: CGPoint(x: -0.63, y: -5.78)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.41, y: -6.59),
            controlPoint1: CGPoint(x: -0.8, y: -5.83),
            controlPoint2: CGPoint(x: -3.31, y: -6.56)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -6.17),
            controlPoint1: CGPoint(x: -3.8, y: -6.59),
            controlPoint2: CGPoint(x: -3.99, y: -6.4)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -4, y: -6.01),
            controlPoint1: CGPoint(x: -3.99, y: -6.12),
            controlPoint2: CGPoint(x: -4, y: -6.06)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -5),
            controlPoint1: CGPoint(x: -4, y: -5.95),
            controlPoint2: CGPoint(x: -3.99, y: -5)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.99, y: -5.05))
        bezier5Path.addCurve(
            to: CGPoint(x: -7.98, y: -6.06),
            controlPoint1: CGPoint(x: -7.99, y: -5.05),
            controlPoint2: CGPoint(x: -7.98, y: -5.99)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.99, y: -6.22),
            controlPoint1: CGPoint(x: -7.99, y: -6.11),
            controlPoint2: CGPoint(x: -7.99, y: -6.17)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -8.47, y: -6.64),
            controlPoint1: CGPoint(x: -7.99, y: -6.45),
            controlPoint2: CGPoint(x: -8.18, y: -6.64)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.29, y: -5.85),
            controlPoint1: CGPoint(x: -8.68, y: -6.61),
            controlPoint2: CGPoint(x: -11.18, y: -5.88)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.48, y: -5.81),
            controlPoint1: CGPoint(x: -11.35, y: -5.83),
            controlPoint2: CGPoint(x: -11.42, y: -5.81)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -12, y: -6.22),
            controlPoint1: CGPoint(x: -11.77, y: -5.81),
            controlPoint2: CGPoint(x: -12, y: -6)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.84, y: -6.53),
            controlPoint1: CGPoint(x: -12, y: -6.35),
            controlPoint2: CGPoint(x: -11.94, y: -6.46)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.99, y: -13),
            controlPoint1: CGPoint(x: -11.72, y: -6.67),
            controlPoint2: CGPoint(x: -6.03, y: -12.96)
        )
        bezier5Path.addLine(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.close()
        primaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrTurnOrUturnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 3, y: 9.27))
        bezierPath.addLine(to: CGPoint(x: 3, y: 2.12))
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: 3, y: 0.78),
            controlPoint2: CGPoint(x: 2, y: -3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: 1.91),
            controlPoint1: CGPoint(x: -6, y: -3),
            controlPoint2: CGPoint(x: -6, y: 1.91)
        )
        bezierPath.addLine(to: CGPoint(x: -6, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.01, y: 4.31),
            controlPoint1: CGPoint(x: 5.02, y: 3.05),
            controlPoint2: CGPoint(x: 5.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.02, y: 4.51),
            controlPoint1: CGPoint(x: 5.02, y: 4.37),
            controlPoint2: CGPoint(x: 5.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.5, y: 5.03),
            controlPoint1: CGPoint(x: 5.02, y: 4.8),
            controlPoint2: CGPoint(x: 5.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.32, y: 4.04),
            controlPoint1: CGPoint(x: 5.71, y: 4.99),
            controlPoint2: CGPoint(x: 8.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.51, y: 4),
            controlPoint1: CGPoint(x: 8.38, y: 4.02),
            controlPoint2: CGPoint(x: 8.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9, y: 4.34),
            controlPoint1: CGPoint(x: 8.74, y: 4),
            controlPoint2: CGPoint(x: 8.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.87, y: 4.89),
            controlPoint1: CGPoint(x: 8.97, y: 4.77),
            controlPoint2: CGPoint(x: 8.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.02, y: 11.97),
            controlPoint1: CGPoint(x: 8.74, y: 5.05),
            controlPoint2: CGPoint(x: 3.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0.69, y: 7.44),
            controlPoint1: CGPoint(x: 3.02, y: 11.97),
            controlPoint2: CGPoint(x: 0.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.83, y: 4.84),
            controlPoint1: CGPoint(x: -1.82, y: 6.07),
            controlPoint2: CGPoint(x: -2.77, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.99, y: 4.46),
            controlPoint1: CGPoint(x: -2.93, y: 4.74),
            controlPoint2: CGPoint(x: -2.99, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.47, y: 3.94),
            controlPoint1: CGPoint(x: -2.99, y: 4.17),
            controlPoint2: CGPoint(x: -2.76, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.28, y: 3.98),
            controlPoint1: CGPoint(x: -2.4, y: 3.94),
            controlPoint2: CGPoint(x: -2.34, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.44, y: 4.97),
            controlPoint1: CGPoint(x: -2.17, y: 4.02),
            controlPoint2: CGPoint(x: 0.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 4.45),
            controlPoint1: CGPoint(x: 0.83, y: 4.97),
            controlPoint2: CGPoint(x: 1.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.03, y: 4.25),
            controlPoint1: CGPoint(x: 1.02, y: 4.38),
            controlPoint2: CGPoint(x: 1.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 2.99),
            controlPoint1: CGPoint(x: 1.03, y: 4.17),
            controlPoint2: CGPoint(x: 1.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 5
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -8, y: -6, width: 4, height: 18))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.addCurve(
            to: CGPoint(x: -0.14, y: -6.48),
            controlPoint1: CGPoint(x: -5.94, y: -12.96),
            controlPoint2: CGPoint(x: -0.26, y: -6.62)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.02, y: -6.18),
            controlPoint1: CGPoint(x: -0.04, y: -6.4),
            controlPoint2: CGPoint(x: 0.02, y: -6.3)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.5, y: -5.77),
            controlPoint1: CGPoint(x: 0.02, y: -5.95),
            controlPoint2: CGPoint(x: -0.21, y: -5.77)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.69, y: -5.79),
            controlPoint1: CGPoint(x: -0.56, y: -5.77),
            controlPoint2: CGPoint(x: -0.63, y: -5.78)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.41, y: -6.59),
            controlPoint1: CGPoint(x: -0.8, y: -5.83),
            controlPoint2: CGPoint(x: -3.31, y: -6.56)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -6.17),
            controlPoint1: CGPoint(x: -3.8, y: -6.59),
            controlPoint2: CGPoint(x: -3.99, y: -6.4)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -4, y: -6.01),
            controlPoint1: CGPoint(x: -3.99, y: -6.12),
            controlPoint2: CGPoint(x: -4, y: -6.06)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -5),
            controlPoint1: CGPoint(x: -4, y: -5.95),
            controlPoint2: CGPoint(x: -3.99, y: -5)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.99, y: -5.05))
        bezier5Path.addCurve(
            to: CGPoint(x: -7.98, y: -6.06),
            controlPoint1: CGPoint(x: -7.99, y: -5.05),
            controlPoint2: CGPoint(x: -7.98, y: -5.99)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.99, y: -6.22),
            controlPoint1: CGPoint(x: -7.99, y: -6.11),
            controlPoint2: CGPoint(x: -7.99, y: -6.17)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -8.47, y: -6.64),
            controlPoint1: CGPoint(x: -7.99, y: -6.45),
            controlPoint2: CGPoint(x: -8.18, y: -6.64)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.29, y: -5.85),
            controlPoint1: CGPoint(x: -8.68, y: -6.61),
            controlPoint2: CGPoint(x: -11.18, y: -5.88)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.48, y: -5.81),
            controlPoint1: CGPoint(x: -11.35, y: -5.83),
            controlPoint2: CGPoint(x: -11.42, y: -5.81)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -12, y: -6.22),
            controlPoint1: CGPoint(x: -11.77, y: -5.81),
            controlPoint2: CGPoint(x: -12, y: -6)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.84, y: -6.53),
            controlPoint1: CGPoint(x: -12, y: -6.35),
            controlPoint2: CGPoint(x: -11.94, y: -6.46)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.99, y: -13),
            controlPoint1: CGPoint(x: -11.72, y: -6.67),
            controlPoint2: CGPoint(x: -6.03, y: -12.96)
        )
        bezier5Path.addLine(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.close()
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.addCurve(
            to: CGPoint(x: 6.38, y: -8.84),
            controlPoint1: CGPoint(x: 6.2, y: -9),
            controlPoint2: CGPoint(x: 6.31, y: -8.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 12, y: -2.98),
            controlPoint1: CGPoint(x: 6.51, y: -8.71),
            controlPoint2: CGPoint(x: 12, y: -2.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.33, y: 2.86),
            controlPoint1: CGPoint(x: 12, y: -2.98),
            controlPoint2: CGPoint(x: 6.46, y: 2.73)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: 3.02),
            controlPoint1: CGPoint(x: 6.26, y: 2.96),
            controlPoint2: CGPoint(x: 6.15, y: 3.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.62, y: 2.5),
            controlPoint1: CGPoint(x: 5.81, y: 3.02),
            controlPoint2: CGPoint(x: 5.62, y: 2.79)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.65, y: 2.31),
            controlPoint1: CGPoint(x: 5.62, y: 2.44),
            controlPoint2: CGPoint(x: 5.63, y: 2.37)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.44, y: -0.41),
            controlPoint1: CGPoint(x: 5.69, y: 2.2),
            controlPoint2: CGPoint(x: 6.41, y: -0.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.99),
            controlPoint1: CGPoint(x: 6.44, y: -0.8),
            controlPoint2: CGPoint(x: 6.26, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.97, y: -0.99),
            controlPoint2: CGPoint(x: 5.92, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.8, y: -1),
            controlPoint2: CGPoint(x: 4.87, y: -0.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 4.91, y: -4.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.92, y: -4.98),
            controlPoint1: CGPoint(x: 4.91, y: -4.99),
            controlPoint2: CGPoint(x: 5.85, y: -4.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.07, y: -4.99),
            controlPoint1: CGPoint(x: 5.97, y: -4.99),
            controlPoint2: CGPoint(x: 6.02, y: -4.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.49, y: -5.47),
            controlPoint1: CGPoint(x: 6.31, y: -4.99),
            controlPoint2: CGPoint(x: 6.49, y: -5.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.7, y: -8.29),
            controlPoint1: CGPoint(x: 6.46, y: -5.68),
            controlPoint2: CGPoint(x: 5.74, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.67, y: -8.48),
            controlPoint1: CGPoint(x: 5.68, y: -8.35),
            controlPoint2: CGPoint(x: 5.67, y: -8.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.08, y: -9),
            controlPoint1: CGPoint(x: 5.67, y: -8.77),
            controlPoint2: CGPoint(x: 5.85, y: -9)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.close()
        primaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -6, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -6, y: 2))
        bezier4Path.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: -6, y: 2),
            controlPoint2: CGPoint(x: -6, y: -3)
        )
        bezier4Path.addLine(to: CGPoint(x: 6, y: -3))
        primaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrTurnOrUturnUsingUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 5
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -8, y: -6, width: 4, height: 18))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.addCurve(
            to: CGPoint(x: -0.14, y: -6.48),
            controlPoint1: CGPoint(x: -5.94, y: -12.96),
            controlPoint2: CGPoint(x: -0.26, y: -6.62)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.02, y: -6.18),
            controlPoint1: CGPoint(x: -0.04, y: -6.4),
            controlPoint2: CGPoint(x: 0.02, y: -6.3)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.5, y: -5.77),
            controlPoint1: CGPoint(x: 0.02, y: -5.95),
            controlPoint2: CGPoint(x: -0.21, y: -5.77)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.69, y: -5.79),
            controlPoint1: CGPoint(x: -0.56, y: -5.77),
            controlPoint2: CGPoint(x: -0.63, y: -5.78)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.41, y: -6.59),
            controlPoint1: CGPoint(x: -0.8, y: -5.83),
            controlPoint2: CGPoint(x: -3.31, y: -6.56)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -6.17),
            controlPoint1: CGPoint(x: -3.8, y: -6.59),
            controlPoint2: CGPoint(x: -3.99, y: -6.4)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -4, y: -6.01),
            controlPoint1: CGPoint(x: -3.99, y: -6.12),
            controlPoint2: CGPoint(x: -4, y: -6.06)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -5),
            controlPoint1: CGPoint(x: -4, y: -5.95),
            controlPoint2: CGPoint(x: -3.99, y: -5)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.99, y: -5.05))
        bezier5Path.addCurve(
            to: CGPoint(x: -7.98, y: -6.06),
            controlPoint1: CGPoint(x: -7.99, y: -5.05),
            controlPoint2: CGPoint(x: -7.98, y: -5.99)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.99, y: -6.22),
            controlPoint1: CGPoint(x: -7.99, y: -6.11),
            controlPoint2: CGPoint(x: -7.99, y: -6.17)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -8.47, y: -6.64),
            controlPoint1: CGPoint(x: -7.99, y: -6.45),
            controlPoint2: CGPoint(x: -8.18, y: -6.64)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.29, y: -5.85),
            controlPoint1: CGPoint(x: -8.68, y: -6.61),
            controlPoint2: CGPoint(x: -11.18, y: -5.88)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.48, y: -5.81),
            controlPoint1: CGPoint(x: -11.35, y: -5.83),
            controlPoint2: CGPoint(x: -11.42, y: -5.81)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -12, y: -6.22),
            controlPoint1: CGPoint(x: -11.77, y: -5.81),
            controlPoint2: CGPoint(x: -12, y: -6)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.84, y: -6.53),
            controlPoint1: CGPoint(x: -12, y: -6.35),
            controlPoint2: CGPoint(x: -11.94, y: -6.46)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.99, y: -13),
            controlPoint1: CGPoint(x: -11.72, y: -6.67),
            controlPoint2: CGPoint(x: -6.03, y: -12.96)
        )
        bezier5Path.addLine(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.close()
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.addCurve(
            to: CGPoint(x: 6.38, y: -8.84),
            controlPoint1: CGPoint(x: 6.2, y: -9),
            controlPoint2: CGPoint(x: 6.31, y: -8.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 12, y: -2.98),
            controlPoint1: CGPoint(x: 6.51, y: -8.71),
            controlPoint2: CGPoint(x: 12, y: -2.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.33, y: 2.86),
            controlPoint1: CGPoint(x: 12, y: -2.98),
            controlPoint2: CGPoint(x: 6.46, y: 2.73)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: 3.02),
            controlPoint1: CGPoint(x: 6.26, y: 2.96),
            controlPoint2: CGPoint(x: 6.15, y: 3.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.62, y: 2.5),
            controlPoint1: CGPoint(x: 5.81, y: 3.02),
            controlPoint2: CGPoint(x: 5.62, y: 2.79)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.65, y: 2.31),
            controlPoint1: CGPoint(x: 5.62, y: 2.44),
            controlPoint2: CGPoint(x: 5.63, y: 2.37)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.44, y: -0.41),
            controlPoint1: CGPoint(x: 5.69, y: 2.2),
            controlPoint2: CGPoint(x: 6.41, y: -0.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.99),
            controlPoint1: CGPoint(x: 6.44, y: -0.8),
            controlPoint2: CGPoint(x: 6.26, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.97, y: -0.99),
            controlPoint2: CGPoint(x: 5.92, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.8, y: -1),
            controlPoint2: CGPoint(x: 4.87, y: -0.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 4.91, y: -4.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.92, y: -4.98),
            controlPoint1: CGPoint(x: 4.91, y: -4.99),
            controlPoint2: CGPoint(x: 5.85, y: -4.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.07, y: -4.99),
            controlPoint1: CGPoint(x: 5.97, y: -4.99),
            controlPoint2: CGPoint(x: 6.02, y: -4.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.49, y: -5.47),
            controlPoint1: CGPoint(x: 6.31, y: -4.99),
            controlPoint2: CGPoint(x: 6.49, y: -5.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.7, y: -8.29),
            controlPoint1: CGPoint(x: 6.46, y: -5.68),
            controlPoint2: CGPoint(x: 5.74, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.67, y: -8.48),
            controlPoint1: CGPoint(x: 5.68, y: -8.35),
            controlPoint2: CGPoint(x: 5.67, y: -8.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.08, y: -9),
            controlPoint1: CGPoint(x: 5.67, y: -8.77),
            controlPoint2: CGPoint(x: 5.85, y: -9)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -6, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -6, y: 2))
        bezier4Path.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: -6, y: 2),
            controlPoint2: CGPoint(x: -6, y: -3)
        )
        bezier4Path.addLine(to: CGPoint(x: 6, y: -3))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 3, y: 9.27))
        bezierPath.addLine(to: CGPoint(x: 3, y: 2.12))
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: 3, y: 0.78),
            controlPoint2: CGPoint(x: 2, y: -3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: 1.91),
            controlPoint1: CGPoint(x: -6, y: -3),
            controlPoint2: CGPoint(x: -6, y: 1.91)
        )
        bezierPath.addLine(to: CGPoint(x: -6, y: 12))
        primaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.01, y: 4.31),
            controlPoint1: CGPoint(x: 5.02, y: 3.05),
            controlPoint2: CGPoint(x: 5.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.02, y: 4.51),
            controlPoint1: CGPoint(x: 5.02, y: 4.37),
            controlPoint2: CGPoint(x: 5.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.5, y: 5.03),
            controlPoint1: CGPoint(x: 5.02, y: 4.8),
            controlPoint2: CGPoint(x: 5.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.32, y: 4.04),
            controlPoint1: CGPoint(x: 5.71, y: 4.99),
            controlPoint2: CGPoint(x: 8.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.51, y: 4),
            controlPoint1: CGPoint(x: 8.38, y: 4.02),
            controlPoint2: CGPoint(x: 8.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9, y: 4.34),
            controlPoint1: CGPoint(x: 8.74, y: 4),
            controlPoint2: CGPoint(x: 8.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.87, y: 4.89),
            controlPoint1: CGPoint(x: 8.97, y: 4.77),
            controlPoint2: CGPoint(x: 8.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.02, y: 11.97),
            controlPoint1: CGPoint(x: 8.74, y: 5.05),
            controlPoint2: CGPoint(x: 3.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0.69, y: 7.44),
            controlPoint1: CGPoint(x: 3.02, y: 11.97),
            controlPoint2: CGPoint(x: 0.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.83, y: 4.84),
            controlPoint1: CGPoint(x: -1.82, y: 6.07),
            controlPoint2: CGPoint(x: -2.77, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.99, y: 4.46),
            controlPoint1: CGPoint(x: -2.93, y: 4.74),
            controlPoint2: CGPoint(x: -2.99, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.47, y: 3.94),
            controlPoint1: CGPoint(x: -2.99, y: 4.17),
            controlPoint2: CGPoint(x: -2.76, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.28, y: 3.98),
            controlPoint1: CGPoint(x: -2.4, y: 3.94),
            controlPoint2: CGPoint(x: -2.34, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.44, y: 4.97),
            controlPoint1: CGPoint(x: -2.17, y: 4.02),
            controlPoint2: CGPoint(x: 0.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 4.45),
            controlPoint1: CGPoint(x: 0.83, y: 4.97),
            controlPoint2: CGPoint(x: 1.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.03, y: 4.25),
            controlPoint1: CGPoint(x: 1.02, y: 4.38),
            controlPoint2: CGPoint(x: 1.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 2.99),
            controlPoint1: CGPoint(x: 1.03, y: 4.17),
            controlPoint2: CGPoint(x: 1.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.close()
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSlightTurnOrTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.05, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.51, y: 1.59),
            controlPoint1: CGPoint(x: 6.37, y: 1.59),
            controlPoint2: CGPoint(x: 6.44, y: 1.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.1),
            controlPoint1: CGPoint(x: 6.8, y: 1.59),
            controlPoint2: CGPoint(x: 7.03, y: 1.4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.01),
            controlPoint1: CGPoint(x: 7.03, y: 1.07),
            controlPoint2: CGPoint(x: 7.03, y: 1.04)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.03, y: 1.01))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.72))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 6, y: -1.91),
            controlPoint1: CGPoint(x: 6.02, y: -1.77),
            controlPoint2: CGPoint(x: 6, y: -1.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.52, y: -2.42),
            controlPoint1: CGPoint(x: 6, y: -2.19),
            controlPoint2: CGPoint(x: 6.23, y: -2.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.9, y: -2.26),
            controlPoint1: CGPoint(x: 6.67, y: -2.42),
            controlPoint2: CGPoint(x: 6.8, y: -2.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.9, y: -2.26))
        bezier2Path.addLine(to: CGPoint(x: 13.97, y: 3.59))
        bezier2Path.addLine(to: CGPoint(x: 6.83, y: 9.44))
        bezier2Path.addLine(to: CGPoint(x: 6.84, y: 9.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.46, y: 9.6),
            controlPoint1: CGPoint(x: 6.74, y: 9.53),
            controlPoint2: CGPoint(x: 6.6, y: 9.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.94, y: 9.08),
            controlPoint1: CGPoint(x: 6.17, y: 9.6),
            controlPoint2: CGPoint(x: 5.94, y: 9.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.98, y: 8.89),
            controlPoint1: CGPoint(x: 5.94, y: 9.01),
            controlPoint2: CGPoint(x: 5.95, y: 8.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.98, y: 8.89))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.97, y: 6.07),
            controlPoint1: CGPoint(x: 6.97, y: 6.14),
            controlPoint2: CGPoint(x: 6.97, y: 6.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.45, y: 5.59),
            controlPoint1: CGPoint(x: 6.97, y: 5.78),
            controlPoint2: CGPoint(x: 6.74, y: 5.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.25, y: 5.58),
            controlPoint1: CGPoint(x: 6.38, y: 5.59),
            controlPoint2: CGPoint(x: 6.31, y: 5.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.25, y: 5.58))
        bezier2Path.addLine(to: CGPoint(x: 4.99, y: 5.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -6.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -6.97, y: 9.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -5, y: 5.61),
            controlPoint1: CGPoint(x: -6.97, y: 8.23),
            controlPoint2: CGPoint(x: -6.27, y: 6.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -0.16, y: 3.61),
            controlPoint1: CGPoint(x: -3.77, y: 4.61),
            controlPoint2: CGPoint(x: -2.07, y: 3.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.03, y: 3.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 2.15, y: -6.97))
        bezier4Path.addLine(to: CGPoint(x: -1, y: -4))
        bezier4Path.addCurve(
            to: CGPoint(x: -7, y: 7),
            controlPoint1: CGPoint(x: -4, y: -1),
            controlPoint2: CGPoint(x: -7, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 5.23, y: -17.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -9, y: -4.42, width: 4, height: 16.42))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -6.98, y: -14))
        bezierPath.addCurve(
            to: CGPoint(x: -1.14, y: -5.87),
            controlPoint1: CGPoint(x: -6.94, y: -13.94),
            controlPoint2: CGPoint(x: -1.26, y: -6.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0.98, y: -5.48),
            controlPoint1: CGPoint(x: -1.04, y: -5.77),
            controlPoint2: CGPoint(x: -0.98, y: -5.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.5, y: -4.97),
            controlPoint1: CGPoint(x: -0.98, y: -5.2),
            controlPoint2: CGPoint(x: -1.21, y: -4.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.69, y: -5.01),
            controlPoint1: CGPoint(x: -1.56, y: -4.97),
            controlPoint2: CGPoint(x: -1.63, y: -4.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.41, y: -6),
            controlPoint1: CGPoint(x: -1.8, y: -5.05),
            controlPoint2: CGPoint(x: -4.31, y: -5.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -5.48),
            controlPoint1: CGPoint(x: -4.8, y: -6),
            controlPoint2: CGPoint(x: -4.99, y: -5.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5, y: -5.28),
            controlPoint1: CGPoint(x: -4.99, y: -5.41),
            controlPoint2: CGPoint(x: -5, y: -5.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -4.01),
            controlPoint1: CGPoint(x: -5, y: -5.2),
            controlPoint2: CGPoint(x: -4.99, y: -4.01)
        )
        bezierPath.addLine(to: CGPoint(x: -8.99, y: -4.08))
        bezierPath.addCurve(
            to: CGPoint(x: -8.98, y: -5.34),
            controlPoint1: CGPoint(x: -8.99, y: -4.08),
            controlPoint2: CGPoint(x: -8.98, y: -5.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -8.99, y: -5.54),
            controlPoint1: CGPoint(x: -8.99, y: -5.4),
            controlPoint2: CGPoint(x: -8.99, y: -5.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.47, y: -6.06),
            controlPoint1: CGPoint(x: -8.99, y: -5.83),
            controlPoint2: CGPoint(x: -9.18, y: -6.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.29, y: -5.07),
            controlPoint1: CGPoint(x: -9.68, y: -6.02),
            controlPoint2: CGPoint(x: -12.18, y: -5.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.48, y: -5.03),
            controlPoint1: CGPoint(x: -12.35, y: -5.04),
            controlPoint2: CGPoint(x: -12.42, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -13, y: -5.54),
            controlPoint1: CGPoint(x: -12.77, y: -5.03),
            controlPoint2: CGPoint(x: -13, y: -5.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.84, y: -5.92),
            controlPoint1: CGPoint(x: -13, y: -5.7),
            controlPoint2: CGPoint(x: -12.94, y: -5.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.99, y: -14),
            controlPoint1: CGPoint(x: -12.72, y: -6.1),
            controlPoint2: CGPoint(x: -7.03, y: -13.94)
        )
        bezierPath.addLine(to: CGPoint(x: -6.98, y: -14))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSlightTurnOrTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.05, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.51, y: 1.59),
            controlPoint1: CGPoint(x: 6.37, y: 1.59),
            controlPoint2: CGPoint(x: 6.44, y: 1.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.1),
            controlPoint1: CGPoint(x: 6.8, y: 1.59),
            controlPoint2: CGPoint(x: 7.03, y: 1.4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.01),
            controlPoint1: CGPoint(x: 7.03, y: 1.07),
            controlPoint2: CGPoint(x: 7.03, y: 1.04)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.03, y: 1.01))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.72))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 6, y: -1.91),
            controlPoint1: CGPoint(x: 6.02, y: -1.77),
            controlPoint2: CGPoint(x: 6, y: -1.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.52, y: -2.42),
            controlPoint1: CGPoint(x: 6, y: -2.19),
            controlPoint2: CGPoint(x: 6.23, y: -2.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.9, y: -2.26),
            controlPoint1: CGPoint(x: 6.67, y: -2.42),
            controlPoint2: CGPoint(x: 6.8, y: -2.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.9, y: -2.26))
        bezier2Path.addLine(to: CGPoint(x: 13.97, y: 3.59))
        bezier2Path.addLine(to: CGPoint(x: 6.83, y: 9.44))
        bezier2Path.addLine(to: CGPoint(x: 6.84, y: 9.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.46, y: 9.6),
            controlPoint1: CGPoint(x: 6.74, y: 9.53),
            controlPoint2: CGPoint(x: 6.6, y: 9.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.94, y: 9.08),
            controlPoint1: CGPoint(x: 6.17, y: 9.6),
            controlPoint2: CGPoint(x: 5.94, y: 9.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.98, y: 8.89),
            controlPoint1: CGPoint(x: 5.94, y: 9.01),
            controlPoint2: CGPoint(x: 5.95, y: 8.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.98, y: 8.89))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.97, y: 6.07),
            controlPoint1: CGPoint(x: 6.97, y: 6.14),
            controlPoint2: CGPoint(x: 6.97, y: 6.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.45, y: 5.59),
            controlPoint1: CGPoint(x: 6.97, y: 5.78),
            controlPoint2: CGPoint(x: 6.74, y: 5.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.25, y: 5.58),
            controlPoint1: CGPoint(x: 6.38, y: 5.59),
            controlPoint2: CGPoint(x: 6.31, y: 5.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.25, y: 5.58))
        bezier2Path.addLine(to: CGPoint(x: 4.99, y: 5.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -6.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -6.97, y: 9.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -5, y: 5.61),
            controlPoint1: CGPoint(x: -6.97, y: 8.23),
            controlPoint2: CGPoint(x: -6.27, y: 6.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -0.16, y: 3.61),
            controlPoint1: CGPoint(x: -3.77, y: 4.61),
            controlPoint2: CGPoint(x: -2.07, y: 3.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.03, y: 3.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -9, y: -4.42, width: 4, height: 16.42))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -6.98, y: -14))
        bezierPath.addCurve(
            to: CGPoint(x: -1.14, y: -5.87),
            controlPoint1: CGPoint(x: -6.94, y: -13.94),
            controlPoint2: CGPoint(x: -1.26, y: -6.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0.98, y: -5.48),
            controlPoint1: CGPoint(x: -1.04, y: -5.77),
            controlPoint2: CGPoint(x: -0.98, y: -5.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.5, y: -4.97),
            controlPoint1: CGPoint(x: -0.98, y: -5.2),
            controlPoint2: CGPoint(x: -1.21, y: -4.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.69, y: -5.01),
            controlPoint1: CGPoint(x: -1.56, y: -4.97),
            controlPoint2: CGPoint(x: -1.63, y: -4.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.41, y: -6),
            controlPoint1: CGPoint(x: -1.8, y: -5.05),
            controlPoint2: CGPoint(x: -4.31, y: -5.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -5.48),
            controlPoint1: CGPoint(x: -4.8, y: -6),
            controlPoint2: CGPoint(x: -4.99, y: -5.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5, y: -5.28),
            controlPoint1: CGPoint(x: -4.99, y: -5.41),
            controlPoint2: CGPoint(x: -5, y: -5.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -4.01),
            controlPoint1: CGPoint(x: -5, y: -5.2),
            controlPoint2: CGPoint(x: -4.99, y: -4.01)
        )
        bezierPath.addLine(to: CGPoint(x: -8.99, y: -4.08))
        bezierPath.addCurve(
            to: CGPoint(x: -8.98, y: -5.34),
            controlPoint1: CGPoint(x: -8.99, y: -4.08),
            controlPoint2: CGPoint(x: -8.98, y: -5.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -8.99, y: -5.54),
            controlPoint1: CGPoint(x: -8.99, y: -5.4),
            controlPoint2: CGPoint(x: -8.99, y: -5.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.47, y: -6.06),
            controlPoint1: CGPoint(x: -8.99, y: -5.83),
            controlPoint2: CGPoint(x: -9.18, y: -6.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.29, y: -5.07),
            controlPoint1: CGPoint(x: -9.68, y: -6.02),
            controlPoint2: CGPoint(x: -12.18, y: -5.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.48, y: -5.03),
            controlPoint1: CGPoint(x: -12.35, y: -5.04),
            controlPoint2: CGPoint(x: -12.42, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -13, y: -5.54),
            controlPoint1: CGPoint(x: -12.77, y: -5.03),
            controlPoint2: CGPoint(x: -13, y: -5.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.84, y: -5.92),
            controlPoint1: CGPoint(x: -13, y: -5.7),
            controlPoint2: CGPoint(x: -12.94, y: -5.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.99, y: -14),
            controlPoint1: CGPoint(x: -12.72, y: -6.1),
            controlPoint2: CGPoint(x: -7.03, y: -13.94)
        )
        bezierPath.addLine(to: CGPoint(x: -6.98, y: -14))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 2.15, y: -6.97))
        bezier4Path.addLine(to: CGPoint(x: -1, y: -4))
        bezier4Path.addCurve(
            to: CGPoint(x: -7, y: 7),
            controlPoint1: CGPoint(x: -4, y: -1),
            controlPoint2: CGPoint(x: -7, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.02, y: 12.02))
        primaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 5.23, y: -17.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSlightTurnOrTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -9, y: -4.42, width: 4, height: 16.42))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -6.98, y: -14))
        bezierPath.addCurve(
            to: CGPoint(x: -1.14, y: -5.87),
            controlPoint1: CGPoint(x: -6.94, y: -13.94),
            controlPoint2: CGPoint(x: -1.26, y: -6.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0.98, y: -5.48),
            controlPoint1: CGPoint(x: -1.04, y: -5.77),
            controlPoint2: CGPoint(x: -0.98, y: -5.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.5, y: -4.97),
            controlPoint1: CGPoint(x: -0.98, y: -5.2),
            controlPoint2: CGPoint(x: -1.21, y: -4.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.69, y: -5.01),
            controlPoint1: CGPoint(x: -1.56, y: -4.97),
            controlPoint2: CGPoint(x: -1.63, y: -4.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.41, y: -6),
            controlPoint1: CGPoint(x: -1.8, y: -5.05),
            controlPoint2: CGPoint(x: -4.31, y: -5.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -5.48),
            controlPoint1: CGPoint(x: -4.8, y: -6),
            controlPoint2: CGPoint(x: -4.99, y: -5.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5, y: -5.28),
            controlPoint1: CGPoint(x: -4.99, y: -5.41),
            controlPoint2: CGPoint(x: -5, y: -5.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -4.01),
            controlPoint1: CGPoint(x: -5, y: -5.2),
            controlPoint2: CGPoint(x: -4.99, y: -4.01)
        )
        bezierPath.addLine(to: CGPoint(x: -8.99, y: -4.08))
        bezierPath.addCurve(
            to: CGPoint(x: -8.98, y: -5.34),
            controlPoint1: CGPoint(x: -8.99, y: -4.08),
            controlPoint2: CGPoint(x: -8.98, y: -5.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -8.99, y: -5.54),
            controlPoint1: CGPoint(x: -8.99, y: -5.4),
            controlPoint2: CGPoint(x: -8.99, y: -5.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.47, y: -6.06),
            controlPoint1: CGPoint(x: -8.99, y: -5.83),
            controlPoint2: CGPoint(x: -9.18, y: -6.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.29, y: -5.07),
            controlPoint1: CGPoint(x: -9.68, y: -6.02),
            controlPoint2: CGPoint(x: -12.18, y: -5.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.48, y: -5.03),
            controlPoint1: CGPoint(x: -12.35, y: -5.04),
            controlPoint2: CGPoint(x: -12.42, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -13, y: -5.54),
            controlPoint1: CGPoint(x: -12.77, y: -5.03),
            controlPoint2: CGPoint(x: -13, y: -5.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.84, y: -5.92),
            controlPoint1: CGPoint(x: -13, y: -5.7),
            controlPoint2: CGPoint(x: -12.94, y: -5.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.99, y: -14),
            controlPoint1: CGPoint(x: -12.72, y: -6.1),
            controlPoint2: CGPoint(x: -7.03, y: -13.94)
        )
        bezierPath.addLine(to: CGPoint(x: -6.98, y: -14))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 2.15, y: -6.97))
        bezier4Path.addLine(to: CGPoint(x: -1, y: -4))
        bezier4Path.addCurve(
            to: CGPoint(x: -7, y: 7),
            controlPoint1: CGPoint(x: -4, y: -1),
            controlPoint2: CGPoint(x: -7, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 5.23, y: -17.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.05, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.51, y: 1.59),
            controlPoint1: CGPoint(x: 6.37, y: 1.59),
            controlPoint2: CGPoint(x: 6.44, y: 1.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.1),
            controlPoint1: CGPoint(x: 6.8, y: 1.59),
            controlPoint2: CGPoint(x: 7.03, y: 1.4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.01),
            controlPoint1: CGPoint(x: 7.03, y: 1.07),
            controlPoint2: CGPoint(x: 7.03, y: 1.04)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.03, y: 1.01))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.72))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 6, y: -1.91),
            controlPoint1: CGPoint(x: 6.02, y: -1.77),
            controlPoint2: CGPoint(x: 6, y: -1.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.52, y: -2.42),
            controlPoint1: CGPoint(x: 6, y: -2.19),
            controlPoint2: CGPoint(x: 6.23, y: -2.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.9, y: -2.26),
            controlPoint1: CGPoint(x: 6.67, y: -2.42),
            controlPoint2: CGPoint(x: 6.8, y: -2.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.9, y: -2.26))
        bezier2Path.addLine(to: CGPoint(x: 13.97, y: 3.59))
        bezier2Path.addLine(to: CGPoint(x: 6.83, y: 9.44))
        bezier2Path.addLine(to: CGPoint(x: 6.84, y: 9.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.46, y: 9.6),
            controlPoint1: CGPoint(x: 6.74, y: 9.53),
            controlPoint2: CGPoint(x: 6.6, y: 9.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.94, y: 9.08),
            controlPoint1: CGPoint(x: 6.17, y: 9.6),
            controlPoint2: CGPoint(x: 5.94, y: 9.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.98, y: 8.89),
            controlPoint1: CGPoint(x: 5.94, y: 9.01),
            controlPoint2: CGPoint(x: 5.95, y: 8.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.98, y: 8.89))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.97, y: 6.07),
            controlPoint1: CGPoint(x: 6.97, y: 6.14),
            controlPoint2: CGPoint(x: 6.97, y: 6.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.45, y: 5.59),
            controlPoint1: CGPoint(x: 6.97, y: 5.78),
            controlPoint2: CGPoint(x: 6.74, y: 5.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.25, y: 5.58),
            controlPoint1: CGPoint(x: 6.38, y: 5.59),
            controlPoint2: CGPoint(x: 6.31, y: 5.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.25, y: 5.58))
        bezier2Path.addLine(to: CGPoint(x: 4.99, y: 5.59))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -6.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -6.97, y: 9.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -5, y: 5.61),
            controlPoint1: CGPoint(x: -6.97, y: 8.23),
            controlPoint2: CGPoint(x: -6.27, y: 6.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -0.16, y: 3.61),
            controlPoint1: CGPoint(x: -3.77, y: 4.61),
            controlPoint2: CGPoint(x: -2.07, y: 3.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.03, y: 3.61))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrStraightOrSlightTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.91, y: -0.41),
            controlPoint1: CGPoint(x: -6.8, y: -0.41),
            controlPoint2: CGPoint(x: -6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.34, y: -0.9),
            controlPoint1: CGPoint(x: -7.15, y: -0.41),
            controlPoint2: CGPoint(x: -7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.33, y: -0.99),
            controlPoint1: CGPoint(x: -7.34, y: -0.93),
            controlPoint2: CGPoint(x: -7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.5, y: -3.91),
            controlPoint1: CGPoint(x: -6.51, y: -3.77),
            controlPoint2: CGPoint(x: -6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.92, y: -4.42),
            controlPoint1: CGPoint(x: -6.5, y: -4.19),
            controlPoint2: CGPoint(x: -6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.23, y: -4.26),
            controlPoint1: CGPoint(x: -7.04, y: -4.42),
            controlPoint2: CGPoint(x: -7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: -12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.87, y: 7.6),
            controlPoint1: CGPoint(x: -7.1, y: 7.53),
            controlPoint2: CGPoint(x: -6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.45, y: 7.08),
            controlPoint1: CGPoint(x: -6.64, y: 7.6),
            controlPoint2: CGPoint(x: -6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.48, y: 6.89),
            controlPoint1: CGPoint(x: -6.45, y: 7.01),
            controlPoint2: CGPoint(x: -6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: -7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: -7.28, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: -7.29, y: 4.07),
            controlPoint1: CGPoint(x: -7.29, y: 4.14),
            controlPoint2: CGPoint(x: -7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.86, y: 3.59),
            controlPoint1: CGPoint(x: -7.29, y: 3.78),
            controlPoint2: CGPoint(x: -7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.7, y: 3.58),
            controlPoint1: CGPoint(x: -6.81, y: 3.59),
            controlPoint2: CGPoint(x: -6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.7, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: -5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: -0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: -1.63, y: 3.61),
            controlPoint1: CGPoint(x: -0.03, y: 6.23),
            controlPoint2: CGPoint(x: -0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.56, y: 1.61),
            controlPoint1: CGPoint(x: -2.63, y: 2.61),
            controlPoint2: CGPoint(x: -4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.15, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: 3, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 6),
            controlPoint1: CGPoint(x: 0, y: 1),
            controlPoint2: CGPoint(x: 0, y: 4.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -0.02, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 9.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrStraightOrSlightTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.91, y: -0.41),
            controlPoint1: CGPoint(x: -6.8, y: -0.41),
            controlPoint2: CGPoint(x: -6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.34, y: -0.9),
            controlPoint1: CGPoint(x: -7.15, y: -0.41),
            controlPoint2: CGPoint(x: -7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.33, y: -0.99),
            controlPoint1: CGPoint(x: -7.34, y: -0.93),
            controlPoint2: CGPoint(x: -7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.5, y: -3.91),
            controlPoint1: CGPoint(x: -6.51, y: -3.77),
            controlPoint2: CGPoint(x: -6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.92, y: -4.42),
            controlPoint1: CGPoint(x: -6.5, y: -4.19),
            controlPoint2: CGPoint(x: -6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.23, y: -4.26),
            controlPoint1: CGPoint(x: -7.04, y: -4.42),
            controlPoint2: CGPoint(x: -7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: -12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.87, y: 7.6),
            controlPoint1: CGPoint(x: -7.1, y: 7.53),
            controlPoint2: CGPoint(x: -6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.45, y: 7.08),
            controlPoint1: CGPoint(x: -6.64, y: 7.6),
            controlPoint2: CGPoint(x: -6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.48, y: 6.89),
            controlPoint1: CGPoint(x: -6.45, y: 7.01),
            controlPoint2: CGPoint(x: -6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: -7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: -7.28, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: -7.29, y: 4.07),
            controlPoint1: CGPoint(x: -7.29, y: 4.14),
            controlPoint2: CGPoint(x: -7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.86, y: 3.59),
            controlPoint1: CGPoint(x: -7.29, y: 3.78),
            controlPoint2: CGPoint(x: -7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.7, y: 3.58),
            controlPoint1: CGPoint(x: -6.81, y: 3.59),
            controlPoint2: CGPoint(x: -6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.7, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: -5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: -0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: -1.63, y: 3.61),
            controlPoint1: CGPoint(x: -0.03, y: 6.23),
            controlPoint2: CGPoint(x: -0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.56, y: 1.61),
            controlPoint1: CGPoint(x: -2.63, y: 2.61),
            controlPoint2: CGPoint(x: -4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.15, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: 3, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 6),
            controlPoint1: CGPoint(x: 0, y: 1),
            controlPoint2: CGPoint(x: 0, y: 4.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -0.02, y: 12.02))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 9.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrStraightOrTurnUsingTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -6.14, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: -2.99, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: 0.01, y: 6),
            controlPoint1: CGPoint(x: 0.01, y: 1),
            controlPoint2: CGPoint(x: 0.01, y: 4.35)
        )
        bezier3Path.addLine(to: CGPoint(x: 0.03, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: -9.57, y: -15.58)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier2Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier2Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier2Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier2Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier2Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier2Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier2Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier2Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier2Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier2Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier2Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier2Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier2Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier2Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier2Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier2Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: 6.76, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.91, y: -0.41),
            controlPoint1: CGPoint(x: 6.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.9),
            controlPoint1: CGPoint(x: 7.15, y: -0.41),
            controlPoint2: CGPoint(x: 7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.99),
            controlPoint1: CGPoint(x: 7.34, y: -0.93),
            controlPoint2: CGPoint(x: 7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: 7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: 6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: 6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.5, y: -3.91),
            controlPoint1: CGPoint(x: 6.52, y: -3.77),
            controlPoint2: CGPoint(x: 6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.92, y: -4.42),
            controlPoint1: CGPoint(x: 6.5, y: -4.19),
            controlPoint2: CGPoint(x: 6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.23, y: -4.26),
            controlPoint1: CGPoint(x: 7.04, y: -4.42),
            controlPoint2: CGPoint(x: 7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: 7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: 7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: 7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.87, y: 7.6),
            controlPoint1: CGPoint(x: 7.1, y: 7.53),
            controlPoint2: CGPoint(x: 6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.45, y: 7.08),
            controlPoint1: CGPoint(x: 6.64, y: 7.6),
            controlPoint2: CGPoint(x: 6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.48, y: 6.89),
            controlPoint1: CGPoint(x: 6.45, y: 7.01),
            controlPoint2: CGPoint(x: 6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: 6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: 7.29, y: 4.07),
            controlPoint1: CGPoint(x: 7.29, y: 4.14),
            controlPoint2: CGPoint(x: 7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.86, y: 3.59),
            controlPoint1: CGPoint(x: 7.29, y: 3.78),
            controlPoint2: CGPoint(x: 7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.7, y: 3.58),
            controlPoint1: CGPoint(x: 6.81, y: 3.59),
            controlPoint2: CGPoint(x: 6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: 6.71, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: 5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: 0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: 1.63, y: 3.61),
            controlPoint1: CGPoint(x: 0.03, y: 6.23),
            controlPoint2: CGPoint(x: 0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 5.56, y: 1.61),
            controlPoint1: CGPoint(x: 2.63, y: 2.61),
            controlPoint2: CGPoint(x: 4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: 7.34, y: 1.61))
        primaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrStraightOrTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -6.14, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: -2.99, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: 0.01, y: 6),
            controlPoint1: CGPoint(x: 0.01, y: 1),
            controlPoint2: CGPoint(x: 0.01, y: 4.35)
        )
        bezier3Path.addLine(to: CGPoint(x: 0.03, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: -9.57, y: -15.58)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier2Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier2Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier2Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier2Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier2Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier2Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier2Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier2Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier2Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier2Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier2Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier2Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier2Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier2Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier2Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier2Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: 6.76, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.91, y: -0.41),
            controlPoint1: CGPoint(x: 6.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.9),
            controlPoint1: CGPoint(x: 7.15, y: -0.41),
            controlPoint2: CGPoint(x: 7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.99),
            controlPoint1: CGPoint(x: 7.34, y: -0.93),
            controlPoint2: CGPoint(x: 7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: 7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: 6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: 6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.5, y: -3.91),
            controlPoint1: CGPoint(x: 6.52, y: -3.77),
            controlPoint2: CGPoint(x: 6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.92, y: -4.42),
            controlPoint1: CGPoint(x: 6.5, y: -4.19),
            controlPoint2: CGPoint(x: 6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.23, y: -4.26),
            controlPoint1: CGPoint(x: 7.04, y: -4.42),
            controlPoint2: CGPoint(x: 7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: 7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: 7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: 7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.87, y: 7.6),
            controlPoint1: CGPoint(x: 7.1, y: 7.53),
            controlPoint2: CGPoint(x: 6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.45, y: 7.08),
            controlPoint1: CGPoint(x: 6.64, y: 7.6),
            controlPoint2: CGPoint(x: 6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.48, y: 6.89),
            controlPoint1: CGPoint(x: 6.45, y: 7.01),
            controlPoint2: CGPoint(x: 6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: 6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: 7.29, y: 4.07),
            controlPoint1: CGPoint(x: 7.29, y: 4.14),
            controlPoint2: CGPoint(x: 7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.86, y: 3.59),
            controlPoint1: CGPoint(x: 7.29, y: 3.78),
            controlPoint2: CGPoint(x: 7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.7, y: 3.58),
            controlPoint1: CGPoint(x: 6.81, y: 3.59),
            controlPoint2: CGPoint(x: 6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: 6.71, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: 5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: 0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: 1.63, y: 3.61),
            controlPoint1: CGPoint(x: 0.03, y: 6.23),
            controlPoint2: CGPoint(x: 0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 5.56, y: 1.61),
            controlPoint1: CGPoint(x: 2.63, y: 2.61),
            controlPoint2: CGPoint(x: 4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: 7.34, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrStraightOrSlightTurnUsingStraight(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 14.9, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -6.05, y: 1.03))
        bezier4Path.addLine(to: CGPoint(x: -2.9, y: 4))
        bezier4Path.addCurve(
            to: CGPoint(x: 0.1, y: 11),
            controlPoint1: CGPoint(x: 0.1, y: 7),
            controlPoint2: CGPoint(x: 0.1, y: 9.35)
        )
        bezier4Path.addLine(to: CGPoint(x: 0.12, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: -9.48, y: -9.58)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier5Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier5Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier5Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier5Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier5Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier5Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier5Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier5Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier5Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier5Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier5Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier5Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier5Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier5Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier5Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.15, y: 1.03))
        bezier3Path.addLine(to: CGPoint(x: 3, y: 4))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 11),
            controlPoint1: CGPoint(x: 0, y: 7),
            controlPoint2: CGPoint(x: 0, y: 9.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -0.02, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 9.23, y: -9.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        primaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        primaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrStraightOrSlightTurnUsingSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        primaryColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000),
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 14.9, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -6.05, y: 1.03))
        bezier4Path.addLine(to: CGPoint(x: -2.9, y: 4))
        bezier4Path.addCurve(
            to: CGPoint(x: 0.1, y: 11),
            controlPoint1: CGPoint(x: 0.1, y: 7),
            controlPoint2: CGPoint(x: 0.1, y: 9.35)
        )
        bezier4Path.addLine(to: CGPoint(x: 0.12, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: -9.48, y: -9.58)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier5Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier5Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier5Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier5Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier5Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier5Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier5Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier5Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier5Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier5Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier5Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier5Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier5Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier5Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier5Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.15, y: 1.03))
        bezier3Path.addLine(to: CGPoint(x: 3, y: 4))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 11),
            controlPoint1: CGPoint(x: 0, y: 7),
            controlPoint2: CGPoint(x: 0, y: 9.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -0.02, y: 12.02))
        primaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 9.23, y: -9.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        primaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrStraightOrSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 14.9, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -6.05, y: 1.03))
        bezier4Path.addLine(to: CGPoint(x: -2.9, y: 4))
        bezier4Path.addCurve(
            to: CGPoint(x: 0.1, y: 11),
            controlPoint1: CGPoint(x: 0.1, y: 7),
            controlPoint2: CGPoint(x: 0.1, y: 9.35)
        )
        bezier4Path.addLine(to: CGPoint(x: 0.12, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: -9.48, y: -9.58)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier5Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier5Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier5Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier5Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier5Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier5Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier5Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier5Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier5Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier5Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier5Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier5Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier5Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier5Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier5Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.15, y: 1.03))
        bezier3Path.addLine(to: CGPoint(x: 3, y: 4))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 11),
            controlPoint1: CGPoint(x: 0, y: 7),
            controlPoint2: CGPoint(x: 0, y: 9.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -0.02, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 9.23, y: -9.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrStraightOrSlightTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.91, y: -0.41),
            controlPoint1: CGPoint(x: -6.8, y: -0.41),
            controlPoint2: CGPoint(x: -6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.34, y: -0.9),
            controlPoint1: CGPoint(x: -7.15, y: -0.41),
            controlPoint2: CGPoint(x: -7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.33, y: -0.99),
            controlPoint1: CGPoint(x: -7.34, y: -0.93),
            controlPoint2: CGPoint(x: -7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.5, y: -3.91),
            controlPoint1: CGPoint(x: -6.51, y: -3.77),
            controlPoint2: CGPoint(x: -6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.92, y: -4.42),
            controlPoint1: CGPoint(x: -6.5, y: -4.19),
            controlPoint2: CGPoint(x: -6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.23, y: -4.26),
            controlPoint1: CGPoint(x: -7.04, y: -4.42),
            controlPoint2: CGPoint(x: -7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: -12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.87, y: 7.6),
            controlPoint1: CGPoint(x: -7.1, y: 7.53),
            controlPoint2: CGPoint(x: -6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.45, y: 7.08),
            controlPoint1: CGPoint(x: -6.64, y: 7.6),
            controlPoint2: CGPoint(x: -6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.48, y: 6.89),
            controlPoint1: CGPoint(x: -6.45, y: 7.01),
            controlPoint2: CGPoint(x: -6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: -7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: -7.28, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: -7.29, y: 4.07),
            controlPoint1: CGPoint(x: -7.29, y: 4.14),
            controlPoint2: CGPoint(x: -7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.86, y: 3.59),
            controlPoint1: CGPoint(x: -7.29, y: 3.78),
            controlPoint2: CGPoint(x: -7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.7, y: 3.58),
            controlPoint1: CGPoint(x: -6.81, y: 3.59),
            controlPoint2: CGPoint(x: -6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.7, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: -5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: -0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: -1.63, y: 3.61),
            controlPoint1: CGPoint(x: -0.03, y: 6.23),
            controlPoint2: CGPoint(x: -0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.56, y: 1.61),
            controlPoint1: CGPoint(x: -2.63, y: 2.61),
            controlPoint2: CGPoint(x: -4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.15, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: 3, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: 0, y: 6),
            controlPoint1: CGPoint(x: 0, y: 1),
            controlPoint2: CGPoint(x: 0, y: 4.35)
        )
        bezier3Path.addLine(to: CGPoint(x: -0.02, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: 9.23, y: -15.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier2Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier2Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier2Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier2Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier2Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier2Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier2Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier2Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier2Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier2Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier2Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeTurnOrStraightOrTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: -6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.91, y: -0.41),
            controlPoint1: CGPoint(x: -6.8, y: -0.41),
            controlPoint2: CGPoint(x: -6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.34, y: -0.9),
            controlPoint1: CGPoint(x: -7.15, y: -0.41),
            controlPoint2: CGPoint(x: -7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.33, y: -0.99),
            controlPoint1: CGPoint(x: -7.34, y: -0.93),
            controlPoint2: CGPoint(x: -7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: -6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.5, y: -3.91),
            controlPoint1: CGPoint(x: -6.51, y: -3.77),
            controlPoint2: CGPoint(x: -6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.92, y: -4.42),
            controlPoint1: CGPoint(x: -6.5, y: -4.19),
            controlPoint2: CGPoint(x: -6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -7.23, y: -4.26),
            controlPoint1: CGPoint(x: -7.04, y: -4.42),
            controlPoint2: CGPoint(x: -7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: -12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: -7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: -6.87, y: 7.6),
            controlPoint1: CGPoint(x: -7.1, y: 7.53),
            controlPoint2: CGPoint(x: -6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.45, y: 7.08),
            controlPoint1: CGPoint(x: -6.64, y: 7.6),
            controlPoint2: CGPoint(x: -6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.48, y: 6.89),
            controlPoint1: CGPoint(x: -6.45, y: 7.01),
            controlPoint2: CGPoint(x: -6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: -7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: -7.28, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: -7.29, y: 4.07),
            controlPoint1: CGPoint(x: -7.29, y: 4.14),
            controlPoint2: CGPoint(x: -7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.86, y: 3.59),
            controlPoint1: CGPoint(x: -7.29, y: 3.78),
            controlPoint2: CGPoint(x: -7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: -6.7, y: 3.58),
            controlPoint1: CGPoint(x: -6.81, y: 3.59),
            controlPoint2: CGPoint(x: -6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: -6.7, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: -5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: -0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: -1.63, y: 3.61),
            controlPoint1: CGPoint(x: -0.03, y: 6.23),
            controlPoint2: CGPoint(x: -0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.56, y: 1.61),
            controlPoint1: CGPoint(x: -2.63, y: 2.61),
            controlPoint2: CGPoint(x: -4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.73, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier2Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.91, y: -0.41),
            controlPoint1: CGPoint(x: 6.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.86, y: -0.41)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.9),
            controlPoint1: CGPoint(x: 7.15, y: -0.41),
            controlPoint2: CGPoint(x: 7.34, y: -0.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.33, y: -0.99),
            controlPoint1: CGPoint(x: 7.34, y: -0.93),
            controlPoint2: CGPoint(x: 7.34, y: -0.96)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.34, y: -0.99))
        bezier2Path.addLine(to: CGPoint(x: 6.53, y: -3.72))
        bezier2Path.addLine(to: CGPoint(x: 6.53, y: -3.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.5, y: -3.91),
            controlPoint1: CGPoint(x: 6.51, y: -3.77),
            controlPoint2: CGPoint(x: 6.5, y: -3.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.92, y: -4.42),
            controlPoint1: CGPoint(x: 6.5, y: -4.19),
            controlPoint2: CGPoint(x: 6.69, y: -4.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.23, y: -4.26),
            controlPoint1: CGPoint(x: 7.04, y: -4.42),
            controlPoint2: CGPoint(x: 7.15, y: -4.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.23, y: -4.26))
        bezier2Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 7.18, y: 7.44))
        bezier2Path.addLine(to: CGPoint(x: 7.18, y: 7.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.87, y: 7.6),
            controlPoint1: CGPoint(x: 7.1, y: 7.53),
            controlPoint2: CGPoint(x: 6.99, y: 7.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.45, y: 7.08),
            controlPoint1: CGPoint(x: 6.64, y: 7.6),
            controlPoint2: CGPoint(x: 6.45, y: 7.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.48, y: 6.89),
            controlPoint1: CGPoint(x: 6.45, y: 7.01),
            controlPoint2: CGPoint(x: 6.46, y: 6.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.48, y: 6.89))
        bezier2Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier2Path.addLine(to: CGPoint(x: 7.28, y: 4.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 7.29, y: 4.07),
            controlPoint1: CGPoint(x: 7.29, y: 4.14),
            controlPoint2: CGPoint(x: 7.29, y: 4.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.86, y: 3.59),
            controlPoint1: CGPoint(x: 7.29, y: 3.78),
            controlPoint2: CGPoint(x: 7.1, y: 3.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.7, y: 3.58),
            controlPoint1: CGPoint(x: 6.81, y: 3.59),
            controlPoint2: CGPoint(x: 6.75, y: 3.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.7, y: 3.58))
        bezier2Path.addLine(to: CGPoint(x: 5.68, y: 3.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 0.03, y: 12))
        bezier3Path.addLine(to: CGPoint(x: 0.03, y: 7.87))
        bezier3Path.addCurve(
            to: CGPoint(x: 1.63, y: 3.61),
            controlPoint1: CGPoint(x: 0.03, y: 6.23),
            controlPoint2: CGPoint(x: 0.6, y: 4.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.56, y: 1.61),
            controlPoint1: CGPoint(x: 2.63, y: 2.61),
            controlPoint2: CGPoint(x: 4.01, y: 1.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 7.33, y: 1.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group 5
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -6, width: 4, height: 18))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -6.48),
            controlPoint1: CGPoint(x: 0.06, y: -12.96),
            controlPoint2: CGPoint(x: 5.74, y: -6.62)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -6.18),
            controlPoint1: CGPoint(x: 5.96, y: -6.4),
            controlPoint2: CGPoint(x: 6.02, y: -6.3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -5.77),
            controlPoint1: CGPoint(x: 6.02, y: -5.95),
            controlPoint2: CGPoint(x: 5.79, y: -5.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -5.79),
            controlPoint1: CGPoint(x: 5.44, y: -5.77),
            controlPoint2: CGPoint(x: 5.37, y: -5.78)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -6.59),
            controlPoint1: CGPoint(x: 5.2, y: -5.83),
            controlPoint2: CGPoint(x: 2.69, y: -6.56)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -6.17),
            controlPoint1: CGPoint(x: 2.2, y: -6.59),
            controlPoint2: CGPoint(x: 2.01, y: -6.4)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -6.01),
            controlPoint1: CGPoint(x: 2.01, y: -6.12),
            controlPoint2: CGPoint(x: 2, y: -6.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -5),
            controlPoint1: CGPoint(x: 2, y: -5.95),
            controlPoint2: CGPoint(x: 2.01, y: -5)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -5.05))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -6.06),
            controlPoint1: CGPoint(x: -1.99, y: -5.05),
            controlPoint2: CGPoint(x: -1.98, y: -5.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -6.22),
            controlPoint1: CGPoint(x: -1.99, y: -6.11),
            controlPoint2: CGPoint(x: -1.99, y: -6.17)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -6.64),
            controlPoint1: CGPoint(x: -1.99, y: -6.45),
            controlPoint2: CGPoint(x: -2.18, y: -6.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -5.85),
            controlPoint1: CGPoint(x: -2.68, y: -6.61),
            controlPoint2: CGPoint(x: -5.18, y: -5.88)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -5.81),
            controlPoint1: CGPoint(x: -5.35, y: -5.83),
            controlPoint2: CGPoint(x: -5.42, y: -5.81)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -6.22),
            controlPoint1: CGPoint(x: -5.77, y: -5.81),
            controlPoint2: CGPoint(x: -6, y: -6)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -6.53),
            controlPoint1: CGPoint(x: -6, y: -6.35),
            controlPoint2: CGPoint(x: -5.94, y: -6.46)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -6.67),
            controlPoint2: CGPoint(x: -0.03, y: -12.96)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneOppositeSlightTurnOrStraightOrTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -6.14, y: -4.97))
        bezier3Path.addLine(to: CGPoint(x: -2.99, y: -2))
        bezier3Path.addCurve(
            to: CGPoint(x: 0.01, y: 6),
            controlPoint1: CGPoint(x: 0.01, y: 1),
            controlPoint2: CGPoint(x: 0.01, y: 4.35)
        )
        bezier3Path.addLine(to: CGPoint(x: 0.03, y: 12.02))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.lineJoinStyle = .round
        bezier3Path.stroke()

        //// Bezier 2 Drawing
        context.saveGState()
        context.translateBy(x: -9.57, y: -15.58)
        context.rotate(by: -49 * CGFloat.pi / 180)

        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: -3.78, y: 10.19))
        bezier2Path.addLine(to: CGPoint(x: -3.79, y: 8.92))
        bezier2Path.addLine(to: CGPoint(x: -3.79, y: 8.93))
        bezier2Path.addCurve(
            to: CGPoint(x: -3.78, y: 8.73),
            controlPoint1: CGPoint(x: -3.79, y: 8.87),
            controlPoint2: CGPoint(x: -3.78, y: 8.79)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.3, y: 8.2),
            controlPoint1: CGPoint(x: -3.78, y: 8.44),
            controlPoint2: CGPoint(x: -3.59, y: 8.2)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -3.2, y: 8.21),
            controlPoint1: CGPoint(x: -3.27, y: 8.2),
            controlPoint2: CGPoint(x: -3.23, y: 8.2)
        )
        bezier2Path.addLine(to: CGPoint(x: -3.21, y: 8.2))
        bezier2Path.addLine(to: CGPoint(x: -0.48, y: 9.2))
        bezier2Path.addLine(to: CGPoint(x: -0.48, y: 9.19))
        bezier2Path.addCurve(
            to: CGPoint(x: -0.29, y: 9.23),
            controlPoint1: CGPoint(x: -0.42, y: 9.22),
            controlPoint2: CGPoint(x: -0.36, y: 9.23)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.23, y: 8.72),
            controlPoint1: CGPoint(x: -0, y: 9.23),
            controlPoint2: CGPoint(x: 0.23, y: 9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.07, y: 8.34),
            controlPoint1: CGPoint(x: 0.23, y: 8.57),
            controlPoint2: CGPoint(x: 0.17, y: 8.43)
        )
        bezier2Path.addLine(to: CGPoint(x: 0.07, y: 8.34))
        bezier2Path.addLine(to: CGPoint(x: -5.79, y: 0.26))
        bezier2Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier2Path.addLine(to: CGPoint(x: -11.63, y: 8.4))
        bezier2Path.addCurve(
            to: CGPoint(x: -11.79, y: 8.78),
            controlPoint1: CGPoint(x: -11.73, y: 8.49),
            controlPoint2: CGPoint(x: -11.79, y: 8.63)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.27, y: 9.29),
            controlPoint1: CGPoint(x: -11.79, y: 9.06),
            controlPoint2: CGPoint(x: -11.56, y: 9.29)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -11.08, y: 9.26),
            controlPoint1: CGPoint(x: -11.21, y: 9.29),
            controlPoint2: CGPoint(x: -11.14, y: 9.28)
        )
        bezier2Path.addLine(to: CGPoint(x: -11.08, y: 9.26))
        bezier2Path.addLine(to: CGPoint(x: -8.35, y: 8.27))
        bezier2Path.addLine(to: CGPoint(x: -8.36, y: 8.27))
        bezier2Path.addCurve(
            to: CGPoint(x: -8.26, y: 8.26),
            controlPoint1: CGPoint(x: -8.33, y: 8.27),
            controlPoint2: CGPoint(x: -8.29, y: 8.26)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.79),
            controlPoint1: CGPoint(x: -7.97, y: 8.26),
            controlPoint2: CGPoint(x: -7.78, y: 8.5)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -7.78, y: 8.99),
            controlPoint1: CGPoint(x: -7.78, y: 8.86),
            controlPoint2: CGPoint(x: -7.78, y: 8.93)
        )
        bezier2Path.addLine(to: CGPoint(x: -7.77, y: 8.98))
        bezier2Path.addLine(to: CGPoint(x: -7.78, y: 10.25))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group 4
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 5.73, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: 6.76, y: -0.41))
        bezier4Path.addLine(to: CGPoint(x: 6.75, y: -0.41))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.91, y: -0.41),
            controlPoint1: CGPoint(x: 6.8, y: -0.41),
            controlPoint2: CGPoint(x: 6.86, y: -0.41)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.9),
            controlPoint1: CGPoint(x: 7.15, y: -0.41),
            controlPoint2: CGPoint(x: 7.34, y: -0.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.34, y: -0.99),
            controlPoint1: CGPoint(x: 7.34, y: -0.93),
            controlPoint2: CGPoint(x: 7.34, y: -0.96)
        )
        bezier4Path.addLine(to: CGPoint(x: 7.34, y: -0.99))
        bezier4Path.addLine(to: CGPoint(x: 6.53, y: -3.72))
        bezier4Path.addLine(to: CGPoint(x: 6.53, y: -3.71))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.5, y: -3.91),
            controlPoint1: CGPoint(x: 6.52, y: -3.77),
            controlPoint2: CGPoint(x: 6.5, y: -3.84)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.92, y: -4.42),
            controlPoint1: CGPoint(x: 6.5, y: -4.19),
            controlPoint2: CGPoint(x: 6.69, y: -4.42)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 7.23, y: -4.26),
            controlPoint1: CGPoint(x: 7.04, y: -4.42),
            controlPoint2: CGPoint(x: 7.15, y: -4.36)
        )
        bezier4Path.addLine(to: CGPoint(x: 7.23, y: -4.26))
        bezier4Path.addLine(to: CGPoint(x: 12.97, y: 1.59))
        bezier4Path.addLine(to: CGPoint(x: 7.18, y: 7.44))
        bezier4Path.addLine(to: CGPoint(x: 7.18, y: 7.43))
        bezier4Path.addCurve(
            to: CGPoint(x: 6.87, y: 7.6),
            controlPoint1: CGPoint(x: 7.1, y: 7.53),
            controlPoint2: CGPoint(x: 6.99, y: 7.6)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.45, y: 7.08),
            controlPoint1: CGPoint(x: 6.64, y: 7.6),
            controlPoint2: CGPoint(x: 6.45, y: 7.37)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.48, y: 6.89),
            controlPoint1: CGPoint(x: 6.45, y: 7.01),
            controlPoint2: CGPoint(x: 6.46, y: 6.95)
        )
        bezier4Path.addLine(to: CGPoint(x: 6.48, y: 6.89))
        bezier4Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier4Path.addLine(to: CGPoint(x: 7.29, y: 4.16))
        bezier4Path.addCurve(
            to: CGPoint(x: 7.29, y: 4.07),
            controlPoint1: CGPoint(x: 7.29, y: 4.14),
            controlPoint2: CGPoint(x: 7.29, y: 4.1)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.86, y: 3.59),
            controlPoint1: CGPoint(x: 7.29, y: 3.78),
            controlPoint2: CGPoint(x: 7.1, y: 3.59)
        )
        bezier4Path.addCurve(
            to: CGPoint(x: 6.7, y: 3.58),
            controlPoint1: CGPoint(x: 6.81, y: 3.59),
            controlPoint2: CGPoint(x: 6.75, y: 3.58)
        )
        bezier4Path.addLine(to: CGPoint(x: 6.71, y: 3.58))
        bezier4Path.addLine(to: CGPoint(x: 5.68, y: 3.59))
        bezier4Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier4Path.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 0.03, y: 12))
        bezier5Path.addLine(to: CGPoint(x: 0.03, y: 7.87))
        bezier5Path.addCurve(
            to: CGPoint(x: 1.63, y: 3.61),
            controlPoint1: CGPoint(x: 0.03, y: 6.23),
            controlPoint2: CGPoint(x: 0.6, y: 4.65)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 5.56, y: 1.61),
            controlPoint1: CGPoint(x: 2.63, y: 2.61),
            controlPoint2: CGPoint(x: 4.01, y: 1.61)
        )
        bezier5Path.addLine(to: CGPoint(x: 7.34, y: 1.61))
        secondaryColor.setStroke()
        bezier5Path.lineWidth = 4
        bezier5Path.stroke()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -2, y: -4, width: 4, height: 16))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 0.02, y: -13))
        bezierPath.addCurve(
            to: CGPoint(x: 5.86, y: -4.87),
            controlPoint1: CGPoint(x: 0.06, y: -12.95),
            controlPoint2: CGPoint(x: 5.74, y: -5.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 6.02, y: -4.49),
            controlPoint1: CGPoint(x: 5.96, y: -4.77),
            controlPoint2: CGPoint(x: 6.02, y: -4.64)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.5, y: -3.97),
            controlPoint1: CGPoint(x: 6.02, y: -4.2),
            controlPoint2: CGPoint(x: 5.79, y: -3.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 5.31, y: -4.01),
            controlPoint1: CGPoint(x: 5.44, y: -3.97),
            controlPoint2: CGPoint(x: 5.37, y: -3.99)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.59, y: -5),
            controlPoint1: CGPoint(x: 5.2, y: -4.05),
            controlPoint2: CGPoint(x: 2.69, y: -4.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -4.48),
            controlPoint1: CGPoint(x: 2.2, y: -5.01),
            controlPoint2: CGPoint(x: 2.01, y: -4.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2, y: -4.28),
            controlPoint1: CGPoint(x: 2.01, y: -4.41),
            controlPoint2: CGPoint(x: 2, y: -4.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 2.01, y: -3.02),
            controlPoint1: CGPoint(x: 2, y: -4.2),
            controlPoint2: CGPoint(x: 2.01, y: -3.02)
        )
        bezierPath.addLine(to: CGPoint(x: -1.99, y: -3.08))
        bezierPath.addCurve(
            to: CGPoint(x: -1.98, y: -4.34),
            controlPoint1: CGPoint(x: -1.99, y: -3.08),
            controlPoint2: CGPoint(x: -1.98, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.99, y: -4.54),
            controlPoint1: CGPoint(x: -1.99, y: -4.41),
            controlPoint2: CGPoint(x: -1.99, y: -4.48)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -2.47, y: -5.07),
            controlPoint1: CGPoint(x: -1.99, y: -4.83),
            controlPoint2: CGPoint(x: -2.18, y: -5.07)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.29, y: -4.07),
            controlPoint1: CGPoint(x: -2.68, y: -5.02),
            controlPoint2: CGPoint(x: -5.18, y: -4.12)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.48, y: -4.04),
            controlPoint1: CGPoint(x: -5.35, y: -4.05),
            controlPoint2: CGPoint(x: -5.42, y: -4.04)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: -4.55),
            controlPoint1: CGPoint(x: -5.77, y: -4.04),
            controlPoint2: CGPoint(x: -6, y: -4.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5.84, y: -4.93),
            controlPoint1: CGPoint(x: -6, y: -4.7),
            controlPoint2: CGPoint(x: -5.94, y: -4.84)
        )
        bezierPath.addCurve(
            to: CGPoint(x: 0.01, y: -13),
            controlPoint1: CGPoint(x: -5.72, y: -5.1),
            controlPoint2: CGPoint(x: -0.03, y: -12.95)
        )
        bezierPath.addLine(to: CGPoint(x: 0.02, y: -13))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrTurnOrUturn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: 3, y: 9.27))
        bezierPath.addLine(to: CGPoint(x: 3, y: 2.12))
        bezierPath.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: 3, y: 0.78),
            controlPoint2: CGPoint(x: 2, y: -3)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6, y: 1.91),
            controlPoint1: CGPoint(x: -6, y: -3),
            controlPoint2: CGPoint(x: -6, y: 1.91)
        )
        bezierPath.addLine(to: CGPoint(x: -6, y: 12))
        secondaryColor.setStroke()
        bezierPath.lineWidth = 4
        bezierPath.stroke()

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.addCurve(
            to: CGPoint(x: 5.01, y: 4.31),
            controlPoint1: CGPoint(x: 5.02, y: 3.05),
            controlPoint2: CGPoint(x: 5.01, y: 4.22)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.02, y: 4.51),
            controlPoint1: CGPoint(x: 5.02, y: 4.37),
            controlPoint2: CGPoint(x: 5.02, y: 4.44)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.5, y: 5.03),
            controlPoint1: CGPoint(x: 5.02, y: 4.8),
            controlPoint2: CGPoint(x: 5.21, y: 5.03)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.32, y: 4.04),
            controlPoint1: CGPoint(x: 5.71, y: 4.99),
            controlPoint2: CGPoint(x: 8.21, y: 4.08)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 8.51, y: 4),
            controlPoint1: CGPoint(x: 8.38, y: 4.02),
            controlPoint2: CGPoint(x: 8.45, y: 4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 9, y: 4.34),
            controlPoint1: CGPoint(x: 8.74, y: 4),
            controlPoint2: CGPoint(x: 8.93, y: 4.15)
        )
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.52))
        bezier2Path.addLine(to: CGPoint(x: 9, y: 4.69))
        bezier2Path.addCurve(
            to: CGPoint(x: 8.87, y: 4.89),
            controlPoint1: CGPoint(x: 8.97, y: 4.77),
            controlPoint2: CGPoint(x: 8.93, y: 4.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 3.02, y: 11.97),
            controlPoint1: CGPoint(x: 8.74, y: 5.05),
            controlPoint2: CGPoint(x: 3.02, y: 11.97)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -0.69, y: 7.44),
            controlPoint1: CGPoint(x: 3.02, y: 11.97),
            controlPoint2: CGPoint(x: 0.98, y: 9.48)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.83, y: 4.84),
            controlPoint1: CGPoint(x: -1.82, y: 6.07),
            controlPoint2: CGPoint(x: -2.77, y: 4.9)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.99, y: 4.46),
            controlPoint1: CGPoint(x: -2.93, y: 4.74),
            controlPoint2: CGPoint(x: -2.99, y: 4.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.47, y: 3.94),
            controlPoint1: CGPoint(x: -2.99, y: 4.17),
            controlPoint2: CGPoint(x: -2.76, y: 3.94)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: -2.28, y: 3.98),
            controlPoint1: CGPoint(x: -2.4, y: 3.94),
            controlPoint2: CGPoint(x: -2.34, y: 3.95)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 0.44, y: 4.97),
            controlPoint1: CGPoint(x: -2.17, y: 4.02),
            controlPoint2: CGPoint(x: 0.34, y: 4.93)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 4.45),
            controlPoint1: CGPoint(x: 0.83, y: 4.97),
            controlPoint2: CGPoint(x: 1.02, y: 4.74)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.03, y: 4.25),
            controlPoint1: CGPoint(x: 1.02, y: 4.38),
            controlPoint2: CGPoint(x: 1.03, y: 4.31)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 1.02, y: 2.99),
            controlPoint1: CGPoint(x: 1.03, y: 4.17),
            controlPoint2: CGPoint(x: 1.02, y: 2.99)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.02, y: 3.05))
        bezier2Path.close()
        secondaryColor.setFill()
        bezier2Path.fill()

        context.restoreGState()

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.addCurve(
            to: CGPoint(x: 6.38, y: -8.84),
            controlPoint1: CGPoint(x: 6.2, y: -9),
            controlPoint2: CGPoint(x: 6.31, y: -8.94)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 12, y: -2.98),
            controlPoint1: CGPoint(x: 6.51, y: -8.71),
            controlPoint2: CGPoint(x: 12, y: -2.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.33, y: 2.86),
            controlPoint1: CGPoint(x: 12, y: -2.98),
            controlPoint2: CGPoint(x: 6.46, y: 2.73)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: 3.02),
            controlPoint1: CGPoint(x: 6.26, y: 2.96),
            controlPoint2: CGPoint(x: 6.15, y: 3.02)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.62, y: 2.5),
            controlPoint1: CGPoint(x: 5.81, y: 3.02),
            controlPoint2: CGPoint(x: 5.62, y: 2.79)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.65, y: 2.31),
            controlPoint1: CGPoint(x: 5.62, y: 2.44),
            controlPoint2: CGPoint(x: 5.63, y: 2.37)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.44, y: -0.41),
            controlPoint1: CGPoint(x: 5.69, y: 2.2),
            controlPoint2: CGPoint(x: 6.41, y: -0.3)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.03, y: -0.99),
            controlPoint1: CGPoint(x: 6.44, y: -0.8),
            controlPoint2: CGPoint(x: 6.26, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.97, y: -0.99),
            controlPoint2: CGPoint(x: 5.92, y: -0.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 4.87, y: -0.99),
            controlPoint1: CGPoint(x: 5.8, y: -1),
            controlPoint2: CGPoint(x: 4.87, y: -0.99)
        )
        bezier3Path.addLine(to: CGPoint(x: 4.91, y: -4.99))
        bezier3Path.addCurve(
            to: CGPoint(x: 5.92, y: -4.98),
            controlPoint1: CGPoint(x: 4.91, y: -4.99),
            controlPoint2: CGPoint(x: 5.85, y: -4.98)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.07, y: -4.99),
            controlPoint1: CGPoint(x: 5.97, y: -4.99),
            controlPoint2: CGPoint(x: 6.02, y: -4.99)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.49, y: -5.47),
            controlPoint1: CGPoint(x: 6.31, y: -4.99),
            controlPoint2: CGPoint(x: 6.49, y: -5.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.7, y: -8.29),
            controlPoint1: CGPoint(x: 6.46, y: -5.68),
            controlPoint2: CGPoint(x: 5.74, y: -8.18)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 5.67, y: -8.48),
            controlPoint1: CGPoint(x: 5.68, y: -8.35),
            controlPoint2: CGPoint(x: 5.67, y: -8.42)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: 6.08, y: -9),
            controlPoint1: CGPoint(x: 5.67, y: -8.77),
            controlPoint2: CGPoint(x: 5.85, y: -9)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.13, y: -9))
        bezier3Path.close()
        secondaryColor.setFill()
        bezier3Path.fill()

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: -6, y: 12))
        bezier4Path.addLine(to: CGPoint(x: -6, y: 2))
        bezier4Path.addCurve(
            to: CGPoint(x: -2, y: -3),
            controlPoint1: CGPoint(x: -6, y: 2),
            controlPoint2: CGPoint(x: -6, y: -3)
        )
        bezier4Path.addLine(to: CGPoint(x: 6, y: -3))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.stroke()

        context.restoreGState()

        //// Group 5
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -8, y: -6, width: 4, height: 18))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier 5 Drawing
        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.addCurve(
            to: CGPoint(x: -0.14, y: -6.48),
            controlPoint1: CGPoint(x: -5.94, y: -12.96),
            controlPoint2: CGPoint(x: -0.26, y: -6.62)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.02, y: -6.18),
            controlPoint1: CGPoint(x: -0.04, y: -6.4),
            controlPoint2: CGPoint(x: 0.02, y: -6.3)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.5, y: -5.77),
            controlPoint1: CGPoint(x: 0.02, y: -5.95),
            controlPoint2: CGPoint(x: -0.21, y: -5.77)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0.69, y: -5.79),
            controlPoint1: CGPoint(x: -0.56, y: -5.77),
            controlPoint2: CGPoint(x: -0.63, y: -5.78)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.41, y: -6.59),
            controlPoint1: CGPoint(x: -0.8, y: -5.83),
            controlPoint2: CGPoint(x: -3.31, y: -6.56)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -6.17),
            controlPoint1: CGPoint(x: -3.8, y: -6.59),
            controlPoint2: CGPoint(x: -3.99, y: -6.4)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -4, y: -6.01),
            controlPoint1: CGPoint(x: -3.99, y: -6.12),
            controlPoint2: CGPoint(x: -4, y: -6.06)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -3.99, y: -5),
            controlPoint1: CGPoint(x: -4, y: -5.95),
            controlPoint2: CGPoint(x: -3.99, y: -5)
        )
        bezier5Path.addLine(to: CGPoint(x: -7.99, y: -5.05))
        bezier5Path.addCurve(
            to: CGPoint(x: -7.98, y: -6.06),
            controlPoint1: CGPoint(x: -7.99, y: -5.05),
            controlPoint2: CGPoint(x: -7.98, y: -5.99)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -7.99, y: -6.22),
            controlPoint1: CGPoint(x: -7.99, y: -6.11),
            controlPoint2: CGPoint(x: -7.99, y: -6.17)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -8.47, y: -6.64),
            controlPoint1: CGPoint(x: -7.99, y: -6.45),
            controlPoint2: CGPoint(x: -8.18, y: -6.64)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.29, y: -5.85),
            controlPoint1: CGPoint(x: -8.68, y: -6.61),
            controlPoint2: CGPoint(x: -11.18, y: -5.88)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.48, y: -5.81),
            controlPoint1: CGPoint(x: -11.35, y: -5.83),
            controlPoint2: CGPoint(x: -11.42, y: -5.81)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -12, y: -6.22),
            controlPoint1: CGPoint(x: -11.77, y: -5.81),
            controlPoint2: CGPoint(x: -12, y: -6)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -11.84, y: -6.53),
            controlPoint1: CGPoint(x: -12, y: -6.35),
            controlPoint2: CGPoint(x: -11.94, y: -6.46)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -5.99, y: -13),
            controlPoint1: CGPoint(x: -11.72, y: -6.67),
            controlPoint2: CGPoint(x: -6.03, y: -12.96)
        )
        bezier5Path.addLine(to: CGPoint(x: -5.98, y: -13))
        bezier5Path.close()
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc
    public dynamic class func drawLaneStraightOrSlightTurnOrTurn(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 30, height: 30),
        resizing: ResizingBehavior = .aspectFit,
        secondaryColor: UIColor = UIColor(red: 0.618, green: 0.618, blue: 0.618, alpha: 1.000),
        size: CGSize = CGSize(width: 32, height: 32),
        flipHorizontally: Bool = false
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 30, height: 30), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 30, y: resizedFrame.height / 30)

        //// Variable Declarations
        let scaleX: CGFloat = flipHorizontally ? -1 : 1

        //// Frames
        let frame = CGRect(x: 0, y: 0, width: size.width - 2, height: size.height - 2)

        //// Group 2
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 2 Drawing
        let bezier2Path = UIBezierPath()
        bezier2Path.move(to: CGPoint(x: 5.05, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addLine(to: CGPoint(x: 6.31, y: 1.59))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.51, y: 1.59),
            controlPoint1: CGPoint(x: 6.37, y: 1.59),
            controlPoint2: CGPoint(x: 6.44, y: 1.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.1),
            controlPoint1: CGPoint(x: 6.8, y: 1.59),
            controlPoint2: CGPoint(x: 7.03, y: 1.4)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 7.03, y: 1.01),
            controlPoint1: CGPoint(x: 7.03, y: 1.07),
            controlPoint2: CGPoint(x: 7.03, y: 1.04)
        )
        bezier2Path.addLine(to: CGPoint(x: 7.03, y: 1.01))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.72))
        bezier2Path.addLine(to: CGPoint(x: 6.04, y: -1.71))
        bezier2Path.addCurve(
            to: CGPoint(x: 6, y: -1.91),
            controlPoint1: CGPoint(x: 6.02, y: -1.77),
            controlPoint2: CGPoint(x: 6, y: -1.84)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.52, y: -2.42),
            controlPoint1: CGPoint(x: 6, y: -2.19),
            controlPoint2: CGPoint(x: 6.23, y: -2.42)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.9, y: -2.26),
            controlPoint1: CGPoint(x: 6.67, y: -2.42),
            controlPoint2: CGPoint(x: 6.8, y: -2.36)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.9, y: -2.26))
        bezier2Path.addLine(to: CGPoint(x: 13.97, y: 3.59))
        bezier2Path.addLine(to: CGPoint(x: 6.83, y: 9.44))
        bezier2Path.addLine(to: CGPoint(x: 6.84, y: 9.43))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.46, y: 9.6),
            controlPoint1: CGPoint(x: 6.74, y: 9.53),
            controlPoint2: CGPoint(x: 6.6, y: 9.6)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.94, y: 9.08),
            controlPoint1: CGPoint(x: 6.17, y: 9.6),
            controlPoint2: CGPoint(x: 5.94, y: 9.37)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 5.98, y: 8.89),
            controlPoint1: CGPoint(x: 5.94, y: 9.01),
            controlPoint2: CGPoint(x: 5.95, y: 8.95)
        )
        bezier2Path.addLine(to: CGPoint(x: 5.98, y: 8.89))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addLine(to: CGPoint(x: 6.97, y: 6.16))
        bezier2Path.addCurve(
            to: CGPoint(x: 6.97, y: 6.07),
            controlPoint1: CGPoint(x: 6.97, y: 6.14),
            controlPoint2: CGPoint(x: 6.97, y: 6.1)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.45, y: 5.59),
            controlPoint1: CGPoint(x: 6.97, y: 5.78),
            controlPoint2: CGPoint(x: 6.74, y: 5.59)
        )
        bezier2Path.addCurve(
            to: CGPoint(x: 6.25, y: 5.58),
            controlPoint1: CGPoint(x: 6.38, y: 5.59),
            controlPoint2: CGPoint(x: 6.31, y: 5.58)
        )
        bezier2Path.addLine(to: CGPoint(x: 6.25, y: 5.58))
        bezier2Path.addLine(to: CGPoint(x: 4.99, y: 5.59))
        bezier2Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier2Path.fill()

        //// Bezier 3 Drawing
        let bezier3Path = UIBezierPath()
        bezier3Path.move(to: CGPoint(x: -6.97, y: 12))
        bezier3Path.addLine(to: CGPoint(x: -6.97, y: 9.87))
        bezier3Path.addCurve(
            to: CGPoint(x: -5, y: 5.61),
            controlPoint1: CGPoint(x: -6.97, y: 8.23),
            controlPoint2: CGPoint(x: -6.27, y: 6.65)
        )
        bezier3Path.addCurve(
            to: CGPoint(x: -0.16, y: 3.61),
            controlPoint1: CGPoint(x: -3.77, y: 4.61),
            controlPoint2: CGPoint(x: -2.07, y: 3.61)
        )
        bezier3Path.addLine(to: CGPoint(x: 6.03, y: 3.61))
        secondaryColor.setStroke()
        bezier3Path.lineWidth = 4
        bezier3Path.stroke()

        context.restoreGState()

        //// Group 3
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Bezier 4 Drawing
        let bezier4Path = UIBezierPath()
        bezier4Path.move(to: CGPoint(x: 2.15, y: -6.97))
        bezier4Path.addLine(to: CGPoint(x: -1, y: -4))
        bezier4Path.addCurve(
            to: CGPoint(x: -7, y: 7),
            controlPoint1: CGPoint(x: -4, y: -1),
            controlPoint2: CGPoint(x: -7, y: 5.35)
        )
        bezier4Path.addLine(to: CGPoint(x: -7.02, y: 12.02))
        secondaryColor.setStroke()
        bezier4Path.lineWidth = 4
        bezier4Path.lineJoinStyle = .round
        bezier4Path.stroke()

        //// Bezier 5 Drawing
        context.saveGState()
        context.translateBy(x: 5.23, y: -17.58)
        context.rotate(by: 49 * CGFloat.pi / 180)

        let bezier5Path = UIBezierPath()
        bezier5Path.move(to: CGPoint(x: 4.01, y: 9.92))
        bezier5Path.addLine(to: CGPoint(x: 4.02, y: 8.66))
        bezier5Path.addLine(to: CGPoint(x: 4.01, y: 8.66))
        bezier5Path.addCurve(
            to: CGPoint(x: 4.01, y: 8.46),
            controlPoint1: CGPoint(x: 4.01, y: 8.6),
            controlPoint2: CGPoint(x: 4.01, y: 8.53)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.53, y: 7.94),
            controlPoint1: CGPoint(x: 4.01, y: 8.17),
            controlPoint2: CGPoint(x: 3.82, y: 7.94)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 3.43, y: 7.94),
            controlPoint1: CGPoint(x: 3.5, y: 7.94),
            controlPoint2: CGPoint(x: 3.46, y: 7.94)
        )
        bezier5Path.addLine(to: CGPoint(x: 3.44, y: 7.94))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addLine(to: CGPoint(x: 0.71, y: 8.93))
        bezier5Path.addCurve(
            to: CGPoint(x: 0.52, y: 8.97),
            controlPoint1: CGPoint(x: 0.65, y: 8.96),
            controlPoint2: CGPoint(x: 0.58, y: 8.97)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: -0, y: 8.45),
            controlPoint1: CGPoint(x: 0.23, y: 8.97),
            controlPoint2: CGPoint(x: -0, y: 8.74)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 0.16, y: 8.07),
            controlPoint1: CGPoint(x: -0, y: 8.3),
            controlPoint2: CGPoint(x: 0.06, y: 8.17)
        )
        bezier5Path.addLine(to: CGPoint(x: 0.16, y: 8.08))
        bezier5Path.addLine(to: CGPoint(x: 6.01, y: 0))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addLine(to: CGPoint(x: 11.86, y: 8.14))
        bezier5Path.addCurve(
            to: CGPoint(x: 12.02, y: 8.52),
            controlPoint1: CGPoint(x: 11.96, y: 8.23),
            controlPoint2: CGPoint(x: 12.02, y: 8.37)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.5, y: 9.03),
            controlPoint1: CGPoint(x: 12.02, y: 8.8),
            controlPoint2: CGPoint(x: 11.79, y: 9.03)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 11.31, y: 8.99),
            controlPoint1: CGPoint(x: 11.43, y: 9.03),
            controlPoint2: CGPoint(x: 11.37, y: 9.02)
        )
        bezier5Path.addLine(to: CGPoint(x: 11.31, y: 8.99))
        bezier5Path.addLine(to: CGPoint(x: 8.58, y: 8))
        bezier5Path.addLine(to: CGPoint(x: 8.59, y: 8.01))
        bezier5Path.addCurve(
            to: CGPoint(x: 8.49, y: 8),
            controlPoint1: CGPoint(x: 8.56, y: 8),
            controlPoint2: CGPoint(x: 8.52, y: 8)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8.01, y: 8.53),
            controlPoint1: CGPoint(x: 8.2, y: 8),
            controlPoint2: CGPoint(x: 8.01, y: 8.23)
        )
        bezier5Path.addCurve(
            to: CGPoint(x: 8, y: 8.73),
            controlPoint1: CGPoint(x: 8.01, y: 8.59),
            controlPoint2: CGPoint(x: 8, y: 8.66)
        )
        bezier5Path.addLine(to: CGPoint(x: 8, y: 8.72))
        bezier5Path.addLine(to: CGPoint(x: 8.01, y: 9.99))
        bezier5Path.usesEvenOddFillRule = true
        secondaryColor.setFill()
        bezier5Path.fill()

        context.restoreGState()

        context.restoreGState()

        //// Group
        context.saveGState()
        context.translateBy(x: frame.minX + 15, y: frame.minY + 15)
        context.scaleBy(x: scaleX, y: 1)

        //// Rectangle Drawing
        let rectanglePath = UIBezierPath(rect: CGRect(x: -9, y: -4.42, width: 4, height: 16.42))
        secondaryColor.setFill()
        rectanglePath.fill()

        //// Bezier Drawing
        let bezierPath = UIBezierPath()
        bezierPath.move(to: CGPoint(x: -6.98, y: -14))
        bezierPath.addCurve(
            to: CGPoint(x: -1.14, y: -5.87),
            controlPoint1: CGPoint(x: -6.94, y: -13.94),
            controlPoint2: CGPoint(x: -1.26, y: -6.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -0.98, y: -5.48),
            controlPoint1: CGPoint(x: -1.04, y: -5.77),
            controlPoint2: CGPoint(x: -0.98, y: -5.63)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.5, y: -4.97),
            controlPoint1: CGPoint(x: -0.98, y: -5.2),
            controlPoint2: CGPoint(x: -1.21, y: -4.97)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -1.69, y: -5.01),
            controlPoint1: CGPoint(x: -1.56, y: -4.97),
            controlPoint2: CGPoint(x: -1.63, y: -4.98)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.41, y: -6),
            controlPoint1: CGPoint(x: -1.8, y: -5.05),
            controlPoint2: CGPoint(x: -4.31, y: -5.96)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -5.48),
            controlPoint1: CGPoint(x: -4.8, y: -6),
            controlPoint2: CGPoint(x: -4.99, y: -5.77)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -5, y: -5.28),
            controlPoint1: CGPoint(x: -4.99, y: -5.41),
            controlPoint2: CGPoint(x: -5, y: -5.34)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -4.99, y: -4.01),
            controlPoint1: CGPoint(x: -5, y: -5.2),
            controlPoint2: CGPoint(x: -4.99, y: -4.01)
        )
        bezierPath.addLine(to: CGPoint(x: -8.99, y: -4.08))
        bezierPath.addCurve(
            to: CGPoint(x: -8.98, y: -5.34),
            controlPoint1: CGPoint(x: -8.99, y: -4.08),
            controlPoint2: CGPoint(x: -8.98, y: -5.25)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -8.99, y: -5.54),
            controlPoint1: CGPoint(x: -8.99, y: -5.4),
            controlPoint2: CGPoint(x: -8.99, y: -5.47)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -9.47, y: -6.06),
            controlPoint1: CGPoint(x: -8.99, y: -5.83),
            controlPoint2: CGPoint(x: -9.18, y: -6.06)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.29, y: -5.07),
            controlPoint1: CGPoint(x: -9.68, y: -6.02),
            controlPoint2: CGPoint(x: -12.18, y: -5.11)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.48, y: -5.03),
            controlPoint1: CGPoint(x: -12.35, y: -5.04),
            controlPoint2: CGPoint(x: -12.42, y: -5.03)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -13, y: -5.54),
            controlPoint1: CGPoint(x: -12.77, y: -5.03),
            controlPoint2: CGPoint(x: -13, y: -5.26)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -12.84, y: -5.92),
            controlPoint1: CGPoint(x: -13, y: -5.7),
            controlPoint2: CGPoint(x: -12.94, y: -5.83)
        )
        bezierPath.addCurve(
            to: CGPoint(x: -6.99, y: -14),
            controlPoint1: CGPoint(x: -12.72, y: -6.1),
            controlPoint2: CGPoint(x: -7.03, y: -13.94)
        )
        bezierPath.addLine(to: CGPoint(x: -6.98, y: -14))
        bezierPath.close()
        secondaryColor.setFill()
        bezierPath.fill()

        context.restoreGState()

        context.restoreGState()
    }

    @objc(LanesStyleKitResizingBehavior)
    public enum ResizingBehavior: Int {
        case aspectFit /// The content is proportionally resized to fit into the target rectangle.
        case aspectFill /// The content is proportionally resized to completely fill the target rectangle.
        case stretch /// The content is stretched to match the entire target rectangle.
        case center /// The content is centered in the target rectangle, but it is NOT resized.

        public func apply(rect: CGRect, target: CGRect) -> CGRect {
            if rect == target || target == CGRect.zero {
                return rect
            }

            var scales = CGSize.zero
            scales.width = abs(target.width / rect.width)
            scales.height = abs(target.height / rect.height)

            switch self {
            case .aspectFit:
                scales.width = min(scales.width, scales.height)
                scales.height = scales.width
            case .aspectFill:
                scales.width = max(scales.width, scales.height)
                scales.height = scales.width
            case .stretch:
                break
            case .center:
                scales.width = 1
                scales.height = 1
            }

            var result = rect.standardized
            result.size.width *= scales.width
            result.size.height *= scales.height
            result.origin.x = target.minX + (target.width - result.width) / 2
            result.origin.y = target.minY + (target.height - result.height) / 2
            return result
        }
    }
}
