//
//  UserPuckStyleKit.swift
//  MapboxNavigation
//
//  Created on 2017-10-11.
//  Copyright © 2017 Mapbox. All rights reserved.
//
//  Generated by PaintCode
//  http://www.paintcodeapp.com
//

import UIKit

class UserPuckStyleKit: NSObject {
    //// Drawing Methods

    @objc
    dynamic class func drawNavigationPuck(
        frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 75, height: 75),
        resizing: ResizingBehavior = .aspectFit,
        fillColor: UIColor = UIColor(red: 1.000, green: 1.000, blue: 1.000, alpha: 1.000),
        puckColor: UIColor = UIColor(red: 0.149, green: 0.239, blue: 0.341, alpha: 1.000),
        shadowColor: UIColor = UIColor(red: 0.149, green: 0.239, blue: 0.341, alpha: 0.160),
        circleColor: UIColor = UIColor(red: 1.000, green: 1.000, blue: 1.000, alpha: 1.000)
    ) {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!

        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 75, height: 75), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 75, y: resizedFrame.height / 75)

        //// Canvas 2
        //// navigation_pluck
        //// Oval 7
        //// path0_fill Drawing
        let path0_fillPath = UIBezierPath(ovalIn: CGRect(x: 9, y: 9, width: 57, height: 57))
        fillColor.setFill()
        path0_fillPath.fill()

        //// Group 4
        //// path1_stroke_2x Drawing
        let path1_stroke_2xPath = UIBezierPath()
        path1_stroke_2xPath.move(to: CGPoint(x: 37.5, y: 75))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 75, y: 37.5),
            controlPoint1: CGPoint(x: 58.21, y: 75),
            controlPoint2: CGPoint(x: 75, y: 58.21)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 57, y: 37.5))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 37.5, y: 57),
            controlPoint1: CGPoint(x: 57, y: 48.27),
            controlPoint2: CGPoint(x: 48.27, y: 57)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 37.5, y: 75))
        path1_stroke_2xPath.close()
        path1_stroke_2xPath.move(to: CGPoint(x: 75, y: 37.5))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 37.5, y: 0),
            controlPoint1: CGPoint(x: 75, y: 16.79),
            controlPoint2: CGPoint(x: 58.21, y: 0)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 37.5, y: 18))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 57, y: 37.5),
            controlPoint1: CGPoint(x: 48.27, y: 18),
            controlPoint2: CGPoint(x: 57, y: 26.73)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 75, y: 37.5))
        path1_stroke_2xPath.close()
        path1_stroke_2xPath.move(to: CGPoint(x: 37.5, y: 0))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 0, y: 37.5),
            controlPoint1: CGPoint(x: 16.79, y: 0),
            controlPoint2: CGPoint(x: 0, y: 16.79)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 18, y: 37.5))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 37.5, y: 18),
            controlPoint1: CGPoint(x: 18, y: 26.73),
            controlPoint2: CGPoint(x: 26.73, y: 18)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 37.5, y: 0))
        path1_stroke_2xPath.close()
        path1_stroke_2xPath.move(to: CGPoint(x: 0, y: 37.5))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 37.5, y: 75),
            controlPoint1: CGPoint(x: 0, y: 58.21),
            controlPoint2: CGPoint(x: 16.79, y: 75)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 37.5, y: 57))
        path1_stroke_2xPath.addCurve(
            to: CGPoint(x: 18, y: 37.5),
            controlPoint1: CGPoint(x: 26.73, y: 57),
            controlPoint2: CGPoint(x: 18, y: 48.27)
        )
        path1_stroke_2xPath.addLine(to: CGPoint(x: 0, y: 37.5))
        path1_stroke_2xPath.close()
        shadowColor.setFill()
        path1_stroke_2xPath.fill()

        //// path0_fill 2 Drawing
        let path0_fill2Path = UIBezierPath(ovalIn: CGRect(x: 9, y: 9, width: 57, height: 57))
        circleColor.setFill()
        path0_fill2Path.fill()

        //// Page 1
        //// Fill 1
        //// path3_fill Drawing
        let path3_fillPath = UIBezierPath()
        path3_fillPath.move(to: CGPoint(x: 39.2, y: 28.46))
        path3_fillPath.addCurve(
            to: CGPoint(x: 38.02, y: 27.69),
            controlPoint1: CGPoint(x: 39, y: 27.99),
            controlPoint2: CGPoint(x: 38.54, y: 27.68)
        )
        path3_fillPath.addCurve(
            to: CGPoint(x: 36.8, y: 28.49),
            controlPoint1: CGPoint(x: 37.5, y: 27.7),
            controlPoint2: CGPoint(x: 37.02, y: 28.01)
        )
        path3_fillPath.addLine(to: CGPoint(x: 27.05, y: 45.83))
        path3_fillPath.addCurve(
            to: CGPoint(x: 27.28, y: 47.26),
            controlPoint1: CGPoint(x: 26.83, y: 46.32),
            controlPoint2: CGPoint(x: 26.92, y: 46.89)
        )
        path3_fillPath.addCurve(
            to: CGPoint(x: 28.71, y: 47.54),
            controlPoint1: CGPoint(x: 27.65, y: 47.64),
            controlPoint2: CGPoint(x: 28.21, y: 47.75)
        )
        path3_fillPath.addLine(to: CGPoint(x: 37.07, y: 44.03))
        path3_fillPath.addCurve(
            to: CGPoint(x: 38.06, y: 44.02),
            controlPoint1: CGPoint(x: 37.39, y: 43.89),
            controlPoint2: CGPoint(x: 37.75, y: 43.89)
        )
        path3_fillPath.addLine(to: CGPoint(x: 46.26, y: 47.34))
        path3_fillPath.addCurve(
            to: CGPoint(x: 47.71, y: 47.03),
            controlPoint1: CGPoint(x: 46.75, y: 47.54),
            controlPoint2: CGPoint(x: 47.32, y: 47.42)
        )
        path3_fillPath.addCurve(
            to: CGPoint(x: 48, y: 45.59),
            controlPoint1: CGPoint(x: 48.09, y: 46.64),
            controlPoint2: CGPoint(x: 48.2, y: 46.07)
        )
        path3_fillPath.addLine(to: CGPoint(x: 39.2, y: 28.46))
        path3_fillPath.close()
        path3_fillPath.usesEvenOddFillRule = true
        puckColor.setFill()
        path3_fillPath.fill()

        context.restoreGState()
    }

    @objc(UserPuckStyleKitResizingBehavior)
    enum ResizingBehavior: Int {
        case aspectFit /// The content is proportionally resized to fit into the target rectangle.
        case aspectFill /// The content is proportionally resized to completely fill the target rectangle.
        case stretch /// The content is stretched to match the entire target rectangle.
        case center /// The content is centered in the target rectangle, but it is NOT resized.

        public func apply(rect: CGRect, target: CGRect) -> CGRect {
            if rect == target || target == CGRect.zero {
                return rect
            }

            var scales = CGSize.zero
            scales.width = abs(target.width / rect.width)
            scales.height = abs(target.height / rect.height)

            switch self {
            case .aspectFit:
                scales.width = min(scales.width, scales.height)
                scales.height = scales.width
            case .aspectFill:
                scales.width = max(scales.width, scales.height)
                scales.height = scales.width
            case .stretch:
                break
            case .center:
                scales.width = 1
                scales.height = 1
            }

            var result = rect.standardized
            result.size.width *= scales.width
            result.size.height *= scales.height
            result.origin.x = target.minX + (target.width - result.width) / 2
            result.origin.y = target.minY + (target.height - result.height) / 2
            return result
        }
    }
}
