//
//  SpeedLimitStyleKit.swift
//  MapboxNavigation
//
//  Created on 2019-12-26.
//  Copyright © 2019 Mapbox. All rights reserved.
//
//  Generated by PaintCode
//  http://www.paintcodeapp.com
//



import UIKit

public class SpeedLimitStyleKit : NSObject {

    //// Drawing Methods

    @objc dynamic public class func drawMUTCD(frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 56, height: 66), resizing: ResizingBehavior = .aspectFit, signBackColor: UIColor = UIColor(red: 1.000, green: 1.000, blue: 1.000, alpha: 1.000), strokeColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000), limit: String = "50", legend: String = "MAX") {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!
        
        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 56, height: 66), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 56, y: resizedFrame.height / 66)



        //// Variable Declarations
        let limitFontSize: CGFloat = CGFloat(limit.count) > 2 ? 24 : 32

        //// Sign
        //// Sign Back Drawing
        let signBackPath = UIBezierPath(roundedRect: CGRect(x: 3, y: 3, width: 50, height: 60), cornerRadius: 4)
        signBackColor.setFill()
        signBackPath.fill()
        signBackColor.setStroke()
        signBackPath.lineWidth = 4
        signBackPath.lineJoinStyle = .bevel
        signBackPath.stroke()


        //// Border Drawing
        let borderPath = UIBezierPath(roundedRect: CGRect(x: 3, y: 3, width: 50, height: 60), cornerRadius: 4)
        strokeColor.setStroke()
        borderPath.lineWidth = 2
        borderPath.lineJoinStyle = .bevel
        borderPath.stroke()




        //// Group
        //// Limit Label Drawing
        let limitLabelRect = CGRect(x: 3, y: 28, width: 50, height: 35)
        let limitLabelStyle = NSMutableParagraphStyle()
        limitLabelStyle.alignment = .center
        let limitLabelFontAttributes = [
            .font: UIFont.systemFont(ofSize: limitFontSize, weight: .bold),
            .foregroundColor: strokeColor,
            .paragraphStyle: limitLabelStyle,
        ] as [NSAttributedString.Key: Any]

        let limitLabelTextHeight: CGFloat = limit.boundingRect(with: CGSize(width: limitLabelRect.width, height: CGFloat.infinity), options: .usesLineFragmentOrigin, attributes: limitLabelFontAttributes, context: nil).height
        context.saveGState()
        context.clip(to: limitLabelRect)
        limit.draw(in: CGRect(x: limitLabelRect.minX, y: limitLabelRect.minY + (limitLabelRect.height - limitLabelTextHeight) / 2, width: limitLabelRect.width, height: limitLabelTextHeight), withAttributes: limitLabelFontAttributes)
        context.restoreGState()


        //// Legend Label Drawing
        let legendLabelRect = CGRect(x: 3, y: 3, width: 50, height: 25)
        let legendLabelStyle = NSMutableParagraphStyle()
        legendLabelStyle.alignment = .center
        let legendLabelFontAttributes = [
            .font: UIFont.boldSystemFont(ofSize: UIFont.labelFontSize),
            .foregroundColor: strokeColor,
            .paragraphStyle: legendLabelStyle,
        ] as [NSAttributedString.Key: Any]

        let legendLabelTextHeight: CGFloat = legend.boundingRect(with: CGSize(width: legendLabelRect.width, height: CGFloat.infinity), options: .usesLineFragmentOrigin, attributes: legendLabelFontAttributes, context: nil).height
        context.saveGState()
        context.clip(to: legendLabelRect)
        legend.draw(in: CGRect(x: legendLabelRect.minX, y: legendLabelRect.minY + legendLabelRect.height - legendLabelTextHeight, width: legendLabelRect.width, height: legendLabelTextHeight), withAttributes: legendLabelFontAttributes)
        context.restoreGState()
        
        context.restoreGState()

    }

    @objc dynamic public class func drawVienna(frame targetFrame: CGRect = CGRect(x: 0, y: 0, width: 70, height: 70), resizing: ResizingBehavior = .aspectFit, signBackColor: UIColor = UIColor(red: 1.000, green: 1.000, blue: 1.000, alpha: 1.000), strokeColor: UIColor = UIColor(red: 0.000, green: 0.000, blue: 0.000, alpha: 1.000), regulatoryColor: UIColor = UIColor(red: 0.800, green: 0.000, blue: 0.000, alpha: 1.000), limit: String = "50") {
        //// General Declarations
        let context = UIGraphicsGetCurrentContext()!
        
        //// Resize to Target Frame
        context.saveGState()
        let resizedFrame: CGRect = resizing.apply(rect: CGRect(x: 0, y: 0, width: 70, height: 70), target: targetFrame)
        context.translateBy(x: resizedFrame.minX, y: resizedFrame.minY)
        context.scaleBy(x: resizedFrame.width / 70, y: resizedFrame.height / 70)



        //// Variable Declarations
        let limitFontSize: CGFloat = CGFloat(limit.count) > 2 ? 24 : 32

        //// Sign Back Drawing
        let signBackPath = UIBezierPath(ovalIn: CGRect(x: 5, y: 5, width: 60, height: 60))
        signBackColor.setFill()
        signBackPath.fill()
        signBackColor.setStroke()
        signBackPath.lineWidth = 8
        signBackPath.stroke()


        //// Inscription Drawing
        let inscriptionRect = CGRect(x: 5, y: 5, width: 60, height: 60)
        let inscriptionPath = UIBezierPath(ovalIn: inscriptionRect)
        regulatoryColor.setStroke()
        inscriptionPath.lineWidth = 6
        inscriptionPath.stroke()
        let inscriptionStyle = NSMutableParagraphStyle()
        inscriptionStyle.alignment = .center
        let inscriptionFontAttributes = [
            .font: UIFont.systemFont(ofSize: limitFontSize, weight: .bold),
            .foregroundColor: strokeColor,
            .paragraphStyle: inscriptionStyle,
        ] as [NSAttributedString.Key: Any]

        let inscriptionTextHeight: CGFloat = limit.boundingRect(with: CGSize(width: inscriptionRect.width, height: CGFloat.infinity), options: .usesLineFragmentOrigin, attributes: inscriptionFontAttributes, context: nil).height
        context.saveGState()
        context.clip(to: inscriptionRect)
        limit.draw(in: CGRect(x: inscriptionRect.minX, y: inscriptionRect.minY + (inscriptionRect.height - inscriptionTextHeight) / 2, width: inscriptionRect.width, height: inscriptionTextHeight), withAttributes: inscriptionFontAttributes)
        context.restoreGState()
        
        context.restoreGState()

    }




    @objc(SpeedLimitStyleKitResizingBehavior)
    public enum ResizingBehavior: Int {
        case aspectFit /// The content is proportionally resized to fit into the target rectangle.
        case aspectFill /// The content is proportionally resized to completely fill the target rectangle.
        case stretch /// The content is stretched to match the entire target rectangle.
        case center /// The content is centered in the target rectangle, but it is NOT resized.

        public func apply(rect: CGRect, target: CGRect) -> CGRect {
            if rect == target || target == CGRect.zero {
                return rect
            }

            var scales = CGSize.zero
            scales.width = abs(target.width / rect.width)
            scales.height = abs(target.height / rect.height)

            switch self {
                case .aspectFit:
                    scales.width = min(scales.width, scales.height)
                    scales.height = scales.width
                case .aspectFill:
                    scales.width = max(scales.width, scales.height)
                    scales.height = scales.width
                case .stretch:
                    break
                case .center:
                    scales.width = 1
                    scales.height = 1
            }

            var result = rect.standardized
            result.size.width *= scales.width
            result.size.height *= scales.height
            result.origin.x = target.minX + (target.width - result.width) / 2
            result.origin.y = target.minY + (target.height - result.height) / 2
            return result
        }
    }
}
