# Contributing

We welcome contributions to this project.

If you have a usage question about the Mapbox Maps SDK for iOS, please visit https://www.mapbox.com/help/.

If you'd like to contribute code:

1. Please familiarize yourself with the [install process](README.md), the [development process](DEVELOPING.md), and the contributor license agreement (CLA) at the bottom of this document. All contributions to the project must reflect its development standards and be offered under the terms of the CLA.

2. Ensure that existing [pull requests](https://github.com/mapbox/mapbox-maps-ios/pulls) and [issues](https://github.com/mapbox/mapbox-maps-ios/issues) don’t already cover your contribution or question. If your planned contribution involves significant changes to the SDK, consider opening a new issue to discuss your design before beginning work.

3. Pull requests are gladly accepted. If your PR makes changes to the SDK that developers should be aware of, please be sure to update [CHANGELOG.md](CHANGELOG.md)

4. Prefix your commit messages with the relavent labels that your changes affect: `[sdk]`, `[gestures]`, `[telemetry]`, `[animation]`, `[location]`, ...

### GitHub issue labels

Our labeling system is:

 * **minimalistic:** Labels’ usefulness are inversely proportional to how many we have.
 * **objective:** Labels should be objective enough that any two people would agree on a labeling decision.
 * **useful:** Labels should track state or capture semantic meaning that would otherwise be hard to search for.

# Contributor License Agreement

Thank you for contributing to the Mapbox Maps SDK for iOS ("the SDK")! This Contributor License Agreement (“Agreement”) sets out the terms governing any source code, object code, bug fixes, configuration changes, tools, specifications, documentation, data, materials, feedback, information or other works of authorship that you submit, beginning January 25, 2021, in any form and in any manner, to the SDK (https://github.com/mapbox/mapbox-maps-ios) (collectively “Contributions”).

You agree that the following terms apply to all of your Contributions beginning January 25, 2021. Except for the licenses you grant under this Agreement, you retain all of your right, title and interest in and to your Contributions.

**Disclaimer.** To the fullest extent permitted under applicable law, you provide your Contributions on an "as-is" basis, without any warranties or conditions, express or implied, including, without limitation, any implied warranties or conditions of non-infringement, merchantability or fitness for a particular purpose. You have no obligation to provide support for your Contributions, but you may offer support to the extent you desire.


**Copyright License.** You hereby grant, and agree to grant, to Mapbox, Inc. (“Mapbox”) a non-exclusive, perpetual, irrevocable, worldwide, fully-paid, royalty-free, transferable copyright license to reproduce, prepare derivative works of, publicly display, publicly perform, and distribute your Contributions and such derivative works, with the right to sublicense the foregoing rights through multiple tiers of sublicensees.


**Patent License.** To the extent you have or will have patent rights to grant, you hereby grant, and agree to grant, to Mapbox a non-exclusive, perpetual, irrevocable, worldwide, fully-paid, royalty-free, transferable patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer your Contributions, for any patent claims infringed by your Contributions alone or by combination of your Contributions with the SDK, with the right to sublicense these rights through multiple tiers of sublicensees.


**Moral Rights.** To the fullest extent permitted under applicable law, you hereby waive, and agree not to assert, all of your “moral rights” in or relating to your Contributions for the benefit of Mapbox, its assigns, and their respective direct and indirect sublicensees.


**Third Party Content/Rights.** If your Contribution includes or is based on any source code, object code, bug fixes, configuration changes, tools, specifications, documentation, data, materials, feedback, information, or other works of authorship that you did not author (“Third Party Content”), or if you are aware of any third party intellectual property or proprietary rights in your Contribution (“Third Party Rights”), then you agree to include with the submission of your Contribution full details on such Third Party Content and Third Party Rights, including, without limitation, identification of which aspects of your Contribution contain Third Party Content or are associated with Third Party Rights, the owner/author of the Third Party Content and/or Third Party Rights, where you obtained the Third Party Content, and any applicable third party license terms or restrictions for the Third Party Content and/or Third Party Rights. (You need not identify material from the Mapbox Web SDK project as “Third Party Content” to fulfill the obligations in this paragraph.)


**Representations.** You represent that, other than the Third Party Content and Third Party Rights you identify in your Contributions in accordance with this Agreement, you are the sole author of your Contributions and are legally entitled to grant the licenses and waivers in this Agreement. If your Contributions were created in the course of your employment with your past or present employer(s), you represent that such employer(s) has authorized you to make your Contributions on behalf of such employer(s) or such employer(s) has waived all of their right, title or interest in or to your Contributions.


**No Obligation.** You acknowledge that Mapbox is under no obligation to use or incorporate your Contributions into the SDK. Mapbox has sole discretion in deciding whether to use or incorporate your Contributions.


**Disputes.** These Terms are governed by and construed in accordance with the laws of California, without giving effect to any principles of conflicts of law. Any action arising out of or relating to these Terms must be filed in the state or federal courts for San Francisco County, California, USA, and you hereby consent and submit to the exclusive personal jurisdiction and venue of these courts for the purposes of litigating any such action.
.

**Assignment.** You agree that Mapbox may assign this Agreement, and all of its rights, obligations and licenses hereunder.
