# mapbox-maps-ios

[![CLA assistant](https://cla-assistant.io/readme/badge/mapbox/mapbox-maps-ios)](https://cla-assistant.io/mapbox/mapbox-maps-ios)

The Mapbox Maps SDK for iOS is a public library for displaying interactive, thoroughly customizable maps in native iOS. It takes map styles that conform to the [Mapbox Style Specification](https://docs.mapbox.com/mapbox-gl-js/style-spec/), applies them to vector tiles that conform to the [Mapbox Vector Tile Specification](https://github.com/mapbox/vector-tile-spec), and renders them using Metal.

## Getting Started
This README is intended for developers who are interested in contributing to the Mapbox Maps SDK for iOS. Please visit https://docs.mapbox.com/ios/maps/guides/ for general information and instructions on using the Maps SDK in your iOS application.

## Examples App
The Examples app shows how to use many of the features in the Maps SDK. See the [Examples README](https://github.com/mapbox/mapbox-maps-ios/tree/main/Apps/Examples/README.md) for more information.

## Developing
If you are interested in contributing to the Maps SDK, please see the [DEVELOPING.md](https://github.com/mapbox/mapbox-maps-ios/tree/main/DEVELOPING.md) file for information on setting up, running and building the SDK.

## Reporting issues / Need help?

#### Report a bug :beetle:
Please use our [bug template](https://github.com/mapbox/mapbox-maps-ios/issues/new?labels=bug%20%3Abeetle%3A&template=bug.md) to report any issues.

#### Request a new feature or enhancement :green_apple:
Please use our [feature template](https://github.com/mapbox/mapbox-maps-ios/issues/new?labels=feature%20%3Agreen_apple%3A&template=feature.md) to request new features or enhancements.

#### Other questions
If you have any questions about how to use the SDK or if you need help with specific features, you can reach out to our support team [via our website](https://docs.mapbox.com/help/) or connect with our developer community by joining our [Discord channel](https://discord.gg/UshjQYyDFw). We kindly ask you to avoid using the issue tracker in this repository for questions and instead use our support channels.

## Historical Note
This repository is a continuation of the Mapbox Maps SDK for iOS available at [mapbox/mapbox-gl-native-ios](https://github.com/mapbox/mapbox-gl-native-ios).
