// This file is generated
import XCTest
@_spi(Experimental) @testable import MapboxMaps

final class RainTests: XCTestCase {

    func testRainProperties() {
        var instance = Rain()
        instance.centerThinning = .testConstantValue()
        instance.centerThinningTransition = .testConstantValue()
        instance.color = .testConstantValue()
        instance.colorTransition = .testConstantValue()
        instance.density = .testConstantValue()
        instance.densityTransition = .testConstantValue()
        instance.direction = .testConstantValue()
        instance.directionTransition = .testConstantValue()
        instance.distortionStrength = .testConstantValue()
        instance.distortionStrengthTransition = .testConstantValue()
        instance.dropletSize = .testConstantValue()
        instance.dropletSizeTransition = .testConstantValue()
        instance.intensity = .testConstantValue()
        instance.intensityTransition = .testConstantValue()
        instance.opacity = .testConstantValue()
        instance.opacityTransition = .testConstantValue()
        instance.vignette = .testConstantValue()
        instance.vignetteTransition = .testConstantValue()
        instance.vignetteColor = .testConstantValue()
        instance.vignetteColorTransition = .testConstantValue()

        XCTAssertEqual(instance.centerThinning, .testConstantValue())
        XCTAssertEqual(instance.centerThinningTransition, .testConstantValue())
        XCTAssertEqual(instance.color, .testConstantValue())
        XCTAssertEqual(instance.colorTransition, .testConstantValue())
        XCTAssertEqual(instance.density, .testConstantValue())
        XCTAssertEqual(instance.densityTransition, .testConstantValue())
        XCTAssertEqual(instance.direction, .testConstantValue())
        XCTAssertEqual(instance.directionTransition, .testConstantValue())
        XCTAssertEqual(instance.distortionStrength, .testConstantValue())
        XCTAssertEqual(instance.distortionStrengthTransition, .testConstantValue())
        XCTAssertEqual(instance.dropletSize, .testConstantValue())
        XCTAssertEqual(instance.dropletSizeTransition, .testConstantValue())
        XCTAssertEqual(instance.intensity, .testConstantValue())
        XCTAssertEqual(instance.intensityTransition, .testConstantValue())
        XCTAssertEqual(instance.opacity, .testConstantValue())
        XCTAssertEqual(instance.opacityTransition, .testConstantValue())
        XCTAssertEqual(instance.vignette, .testConstantValue())
        XCTAssertEqual(instance.vignetteTransition, .testConstantValue())
        XCTAssertEqual(instance.vignetteColor, .testConstantValue())
        XCTAssertEqual(instance.vignetteColorTransition, .testConstantValue())
    }

    func testRainSetters() {
        let instance = Rain()
            .centerThinning(Double.testConstantValue())
            .centerThinningTransition(.testConstantValue())
            .color(StyleColor.testConstantValue())
            .colorTransition(.testConstantValue())
            .density(Double.testConstantValue())
            .densityTransition(.testConstantValue())
            .direction(azimuthal: 0, polar: 1)
            .directionTransition(.testConstantValue())
            .distortionStrength(Double.testConstantValue())
            .distortionStrengthTransition(.testConstantValue())
            .dropletSize(normalToDirection: 0, alongDirection: 1)
            .dropletSizeTransition(.testConstantValue())
            .intensity(Double.testConstantValue())
            .intensityTransition(.testConstantValue())
            .opacity(Double.testConstantValue())
            .opacityTransition(.testConstantValue())
            .vignette(Double.testConstantValue())
            .vignetteTransition(.testConstantValue())
            .vignetteColor(StyleColor.testConstantValue())
            .vignetteColorTransition(.testConstantValue())

        XCTAssertEqual(instance.centerThinning, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(instance.centerThinningTransition, .testConstantValue())
        XCTAssertEqual(instance.color, Value.constant(StyleColor.testConstantValue()))
        XCTAssertEqual(instance.colorTransition, .testConstantValue())
        XCTAssertEqual(instance.density, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(instance.densityTransition, .testConstantValue())
        XCTAssertEqual(instance.direction, Value.constant([0, 1]))
        XCTAssertEqual(instance.directionTransition, .testConstantValue())
        XCTAssertEqual(instance.distortionStrength, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(instance.distortionStrengthTransition, .testConstantValue())
        XCTAssertEqual(instance.dropletSize, Value.constant([0, 1]))
        XCTAssertEqual(instance.dropletSizeTransition, .testConstantValue())
        XCTAssertEqual(instance.intensity, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(instance.intensityTransition, .testConstantValue())
        XCTAssertEqual(instance.opacity, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(instance.opacityTransition, .testConstantValue())
        XCTAssertEqual(instance.vignette, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(instance.vignetteTransition, .testConstantValue())
        XCTAssertEqual(instance.vignetteColor, Value.constant(StyleColor.testConstantValue()))
        XCTAssertEqual(instance.vignetteColorTransition, .testConstantValue())
    }

    func testRainPropertySerialization() throws {
        var instance = Rain()
        instance.centerThinning = .testConstantValue()
        instance.centerThinningTransition = .testConstantValue()
        instance.color = .testConstantValue()
        instance.colorTransition = .testConstantValue()
        instance.density = .testConstantValue()
        instance.densityTransition = .testConstantValue()
        instance.direction = .testConstantValue()
        instance.directionTransition = .testConstantValue()
        instance.distortionStrength = .testConstantValue()
        instance.distortionStrengthTransition = .testConstantValue()
        instance.dropletSize = .testConstantValue()
        instance.dropletSizeTransition = .testConstantValue()
        instance.intensity = .testConstantValue()
        instance.intensityTransition = .testConstantValue()
        instance.opacity = .testConstantValue()
        instance.opacityTransition = .testConstantValue()
        instance.vignette = .testConstantValue()
        instance.vignetteTransition = .testConstantValue()
        instance.vignetteColor = .testConstantValue()
        instance.vignetteColorTransition = .testConstantValue()

        let data = try JSONEncoder().encode(instance)
        let decodedInstance = try JSONDecoder().decode(Rain.self, from: data)

        XCTAssertEqual(decodedInstance.centerThinning, .testConstantValue())
        XCTAssertEqual(decodedInstance.centerThinningTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.color, .testConstantValue())
        XCTAssertEqual(decodedInstance.colorTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.density, .testConstantValue())
        XCTAssertEqual(decodedInstance.densityTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.direction, .testConstantValue())
        XCTAssertEqual(decodedInstance.directionTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.distortionStrength, .testConstantValue())
        XCTAssertEqual(decodedInstance.distortionStrengthTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.dropletSize, .testConstantValue())
        XCTAssertEqual(decodedInstance.dropletSizeTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.intensity, .testConstantValue())
        XCTAssertEqual(decodedInstance.intensityTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.opacity, .testConstantValue())
        XCTAssertEqual(decodedInstance.opacityTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.vignette, .testConstantValue())
        XCTAssertEqual(decodedInstance.vignetteTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.vignetteColor, .testConstantValue())
        XCTAssertEqual(decodedInstance.vignetteColorTransition, .testConstantValue())
    }

    func testRainSettersSerialization() throws {
        let instance = Rain()
            .centerThinning(Double.testConstantValue())
            .centerThinningTransition(.testConstantValue())
            .color(StyleColor.testConstantValue())
            .colorTransition(.testConstantValue())
            .density(Double.testConstantValue())
            .densityTransition(.testConstantValue())
            .direction(azimuthal: 0, polar: 1)
            .directionTransition(.testConstantValue())
            .distortionStrength(Double.testConstantValue())
            .distortionStrengthTransition(.testConstantValue())
            .dropletSize(normalToDirection: 0, alongDirection: 1)
            .dropletSizeTransition(.testConstantValue())
            .intensity(Double.testConstantValue())
            .intensityTransition(.testConstantValue())
            .opacity(Double.testConstantValue())
            .opacityTransition(.testConstantValue())
            .vignette(Double.testConstantValue())
            .vignetteTransition(.testConstantValue())
            .vignetteColor(StyleColor.testConstantValue())
            .vignetteColorTransition(.testConstantValue())

        let data = try JSONEncoder().encode(instance)
        let decodedInstance = try JSONDecoder().decode(Rain.self, from: data)

        XCTAssertEqual(decodedInstance.centerThinning, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(decodedInstance.centerThinningTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.color, Value.constant(StyleColor.testConstantValue()))
        XCTAssertEqual(decodedInstance.colorTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.density, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(decodedInstance.densityTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.direction, Value.constant([0, 1]))
        XCTAssertEqual(decodedInstance.directionTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.distortionStrength, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(decodedInstance.distortionStrengthTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.dropletSize, Value.constant([0, 1]))
        XCTAssertEqual(decodedInstance.dropletSizeTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.intensity, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(decodedInstance.intensityTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.opacity, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(decodedInstance.opacityTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.vignette, Value.constant(Double.testConstantValue()))
        XCTAssertEqual(decodedInstance.vignetteTransition, .testConstantValue())
        XCTAssertEqual(decodedInstance.vignetteColor, Value.constant(StyleColor.testConstantValue()))
        XCTAssertEqual(decodedInstance.vignetteColorTransition, .testConstantValue())
    }
}

// End of generated file
