<!--
Thanks for submitting a pull request!

Please fill out the sections below to complete your submission.

We appreciate your contributions!
-->

<!--
Describe the changes in this PR here.

• If this is a new feature, include a short summary on how to use it.
• If this is a bug fix, explain how your contribution resolves the problem.
• Include before/after visuals or gifs if this PR includes visual changes.
• Add a line with "Fixes: #issue-number" or "Fixes: issue URL" for each publicly-visible issue that is fixed by this PR.
-->

## Pull request checklist:
 - [ ] Describe the changes in this PR, especially public API changes.
 - [ ] Include before/after visuals or gifs if this PR includes visual changes.
    <!--
        | Before | After |
        | ----- | ----- |
        | <img src="" width = 250/> | <img src="" width = 250/> |
        or
        | <video src="" width = 250/> | <video src="" width = 250/> |
    -->
 - [ ] Write tests for all new functionality. Put tests in correct [Test Plan](https://github.com/mapbox/mapbox-maps-ios/tree/main/Tests/TestPlans) (Unit, Integration, All)
   - [ ] If tests were not written, please explain why.
 - [ ] Add documentation comments for any added or updated public APIs.
 - [ ] Add any new public, top-level symbols to the Jazzy config's `custom_categories` (scripts/doc-generation/.jazzy.yaml)
 - [ ] Add a changelog entry to to bottom of the relevant section (typically the `## main` heading near the top).
 - [ ] Update the guides (internal access only), README.md, and DEVELOPING.md if their contents are impacted by these changes.
 - [ ] If this PR is a `v10.[version]` release branch fix / enhancement, merge it to `main` first and then port to `v10.[version]` release branch.

PRs must be submitted under the terms of our Contributor License Agreement [CLA](https://github.com/mapbox/mapbox-maps-ios/blob/main/CONTRIBUTING.md#contributor-license-agreement).
