---
name: New Style Modifier
about: Add a new style modifier to WebUI
title: 'feat: add [Style Modifier] style'
labels: enhancement, styling
assignees: ''
---

## Style Modifier Description
<!-- Describe the style modifier you're adding and its purpose -->

## Implementation Details
<!-- Describe the implementation details of this style modifier -->

- [ ] Modifier is implemented as an extension method on the `Element` class
- [ ] The modifier follows the fluent interface pattern returning an Element
- [ ] Comprehensive DocC documentation is included
- [ ] Examples of modifier usage are provided in documentation
- [ ] Unit tests are included

## Usage Example
```swift
// Example showing how to use the new style modifier
```

## CSS Class Output Example
```
// Example showing the CSS classes generated by the modifier
```

## Visual Example
<!-- If applicable, provide screenshots or descriptions of the visual effect -->

## Related Issues
<!-- Reference any related issues (e.g., "Closes #123") -->

## Checklist
- [ ] I have read the [Contributing Guidelines](../../CONTRIBUTING.md)
- [ ] I have followed the [Adding New Style Modifiers](../../CONTRIBUTING.md#adding-new-style-modifiers) guidelines
- [ ] I have added appropriate DocC documentation
- [ ] I have added tests for my style modifier
- [ ] All tests pass locally with my changes
- [ ] My code follows the style guidelines of the project

## Additional Notes
<!-- Any additional information that might be helpful for reviewers -->